/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LinkCoordinatorNotEnabledTaskErrorCode$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnknownTaskState$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\r\u001a\u0001\u0001B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u0005@\u0001\t\u0005\t\u0015!\u0003A\r\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011%\u0019\u0006A!A!\u0002\u0013!F\fC\u0005^\u0001\t\u0005\t\u0015!\u0003_E\")1\r\u0001C\u0001I\"9a\u000e\u0001a\u0001\n\u0013y\u0007b\u00029\u0001\u0001\u0004%I!\u001d\u0005\u0007o\u0002\u0001\u000b\u0015\u0002!\t\u000fa\u0004!\u0019!C\u0001s\"1Q\u0010\u0001Q\u0001\niDqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!A\u00111\u0003\u0001!B\u0013\t\t\u0001C\u0004\u0002\u001e\u0001!\t&a\b\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAA\u0001\u0011E\u00131\u0011\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u0013Ad\u00117vgR,'\u000fT5oWNKhn\u0019+pa&\u001c7oQ8oM&<7O\u0003\u0002\u001b7\u0005!A.\u001b8l\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\"!\t\u0011cE\u0004\u0002$I5\t\u0011$\u0003\u0002&3\u0005!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!a\n\u0015\u0003\u0019A+'/[8eS\u000e$\u0016m]6\u000b\u0005\u0015J\u0012!D2mS\u0016tG/T1oC\u001e,'\u000f\u0005\u0002$W%\u0011A&\u0007\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014\bCA\u00120\u0013\t\u0001\u0014D\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0006m_\u000e\fG.\u00113nS:\u0004\"aM\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u000b\u0005$W.\u001b8\u000b\u0005]B\u0014aB2mS\u0016tGo\u001d\u0006\u0003=eR!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO&\u0011a\b\u000e\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u00039\u0019\u0018P\\2J]R,'O^1m\u001bN\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u00131!\u00138u\u0013\t9e%A\tsKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\fq!\\3ue&\u001c7\u000f\u0005\u0002$\u0015&\u00111*\u0007\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005mS:\\G)\u0019;b!\tq\u0015+D\u0001P\u0015\t\u0001V$\u0001\u0002{W&\u0011!k\u0014\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006!A/[7f!\t)&,D\u0001W\u0015\t9\u0006,A\u0003vi&d7O\u0003\u0002Zq\u000511m\\7n_:L!a\u0017,\u0003\tQKW.Z\u0005\u0003'\u001a\nQ!];pi\u0006\u0004\"a\u00181\u000e\u0003mI!!Y\u000e\u0003/\rcWo\u001d;fe2Kgn\u001b*fcV,7\u000f^)v_R\f\u0017BA/'\u0003\u0019a\u0014N\\5u}QIQMZ4iS*\\G.\u001c\t\u0003G\u0001AQ!K\u0005A\u0002)BQ!L\u0005A\u00029BQ!M\u0005A\u0002IBQaP\u0005A\u0002\u0001CQ\u0001S\u0005A\u0002%CQ\u0001T\u0005A\u00025CQaU\u0005A\u0002QCQ!X\u0005A\u0002y\u000b\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0016\u0003\u0001\u000bA\u0003^1tWN|U\u000f^:uC:$\u0017N\\4`I\u0015\fHC\u0001:v!\t\t5/\u0003\u0002u\u0005\n!QK\\5u\u0011\u001d18\"!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0003E!\u0018m]6t\u001fV$8\u000f^1oI&tw\rI\u0001\u0018Kb\u001cWm]:jm\u0016dunZ4j]\u001eD\u0015M\u001c3mKJ,\u0012A\u001f\t\u0003GmL!\u0001`\r\u0003/\u0015C8-Z:tSZ,Gj\\4hS:<\u0007*\u00198eY\u0016\u0014\u0018\u0001G3yG\u0016\u001c8/\u001b<f\u0019><w-\u001b8h\u0011\u0006tG\r\\3sA\u0005AA/Y:l\t\u0016\u001c8-\u0006\u0002\u0002\u0002A)\u0011)a\u0001\u0002\b%\u0019\u0011Q\u0001\"\u0003\r=\u0003H/[8o!\r\u0019\u0013\u0011B\u0005\u0004\u0003\u0017I\"a\u0004+bg.$Um]2sSB$\u0018n\u001c8\u0002\u0019Q\f7o\u001b#fg\u000e|F%Z9\u0015\u0007I\f\t\u0002\u0003\u0005w!\u0005\u0005\t\u0019AA\u0001\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002\u0012\u0003/\u00012!QA\r\u0013\r\tYB\u0011\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003oq1!!\n%\u001d\u0011\t9#!\u000e\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$C\u0002\u0002:!\u0012!\u0002V1tWJ+7/\u001e7u\u0003iA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016$v\u000e]5d\u0007>tg-[4t)\u0019\t\t#a\u0010\u0002J!9\u0011\u0011I\nA\u0002\u0005\r\u0013a\u0003;bg.\u001cuN\u001c;fqR\u0004B!a\t\u0002F%\u0019\u0011q\t\u0015\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0017\u001a\u0002\u0019AA'\u0003\u0019\u0011Xm];miBA\u0011qJA+\u00033\n)'\u0004\u0002\u0002R)\u0019\u00111\u000b\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002X\u0005E#aA'baB!\u00111LA1\u001b\t\tiFC\u0002\u0002`a\u000baaY8oM&<\u0017\u0002BA2\u0003;\u0012abQ8oM&<'+Z:pkJ\u001cW\r\u0005\u0004\u0002h\u0005%\u0014QN\u0007\u00021&\u0019\u00111\u000e-\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0004g\u0005=\u0014bAA9i\t11i\u001c8gS\u001e\fq\u0003[1oI2,\u0017\t\u001c;feR{\u0007/[2D_:4\u0017nZ:\u0015\r\u0005\u0005\u0012qOA=\u0011\u001d\t\t\u0005\u0006a\u0001\u0003\u0007Bq!a\u0013\u0015\u0001\u0004\tY\bE\u00024\u0003{J1!a 5\u0005I\tE\u000e^3s\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\u0007I\f)\tC\u0004\u0002LU\u0001\r!a\"\u0011\u0007\t\nI)C\u0002\u0002\f\"\u00121cQ8na2,G/\u001a3UCN\\'+Z:vYR\fq\u0002^1tW\u0012+7o\u0019:jaRLwN\u001c\u000b\u0003\u0003\u0003\t\u0001\u0003\\8h\u0003:$W)\\5u\u001b\u0016$(/[2\u0015\u000fI\f)*a+\u0002@\"9\u0011qS\fA\u0002\u0005e\u0015AA3y!\u0011\tY*!*\u000f\t\u0005u\u0015\u0011\u0015\b\u0005\u0003W\ty*C\u0001D\u0013\r\t\u0019KQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9+!+\u0003\u0013QC'o\\<bE2,'bAAR\u0005\"9\u0011QV\fA\u0002\u0005=\u0016AB3se6\u001bx\r\u0005\u0003\u00022\u0006ef\u0002BAZ\u0003k\u00032!a\u000bC\u0013\r\t9LQ\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0016Q\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]&\tC\u0004\u0002B^\u0001\r!a1\u0002\rM,gn]8s!\u0011\t)-!3\u000e\u0005\u0005\u001d'B\u0001%Y\u0013\u0011\tY-a2\u0003\rM+gn]8s\u0001")
public class ClusterLinkSyncTopicsConfigs
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ConfluentAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkData linkData;
    private int tasksOutstanding;
    private final ExcessiveLoggingHandler excessiveLoggingHandler;
    private volatile Option<TaskDescription> taskDesc;

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    public ExcessiveLoggingHandler excessiveLoggingHandler() {
        return this.excessiveLoggingHandler;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (this.tasksOutstanding() != 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
            this.tasksOutstanding_$eq(0);
        }
        Set<String> topics = this.clientManager.getTopics();
        scala.collection.immutable.Set resources = ((IterableOnceOps)topics.map((Function1 & Serializable)name -> new ConfigResource(ConfigResource.Type.TOPIC, name))).toSet();
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (resources.nonEmpty()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Attempting to retrieve topic configs from source cluster for following mirror topics: ").append(topics).toString());
            DescribeConfigsResult describeConfigsResult = this.clientManager.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)resources).asJava());
            this.scheduleWhenComplete(describeConfigsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeTopicConfigs((ClusterLinkScheduler.TaskContext)tc, (Map<ConfigResource, KafkaFuture<Config>>)CollectionConverters$.MODULE$.MapHasAsScala(describeConfigsResult.values()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleDescribeTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, Map<ConfigResource, KafkaFuture<Config>> result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        HashMap alterConfigRequestMap = new HashMap();
        scala.collection.mutable.Map updatedConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Iterable errs = (Iterable)result.flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void var9_9;
                String topic;
                ConfigResource resource = (ConfigResource)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                Tuple2 tuple2 = this.liftedTree1$1(future, topic = resource.name());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option newSourceTopicConfigOpt = (Option)tuple2._1();
                Option errOpt = (Option)tuple2._2();
                if (var9_9 instanceof Some) {
                    TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)var9_9).value();
                    return new Some((Object)err);
                }
                if (None$.MODULE$.equals(var9_9)) {
                    try {
                        Properties newProps;
                        void var8_8;
                        if (var8_8.isEmpty()) {
                            throw new IllegalStateException(new StringBuilder(59).append("There should be a source config for ").append(topic).append(" if there was no error.").toString());
                        }
                        Config newSourceTopicConfig = (Config)var8_8.get();
                        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Topic configuration for source topic ").append(topic).append(" is: ").append(newSourceTopicConfig).toString());
                        MirrorTopicConfigSyncRules topicConfigSyncRules = $this.clientManager.topicConfigSyncRules();
                        Properties curProps = $this.metadataManager.getTopicConfig(topic);
                        Properties resolvedProps = new MirrorTopicConfigsDelegate(curProps, newSourceTopicConfig, topicConfigSyncRules).updateMirrorProps(topic);
                        Properties properties = newProps = ClusterLinkUtils$.MODULE$.restrictValidateTopicConfigPolicy(topic, resolvedProps, $this.clientManager.alterConfigPolicy());
                        if (properties == null ? curProps != null : !((Object)properties).equals(curProps)) {
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Updating local configuration for mirror topic '").append(topic).append("' on cluster link '").append($this.clientManager.linkData().linkName()).append("'").toString());
                            scala.collection.mutable.Set newTopicConfigs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(newProps.entrySet()).asScala().diff((Set)CollectionConverters$.MODULE$.SetHasAsScala(curProps.entrySet()).asScala());
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Adding configs ").append(newTopicConfigs).append(" for topic ").append(topic).append(" on target cluster").toString());
                            HashSet newConfigs = new HashSet();
                            CollectionConverters$.MODULE$.PropertiesHasAsScala(newProps).asScala().foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                            alterConfigRequestMap.put(new ConfigResource(ConfigResource.Type.TOPIC, topic), newConfigs);
                            updatedConfigs.put((Object)topic, (Object)new Some((Object)newSourceTopicConfig));
                        }
                        return None$.MODULE$;
                    }
                    catch (PolicyViolationException e) {
                        String errMsg = new StringBuilder(87).append("Could not update mirror topic '").append(topic).append("' configuration due to policy violation on ").append("cluster link ").append($this.clientManager.linkData().linkName()).toString();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        return new Some((Object)new TaskErrorCodeAndMsg(PolicyViolationTaskErrorCode$.MODULE$, errMsg));
                    }
                    catch (Throwable e) {
                        String errMsg = new StringBuilder(92).append("Error encountered while processing remote configuration for mirror topic '").append(topic).append("' ").append("on cluster link ").append($this.clientManager.linkData().linkName()).toString();
                        this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                        return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                    }
                }
                throw new MatchError((Object)var9_9);
            }
            throw new MatchError(null);
        });
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (!alterConfigRequestMap.isEmpty()) {
            AlterConfigsResult alterConfigResult = this.localAdmin.incrementalAlterConfigs(alterConfigRequestMap);
            this.scheduleWhenComplete(alterConfigResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterTopicConfigs((ClusterLinkScheduler.TaskContext)tc, alterConfigResult), newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = newTaskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleAlterTopicConfigs(ClusterLinkScheduler.TaskContext taskContext, AlterConfigsResult result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        scala.collection.mutable.Set errs = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(result.values().entrySet()).asScala().flatMap((Function1 & Serializable)entry -> {
            String topic = ((ConfigResource)entry.getKey()).name();
            try {
                ((KafkaFuture)entry.getValue()).get();
                $this.metrics.topicConfigUpdateSensor().record();
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully updated configuration for mirror topic ").append(topic).toString());
                return None$.MODULE$;
            }
            catch (ExecutionException ex) {
                TaskErrorCodeAndMsg taskErrorCodeAndMsg;
                KafkaException kafkaException;
                Throwable throwable = ex.getCause();
                if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                    String errMsg = new StringBuilder(64).append("Unable to alter topic configs due to authentication issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
                } else if (throwable instanceof AuthorizationException) {
                    String errMsg = new StringBuilder(63).append("Unable to alter topic configs due to authorization issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
                } else {
                    String errMsg = new StringBuilder(58).append("Unable to alter topic configs due to internal issues for ").append(topic).append(".").toString();
                    taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
                }
                TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
                this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), $this.metrics.topicConfigUpdateFailedSensor());
                return new Some((Object)taskErrorCodeAndMsg2);
            }
            catch (Throwable e) {
                String errMsg = new StringBuilder(63).append("Error encountered while altering configuration on mirror topic ").append(topic).toString();
                this.logAndEmitMetric(e, errMsg, $this.metrics.topicConfigUpdateFailedSensor());
                return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
            }
        });
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        boolean isLinkCoordinatorEnabled = this.metadataManager.isLinkCoordinatorEnabled();
        boolean isLinkCoordinator = this.metadataManager.isLinkCoordinator(this.linkData.linkName());
        if (isLinkCoordinatorEnabled && isLinkCoordinator) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncTopicConfigsTaskType$.MODULE$, "run the topic configs sync task"));
            bl = false;
        } else if (!isLinkCoordinatorEnabled && isLinkCoordinator) {
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(UnknownTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)new .colon.colon((Object)new TaskErrorCodeAndMsg(LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$, "The cluster linking link coordinator is not enabled."), (List)Nil$.MODULE$))));
            bl = true;
        } else {
            this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
            bl = true;
        }
        if (bl) {
            this.excessiveLoggingHandler().clear();
            return;
        }
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private void logAndEmitMetric(Throwable ex, String errMsg, Sensor sensor) {
        this.excessiveLoggingHandler().handle(ex, this, errMsg);
        sensor.record();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture future$1, String topic$1) {
        try {
            return new Tuple2((Object)new Some(future$1.get()), (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            TaskErrorCodeAndMsg taskErrorCodeAndMsg;
            KafkaException kafkaException;
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                String errMsg = new StringBuilder(67).append("Unable to describe topic configs due to authentication issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof AuthorizationException) {
                String errMsg = new StringBuilder(66).append("Unable to describe topic configs due to authorization issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg);
            } else if (throwable instanceof UnknownTopicOrPartitionException) {
                String errMsg = new StringBuilder(83).append("Unable to describe topic configs due to unknown topic partition on the source for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg);
            } else {
                String errMsg = new StringBuilder(61).append("Unable to describe topic configs due to internal issues for ").append(topic$1).append(".").toString();
                taskErrorCodeAndMsg = new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg);
            }
            TaskErrorCodeAndMsg taskErrorCodeAndMsg2 = taskErrorCodeAndMsg;
            this.logAndEmitMetric(ex, taskErrorCodeAndMsg2.msg(), this.metrics.topicConfigUpdateFailedSensor());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)taskErrorCodeAndMsg2));
        }
        catch (Throwable ex) {
            String errMsg = new StringBuilder(61).append("Unable to describe topic configs due to internal issues for ").append(topic$1).append(".").toString();
            this.logAndEmitMetric(ex, errMsg, this.metrics.topicConfigUpdateFailedSensor());
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkSyncTopicsConfigs(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ConfluentAdmin localAdmin, int syncIntervalMs, ClusterLinkMetrics metrics, ClusterLinkData linkData, Time time, ClusterLinkRequestQuota quota) {
        void apply_now;
        void apply_ttlMs;
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        this.linkData = linkData;
        super(clientManager.scheduler(), "ClusterLinkSyncTopicsConfigs", syncIntervalMs, time, quota);
        this.tasksOutstanding = 0;
        ExcessiveLoggingHandler$ apply$default$3_this = ExcessiveLoggingHandler$.MODULE$;
        Object var13_9 = null;
        Function0<Object> function0 = apply$default$3_this.nowDefault();
        long l = ExcessiveLoggingHandler$.MODULE$.ttlMsDefault();
        int apply_capacity = 1000;
        this.excessiveLoggingHandler = new ExcessiveLoggingHandler(apply_capacity, (long)apply_ttlMs, (Function0<Object>)apply_now);
        this.taskDesc = None$.MODULE$;
    }
}

