/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkBatchingAdmin;
import kafka.server.link.ClusterLinkClearStartOffsetsForMirrors;
import kafka.server.link.ClusterLinkConvertTopicsToMirrors;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkNonBatchingAdmin;
import kafka.server.link.ClusterLinkRepairMirrors;
import kafka.server.link.ClusterLinkReverseAndSwapMirrors;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrors;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTransitionMirrors;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\u0010!\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!A!\u0002\u0013)\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003e\u0011%Q\u0007\u00011A\u0001B\u0003&\u0001\r\u0003\u0005p\u0001\t\u0007I\u0011\u0001\u0011q\u0011\u0019!\b\u0001)A\u0005c\"9Q\u000f\u0001b\u0001\n\u00031\bB\u0002>\u0001A\u0003%q\u000fC\u0004|\u0001\t\u0007I\u0011\u0001?\t\u000f\u0005\u0005\u0001\u0001)A\u0005{\"I\u00111\u0001\u0001C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\b!I\u0011q\u0002\u0001C\u0002\u0013\u0005\u0011\u0011\u0003\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002 !9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u001e\u0001\t\u0013\t9\bC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\n12\t\\;ti\u0016\u0014H*\u001b8l)\u0006\u001c8.T1oC\u001e,'O\u0003\u0002\"E\u0005!A.\u001b8l\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001a\u000e\u0003AR!!\r\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0002$a\u0002'pO\u001eLgnZ\u0001\u0006S:$W\r_\u000b\u0002mA\u0011\u0011fN\u0005\u0003q)\u00121!\u00138u\u0003\u0019Ig\u000eZ3yA\u0005\u00112\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s!\taT(D\u0001!\u0013\tq\u0004E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007CA!C\u001b\u0005\u0011\u0013BA\"#\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u0003\r>k\u0011a\u0012\u0006\u0003c!S!!\u0013&\u0002\r\r|W.\\8o\u0015\t)3J\u0003\u0002M\u001b\u00061\u0011\r]1dQ\u0016T\u0011AT\u0001\u0004_J<\u0017B\u0001)H\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u0015\u0019F+\u0016,X!\ta\u0004\u0001C\u00035\r\u0001\u0007a\u0007C\u0003;\r\u0001\u00071\bC\u0003@\r\u0001\u0007\u0001\tC\u0003E\r\u0001\u0007Q)A\u0005tG\",G-\u001e7feV\t!\f\u0005\u0002=7&\u0011A\f\t\u0002\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\tm_\u000e\fG.\u00113nS:\u001cE.[3oiV\t\u0001\r\u0005\u0002=C&\u0011!\r\t\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eT8dC2\fE-\\5o\u0003QawnY1m\u0003\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011Q\r\u001b\t\u0003S\u0019L!a\u001a\u0016\u0003\tUs\u0017\u000e\u001e\u0005\bS*\t\t\u00111\u0001a\u0003\rAH%M\u0001\u0012Y>\u001c\u0017\r\\!e[&t7\t\\5f]R\u0004\u0003FA\u0006m!\tIS.\u0003\u0002oU\tAao\u001c7bi&dW-A\bm_\u000e\fGNQ1uG\"\fE-\\5o+\u0005\t\bC\u0001\u001fs\u0013\t\u0019\bEA\u000bDYV\u001cH/\u001a:MS:\\')\u0019;dQ\u0006#W.\u001b8\u0002!1|7-\u00197CCR\u001c\u0007.\u00113nS:\u0004\u0013AF2mkN$XM\u001d'j].\u001cFo\u001c9NSJ\u0014xN]:\u0016\u0003]\u0004\"\u0001\u0010=\n\u0005e\u0004#AF\"mkN$XM\u001d'j].\u001cFo\u001c9NSJ\u0014xN]:\u0002/\rdWo\u001d;fe2Kgn[*u_Bl\u0015N\u001d:peN\u0004\u0013\u0001I2mkN$XM\u001d'j].\u0014VM^3sg\u0016\fe\u000eZ*xCBl\u0015N\u001d:peN,\u0012! \t\u0003yyL!a \u0011\u0003A\rcWo\u001d;fe2Kgn\u001b*fm\u0016\u00148/Z!oIN;\u0018\r]'jeJ|'o]\u0001\"G2,8\u000f^3s\u0019&t7NU3wKJ\u001cX-\u00118e'^\f\u0007/T5se>\u00148\u000fI\u0001\u001cG2,8\u000f^3s\u0019&t7nQ8om\u0016\u0014H\u000fV8NSJ\u0014xN]:\u0016\u0005\u0005\u001d\u0001c\u0001\u001f\u0002\n%\u0019\u00111\u0002\u0011\u0003C\rcWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+pa&\u001c7\u000fV8NSJ\u0014xN]:\u00029\rdWo\u001d;fe2Kgn[\"p]Z,'\u000f\u001e+p\u001b&\u0014(o\u001c:tA\u0005A2\r\\;ti\u0016\u0014H*\u001b8l%\u0016\u0004\u0018-\u001b:NSJ\u0014xN]:\u0016\u0005\u0005M\u0001c\u0001\u001f\u0002\u0016%\u0019\u0011q\u0003\u0011\u00031\rcWo\u001d;fe2Kgn\u001b*fa\u0006L'/T5se>\u00148/A\rdYV\u001cH/\u001a:MS:\\'+\u001a9bSJl\u0015N\u001d:peN\u0004\u0013AJ2mkN$XM\u001d'j].\u001cE.Z1s'R\f'\u000f^(gMN,Go\u001d$pe6K'O]8sgV\u0011\u0011q\u0004\t\u0004y\u0005\u0005\u0012bAA\u0012A\t13\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M]*uCJ$xJ\u001a4tKR\u001chi\u001c:NSJ\u0014xN]:\u0002O\rdWo\u001d;fe2Kgn[\"mK\u0006\u00148\u000b^1si>3gm]3ug\u001a{'/T5se>\u00148\u000fI\u0001\u0011g\u000eDW\rZ;mKJ\u001cF/\u0019:uK\u0012,\"!a\u000b\u0011\u0007%\ni#C\u0002\u00020)\u0012qAQ8pY\u0016\fg.A\nnCf\u0014Wm\u0015;beR\u001c6\r[3ek2,'\u000fF\u0001[\u0003U9W\r^(s\u0007J,\u0017\r^3M_\u000e\fG.\u00113nS:$\u0012\u0001Y\u0001\u0019aJ|7-Z:t\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,G#C3\u0002>\u0005]\u0013\u0011MA6\u0011\u001d\tyd\u0007a\u0001\u0003\u0003\nQ\u0001^8qS\u000e\u0004B!a\u0011\u0002R9!\u0011QIA'!\r\t9EK\u0007\u0003\u0003\u0013R1!a\u0013'\u0003\u0019a$o\\8u}%\u0019\u0011q\n\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019&!\u0016\u0003\rM#(/\u001b8h\u0015\r\tyE\u000b\u0005\b\u00033Z\u0002\u0019AA.\u0003-i\u0017N\u001d:peN#\u0018\r^3\u0011\u0007q\ni&C\u0002\u0002`\u0001\u0012Qc\u00117vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X\rC\u0004\u0002dm\u0001\r!!\u001a\u0002\u0011=dGm\u0015;bi\u0016\u0004R!KA4\u00037J1!!\u001b+\u0005\u0019y\u0005\u000f^5p]\"9\u0011QN\u000eA\u0002\u0005=\u0014!D2mS\u0016tG/T1oC\u001e,'\u000fE\u0002=\u0003cJ1!a\u001d!\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJ\f\u0011\u0003\u001e:b]NLG/[8o\u001b&\u0014(o\u001c:t+\t\tI\b\u0005\u0004\u0002|\u0005\u0015\u00151\u0012\b\u0005\u0003{\n\tI\u0004\u0003\u0002H\u0005}\u0014\"A\u0016\n\u0007\u0005\r%&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u0004'\u0016\f(bAABUA\u0019A(!$\n\u0007\u0005=\u0005E\u0001\u000fDYV\u001cH/\u001a:MS:\\GK]1og&$\u0018n\u001c8NSJ\u0014xN]:\u00029=tG*\u001b8l\u0007>|'\u000fZ5oCR|'OU3tS\u001et\u0017\r^5p]R\u0019Q-!&\t\u000f\u0005]U\u00041\u0001\u0002\u001a\u00061A.\u001b8l\u0013\u0012\u0004B!a'\u0002\u001e6\t\u0001*C\u0002\u0002 \"\u0013A!V;jI\u0006A1\u000f[;uI><h\u000eF\u0001f\u0001")
public class ClusterLinkTaskManager
implements Logging {
    private final int index;
    private final ClusterLinkManager clusterLinkManager;
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private volatile ClusterLinkLocalAdmin localAdminClient;
    private final ClusterLinkBatchAdmin localBatchAdmin;
    private final ClusterLinkStopMirrors clusterLinkStopMirrors;
    private final ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors;
    private final ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors;
    private final ClusterLinkRepairMirrors clusterLinkRepairMirrors;
    private final ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int index() {
        return this.index;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ClusterLinkLocalAdmin localAdminClient() {
        return this.localAdminClient;
    }

    private void localAdminClient_$eq(ClusterLinkLocalAdmin x$1) {
        this.localAdminClient = x$1;
    }

    public ClusterLinkBatchAdmin localBatchAdmin() {
        return this.localBatchAdmin;
    }

    public ClusterLinkStopMirrors clusterLinkStopMirrors() {
        return this.clusterLinkStopMirrors;
    }

    public ClusterLinkReverseAndSwapMirrors clusterLinkReverseAndSwapMirrors() {
        return this.clusterLinkReverseAndSwapMirrors;
    }

    public ClusterLinkConvertTopicsToMirrors clusterLinkConvertToMirrors() {
        return this.clusterLinkConvertToMirrors;
    }

    public ClusterLinkRepairMirrors clusterLinkRepairMirrors() {
        return this.clusterLinkRepairMirrors;
    }

    public ClusterLinkClearStartOffsetsForMirrors clusterLinkClearStartOffsetsForMirrors() {
        return this.clusterLinkClearStartOffsetsForMirrors;
    }

    public boolean schedulerStarted() {
        return this.scheduler().isStarted();
    }

    public ClusterLinkScheduler maybeStartScheduler() {
        if (!this.scheduler().isStarted()) {
            synchronized (this) {
                if (!this.scheduler().isStarted()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Starting scheduler ").append(this.index()).toString());
                    this.scheduler().startup();
                    this.transitionMirrors().foreach((Function1 & Serializable)x$2 -> {
                        x$2.startup();
                        return BoxedUnit.UNIT;
                    });
                }
            }
        }
        return this.scheduler();
    }

    public ClusterLinkLocalAdmin getOrCreateLocalAdmin() {
        if (this.localAdminClient() == null) {
            synchronized (this) {
                if (this.localAdminClient() == null) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Creating local admin client for scheduler ").append(this.index()).toString());
                    this.localAdminClient_$eq(this.clusterLinkManager.createLocalAdmin(this.maybeStartScheduler(), this.index()));
                }
            }
        }
        return this.localAdminClient();
    }

    public void processMirrorStateChange(String topic, ClusterLinkTopicState mirrorState, Option<ClusterLinkTopicState> oldState, ClusterLinkDestClientManager clientManager) {
        if (!this.clusterLinkManager.metadataManager().isLinkCoordinator(mirrorState.linkName())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(115).append("Not starting tasks for mirror state ").append(mirrorState.state()).append(" for topic '").append(topic).append("' since this broker is not the link coordinator for cluster link '").append(mirrorState.linkName()).append("'").toString());
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Processing mirror state ").append(mirrorState.state()).append(" for topic '").append(topic).append("', oldState ").append(oldState).toString());
        this.clusterLinkStopMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkConvertToMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkReverseAndSwapMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkRepairMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
        this.clusterLinkClearStartOffsetsForMirrors().maybeAddTask(topic, mirrorState, oldState, clientManager);
    }

    private Seq<ClusterLinkTransitionMirrors> transitionMirrors() {
        return new .colon.colon((Object)this.clusterLinkStopMirrors(), (List)new .colon.colon((Object)this.clusterLinkReverseAndSwapMirrors(), (List)new .colon.colon((Object)this.clusterLinkConvertToMirrors(), (List)new .colon.colon((Object)this.clusterLinkRepairMirrors(), (List)new .colon.colon((Object)this.clusterLinkClearStartOffsetsForMirrors(), (List)Nil$.MODULE$)))));
    }

    public void onLinkCoordinatorResignation(Uuid linkId) {
        this.transitionMirrors().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdownTasks(linkId, "coordinator resignation");
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Shutting down task manager with scheduler ").append(this.index()).toString());
        this.transitionMirrors().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Option$.MODULE$.apply((Object)this.localBatchAdmin()).foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Option$.MODULE$.apply((Object)this.localAdminClient()).foreach((Function1 & Serializable)x$6 -> {
            x$6.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTaskManager(int index, ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, Time time) {
        ClusterLinkBatchAdmin clusterLinkBatchAdmin;
        this.index = index;
        this.clusterLinkManager = clusterLinkManager;
        this.brokerConfig = brokerConfig;
        this.logIdent_$eq(new StringBuilder(35).append("[ClusterLinkTaskManager brokerId=").append(brokerConfig.brokerId()).append("] ").toString());
        this.scheduler = new ClusterLinkScheduler(index, 100);
        ClusterLinkScheduler clusterLinkScheduler = this.scheduler();
        JFunction0.mcI.sp & Serializable intersect = (JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminMaxInFlightRequests());
        JFunction0.mcI.sp & Serializable intersect2 = (JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.brokerConfig.clusterLinkAdminRequestBatchSize());
        Function0 & Serializable apply_admin = (Function0 & Serializable)() -> this.getOrCreateLocalAdmin();
        if (Predef$.MODULE$.Integer2int(this.brokerConfig.clusterLinkAdminRequestBatchSize()) <= 1) {
            clusterLinkBatchAdmin = new ClusterLinkNonBatchingAdmin((Function0<ConfluentAdmin>)apply_admin);
        } else {
            void apply_maxInFlight;
            void apply_adminBatchSize;
            void apply_scheduler;
            if (apply_scheduler == null) {
                throw new IllegalArgumentException("Scheduler must be provided for batching admin");
            }
            clusterLinkBatchAdmin = new ClusterLinkBatchingAdmin((Function0<ConfluentAdmin>)apply_admin, (Function0<Object>)apply_adminBatchSize, (Function0<Object>)apply_maxInFlight, (ClusterLinkScheduler)apply_scheduler);
        }
        Object var5_8 = null;
        intersect2 = null;
        intersect = null;
        clusterLinkScheduler = null;
        this.localBatchAdmin = clusterLinkBatchAdmin;
        this.clusterLinkStopMirrors = new ClusterLinkStopMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, 500);
        this.clusterLinkReverseAndSwapMirrors = new ClusterLinkReverseAndSwapMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, 5000);
        this.clusterLinkConvertToMirrors = new ClusterLinkConvertTopicsToMirrors(brokerConfig, clusterLinkManager, this.scheduler(), time, 5000);
        this.clusterLinkRepairMirrors = new ClusterLinkRepairMirrors(brokerConfig, clusterLinkManager, this.scheduler(), this.localBatchAdmin(), time, 1000);
        this.clusterLinkClearStartOffsetsForMirrors = new ClusterLinkClearStartOffsetsForMirrors(brokerConfig, clusterLinkManager, this.scheduler(), this.localBatchAdmin(), time, 1000);
    }
}

