/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class MirrorTopicRequestHelperKraft$ {
    public static final MirrorTopicRequestHelperKraft$ MODULE$ = new MirrorTopicRequestHelperKraft$();
    private static final int CreateTopicsVersionWithSourceTopicIdSupport = 7;

    public int CreateTopicsVersionWithSourceTopicIdSupport() {
        return CreateTopicsVersionWithSourceTopicIdSupport;
    }

    public void transformCreatableTopic(ClusterLinkFactory.LinkManager linkManager, CreateTopicsRequestData.CreatableTopic topic, Option<CompletableFuture<ClusterLinkTopicInfo>> sourceTopicInfo, boolean validateOnly, short version) {
        Properties configs = new Properties();
        topic.configs().forEach(entry -> configs.setProperty(entry.name(), entry.value()));
        ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)linkManager.clusterLinkMetadataManager().getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkNotFoundException(new StringBuilder(47).append("Unable to resolve cluster link information for ").append(topic.name()).toString());
        });
        ClusterLinkData linkData = (ClusterLinkData)Option$.MODULE$.apply((Object)topic.linkName()).flatMap((Function1 & Serializable)linkName -> metadataManager.getClusterLinkData((String)linkName)).getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkNotFoundException(new StringBuilder(47).append("Unable to resolve cluster link information for ").append(topic.name()).toString());
        });
        Uuid linkId = linkData.linkId();
        String tenantPrefix = (String)linkData.tenantPrefix().getOrElse((Function0 & Serializable)() -> "");
        ClusterLinkConfig linkConfig = linkManager.linkConfigFromMetadataProps(linkId);
        ClusterLinkUtils.ResolveCreateTopic resolvedMirrorTopic = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option<Uuid>)new Some((Object)linkId), configs, validateOnly, (Option<ClusterLinkConfig>)new Some((Object)linkConfig), sourceTopicInfo, tenantPrefix);
        CreateTopicsRequestData.CreateableTopicConfigCollection finalizedConfigs = new CreateTopicsRequestData.CreateableTopicConfigCollection(resolvedMirrorTopic){
            {
                resolvedMirrorTopic$1.configs().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x0$1, x1$1) -> this.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreateableTopicConfig().setName(x0$1.toString()).setValue(x1$1.toString()))));
            }
        };
        topic.setConfigs(finalizedConfigs);
        if (resolvedMirrorTopic.numPartitions() != -1) {
            topic.setNumPartitions(resolvedMirrorTopic.numPartitions());
        }
        if (version >= this.CreateTopicsVersionWithSourceTopicIdSupport()) {
            resolvedMirrorTopic.topicState().foreach((Function1 & Serializable)state -> topic.setSourceTopicId(state.sourceTopicId()));
        }
        if (resolvedMirrorTopic.topicState().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MirrorTopicRequestHelperKraft$.$anonfun$transformCreatableTopic$7(x$1)))) {
            resolvedMirrorTopic.topicState().foreach((Function1 & Serializable)state -> topic.setMirrorStartOffsets(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)state.mirrorStartOffsets().map((Function1 & Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x)))).asJava()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$transformCreatableTopic$7(ClusterLinkTopicState x$1) {
        return x$1.mirrorStartOffsets().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> x$2 > 0L);
    }

    private MirrorTopicRequestHelperKraft$() {
    }
}

