/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultTenantEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.TenantEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.authorizer.AuthorizerConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\b\u0011\u0001]A\u0011\u0002\n\u0001\u0003\u0006\u0004%\t\u0001E\u0013\t\u0011Q\u0002!\u0011!Q\u0001\n\u0019B\u0011\"\u000e\u0001\u0003\u0006\u0004%\t\u0001\u0005\u001c\t\u0011u\u0002!\u0011!Q\u0001\n]B\u0011B\u0010\u0001\u0003\u0006\u0004%\t\u0001E \t\u0011=\u0003!\u0011!Q\u0001\n\u0001C\u0011\u0002\u0015\u0001\u0003\u0006\u0004%\t\u0001E)\t\u0011q\u0003!\u0011!Q\u0001\nICQ!\u0018\u0001\u0005\u0002yCQ!\u001a\u0001\u0005\u0002\u0019DQ!\u001a\u0001\u0005\nIDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe*\u0011\u0011CE\u0001\t[\u0016$\u0018\rZ1uC*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0015\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\u001bE,x\u000e^1NC:\fw-\u001a:t+\u00051\u0003CA\u00142\u001d\tAsF\u0004\u0002*]9\u0011!&L\u0007\u0002W)\u0011AFF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!a\u0005\u000b\n\u0005A\u0012\u0012\u0001D)v_R\fg)Y2u_JL\u0018B\u0001\u001a4\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011\u0001GE\u0001\u000fcV|G/Y'b]\u0006<WM]:!\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7/F\u00018!\tA4(D\u0001:\u0015\tQD#A\u0004oKR<xN]6\n\u0005qJ$\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001baJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u000b\u0002\u0001B\u0011\u0011)T\u0007\u0002\u0005*\u00111\tR\u0001\u0004Y><'BA#G\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002H\u0011\u000691\u000f^8sC\u001e,'BA\u000bJ\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\n\u00059\u0013%A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%A\nbkRDwN]5{KJ\u001cuN\u001c4jO>\u0003H/F\u0001S!\rI2+V\u0005\u0003)j\u0011aa\u00149uS>t\u0007C\u0001,[\u001b\u00059&B\u0001-Z\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0003'!K!aW,\u0003!\u0005+H\u000f[8sSj,'oQ8oM&<\u0017\u0001F1vi\"|'/\u001b>fe\u000e{gNZ5h\u001fB$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006?\u0006\u00147\r\u001a\t\u0003A\u0002i\u0011\u0001\u0005\u0005\u0006I%\u0001\rA\n\u0005\u0006k%\u0001\ra\u000e\u0005\u0006}%\u0001\r\u0001\u0011\u0005\u0006!&\u0001\rAU\u0001\u0007kB$\u0017\r^3\u0015\u0005\u001dT\u0007CA\ri\u0013\tI'D\u0001\u0003V]&$\b\"B6\u000b\u0001\u0004a\u0017aC9v_R\f7\u000fR3mi\u0006\u0004\"!\u001c9\u000e\u00039T!a\u001c%\u0002\u000b%l\u0017mZ3\n\u0005Et'!E\"mS\u0016tG/U;pi\u0006\u001cH)\u001a7uCR\u0019qm]?\t\u000bQ\\\u0001\u0019A;\u0002\r\u0015tG/\u001b;z!\t180D\u0001x\u0015\tA\u00180A\u0003rk>$\u0018M\u0003\u0002{\u0011\u000611m\\7n_:L!\u0001`<\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010C\u0003\u007f\u0017\u0001\u0007q0\u0001\u0006rk>$\u0018\rR3mi\u0006\u00042!\\A\u0001\u0013\r\t\u0019A\u001c\u0002\u0011\u00072LWM\u001c;Rk>$\u0018\rR3mi\u0006\fQ\u0002[1oI2,\u0017\n])v_R\fG#B4\u0002\n\u0005M\u0001bBA\u0006\u0019\u0001\u0007\u0011QB\u0001\tSB,e\u000e^5usB\u0019\u0001-a\u0004\n\u0007\u0005E\u0001CA\u0006Rk>$\u0018-\u00128uSRL\b\"\u0002@\r\u0001\u0004y\u0018!\u00055b]\u0012dW\rV3oC:$\u0018+^8uCR)q-!\u0007\u0002\u001e!9\u00111D\u0007A\u0002\u00055\u0011\u0001\u0004;f]\u0006tG/\u00128uSRL\b\"\u0002@\u000e\u0001\u0004y\u0018a\u00075b]\u0012dW-V:fe\u000ec\u0017.\u001a8u#V|G/Y\"iC:<W\rF\u0004h\u0003G\t9#a\u000f\t\u000f\u0005\u0015b\u00021\u0001\u0002\u000e\u0005Y\u0011/^8uC\u0016sG/\u001b;z\u0011\u001d\tIC\u0004a\u0001\u0003W\t1a[3z!\u0011\ti#!\u000e\u000f\t\u0005=\u0012\u0011\u0007\t\u0003UiI1!a\r\u001b\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0007\u000e\t\u000f\u0005ub\u00021\u0001\u0002@\u0005Aa.Z<WC2,X\r\u0005\u0003\u001a'\u0006\u0005\u0003cA\r\u0002D%\u0019\u0011Q\t\u000e\u0003\r\u0011{WO\u00197f\u0001")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final Option<AuthorizerConfig> authorizerConfigOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public Option<AuthorizerConfig> authorizerConfigOpt() {
        return this.authorizerConfigOpt;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().entrySet().forEach(e -> this.update((ClientQuotaEntity)e.getKey(), (ClientQuotaDelta)e.getValue()));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product ipEntity = product;
            this.handleIpQuota((QuotaEntity)ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("confluent-tenant")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("confluent-tenant"));
            if (option instanceof Some) {
                String tenant = (String)((Some)option).value();
                product = new TenantEntity(tenant);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultTenantEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product tenantEntity = product;
            this.handleTenantQuota((QuotaEntity)tenantEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().entrySet().forEach(e -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)e.getKey(), (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble((OptionalDouble)e.getValue())).map((Function1)(JFunction1.mcDD.sp & Serializable)x$1 -> x$1)));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Ignoring unsupported quota entity ").append(entity).append(".").toString());
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            String ip = ((IpEntity)ipEntity).ip();
            try {
                none$ = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException(new StringBuilder(26).append("Unable to resolve address ").append(ip).toString());
            }
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = none$;
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)inetAddress, arg_0));
    }

    public void handleTenantQuota(QuotaEntity tenantEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (tenantEntity instanceof TenantEntity) {
            String tenant = ((TenantEntity)tenantEntity).tenant();
            none$ = new Some((Object)tenant);
        } else if (DefaultTenantEntity$.MODULE$.equals(tenantEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle tenant quota entities here");
        }
        None$ tenantOpt = none$;
        quotaDelta.changes().entrySet().forEach(arg_0 -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$1(this, (Option)tenantOpt, tenantEntity, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        None$ none$;
        Some some;
        ClientQuotaManager clientQuotaManager;
        block26: {
            switch (key == null ? 0 : key.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block26;
                }
                case -965904822: {
                    if (!"request_percentage".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block26;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block26;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block26;
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(key).append(" for entity ").append(quotaEntity).toString());
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        if (quotaEntity instanceof UserEntity) {
            String user = ((UserEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = None$.MODULE$;
        } else if (DefaultUserEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = None$.MODULE$;
        } else if (quotaEntity instanceof ClientIdEntity) {
            String clientId = ((ClientIdEntity)quotaEntity).clientId();
            some = None$.MODULE$;
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = None$.MODULE$;
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof ExplicitUserExplicitClientIdEntity) {
            ExplicitUserExplicitClientIdEntity explicitUserExplicitClientIdEntity = (ExplicitUserExplicitClientIdEntity)quotaEntity;
            String user = explicitUserExplicitClientIdEntity.user();
            String clientId = explicitUserExplicitClientIdEntity.clientId();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (quotaEntity instanceof ExplicitUserDefaultClientIdEntity) {
            String user = ((ExplicitUserDefaultClientIdEntity)quotaEntity).user();
            some = new Some((Object)Sanitizer.sanitize((String)user));
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else if (quotaEntity instanceof DefaultUserExplicitClientIdEntity) {
            String clientId = ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId();
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = new Some((Object)Sanitizer.sanitize((String)clientId));
        } else if (DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)) {
            some = new Some((Object)ConfigEntityName$.MODULE$.Default());
            none$ = new Some((Object)ConfigEntityName$.MODULE$.Default());
        } else {
            if (quotaEntity instanceof IpEntity ? true : DefaultIpEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see IP quota entities here");
            }
            if (quotaEntity instanceof TenantEntity ? true : DefaultTenantEntity$.MODULE$.equals(quotaEntity)) {
                throw new IllegalStateException("Should not see tenant quota entities here");
            }
            throw new MatchError((Object)quotaEntity);
        }
        None$ none$2 = none$;
        Option sanitizedUser = (Option)some;
        Option sanitizedClientId = (Option)none$2;
        Option quotaValue = newValue.map((Function1 & Serializable)x$6 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)x$6)));
        try {
            void var13_14;
            void var12_13;
            manager.updateQuota((Option<String>)var12_13, (Option<String>)var13_14.map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1)), (Option<String>)var13_14, (Option<Quota>)quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Failed to update user-client quota ").append(quotaEntity).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (!quotaName.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(ipEntity$1).toString());
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to update IP quota ").append(ipEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$5(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$handleTenantQuota$16(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$14(ClientQuotaMetadataManager $this, Option tenantOpt$1, OptionalDouble quotaValue$1, AuthorizerConfig authorizerConfig) {
        authorizerConfig.setTenantMaxAcls(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1)), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue$1)).map((Function1)(JFunction1.mcID.sp & Serializable)x$4 -> (int)x$4).map((Function1 & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$16(BoxesRunTime.unboxToInt((Object)x))))));
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Setting tenant-level max acl count limit for tenant ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValue$1).toString());
    }

    public static final /* synthetic */ void $anonfun$handleTenantQuota$1(ClientQuotaMetadataManager $this, Option tenantOpt$1, QuotaEntity tenantEntity$1, Map.Entry e) {
        String quotaName = (String)e.getKey();
        OptionalDouble quotaValue = (OptionalDouble)e.getValue();
        if (quotaName.equals("connection_creation_rate")) {
            try {
                $this.connectionQuotas().updateTenantConnectionRateQuota((Option<String>)tenantOpt$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)));
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("producer_id_expiration_ms")) {
            try {
                Optional quotaValueIntOpt = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable)x$2 -> (int)x$2).map((Function1 & Serializable)x -> ClientQuotaMetadataManager.$anonfun$handleTenantQuota$5(BoxesRunTime.unboxToInt((Object)x)))));
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Setting tenant-level producer ID expiration for tenant ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValueIntOpt).toString());
                $this.producerStateManagerConfig().setProducerIdExpirationMs(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1)), quotaValueIntOpt);
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("connection_creation_count")) {
            try {
                $this.connectionQuotas().updateTenantConnectionCountQuota((Option<String>)tenantOpt$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(quotaValue)).map((Function1)(JFunction1.mcID.sp & Serializable)x$3 -> (int)x$3).map((Function1)(JFunction1.mcII.sp & Serializable)x -> x));
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Setting tenant connection count quota ").append(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(tenantOpt$1))).append(" to ").append(quotaValue).toString());
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        if (quotaName.equals("acl_count")) {
            try {
                $this.authorizerConfigOpt().foreach((Function1 & Serializable)authorizerConfig -> {
                    ClientQuotaMetadataManager.$anonfun$handleTenantQuota$14($this, tenantOpt$1, quotaValue, authorizerConfig);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable t) {
                $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Failed to update tenant quota ").append(tenantEntity$1).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                return;
            }
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Ignoring unexpected quota key ").append(quotaName).append(" for entity ").append(tenantEntity$1).toString());
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$6) {
        return new Quota(x$6, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas, ProducerStateManagerConfig producerStateManagerConfig, Option<AuthorizerConfig> authorizerConfigOpt) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
        this.producerStateManagerConfig = producerStateManagerConfig;
        this.authorizerConfigOpt = authorizerConfigOpt;
    }
}

