/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.BackupObjectsMetadata;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.BlobMetadata;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.DatedList;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.Header;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.TopicMetadata;
import io.confluent.kafka.backupRestore.objectLifecycle.serdes.TopicRetentionData;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtils;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtilsContext;
import kafka.tier.backupObjectLifecycle.StateManagerConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.BackupObjectsListMetadata;
import kafka.tier.store.objects.metadata.LifecycleManagerStateMetadata;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateManager {
    private static final Logger log = LoggerFactory.getLogger(StateManager.class);
    private static final int STATE_LENGTH_LENGTH = 4;
    public static final int LIFECYCLE_MANAGER_STATE_CURRENT_VERSION = 1;

    public static LifecycleManagerState getState(StateManagerConfig config) throws InterruptedException, IOException, IllegalArgumentException, LifecycleManagerVersionException {
        LifecycleManagerState state;
        try (InputStream stream = null;){
            TierObjectStoreResponse response = StateManager.getStateBufFromObjectStore(config);
            stream = response.getInputStream();
            int stateDataLength = StateManager.getSerializedBufferLength(stream);
            ByteBuffer stateDataBuf = ByteBuffer.allocate(stateDataLength);
            int bytesRead = Utils.readBytes((InputStream)stream, (ByteBuffer)stateDataBuf, (int)stateDataLength, (boolean)false);
            if (bytesRead != stateDataLength) {
                throw new IOException("Failed to read the complete state file bytesRead = " + bytesRead + " stateDataLength = " + stateDataLength);
            }
            stateDataBuf.flip();
            state = LifecycleManagerState.getRootAsLifecycleManagerState((ByteBuffer)stateDataBuf);
            if (state.header().version() != 1) {
                throw new LifecycleManagerVersionException("Expected LifecycleManagerState version 1 Currently stored version" + state.header().version());
            }
        }
        return state;
    }

    public static void deleteAllStateFiles(StateManagerConfig config, ThreadPoolExecutor executor) throws InterruptedException {
        BackupObjectsListMetadata metadata = new BackupObjectsListMetadata(config.clusterId, "", "");
        String prefix = metadata.generateKeyPrefix("");
        ObjectStoreUtilsContext ctx = new ObjectStoreUtilsContext(config.objectStore, config.isCLMEnabled, config.isShuttingDownOrInterrupted);
        Set<String> stateFiles = ObjectStoreUtils.listObject(ctx, prefix, false, LifecycleManager.DEFAULT_RETRY_POLICY).keySet();
        List<TierObjectStore.KeyAndVersion> keys = stateFiles.stream().map(TierObjectStore.KeyAndVersion::new).collect(Collectors.toList());
        log.info("Deleting the following state files " + keys);
        if (!keys.isEmpty()) {
            ObjectStoreUtils.deleteVersions(ctx, keys, executor, LifecycleManager.DEFAULT_RETRY_POLICY);
        }
    }

    public static LifecycleManagerState deserializeState(ByteBuffer buf) throws IOException {
        ByteBuffer duplicateBuffer = buf.duplicate();
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        duplicateBuffer.get(lengthBuffer.array(), 0, 4);
        int length = lengthBuffer.getInt();
        if (length > duplicateBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        return LifecycleManagerState.getRootAsLifecycleManagerState((ByteBuffer)duplicateBuffer);
    }

    private static int getSerializedBufferLength(InputStream stream) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        int bytesRead = Utils.readBytes((InputStream)stream, (ByteBuffer)buf, (int)4, (boolean)false);
        if (bytesRead < 4) {
            throw new IOException("Failed to read the length of the state file");
        }
        buf.flip();
        return buf.getInt();
    }

    private static TierObjectStoreResponse getStateBufFromObjectStore(StateManagerConfig config) throws IOException, InterruptedException {
        LifecycleManagerStateMetadata metadata = new LifecycleManagerStateMetadata(config.clusterId);
        log.debug("Get Lifecycle Manager state file " + metadata.toFragmentLocation("", FragmentType.LIFECYCLE_MANAGER_STATE).get().objectPath() + " from object store");
        ObjectStoreUtilsContext ctx = new ObjectStoreUtilsContext(config.objectStore, config.isCLMEnabled, config.isShuttingDownOrInterrupted);
        return ObjectStoreUtils.getObjectStoreFragment(ctx, metadata, FragmentType.LIFECYCLE_MANAGER_STATE, LifecycleManager.DEFAULT_RETRY_POLICY);
    }

    public static void loadDeletionList(StateManagerConfig config, String date, String namePrefix, Map<String, Map<TopicIdPartition, List<LifecycleManager.BlobMetadata>>> dateToDeletableBlobs) throws InterruptedException, IOException {
        BackupObjectsMetadata backupObjectsMetadata;
        log.debug("Load backup objects list for date: " + date + " name: " + namePrefix);
        try {
            backupObjectsMetadata = StateManager.getDeletionList(config, date, namePrefix);
        }
        catch (LifecycleManagerVersionException e) {
            log.info(e.getMessage() + " " + date + " " + namePrefix);
            return;
        }
        dateToDeletableBlobs.putIfAbsent(date, new HashMap());
        Map<TopicIdPartition, List<LifecycleManager.BlobMetadata>> tpIdToBlobs = dateToDeletableBlobs.get(date);
        for (int i = 0; i < backupObjectsMetadata.topicsLength(); ++i) {
            TopicMetadata topicMetadata = backupObjectsMetadata.topics(i);
            TopicIdPartition tpId = new TopicIdPartition(topicMetadata.name(), UUID.fromString(topicMetadata.id()), topicMetadata.partition());
            tpIdToBlobs.putIfAbsent(tpId, new ArrayList());
            List<LifecycleManager.BlobMetadata> blobs = tpIdToBlobs.get(tpId);
            for (int j = 0; j < topicMetadata.blobsLength(); ++j) {
                BlobMetadata blobMetadata = topicMetadata.blobs(j);
                blobs.add(new LifecycleManager.BlobMetadata(blobMetadata.id(), blobMetadata.timeForDeletionInMs(), blobMetadata.retentionInDays()));
            }
        }
    }

    public static String generateNextObjectsListName(String name) {
        int nextNum = 1;
        if (name == null) {
            return String.format("%08d", nextNum);
        }
        nextNum = Integer.parseInt(name) + 1;
        return String.format("%08d", nextNum);
    }

    public static BackupObjectsMetadata getDeletionList(StateManagerConfig config, String date, String namePrefix) throws InterruptedException, IOException, IllegalArgumentException, LifecycleManagerVersionException {
        BackupObjectsMetadata deletionList;
        try (InputStream stream = null;){
            TierObjectStoreResponse response = StateManager.getDeletionListBufFromObjectStore(config, date, namePrefix);
            stream = response.getInputStream();
            int deletionListBufferLength = StateManager.getSerializedBufferLength(stream);
            ByteBuffer deletionListBuf = ByteBuffer.allocate(deletionListBufferLength);
            int bytesRead = Utils.readBytes((InputStream)stream, (ByteBuffer)deletionListBuf, (int)deletionListBufferLength, (boolean)false);
            if (bytesRead != deletionListBufferLength) {
                throw new IOException("Failed to read the complete deletion list, bytesRead = " + bytesRead + " deletionListBufferLength = " + deletionListBufferLength);
            }
            deletionListBuf.flip();
            deletionList = BackupObjectsMetadata.getRootAsBackupObjectsMetadata((ByteBuffer)deletionListBuf);
            if (deletionList.header().version() != 1) {
                throw new LifecycleManagerVersionException("Expected Lifecycle manager state version 1 Current file version" + deletionList.header().version());
            }
        }
        return deletionList;
    }

    private static TierObjectStoreResponse getDeletionListBufFromObjectStore(StateManagerConfig config, String date, String namePrefix) throws IOException, InterruptedException {
        BackupObjectsListMetadata metadata = new BackupObjectsListMetadata(config.clusterId, date, namePrefix);
        log.debug("Get Backup Objects list buffer " + metadata.toFragmentLocation("", FragmentType.BACKUP_OBJECTS_LIST).get().objectPath() + " from object store");
        ObjectStoreUtilsContext ctx = new ObjectStoreUtilsContext(config.objectStore, config.isCLMEnabled, config.isShuttingDownOrInterrupted);
        return ObjectStoreUtils.getObjectStoreFragment(ctx, metadata, FragmentType.BACKUP_OBJECTS_LIST, LifecycleManager.DEFAULT_RETRY_POLICY);
    }

    public static ByteBuffer serializeState(Long currTimeMs, long[] endOffsets, Map<NameAndId, Integer> retentionConfigs, Map<NameAndId, LifecycleManager.ReductionInRetention> retentionChanges, Map<String, String> dateToLatestListNames) {
        FlatBufferBuilder builder = new FlatBufferBuilder(512);
        int headerOffset = Header.createHeader((FlatBufferBuilder)builder, (int)1);
        int tierOffsetsOffset = LifecycleManagerState.createTierOffsetsVector((FlatBufferBuilder)builder, (long[])endOffsets);
        int[] retentionDataOffsets = new int[retentionConfigs.size()];
        int i = 0;
        for (Map.Entry<NameAndId, Integer> entry : retentionConfigs.entrySet()) {
            NameAndId topic = entry.getKey();
            Integer currentRetention = entry.getValue();
            int n = builder.createString((CharSequence)topic.name());
            int lastNotedRetention = currentRetention;
            Long minDeletionTimestamp = -1L;
            Long timestampOfRetentionChange = -1L;
            if (retentionChanges.containsKey(topic) && !retentionChanges.get((Object)topic).hasCompleted) {
                lastNotedRetention = retentionChanges.get((Object)topic).lastNotedRetentionValueInDays;
                minDeletionTimestamp = retentionChanges.get((Object)topic).minDeletionTimestamp;
                timestampOfRetentionChange = retentionChanges.get((Object)topic).changeTimestamp;
            }
            int topicIdOffset = builder.createString((CharSequence)topic.id().toString());
            retentionDataOffsets[i] = TopicRetentionData.createTopicRetentionData((FlatBufferBuilder)builder, (int)n, (int)lastNotedRetention, (long)minDeletionTimestamp, (long)timestampOfRetentionChange, (int)topicIdOffset);
            ++i;
        }
        int retentionDataVectorOffset = LifecycleManagerState.createRetentionDataVector((FlatBufferBuilder)builder, (int[])retentionDataOffsets);
        int[] datedListsOffsets = new int[dateToLatestListNames.size()];
        int j = 0;
        for (Map.Entry entry : dateToLatestListNames.entrySet()) {
            String date = (String)entry.getKey();
            String latestList = (String)entry.getValue();
            int dateOffset = builder.createString((CharSequence)date);
            int latestListOffset = builder.createString((CharSequence)latestList);
            datedListsOffsets[j] = DatedList.createDatedList((FlatBufferBuilder)builder, (int)dateOffset, (int)latestListOffset);
            ++j;
        }
        int latestDataFilesVector = LifecycleManagerState.createLatestDataFilesVector((FlatBufferBuilder)builder, (int[])datedListsOffsets);
        LifecycleManagerState.startLifecycleManagerState((FlatBufferBuilder)builder);
        LifecycleManagerState.addHeader((FlatBufferBuilder)builder, (int)headerOffset);
        LifecycleManagerState.addLastRunTimestamp((FlatBufferBuilder)builder, (long)currTimeMs);
        LifecycleManagerState.addTierOffsets((FlatBufferBuilder)builder, (int)tierOffsetsOffset);
        LifecycleManagerState.addRetentionData((FlatBufferBuilder)builder, (int)retentionDataVectorOffset);
        LifecycleManagerState.addLatestDataFiles((FlatBufferBuilder)builder, (int)latestDataFilesVector);
        int n = LifecycleManagerState.endLifecycleManagerState((FlatBufferBuilder)builder);
        builder.finishSizePrefixed(n);
        return builder.dataBuffer().slice();
    }

    public static ByteBuffer serializeBackupObjectsList(Map<TopicIdPartition, List<LifecycleManager.BlobMetadata>> tpIdToBlobs) {
        int[] topicMetadataOffsets = new int[tpIdToBlobs.size()];
        FlatBufferBuilder builder = new FlatBufferBuilder(512);
        int headerOffset = Header.createHeader((FlatBufferBuilder)builder, (int)1);
        int i = 0;
        for (Map.Entry<TopicIdPartition, List<LifecycleManager.BlobMetadata>> entry : tpIdToBlobs.entrySet()) {
            TopicIdPartition tpId = entry.getKey();
            List<LifecycleManager.BlobMetadata> blobs = entry.getValue();
            int nameOffset = builder.createString((CharSequence)tpId.topic());
            int topicIdOffset = builder.createString((CharSequence)tpId.topicId().toString());
            int[] blobMetadataOffsets = new int[blobs.size()];
            for (int j = 0; j < blobs.size(); ++j) {
                LifecycleManager.BlobMetadata blob = blobs.get(j);
                int objectIdOffset = builder.createString((CharSequence)blob.objectId);
                blobMetadataOffsets[j] = BlobMetadata.createBlobMetadata((FlatBufferBuilder)builder, (int)objectIdOffset, (long)blob.timeForDeletionMs, (int)blob.retentionDays);
            }
            int blobsVectorOffset = TopicMetadata.createBlobsVector((FlatBufferBuilder)builder, (int[])blobMetadataOffsets);
            topicMetadataOffsets[i] = TopicMetadata.createTopicMetadata((FlatBufferBuilder)builder, (int)nameOffset, (int)topicIdOffset, (int)tpId.partition(), (int)blobsVectorOffset);
            ++i;
        }
        int topicsVectorOffset = BackupObjectsMetadata.createTopicsVector((FlatBufferBuilder)builder, (int[])topicMetadataOffsets);
        BackupObjectsMetadata.startBackupObjectsMetadata((FlatBufferBuilder)builder);
        BackupObjectsMetadata.addHeader((FlatBufferBuilder)builder, (int)headerOffset);
        BackupObjectsMetadata.addTopics((FlatBufferBuilder)builder, (int)topicsVectorOffset);
        int finishOffset = BackupObjectsMetadata.endBackupObjectsMetadata((FlatBufferBuilder)builder);
        builder.finishSizePrefixed(finishOffset);
        return builder.dataBuffer().slice();
    }

    public static void putStateBufToObjectStore(StateManagerConfig config, ByteBuffer buf) throws InterruptedException {
        LifecycleManagerStateMetadata metadata = new LifecycleManagerStateMetadata(config.clusterId);
        ObjectStoreUtilsContext ctx = new ObjectStoreUtilsContext(config.objectStore, config.isCLMEnabled, config.isShuttingDownOrInterrupted);
        ObjectStoreUtils.putBuffer(ctx, metadata, buf, ObjectType.LIFECYCLE_MANAGER_STATE, LifecycleManager.DEFAULT_RETRY_POLICY);
    }

    public static void putBackedUpObjectsListBufToObjectStore(StateManagerConfig config, ByteBuffer buf, String date, String namePrefix) throws InterruptedException {
        BackupObjectsListMetadata metadata = new BackupObjectsListMetadata(config.clusterId, date, namePrefix);
        String key = metadata.toFragmentLocation("", FragmentType.BACKUP_OBJECTS_LIST).get().objectPath();
        log.debug("Put backup objects list " + key + " at object store");
        ObjectStoreUtilsContext ctx = new ObjectStoreUtilsContext(config.objectStore, config.isCLMEnabled, config.isShuttingDownOrInterrupted);
        ObjectStoreUtils.putBuffer(ctx, metadata, buf, ObjectType.BACKUP_OBJECTS_LIST, LifecycleManager.DEFAULT_RETRY_POLICY);
    }

    public static String convertToDateKey(Long timeInMs) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date(timeInMs);
        return dateFormat.format(date);
    }

    public static Map<String, String> loadLatestDeletionListNamesFrom(Date currentDate, LifecycleManagerState state) throws ParseException {
        HashMap<String, String> dateToLatestDeletionListName = new HashMap<String, String>();
        if (state == null) {
            return dateToLatestDeletionListName;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        for (int i = 0; i < state.latestDataFilesLength(); ++i) {
            String dateStr = state.latestDataFiles(i).date();
            Date date = dateFormat.parse(dateStr);
            if (date.before(currentDate)) continue;
            dateToLatestDeletionListName.put(dateStr, state.latestDataFiles(i).latestFile());
        }
        return dateToLatestDeletionListName;
    }

    public static class LifecycleManagerVersionException
    extends Exception {
        public LifecycleManagerVersionException(String message) {
            super(message);
        }
    }
}

