/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.tier.serdes.MetadataSnapshotUploadComplete;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;

public class TierMetadataSnapshotUploadComplete
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte VERSION_V2 = 2;
    public static final byte VERSION_V3 = 3;
    public static final byte VERSION_V4 = 4;
    public static final byte CURRENT_VERSION = 4;
    private static final int INITIAL_BUFFER_SIZE = 120;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotUploadComplete metadata;

    public TierMetadataSnapshotUploadComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset, kafka.tier.state.OffsetAndEpoch snapshotOffset, long snapshotTimestampMs, byte checksumAlgorithm, Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotUploadComplete.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotUploadComplete.buildMetadataSnapshotComplete(builder, tierEpoch, objectId, stateOffset, snapshotOffset, snapshotTimestampMs, checksumAlgorithm, partitionCreationOffsetAndEpoch);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotUploadComplete.getRootAsMetadataSnapshotUploadComplete((ByteBuffer)builder.dataBuffer());
    }

    public TierMetadataSnapshotUploadComplete(TopicIdPartition topicIdPartition, MetadataSnapshotUploadComplete metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public TierMetadataSnapshotUploadComplete(TierMetadataSnapshotUploadInitiate snapshotInitiate, FileTierPartitionStateSnapshotObject snapshotObject, Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch) {
        this(snapshotInitiate.topicIdPartition(), snapshotInitiate.tierEpoch(), snapshotInitiate.messageId(), snapshotInitiate.stateOffsetAndEpoch(), snapshotObject.lastMaterializedEventOffsetAndEpoch(), snapshotObject.snapshotTimestampMs(), snapshotObject.checksumAlgorithm().id, partitionCreationOffsetAndEpoch);
    }

    static int buildMetadataSnapshotComplete(FlatBufferBuilder builder, int tierEpoch, UUID objectId, kafka.tier.state.OffsetAndEpoch stateOffset, kafka.tier.state.OffsetAndEpoch snapshotOffset, long snapshotTimestampMs, byte checksumAlgorithm, Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch) {
        MetadataSnapshotUploadComplete.startMetadataSnapshotUploadComplete((FlatBufferBuilder)builder);
        MetadataSnapshotUploadComplete.addVersion((FlatBufferBuilder)builder, (byte)4);
        MetadataSnapshotUploadComplete.addTierEpoch((FlatBufferBuilder)builder, (int)tierEpoch);
        int objectIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)objectId.getMostSignificantBits(), (long)objectId.getLeastSignificantBits());
        MetadataSnapshotUploadComplete.addObjectId((FlatBufferBuilder)builder, (int)objectIdOffset);
        int stateOffsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)stateOffset.offset(), (int)stateOffset.epoch().orElse(-1));
        MetadataSnapshotUploadComplete.addStateOffsetAndEpoch((FlatBufferBuilder)builder, (int)stateOffsetAndEpochId);
        int snapshotOffsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)snapshotOffset.offset(), (int)snapshotOffset.epoch().orElse(-1));
        MetadataSnapshotUploadComplete.addSnapshotOffsetAndEpoch((FlatBufferBuilder)builder, (int)snapshotOffsetAndEpochId);
        MetadataSnapshotUploadComplete.addSnapshotTimestampMs((FlatBufferBuilder)builder, (long)snapshotTimestampMs);
        MetadataSnapshotUploadComplete.addChecksumAlgorithmId((FlatBufferBuilder)builder, (byte)checksumAlgorithm);
        partitionCreationOffsetAndEpoch.ifPresent(raftOffsetAndEpoch -> {
            int partitionOffsetAndEpochId = OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)raftOffsetAndEpoch.offset(), (int)raftOffsetAndEpoch.epoch());
            MetadataSnapshotUploadComplete.addPartitionCreationOffsetAndEpoch((FlatBufferBuilder)builder, (int)partitionOffsetAndEpochId);
        });
        return MetadataSnapshotUploadComplete.endMetadataSnapshotUploadComplete((FlatBufferBuilder)builder);
    }

    public static int initialBufferSize() {
        return 120;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotUploadComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public kafka.tier.state.OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    public kafka.tier.state.OffsetAndEpoch snapshotOffsetAndEpoch() {
        return this.metadata.snapshotOffsetAndEpoch() == null ? kafka.tier.state.OffsetAndEpoch.EMPTY : new kafka.tier.state.OffsetAndEpoch(this.metadata.snapshotOffsetAndEpoch());
    }

    public Optional<org.apache.kafka.raft.OffsetAndEpoch> partitionCreationOffsetAndEpoch() {
        return Optional.ofNullable(this.metadata.partitionCreationOffsetAndEpoch()).map(v -> new org.apache.kafka.raft.OffsetAndEpoch(v.offset(), v.epoch()));
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        io.confluent.kafka.storage.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public long snapshotTimestampMs() {
        return this.metadata.snapshotTimestampMs();
    }

    public Algorithm checksumAlgorithm() {
        return Algorithm.toAlgorithm((Byte)this.metadata.checksumAlgorithmId());
    }

    public byte version() {
        return this.metadata.version();
    }

    public String toString() {
        return "MetadataSnapshotUploadComplete(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", snapshotId=" + this.messageId() + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", snapshotOffsetAndEpoch=" + this.snapshotOffsetAndEpoch() + ", snapshotTimestampMs=" + this.snapshotTimestampMs() + ", checksum=" + this.checksumAlgorithm() + ", partitionCreationOffsetAndEpoch=" + this.partitionCreationOffsetAndEpoch() + ")";
    }
}

