/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kafka.server.DelayedOperationKey;
import kafka.tier.TierUnfetchedTimestampAndOffset;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.OffsetIndexFetchRequest;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import kafka.tier.fetcher.TierFetcherMetrics;
import kafka.tier.fetcher.TimestampIndexFetchRequest;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.OffsetPosition;

public class PendingOffsetForTimestampAsync
extends PendingOffsetForTimestamp {
    private final int parallelism;
    private final List<TopicPartition> partitionList;
    private final AtomicInteger nextPartitionIndex = new AtomicInteger(0);

    PendingOffsetForTimestampAsync(CancellationContext cancellationContext, TierObjectStore tierObjectStore, Map<TopicPartition, TierUnfetchedTimestampAndOffset> timestamps, Optional<TierFetcherMetrics> tierFetcherMetrics, Consumer<DelayedOperationKey> fetchCompletionCallback, Time time, int parallelism) {
        super(cancellationContext, tierObjectStore, timestamps, tierFetcherMetrics, fetchCompletionCallback, time, Uuid.randomUuid(), "PendingOffsetForTimestampAsync(%s)");
        this.parallelism = parallelism;
        this.partitionList = new ArrayList<TopicPartition>(timestamps.keySet());
    }

    @Override
    public void run() {
        log.debug("Starting offsetForTimestamp async, requestId={}, timestamps={}.", (Object)this.requestId, (Object)this.timestamps);
        long executionStartTimeMs = this.time.hiResClockMs();
        long queuedTimeMs = executionStartTimeMs - this.creationTimeMs;
        this.tierFetcherMetrics.ifPresent(metrics -> metrics.queuedTimeMs().record((double)queuedTimeMs));
        int futureCnt = Math.min(this.parallelism, this.timestamps.size());
        ArrayList<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>(futureCnt);
        for (int i = 0; i < futureCnt; ++i) {
            futureList.add(this.chainOffsetForTimestamp());
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureCnt])).join();
        long timeTakenMs = this.time.hiResClockMs() - executionStartTimeMs;
        this.tierFetcherMetrics.ifPresent(metrics -> metrics.fetchOffsetForTimestampTotalTimeMs().record((double)timeTakenMs));
        String logMsg = String.format("Complete PendingOffsetForTimestampAsync for %d partitions, requestId=%s, queuedTimeMs=%d, executionTimeMs=%d", this.results.size(), this.requestId.toString(), queuedTimeMs, timeTakenMs);
        if (timeTakenMs > 5000L) {
            log.info(logMsg);
        } else {
            log.debug(logMsg);
        }
        this.complete();
    }

    private CompletableFuture<Void> chainOffsetForTimestamp() {
        int partitionIndex = this.nextPartitionIndex.getAndIncrement();
        if (partitionIndex >= this.partitionList.size()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicPartition partition = this.partitionList.get(partitionIndex);
        TierUnfetchedTimestampAndOffset tierTimestampAndOffset = (TierUnfetchedTimestampAndOffset)this.timestamps.get(partition);
        CompletableFuture<Void> future = this.searchOffsetForPartition(partition, tierTimestampAndOffset);
        return future.thenCompose(__ -> this.chainOffsetForTimestamp());
    }

    private CompletableFuture<Void> searchOffsetForPartition(TopicPartition topicPartition, TierUnfetchedTimestampAndOffset tierTimestampAndOffset) {
        ObjectMetadata objectMetadata = tierTimestampAndOffset.metadata;
        long targetTimestamp = tierTimestampAndOffset.timestamp;
        if (this.fetchable(topicPartition)) {
            return ((CompletableFuture)((CompletableFuture)TimestampIndexFetchRequest.fetchOffsetForTimestampAsync(this.cancellationContext, this.tierObjectStore, objectMetadata, targetTimestamp).thenCompose(timestampOffsets -> this.fetchable(topicPartition) ? OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync(this.cancellationContext, this.tierObjectStore, objectMetadata, timestampOffsets) : CompletableFuture.completedFuture(null))).thenCompose(offsetPositions -> offsetPositions != null && this.fetchable(topicPartition) ? this.fetchSegmentRangeAndSearch(objectMetadata, (OffsetPosition[])offsetPositions, targetTimestamp, tierTimestampAndOffset) : CompletableFuture.completedFuture(null))).handle((offsetOpt, e) -> {
                if (e != null) {
                    this.handlePartitionError(topicPartition, tierTimestampAndOffset, (Throwable)e);
                } else if (offsetOpt != null) {
                    this.putOffsetResult(topicPartition, (Optional<Long>)offsetOpt, targetTimestamp);
                }
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Optional<Long>> fetchSegmentRangeAndSearch(ObjectMetadata objectMetadata, OffsetPosition[] offsetPositions, long targetTimestamp, TierUnfetchedTimestampAndOffset tierTimestampAndOffset) {
        CompletableFuture<TierObjectStoreResponse> response = offsetPositions[1] == null ? this.tierObjectStore.getObjectStoreFragmentAsync(objectMetadata, FragmentType.SEGMENT, Long.valueOf(offsetPositions[0].position)) : this.tierObjectStore.getObjectStoreFragmentAsync(objectMetadata, FragmentType.SEGMENT, Long.valueOf(offsetPositions[0].position), Long.valueOf(offsetPositions[1].position));
        return response.thenApply(res -> {
            try {
                Optional<Long> optional = this.reader.offsetForTimestamp(this.cancellationContext, res.getInputStream(), targetTimestamp, tierTimestampAndOffset.objectSize);
                return optional;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                try {
                    res.close();
                }
                catch (Exception e) {
                    log.warn("failed to close TierObjectStoreResponse of SEGMENT byte range", (Throwable)e);
                }
            }
        });
    }
}

