/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.SyncPoller;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AzureBlockBlobAutoAbortingInputStream;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.ThrottledFileInputStream;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.HealthMetadata;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class AzureBlockBlobTierObjectStore
extends TierObjectStore {
    private static final Logger log = LoggerFactory.getLogger(AzureBlockBlobTierObjectStore.class);
    private final BlobServiceClient blobServiceClient;
    private final BlobContainerClient blobContainerClient;
    private final BlobServiceAsyncClient blobServiceAsyncClient;
    public final BlobContainerAsyncClient blobContainerAsyncClient;
    private final Optional<String> clusterIdOpt;
    private final Optional<Integer> brokerIdOpt;
    private final String container;
    private final String prefix;
    private final int drainThreshold;
    private static final long DEFAULT_TIMEOUT_IN_SECS = 30L;

    public AzureBlockBlobTierObjectStore(AzureBlockBlobTierObjectStoreConfig config) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.container = config.container;
        this.prefix = config.azureBlobPrefix;
        this.drainThreshold = config.drainThreshold;
        this.blobServiceClient = AzureBlockBlobTierObjectStore.createServiceClient(config);
        this.blobContainerClient = AzureBlockBlobTierObjectStore.createContainerClient(this.blobServiceClient, config);
        this.blobServiceAsyncClient = AzureBlockBlobTierObjectStore.createServiceAsyncClient(config);
        this.blobContainerAsyncClient = AzureBlockBlobTierObjectStore.createContainerAsyncClient(this.blobServiceAsyncClient, config);
    }

    public AzureBlockBlobTierObjectStore(AzureBlockBlobTierObjectStoreConfig config, BlobServiceClient blobServiceClient, BlobContainerClient blobContainerClient, BlobServiceAsyncClient blobServiceAsyncClient, BlobContainerAsyncClient blobContainerAsyncClient) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.container = config.container;
        this.prefix = config.azureBlobPrefix;
        this.drainThreshold = config.drainThreshold;
        this.blobServiceClient = blobServiceClient;
        this.blobContainerClient = blobContainerClient;
        this.blobServiceAsyncClient = blobServiceAsyncClient;
        this.blobContainerAsyncClient = blobContainerAsyncClient;
    }

    @Override
    public String keyPrefix() {
        return this.prefix;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.AzureBlockBlob;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        HashMap<String, List<VersionInformation>> results = new HashMap<String, List<VersionInformation>>();
        Duration timeout = Duration.ofSeconds(30L);
        try {
            ListBlobsOptions options = new ListBlobsOptions().setPrefix(keyPrefix).setDetails(new BlobListDetails().setRetrieveVersions(getVersionInfo));
            PagedIterable blobItems = this.blobContainerClient.listBlobs(options, timeout);
            for (BlobItem blobItem : blobItems) {
                results.putIfAbsent(blobItem.getName(), new ArrayList());
                if (!getVersionInfo) continue;
                ((List)results.get(blobItem.getName())).add(new VersionInformation(blobItem.getVersionId()));
            }
            if (log.isDebugEnabled()) {
                StringBuilder allBlobs = new StringBuilder();
                results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                log.debug("TierObjectStore listObjects versions: " + getVersionInfo + " prefix: " + keyPrefix + " " + allBlobs);
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to list objects with keyPrefix: %s, getVersionInfo: %b", keyPrefix, getVersionInfo), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to list objects with keyPrefix: %s, getVersionInfo: %b", keyPrefix, getVersionInfo), e);
        }
        return results;
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (fragmentType != FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT && fragmentType != FragmentType.TIER_STATE_SNAPSHOT && fragmentType != FragmentType.PRODUCER_STATE) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + (Object)((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray((InputStream)response.getInputStream(), (int)estimatedBufferSize));
        }
        catch (Exception e) {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof BlobStorageException) || !BlobErrorCode.BLOB_NOT_FOUND.equals((Object)((BlobStorageException)cause).getErrorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        InputStream inputStream;
        String key = this.keyPath(objectMetadata, objectType);
        BlobClient blob = versionInformation != null ? this.blobContainerClient.getBlobVersionClient(key, versionInformation.getVersionId()) : this.blobContainerClient.getBlobClient(key);
        AzureBlockBlobTierObjectStore.checkOffsets(byteOffsetStart, byteOffsetEndExclusive);
        log.debug("Fetching object from {}/{}, with range of {} to {}", new Object[]{this.container, key, byteOffsetStart, byteOffsetEndExclusive});
        long byteOffsetStartLong = byteOffsetStart != null ? byteOffsetStart : 0L;
        BlobRange range = byteOffsetEndExclusive != null ? new BlobRange(byteOffsetStartLong, Long.valueOf(byteOffsetEndExclusive - byteOffsetStartLong)) : new BlobRange(byteOffsetStartLong);
        try {
            inputStream = this.getInputStreamFromBlobClient(blob, range);
        }
        catch (Exception e) {
            throw this.convertFetchException(e, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive);
        }
        Long streamSize = range.getCount();
        return new AzureBlockBlobTierObjectStoreResponse(inputStream, this.drainThreshold, streamSize == null ? Long.MAX_VALUE : streamSize);
    }

    @Override
    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        CompletableFuture<TierObjectStoreResponse> future = new CompletableFuture<TierObjectStoreResponse>();
        try {
            String key = this.keyPath(objectMetadata, objectType);
            BlobAsyncClient blob = versionInformation != null ? this.blobContainerAsyncClient.getBlobVersionAsyncClient(key, versionInformation.getVersionId()) : this.blobContainerAsyncClient.getBlobAsyncClient(key);
            AzureBlockBlobTierObjectStore.checkOffsets(byteOffsetStart, byteOffsetEndExclusive);
            log.debug("Fetching object async from {}/{}, with range of {} to {}", new Object[]{this.container, key, byteOffsetStart, byteOffsetEndExclusive});
            long byteOffsetStartLong = byteOffsetStart == null ? 0L : byteOffsetStart;
            BlobRange range = byteOffsetEndExclusive != null ? new BlobRange(byteOffsetStartLong, Long.valueOf(byteOffsetEndExclusive - byteOffsetStartLong)) : new BlobRange(byteOffsetStartLong);
            Long streamSize = range.getCount();
            blob.getBlockBlobAsyncClient().downloadStreamWithResponse(range, null, new BlobRequestConditions(), false).flatMap(response -> streamSize == null ? FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue())) : FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue()), (int)streamSize.intValue())).subscribe(bytes -> future.complete(new AzureBlockBlobTierObjectStoreResponse(new ByteArrayInputStream((byte[])bytes), this.drainThreshold, ((byte[])bytes).length)), e -> future.completeExceptionally(this.convertFetchException((Throwable)e, key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive)));
        }
        catch (Exception e2) {
            log.error("Failed to send async fetch request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertFetchException(Throwable e, String key, ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        if (e instanceof BlobStorageException) {
            if (BlobErrorCode.BLOB_NOT_FOUND.equals((Object)((BlobStorageException)e).getErrorCode())) {
                return new TierObjectStoreFatalException(String.format("Failed to fetch object from %s, metadata: %s type: %s range %s-%s.Object not found.", new Object[]{key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
            }
            return new TierObjectStoreRetriableException(String.format("Failed to fetch object from %s, metadata: %s type: %s range %s-%s", new Object[]{key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        if (e instanceof RuntimeException) {
            return new TierObjectStoreRetriableException(String.format("Runtime exception when fetching object from %s, metadata: %s type: %s range %s-%s", new Object[]{key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        return new TierObjectStoreFatalException(String.format("Unknown exception when fetching object from %s, metadata: %s type: %s range %s-%s", new Object[]{key, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
    }

    private static void checkOffsets(Long byteOffsetStartOpt, Long byteOffsetEndExclusiveOpt) {
        if (byteOffsetStartOpt != null && byteOffsetEndExclusiveOpt != null && byteOffsetStartOpt > byteOffsetEndExclusiveOpt) {
            throw new IllegalStateException(String.format("Invalid range of byteOffsetStart=%d and byteOffsetEndExclusive=%d", byteOffsetStartOpt, byteOffsetEndExclusiveOpt));
        }
        if (byteOffsetStartOpt == null && byteOffsetEndExclusiveOpt != null) {
            throw new IllegalStateException(String.format("Cannot specify a byteOffsetEndExclusive=%d without specifying a byteOffsetStart", byteOffsetEndExclusiveOpt));
        }
    }

    InputStream getInputStreamFromBlobClient(BlobClient blob, BlobRange range) {
        return blob.getBlockBlobClient().openInputStream(range, new BlobRequestConditions());
    }

    @Override
    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
        return OpaqueData.ZEROED;
    }

    @Override
    public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState, Optional<Throttler> throttlerOpt) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            if (throttlerOpt.isPresent()) {
                this.putFileWithThrottling(this.keyPath(objectMetadata, ObjectType.SEGMENT), metadata, segmentData, throttlerOpt.get());
                this.putFileWithThrottling(this.keyPath(objectMetadata, ObjectType.OFFSET_INDEX), metadata, offsetIndexData, throttlerOpt.get());
                this.putFileWithThrottling(this.keyPath(objectMetadata, ObjectType.TIMESTAMP_INDEX), metadata, timestampIndexData, throttlerOpt.get());
                if (producerStateSnapshotData.isPresent()) {
                    this.putFileWithThrottling(this.keyPath(objectMetadata, ObjectType.PRODUCER_STATE), metadata, producerStateSnapshotData.get(), throttlerOpt.get());
                }
            } else {
                this.putFile(this.keyPath(objectMetadata, ObjectType.SEGMENT), metadata, segmentData);
                this.putFile(this.keyPath(objectMetadata, ObjectType.OFFSET_INDEX), metadata, offsetIndexData);
                this.putFile(this.keyPath(objectMetadata, ObjectType.TIMESTAMP_INDEX), metadata, timestampIndexData);
                producerStateSnapshotData.ifPresent(file -> this.putFile(this.keyPath(objectMetadata, ObjectType.PRODUCER_STATE), metadata, (File)file));
            }
            if (transactionIndexData.isPresent()) {
                this.putBuf(this.keyPath(objectMetadata, ObjectType.TRANSACTION_INDEX), metadata, transactionIndexData.get());
            }
            if (epochState.isPresent()) {
                this.putBuf(this.keyPath(objectMetadata, ObjectType.EPOCH_STATE), metadata, epochState.get());
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException("Failed to upload segment " + objectMetadata, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when uploading segment: " + objectMetadata, e);
        }
    }

    @Override
    public void putInMemorySegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            this.putFile(this.keyPath(objectMetadata, ObjectType.SEGMENT), metadata, segmentData);
            this.putFile(this.keyPath(objectMetadata, ObjectType.OFFSET_INDEX), metadata, offsetIndexData);
            this.putFile(this.keyPath(objectMetadata, ObjectType.TIMESTAMP_INDEX), metadata, timestampIndexData);
            if (producerStateSnapshotData.isPresent()) {
                this.putBuf(this.keyPath(objectMetadata, ObjectType.PRODUCER_STATE), metadata, producerStateSnapshotData.get());
            }
            if (transactionIndexData.isPresent()) {
                this.putBuf(this.keyPath(objectMetadata, ObjectType.TRANSACTION_INDEX), metadata, transactionIndexData.get());
            }
            if (epochState.isPresent()) {
                this.putBuf(this.keyPath(objectMetadata, ObjectType.EPOCH_STATE), metadata, epochState.get());
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException("Failed to upload segment " + objectMetadata, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when uploading segment: " + objectMetadata, e);
        }
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            String key = this.keyPath(objectMetadata, objectType);
            this.putFile(key, metadata, file);
            return key;
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object %s, file %s, type %s", new Object[]{objectMetadata, file, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object %s, file %s, type %s", new Object[]{objectMetadata, file, objectType}), e);
        }
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            String key = this.keyPath(objectMetadata, objectType);
            this.putBuf(key, metadata, buffer);
            return key;
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object %s, buffer %s, type %s", new Object[]{objectMetadata, buffer, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object %s, buffer %s, type %s", new Object[]{objectMetadata, buffer, objectType}), e);
        }
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        String lastLiveVersionId = lastLiveVersion.getVersionId();
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        try {
            BlobClient blobSource = this.blobContainerClient.getBlobVersionClient(key, lastLiveVersionId);
            String copySource = blobSource.getBlobUrl();
            log.debug(String.format("Azure restore key: %s lastLiveVersionId: %s copySource: %s", key, lastLiveVersionId, copySource));
            BlobClient blobDest = this.blobContainerClient.getBlobClient(key);
            BlobBeginCopyOptions options = new BlobBeginCopyOptions(copySource).setMetadata(metadata).setTier(AccessTier.HOT);
            SyncPoller syncPoller = blobDest.beginCopy(options);
            PollResponse pollResponse = syncPoller.waitUntil(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED);
            log.debug(String.format("Azure restore key: %s response status: %s", key, pollResponse.getStatus()));
        }
        catch (BlobStorageException e) {
            if (BlobErrorCode.BLOB_NOT_FOUND.equals((Object)e.getErrorCode())) {
                throw new TierObjectStoreFatalException(String.format("Failed to restore object %s (version: %s) as blob not found", key, lastLiveVersionId), e);
            }
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", key, lastLiveVersionId), e);
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", key, lastLiveVersionId), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Unknown exception when restoring object %s (version: %s)", key, lastLiveVersionId), e);
        }
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) {
        List<String> keys = this.keysForSegment(objectMetadata);
        for (String key : keys) {
            try {
                BlobClient blob = this.blobContainerClient.getBlobClient(key);
                log.debug("Deleting " + key);
                blob.delete();
            }
            catch (BlobStorageException be) {
                if (BlobErrorCode.BLOB_NOT_FOUND.equals((Object)be.getErrorCode())) continue;
                throw new TierObjectStoreRetriableException("Failed to delete file " + key, be);
            }
            catch (RuntimeException e) {
                throw new TierObjectStoreRetriableException("Failed to delete file " + key, e);
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting segment " + objectMetadata, e);
            }
        }
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        Duration timeout = Duration.ofSeconds(30L);
        for (TierObjectStore.KeyAndVersion key : keys) {
            BlobClient blobClient = key.versionId() == null ? this.blobContainerClient.getBlobClient(key.key()) : this.blobContainerClient.getBlobVersionClient(key.key(), key.versionId());
            try {
                Response response = blobClient.deleteWithResponse(null, null, timeout, Context.NONE);
                log.debug("TierObjectStore delete request for " + key + " statusCode: " + response.getStatusCode());
            }
            catch (RuntimeException e) {
                throw new TierObjectStoreRetriableException("Failed to delete versioned objects: " + key, e);
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting versioned objects: " + key, e);
            }
        }
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws IOException, TierObjectStoreRetriableException {
        String key = this.keyPath(objectMetadata, type);
        TierObjectAttribute result = new TierObjectAttribute(false);
        try {
            BlobClient client = this.blobContainerClient.getBlobClient(key);
            if (client.exists().booleanValue()) {
                result.size = client.getProperties().getBlobSize();
                result.exist = true;
                log.trace("objectExists at {}/{} with size {}", new Object[]{this.container, key, result.size});
            }
        }
        catch (RuntimeException e) {
            throw new TierObjectStoreRetriableException("Failed to check for object attributes with metadata " + objectMetadata + " @ " + key, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception while checking for object attributes with metadata " + objectMetadata + " @ " + key, e);
        }
        return result;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        try {
            ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
            HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
            this.putBuf(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload);
            try (InputStream inputStream = this.getObjectStoreFragment(metadata, FragmentType.HEALTH_CHECK).getInputStream();){
                int read;
                while ((read = inputStream.read()) > 0) {
                    log.trace("Bucket probe read {} bytes", (Object)read);
                }
            }
            BlobClient blob = this.blobContainerClient.getBlobClient(key);
            log.debug("Deleting " + key);
            blob.delete();
            return BucketHealthResult.HEALTHY;
        }
        catch (Exception e) {
            log.error("Bucket health checker returned unclassified error", (Throwable)e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    @Override
    public void close() {
    }

    private void putFile(String key, Map<String, String> metadata, File file) {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(key);
        blobClient.uploadFromFile(file.getPath(), new ParallelTransferOptions(), new BlobHttpHeaders(), metadata, AccessTier.HOT, new BlobRequestConditions(), null);
        log.debug("Uploaded file to {}/{}", (Object)this.container, (Object)key);
    }

    private void putFileWithThrottling(String key, Map<String, String> metadata, File file, Throttler throttler) throws IOException {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(key);
        try (BufferedInputStream inputStream = new BufferedInputStream(new ThrottledFileInputStream(file, throttler));){
            blobClient.getBlockBlobClient().uploadWithResponse((InputStream)inputStream, file.length(), new BlobHttpHeaders(), metadata, AccessTier.HOT, null, new BlobRequestConditions(), null, null);
        }
        log.debug("Uploaded file with throttling to {}/{}", (Object)this.container, (Object)key);
    }

    public void putBuf(String key, Map<String, String> metadata, ByteBuffer buf) throws IOException {
        BlobClient blobClient = this.blobContainerClient.getBlobClient(key);
        byte[] md5 = CoreUtils.md5hash(buf);
        try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)new ByteBufferInputStream(buf.duplicate()));){
            blobClient.getBlockBlobClient().uploadWithResponse((InputStream)inputStream, (long)(buf.limit() - buf.position()), new BlobHttpHeaders().setContentMd5(md5), metadata, AccessTier.HOT, md5, new BlobRequestConditions(), null, null);
        }
        log.debug("Uploaded buffer to {}/{}", (Object)this.container, (Object)key);
    }

    private List<String> keysForSegment(ObjectMetadata objectMetadata) {
        ArrayList<String> keys = new ArrayList<String>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add(this.keyPath(objectMetadata, objectType));
                    continue block5;
                }
            }
            keys.add(this.keyPath(objectMetadata, objectType));
        }
        return keys;
    }

    private static BlobServiceClientBuilder createServiceClientBuilder(AzureBlockBlobTierObjectStoreConfig config) {
        BlobServiceClientBuilder blobServiceClientBuilder;
        if (config.azureCredentialsConfig.isPresent()) {
            AzureBlockBlobTierObjectStoreConfig.AzureCredentialsConfig azureCredentialsConfig = config.azureCredentialsConfig.get();
            if (azureCredentialsConfig.connectionStringAuthMethod().booleanValue()) {
                blobServiceClientBuilder = new BlobServiceClientBuilder().connectionString(azureCredentialsConfig.connectionString());
            } else {
                ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(azureCredentialsConfig.azureClientId())).tenantId(azureCredentialsConfig.azureTenantId())).clientSecret(azureCredentialsConfig.azureClientSecret()).build();
                blobServiceClientBuilder = new BlobServiceClientBuilder().endpoint(config.endpoint.get()).credential((TokenCredential)credential);
            }
        } else {
            DefaultAzureCredential credential = new DefaultAzureCredentialBuilder().build();
            blobServiceClientBuilder = new BlobServiceClientBuilder().endpoint(config.endpoint.get()).credential((TokenCredential)credential);
        }
        return blobServiceClientBuilder;
    }

    private static BlobServiceClient createServiceClient(AzureBlockBlobTierObjectStoreConfig config) {
        return AzureBlockBlobTierObjectStore.createServiceClientBuilder(config).buildClient();
    }

    private static BlobServiceAsyncClient createServiceAsyncClient(AzureBlockBlobTierObjectStoreConfig config) {
        return AzureBlockBlobTierObjectStore.createServiceClientBuilder(config).buildAsyncClient();
    }

    private static BlobContainerClient createContainerClient(BlobServiceClient blobServiceClient, AzureBlockBlobTierObjectStoreConfig config) {
        BlobContainerClient blobContainerClient = blobServiceClient.getBlobContainerClient(config.container);
        if (!blobContainerClient.exists()) {
            throw new TierObjectStoreFatalException("Container " + config.container + " does not exist or could not be found");
        }
        return blobContainerClient;
    }

    private static BlobContainerAsyncClient createContainerAsyncClient(BlobServiceAsyncClient blobServiceAsyncClient, AzureBlockBlobTierObjectStoreConfig config) {
        BlobContainerAsyncClient blobContainerAsyncClient = blobServiceAsyncClient.getBlobContainerAsyncClient(config.container);
        if (!blobContainerAsyncClient.exists().blockOptional().orElse(false).booleanValue()) {
            throw new TierObjectStoreFatalException("Container " + config.container + " does not exist or could not be found");
        }
        return blobContainerAsyncClient;
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return objectMetadata.toFragmentLocation(this.prefix, objectType.getDesignatedFragmentType().get()).get().objectPath();
    }

    private static class AzureBlockBlobTierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final InputStream inputStream;

        AzureBlockBlobTierObjectStoreResponse(InputStream inputStream, int drainThreshold, long streamSize) {
            this.inputStream = new AzureBlockBlobAutoAbortingInputStream(inputStream, drainThreshold, streamSize);
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

