/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.Throttler;

public abstract class TierObjectStore {
    public abstract String keyPrefix();

    public abstract Backend getBackend();

    public abstract BucketHealthResult checkBucketHealth();

    public abstract Map<String, List<VersionInformation>> listObject(String var1, boolean var2);

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        TierObjectStore.validateRelativeOffsets(relativeByteOffsetStart, relativeByteOffsetEndExclusive);
        FragmentLocation fragmentLocation = objectMetadata.toFragmentLocation(this.keyPrefix(), fragmentType).orElseThrow(() -> new IllegalArgumentException(String.format("FragmentType %s is not present in the given objectMetadata%s", new Object[]{fragmentType, objectMetadata})));
        long absoluteStartOffset = fragmentLocation.toByteOffsetStartInObject(relativeByteOffsetStart);
        Long absoluteEndOffsetExclusive = fragmentLocation.toByteOffsetEndExclusiveInObject(relativeByteOffsetEndExclusive);
        if (absoluteEndOffsetExclusive != null && absoluteEndOffsetExclusive == absoluteStartOffset) {
            TierObjectAttribute objectAttributes = this.objectExists(objectMetadata, fragmentLocation.objectType());
            if (!objectAttributes.exist) {
                throw new TierObjectStoreRetriableException(String.format("Object %s not found in objectStore while attempting to check existence during fetch of empty range", fragmentLocation.objectPath()));
            }
            if (objectAttributes.size >= 0L && objectAttributes.size < absoluteStartOffset) {
                throw new TierObjectStoreRetriableException(String.format("Attempted to fetch empty range starting from invalid start offset %d from object %s. Actual object size: %d", absoluteStartOffset, fragmentLocation.objectPath(), objectAttributes.size));
            }
            return new TierObjectStoreResponse.EmptyTierObjectStoreResponse();
        }
        return this.getObject(objectMetadata, fragmentLocation.objectType(), absoluteStartOffset, absoluteEndOffsetExclusive, versionInformation);
    }

    static void validateRelativeOffsets(Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive) {
        if (relativeByteOffsetStart == null && relativeByteOffsetEndExclusive != null) {
            throw new IllegalArgumentException("Cannot specify a relativeByteOffsetEndExclusive without specifying a relativeByteOffsetStart");
        }
        if (relativeByteOffsetStart != null && relativeByteOffsetStart < 0L) {
            throw new IllegalArgumentException("relativeByteOffsetStart cannot be negative");
        }
        if (relativeByteOffsetEndExclusive != null && relativeByteOffsetEndExclusive <= 0L) {
            throw new IllegalArgumentException("relativeByteOffsetEndExclusive must be greater than 0");
        }
        if (relativeByteOffsetEndExclusive != null && relativeByteOffsetStart > relativeByteOffsetEndExclusive) {
            throw new IllegalArgumentException(String.format("relativeByteOffsetStart=%s cannot be greater than relativeByteOffsetEndExclusive=%s", relativeByteOffsetStart, relativeByteOffsetEndExclusive));
        }
    }

    protected abstract TierObjectStoreResponse getObject(ObjectStoreMetadata var1, ObjectType var2, Long var3, Long var4, VersionInformation var5) throws IOException;

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) {
        TierObjectStore.validateRelativeOffsets(relativeByteOffsetStart, relativeByteOffsetEndExclusive);
        FragmentLocation fragmentLocation = objectMetadata.toFragmentLocation(this.keyPrefix(), fragmentType).orElseThrow(() -> new IllegalArgumentException(String.format("FragmentType %s is not present in the given objectMetadata %s", new Object[]{fragmentType, objectMetadata})));
        long absoluteStartOffset = fragmentLocation.toByteOffsetStartInObject(relativeByteOffsetStart);
        Long absoluteEndOffsetExclusive = fragmentLocation.toByteOffsetEndExclusiveInObject(relativeByteOffsetEndExclusive);
        if (absoluteEndOffsetExclusive != null && absoluteEndOffsetExclusive == absoluteStartOffset) {
            return this.objectExistsAsync(objectMetadata, fragmentLocation.objectType()).thenApply(objectAttributes -> {
                if (!objectAttributes.exist) {
                    throw new TierObjectStoreRetriableException(String.format("Object %s not found in objectStore while attempting to check existence during fetch of empty range", fragmentLocation.objectPath()));
                }
                if (objectAttributes.size >= 0L && objectAttributes.size < absoluteStartOffset) {
                    throw new TierObjectStoreRetriableException(String.format("Attempted to fetch empty range starting from invalid start offset %d from object %s. Actual object size: %d", absoluteStartOffset, fragmentLocation.objectPath(), objectAttributes.size));
                }
                return new TierObjectStoreResponse.EmptyTierObjectStoreResponse();
            });
        }
        return this.getObjectAsync(objectMetadata, fragmentLocation.objectType(), absoluteStartOffset, absoluteEndOffsetExclusive, versionInformation);
    }

    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        CompletableFuture<TierObjectStoreResponse> future = new CompletableFuture<TierObjectStoreResponse>();
        try {
            TierObjectStoreResponse res = this.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation);
            future.complete(res);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    protected CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        CompletableFuture<TierObjectAttribute> future = new CompletableFuture<TierObjectAttribute>();
        try {
            TierObjectAttribute attribute = this.objectExists(objectMetadata, objectType);
            future.complete(attribute);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public abstract ByteBuffer getSnapshot(ObjectStoreMetadata var1, FragmentType var2, int var3);

    public static Set<ObjectType> getObjectTypesPerSegment() {
        HashSet<ObjectType> objectTypesPerSegment = new HashSet<ObjectType>();
        objectTypesPerSegment.add(ObjectType.SEGMENT);
        objectTypesPerSegment.add(ObjectType.OFFSET_INDEX);
        objectTypesPerSegment.add(ObjectType.TIMESTAMP_INDEX);
        objectTypesPerSegment.add(ObjectType.PRODUCER_STATE);
        objectTypesPerSegment.add(ObjectType.TRANSACTION_INDEX);
        objectTypesPerSegment.add(ObjectType.EPOCH_STATE);
        return objectTypesPerSegment;
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart, Long byteOffsetEndExclusive) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, byteOffsetStart, byteOffsetEndExclusive, null);
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, byteOffsetStart, null, null);
    }

    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType) throws IOException {
        return this.getObjectStoreFragment(objectMetadata, fragmentType, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffsetStart, byteOffsetEndExclusive, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffsetStart, null, null);
    }

    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType) {
        return this.getObjectStoreFragmentAsync(objectMetadata, fragmentType, null);
    }

    public abstract OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException;

    public abstract String putObject(ObjectStoreMetadata var1, File var2, ObjectType var3) throws TierObjectStoreRetriableException, IOException;

    public abstract String putBuffer(ObjectStoreMetadata var1, ByteBuffer var2, ObjectType var3) throws TierObjectStoreRetriableException, IOException;

    public abstract void restoreObjectByCopy(ObjectMetadata var1, String var2, VersionInformation var3);

    public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws TierObjectStoreRetriableException, IOException {
        this.putSegment(objectMetadata, segmentData, offsetIndexData, timestampIndexData, producerStateSnapshotData, transactionIndexData, epochState, Optional.empty());
    }

    public abstract void putSegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<File> var5, Optional<ByteBuffer> var6, Optional<ByteBuffer> var7, Optional<Throttler> var8) throws TierObjectStoreRetriableException, IOException;

    public abstract void putInMemorySegment(ObjectMetadata var1, File var2, File var3, File var4, Optional<ByteBuffer> var5, Optional<ByteBuffer> var6, Optional<ByteBuffer> var7) throws TierObjectStoreRetriableException, IOException;

    public abstract void deleteSegment(ObjectMetadata var1) throws IOException;

    public abstract void deleteVersions(List<KeyAndVersion> var1);

    public abstract TierObjectAttribute objectExists(ObjectStoreMetadata var1, ObjectType var2) throws IOException;

    public abstract void close();

    public static class KeyAndVersion {
        private final String key;
        private final String versionId;

        public KeyAndVersion(String key) {
            this.key = key;
            this.versionId = null;
        }

        public KeyAndVersion(String key, String versionId) {
            this.key = key;
            this.versionId = versionId;
        }

        public String key() {
            return this.key;
        }

        public String versionId() {
            return this.versionId;
        }

        public String toString() {
            String m = "Key: " + this.key();
            if (this.versionId() != null) {
                m = m + " VersionId: " + this.versionId();
            }
            return m;
        }
    }

    public static enum Backend {
        AzureBlockBlob("AzureBlockBlob"),
        GCS("GCS"),
        Mock("Mock"),
        S3("S3"),
        Test("Test");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Backend(String name) {
            this.name = name;
        }
    }

    public static enum DataTypePathPrefix {
        TOPIC("0"),
        TIER_STATE_RESTORE_SNAPSHOTS("1"),
        LAST_ACTIVE_ENCRYPTION_KEY("2"),
        LIFECYCLE_MANAGER_STATE("3"),
        TIER_PARTITION_STATE_METADATA_SNAPSHOT("4"),
        TIER_TOPIC_SNAPSHOT("5"),
        DA_OFFSET_MAP("6"),
        KRAFT_SNAPSHOT("7"),
        TIER_RECOVERY_DATA_UPLOAD("8");

        public final String prefix;

        private DataTypePathPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String prefix() {
            return this.prefix;
        }
    }
}

