/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreMetrics;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.Throttler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;

public class TierObjectStoreMetricsEnabled
extends TierObjectStore {
    private TierObjectStore inner;
    private TierObjectStoreMetrics tierObjectStoreMetrics;
    private Time time;

    public TierObjectStoreMetricsEnabled(TierObjectStore inner, Metrics metrics, Time time) {
        this.inner = inner;
        this.tierObjectStoreMetrics = new TierObjectStoreMetrics(metrics);
        this.time = time;
    }

    @Override
    public String keyPrefix() {
        return this.inner.keyPrefix();
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return this.inner.getBackend();
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        return this.inner.listObject(keyPrefix, getVersionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long relativeByteOffsetStart, Long relativeByteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        this.recordFetchMetrics(fragmentType);
        long startTime = this.time.milliseconds();
        try {
            TierObjectStoreResponse tierObjectStoreResponse = this.inner.getObjectStoreFragment(objectMetadata, fragmentType, relativeByteOffsetStart, relativeByteOffsetEndExclusive, versionInformation);
            return tierObjectStoreResponse;
        }
        finally {
            long endTime = this.time.milliseconds();
            this.tierObjectStoreMetrics.getLatency().record((double)(endTime - startTime));
        }
    }

    @Override
    public CompletableFuture<TierObjectStoreResponse> getObjectStoreFragmentAsync(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffset, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        this.recordFetchMetrics(fragmentType);
        return this.inner.getObjectStoreFragmentAsync(objectMetadata, fragmentType, byteOffset, byteOffsetEndExclusive, versionInformation);
    }

    private void recordFetchMetrics(FragmentType fragmentType) {
        switch (fragmentType) {
            case SEGMENT: {
                this.tierObjectStoreMetrics.segmentFetched().record();
                break;
            }
            case OFFSET_INDEX: {
                this.tierObjectStoreMetrics.offsetIndexFetched().record();
                break;
            }
            case TIMESTAMP_INDEX: {
                this.tierObjectStoreMetrics.timestampIndexFetched().record();
                break;
            }
            case TRANSACTION_INDEX: {
                this.tierObjectStoreMetrics.transactionIndexFetched().record();
                break;
            }
            case PRODUCER_STATE: {
                this.tierObjectStoreMetrics.producerStateFetched().record();
                break;
            }
            case EPOCH_STATE: {
                this.tierObjectStoreMetrics.epochStateFetched().record();
                break;
            }
            case TIER_STATE_SNAPSHOT: {
                this.tierObjectStoreMetrics.tierStateFetched().record();
            }
        }
    }

    @Override
    public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
        return this.inner.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation);
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        return this.inner.getSnapshot(metadata, fragmentType, estimatedBufferSize);
    }

    @Override
    public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
        return this.inner.prepPutSegment();
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) throws TierObjectStoreRetriableException, IOException {
        return this.inner.putObject(objectMetadata, file, objectType);
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) throws TierObjectStoreRetriableException, IOException {
        return this.inner.putBuffer(objectMetadata, buffer, objectType);
    }

    @Override
    public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        this.inner.restoreObjectByCopy(objectMetadata, key, lastLiveVersion);
    }

    @Override
    public void putInMemorySegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws TierObjectStoreRetriableException, IOException {
        long startTime = this.time.milliseconds();
        this.inner.putInMemorySegment(objectMetadata, segmentData, offsetIndexData, timestampIndexData, producerStateSnapshotData, transactionIndexData, epochState);
        long endTime = this.time.milliseconds();
        this.recordUploadMetrics(endTime - startTime, producerStateSnapshotData.isPresent(), transactionIndexData.isPresent(), epochState.isPresent());
    }

    @Override
    public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState, Optional<Throttler> throttlerOpt) throws TierObjectStoreRetriableException, IOException {
        long startTime = this.time.milliseconds();
        this.inner.putSegment(objectMetadata, segmentData, offsetIndexData, timestampIndexData, producerStateSnapshotData, transactionIndexData, epochState, throttlerOpt);
        long endTime = this.time.milliseconds();
        this.recordUploadMetrics(endTime - startTime, producerStateSnapshotData.isPresent(), transactionIndexData.isPresent(), epochState.isPresent());
    }

    private void recordUploadMetrics(long latency, boolean producerStateSnapshotDataPresent, boolean transactionIndexDataPresent, boolean epochStatePresent) {
        this.tierObjectStoreMetrics.putLatency().record((double)latency);
        int totalObjects = 3 + (producerStateSnapshotDataPresent ? 1 : 0) + (transactionIndexDataPresent ? 1 : 0) + (epochStatePresent ? 1 : 0);
        this.tierObjectStoreMetrics.segmentObjectsUploaded().record((double)totalObjects);
    }

    @Override
    public void deleteSegment(ObjectMetadata objectMetadata) throws IOException {
        long startTime = this.time.milliseconds();
        this.inner.deleteSegment(objectMetadata);
        long endTime = this.time.milliseconds();
        this.tierObjectStoreMetrics.deleteLatency().record((double)(endTime - startTime));
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        return this.inner.checkBucketHealth();
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        this.inner.deleteVersions(keys);
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws TierObjectStoreRetriableException, IOException {
        return this.inner.objectExists(objectMetadata, type);
    }

    @Override
    public void close() {
        this.inner.close();
    }
}

