/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.TierPartitionStateEntry;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;

public class FragmentDescriptionWrapper {
    static final int INITIAL_BUFFER_SIZE = 48;
    private final FragmentDescription fragmentDescription;

    public FragmentDescriptionWrapper(FragmentType fragmentType, ObjectType objectType, long filePosition, int size) {
        FlatBufferBuilder builder = new FlatBufferBuilder(48).forceDefaults(true);
        int entryId = FragmentDescription.createFragmentDescription((FlatBufferBuilder)builder, (byte)fragmentType.getByte(), (byte)objectType.getByte(), (long)filePosition, (int)size);
        builder.finish(entryId);
        this.fragmentDescription = FragmentDescription.getRootAsFragmentDescription((ByteBuffer)builder.dataBuffer());
    }

    @JsonCreator
    public FragmentDescriptionWrapper(@JsonProperty(value="fragmentTypeByte") byte fragmentTypeByte, @JsonProperty(value="objectTypeByte") byte objectTypeByte, @JsonProperty(value="filePosition") long filePosition, @JsonProperty(value="size") int size) {
        this(FragmentType.byteToFragmentType(fragmentTypeByte), ObjectType.byteToObjectType(objectTypeByte), filePosition, size);
    }

    public FragmentDescriptionWrapper(FragmentDescription fragmentDescription) {
        this.fragmentDescription = fragmentDescription;
    }

    public static List<FragmentDescriptionWrapper> createFragmentDescriptionsListWithOneFilePerFragment(TopicIdPartition tpid, int segmentSize, long offsetIndexSize, long timestampIndexSize, int transactionIndexSize, int epochStateSize, long producerStateSize) {
        if (offsetIndexSize > Integer.MAX_VALUE || timestampIndexSize > Integer.MAX_VALUE || producerStateSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("At least one per-segment file for topicIdPartition %s exceeds the maximum size of INT_MAX, so we cannot represent its layout in the format required by the tier topic.\noffsetIndexSize: %d, timestampIndexSize: %d, producerStateSize: %d", tpid, offsetIndexSize, timestampIndexSize, producerStateSize));
        }
        if (segmentSize < 0 || offsetIndexSize < 0L || timestampIndexSize < 0L || transactionIndexSize < 0 || epochStateSize < 0 || producerStateSize < 0L) {
            throw new IllegalArgumentException(String.format("At least one per-segment file for topicIdPartition %s has a negative size.\nsegmentSize: %d, offsetIndexSize: %d, timestampIndexSize: %d, transactionIndexSize: %d, epochStateSize: %d, producerStateSize: %d", tpid, segmentSize, offsetIndexSize, timestampIndexSize, transactionIndexSize, epochStateSize, producerStateSize));
        }
        return Arrays.asList(new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT, 0L, segmentSize), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.OFFSET_INDEX, 0L, (int)offsetIndexSize), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.TIMESTAMP_INDEX, 0L, (int)timestampIndexSize), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.TRANSACTION_INDEX, 0L, transactionIndexSize), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.PRODUCER_STATE, 0L, (int)producerStateSize), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.EPOCH_STATE, 0L, epochStateSize));
    }

    public static int serializeFragmentDescriptionsIntoSegmentUploadInitiate(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = FragmentDescriptionWrapper.createSegmentAndMetadataLayoutOffsetsArray(builder, fragmentDescriptionsList);
        return SegmentUploadInitiate.createSegmentAndMetadataLayoutVector((FlatBufferBuilder)builder, (int[])segmentAndMetadataLayoutOffsets);
    }

    public static int serializeFragmentDescriptionsIntoTierPartitionStateEntry(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = FragmentDescriptionWrapper.createSegmentAndMetadataLayoutOffsetsArray(builder, fragmentDescriptionsList);
        return TierPartitionStateEntry.createSegmentAndMetadataLayoutVector((FlatBufferBuilder)builder, (int[])segmentAndMetadataLayoutOffsets);
    }

    private static int[] createSegmentAndMetadataLayoutOffsetsArray(FlatBufferBuilder builder, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        int[] segmentAndMetadataLayoutOffsets = new int[fragmentDescriptionsList.size()];
        for (int i = 0; i < fragmentDescriptionsList.size(); ++i) {
            FragmentDescriptionWrapper fragmentDescription = fragmentDescriptionsList.get(i);
            segmentAndMetadataLayoutOffsets[i] = FragmentDescription.createFragmentDescription((FlatBufferBuilder)builder, (byte)fragmentDescription.fragmentType().getByte(), (byte)fragmentDescription.objectType().getByte(), (long)fragmentDescription.filePosition(), (int)fragmentDescription.size());
        }
        return segmentAndMetadataLayoutOffsets;
    }

    public FragmentType fragmentType() {
        return FragmentType.byteToFragmentType(this.fragmentDescription.fragmentType());
    }

    @JsonProperty(value="fragmentTypeByte", required=true)
    public byte fragmentTypeByte() {
        return this.fragmentType().getByte();
    }

    public ObjectType objectType() {
        return ObjectType.byteToObjectType(this.fragmentDescription.objectType());
    }

    @JsonProperty(value="objectTypeByte", required=true)
    public byte objectTypeByte() {
        return this.objectType().getByte();
    }

    @JsonProperty(value="filePosition", required=true)
    public long filePosition() {
        return this.fragmentDescription.filePosition();
    }

    @JsonProperty(value="size", required=true)
    public int size() {
        return this.fragmentDescription.size();
    }

    int underlyingBufferSize() {
        return this.fragmentDescription.getByteBuffer().capacity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentDescriptionWrapper that = (FragmentDescriptionWrapper)o;
        return Objects.equals(this.fragmentDescription.getByteBuffer(), that.fragmentDescription.getByteBuffer());
    }

    public int hashCode() {
        return Objects.hash(this.fragmentDescription.getByteBuffer());
    }

    public String toString() {
        return String.format("FragmentDescriptionWrapper(fragmentType=%s, ObjectType=%s, filePosition=%d, size=%d)", new Object[]{this.fragmentType(), this.objectType(), this.filePosition(), this.size()});
    }
}

