/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils;

public class DurabilityAuditsOffsetMapMetadata
implements ObjectStoreMetadata {
    private final int version = 0;
    private final UUID objectId;
    private final TopicIdPartition topicIdPartition;

    public DurabilityAuditsOffsetMapMetadata(TopicIdPartition topicIdPartition, UUID objectId) {
        this.objectId = objectId;
        this.topicIdPartition = topicIdPartition;
    }

    public String objectIdAsBase64() {
        return CoreUtils.uuidToBase64(this.objectId);
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadata_version", Integer.toString(0));
        clusterIdOpt.ifPresent(clusterId -> metadata.put("cluster_id", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("broker_id", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.DA_OFFSET_MAP) {
            throw new UnsupportedOperationException(String.format("DurabilityAuditsOffsetMapMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.DA_OFFSET_MAP.prefix + "/" + this.objectIdAsBase64() + "/" + this.topicIdPartition.topicIdAsBase64() + "/" + this.topicIdPartition.partition() + "_v" + 0 + "." + objectType.suffix();
    }

    public String toString() {
        return "DurabilityAuditsOffsetMapMetadata{TopicIdPartition=" + this.topicIdPartition + ", objectId=" + this.objectIdAsBase64() + ", version=" + 0 + '}';
    }
}

