/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class TierTopicHeadDataLossReportMetadata
implements ObjectStoreMetadata {
    public static final int CURRENT_KEY_PATH_VERSION = 0;
    private static final String OBJECT_PATH_DELIMITER = "/";
    private static final String RECOVERY_DIR_PREFIX = "recovery-";
    private static final String REPORT_TIMESTAMP_DELIMITER = "_";
    private static final String SUFFIX_DELIMITER = ".";
    private static final String VERSION_CONSTANT = "v";
    private static final String DATA_LOSS_REPORT_DIR = "tier-topic-head-data-loss-report";
    private final String identifier;
    private final int broker;
    private final String reportCreationTimestamp;
    private final int version;

    private TierTopicHeadDataLossReportMetadata(String identifier, int broker, String reportCreationTimestamp, int version) {
        if (version != 0) {
            throw new IllegalArgumentException(String.format("Unsupported path version:%d for identifier:%s, broker:%d, reportCreationTimestamp:%s", identifier, broker, reportCreationTimestamp, version));
        }
        this.identifier = identifier;
        this.broker = broker;
        this.reportCreationTimestamp = reportCreationTimestamp;
        this.version = version;
    }

    public TierTopicHeadDataLossReportMetadata(String identifier, int broker, String reportCreationTimestamp) {
        this(identifier, broker, reportCreationTimestamp, 0);
    }

    public String identifier() {
        return this.identifier;
    }

    public int broker() {
        return this.broker;
    }

    public int version() {
        return this.version;
    }

    public String reportCreationTimestamp() {
        return this.reportCreationTimestamp;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT) {
            throw new UnsupportedOperationException(String.format("TierPartitionStateUploadMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        String objectPath = this.toPath(keyPrefix, ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get());
        return Optional.of(new FragmentLocation(objectPath, ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        String fileName = this.reportCreationTimestamp + REPORT_TIMESTAMP_DELIMITER + VERSION_CONSTANT + this.version + SUFFIX_DELIMITER + objectType.suffix();
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, TierTopicHeadDataLossReportMetadata.pathPrefix(keyPrefix, this.identifier, this.broker), fileName);
    }

    public static String pathPrefix(String keyPrefix, String identifier, Integer broker) {
        return String.join((CharSequence)OBJECT_PATH_DELIMITER, keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix(), RECOVERY_DIR_PREFIX + identifier, broker.toString(), DATA_LOSS_REPORT_DIR);
    }

    public static TierTopicHeadDataLossReportMetadata fromPath(String filePath) {
        String errorMessage = String.format("The filePath: %s does not have the expected format.", filePath);
        String prefixDelimiter = TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix() + OBJECT_PATH_DELIMITER;
        String[] prefix = filePath.split(prefixDelimiter, 2);
        String[] attributes = prefix[1].split(OBJECT_PATH_DELIMITER);
        String identifier = attributes[0].split(RECOVERY_DIR_PREFIX)[1];
        int broker = Integer.parseInt(attributes[1]);
        TierTopicHeadDataLossReportMetadata.validateAssertion(attributes[2].equals(DATA_LOSS_REPORT_DIR), errorMessage);
        String[] fileNameComponents = attributes[3].split(REPORT_TIMESTAMP_DELIMITER);
        TierTopicHeadDataLossReportMetadata.validateAssertion(fileNameComponents.length == 2, errorMessage);
        String reportCreationTimestamp = fileNameComponents[0];
        String[] versionWithSuffixComponents = fileNameComponents[1].split(Pattern.quote(SUFFIX_DELIMITER));
        TierTopicHeadDataLossReportMetadata.validateAssertion(versionWithSuffixComponents.length == 2, errorMessage);
        String versionStr = versionWithSuffixComponents[0];
        String[] versionComponents = versionStr.split(VERSION_CONSTANT);
        TierTopicHeadDataLossReportMetadata.validateAssertion(versionComponents.length == 2, errorMessage);
        int version = Integer.parseInt(versionComponents[1]);
        String suffix = versionWithSuffixComponents[1];
        TierTopicHeadDataLossReportMetadata.validateAssertion(suffix.equals(ObjectType.TIER_TOPIC_HEAD_DATA_LOSS_REPORT.suffix()), errorMessage);
        return new TierTopicHeadDataLossReportMetadata(identifier, broker, reportCreationTimestamp, version);
    }

    private static void validateAssertion(Boolean assertion, String errorMessage) {
        if (!assertion.booleanValue()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("identifier", this.identifier);
        metadata.put("broker", Integer.toString(this.broker));
        metadata.put("version", String.valueOf(this.version));
        metadata.put("reportCreationTimestamp", this.reportCreationTimestamp);
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicHeadDataLossReportMetadata that = (TierTopicHeadDataLossReportMetadata)o;
        return Objects.equals(this.identifier, that.identifier) && this.broker == that.broker && this.version == that.version && Objects.equals(this.reportCreationTimestamp, that.reportCreationTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.identifier, this.version, this.reportCreationTimestamp);
    }

    public String toString() {
        return "TierTopicHeadDataLossReportMetadata{identifier=" + this.identifier + ", broker=" + this.broker + ", reportCreationTimestamp=" + this.reportCreationTimestamp + ", version=" + this.version + '}';
    }
}

