/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataRecoveryConstants;
import kafka.tier.tools.TierMetadataRecoveryOrchestrator;
import kafka.tier.tools.TierMetadataRecoveryUtils;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.TopicIdPartition;

public final class InitiateTierRecoveryDataUploadCommand {
    static final String COMMAND = "initiate-tier-recovery-data-upload";
    private static final String IDENTIFIER = "identifier";
    private static final String IDENTIFIER_DOC = "Unique identifier representing the recovery upload job.";
    private static final Integer DEFAULT_NUM_THREADS = 4;
    private static final String NUM_THREADS_OVERRIDE = "num-threads-override";
    private static final String NUM_THREADS_OVERRIDE_DOC = String.format("Number of threads required to upload the recovery data. Defaults to %d, but we should not use a non-default value unless absolutely necessary.", DEFAULT_NUM_THREADS);
    private static final String DATA_LOSS_VALIDATOR_OUTPUT = "data-loss-validator-output";
    private static final String DATA_LOSS_VALIDATOR_OUTPUT_DOC = "Name of the file that contains the output of the data loss validator.";
    private static final String AFFECTED_TOPIC_PARTITIONS = "affected-topic-partitions";
    private static final String AFFECTED_TOPIC_PARTITIONS_DOC = "Name of the file that contains the list of affected topic partitions.";

    static void addCommand(Subparsers subparsers) {
        Subparser tierRecoveryDataUpload = subparsers.addParser(COMMAND).help("Upload the FTPS, tier.offsets, and upload metadata to the object store.");
        MutuallyExclusiveGroup runScopeGroup = tierRecoveryDataUpload.addMutuallyExclusiveGroup().required(true);
        runScopeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("broker-ids")}).dest("broker-ids").action((ArgumentAction)Arguments.store()).help("Runs the operation only on the specified brokers");
        runScopeGroup.addArgument(new String[]{RecoveryUtils.makeArgument("all-brokers")}).dest("all-brokers").action((ArgumentAction)Arguments.storeTrue()).help("Runs the operation for all brokers in the cluster");
        tierRecoveryDataUpload.addArgument(new String[]{RecoveryUtils.makeArgument("rest-server-port-override")}).dest("rest-server-port-override").type(Integer.class).setDefault((Object)TierMetadataRecoveryConstants.DEFAULT_REST_SERVER_PORT_OVERRIDE).help(TierMetadataRecoveryConstants.REST_SERVER_PORT_OVERRIDE_DOC);
        tierRecoveryDataUpload.addArgument(new String[]{RecoveryUtils.makeArgument(IDENTIFIER)}).required(true).dest(IDENTIFIER).type(String.class).help(IDENTIFIER_DOC);
        tierRecoveryDataUpload.addArgument(new String[]{RecoveryUtils.makeArgument(NUM_THREADS_OVERRIDE)}).setDefault((Object)DEFAULT_NUM_THREADS).dest(NUM_THREADS_OVERRIDE).type(Integer.class).help(NUM_THREADS_OVERRIDE_DOC);
        MutuallyExclusiveGroup inputDataGroup = tierRecoveryDataUpload.addMutuallyExclusiveGroup().required(true);
        inputDataGroup.addArgument(new String[]{RecoveryUtils.makeArgument(DATA_LOSS_VALIDATOR_OUTPUT)}).dest(DATA_LOSS_VALIDATOR_OUTPUT).type(String.class).help(DATA_LOSS_VALIDATOR_OUTPUT_DOC);
        inputDataGroup.addArgument(new String[]{RecoveryUtils.makeArgument(AFFECTED_TOPIC_PARTITIONS)}).dest(AFFECTED_TOPIC_PARTITIONS).type(String.class).help(AFFECTED_TOPIC_PARTITIONS_DOC);
    }

    static int execute(Namespace namespace) throws ExecutionException, InterruptedException, IOException {
        Set<TopicIdPartition> topicIdPartitions;
        String bootstrapServers = namespace.getString("bootstrap-servers");
        String adminConfig = namespace.getString("admin.config");
        Integer restServerPort = namespace.getInt("rest-server-port-override");
        TierMetadataRecoveryOrchestrator orchestrator = TierMetadataRecoveryUtils.getTierMetadataRecoveryOrchestrator(bootstrapServers, adminConfig, restServerPort);
        String identifier = namespace.getString(IDENTIFIER);
        int numThreads = namespace.getInt(NUM_THREADS_OVERRIDE);
        String dataLossValidatorOutput = namespace.getString(DATA_LOSS_VALIDATOR_OUTPUT);
        String affectedTopicPartitions = namespace.getString(AFFECTED_TOPIC_PARTITIONS);
        if (dataLossValidatorOutput != null) {
            topicIdPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromReconciledDLVOutput(dataLossValidatorOutput).stream().map(tp -> new TopicIdPartition(CoreUtils.toKafkaUUID(tp.topicId()), tp.topicPartition())).collect(Collectors.toSet());
        } else if (affectedTopicPartitions != null) {
            topicIdPartitions = TierMetadataRecoveryUtils.getAffectedTopicPartitionsFromTargetTopicPartitionsFile(affectedTopicPartitions).stream().map(tp -> new TopicIdPartition(CoreUtils.toKafkaUUID(tp.topicId()), tp.topicPartition())).collect(Collectors.toSet());
        } else {
            throw new IllegalArgumentException(String.format("Either %s or %s must be provided", DATA_LOSS_VALIDATOR_OUTPUT, AFFECTED_TOPIC_PARTITIONS));
        }
        if (namespace.getBoolean("all-brokers").booleanValue()) {
            orchestrator.initiateTierRecoveryDataUploadForCluster(topicIdPartitions, identifier, numThreads);
        } else {
            Set<Integer> brokers = TierMetadataRecoveryUtils.getBrokerList(namespace);
            for (Integer broker : brokers) {
                orchestrator.initiateTierRecoveryDataUploadForBroker(topicIdPartitions, identifier, numThreads, broker);
            }
        }
        return 0;
    }
}

