/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.server.Defaults;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicClient;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.CoreUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicCollection;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.AdminCommandFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryUtils {
    private static final Logger log = LoggerFactory.getLogger(RecoveryUtils.class);
    public static final String TIER_PROPERTIES_CONFIG_FILE = "tier.config";
    public static final String TIER_PROPERTIES_CONFIG_FILE_DOC = "The path to a configuration file containing the required properties";
    public static final String COMPARISON_TOOL_INPUT = "input.json";
    public static final String COMPARISON_TOOL_INPUT_DOC = "The path to a json file to be accepted as the input to the tool";
    public static final String COMPARISON_TOOL_OUTPUT = "output.json";
    public static final String COMPARISON_TOOL_OUTPUT_DOC = "The path to a json file where the tool will generate the output";
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE_FORMAT = "<tiered_partition_topic_ID_base64_encoded>:<tiered_partition_topic_name>-<tiered_partition_number> <freeze_merged_log_start_offset>";
    public static final String FENCE_RESULT_JSON_FILE = "fence.json";
    public static final String FENCE_RESULT_JSON_FILE_DOC = "The path to a JSON file containing the output of the successful fencing command.";
    public static final String RESTORE_LOCAL_TIER_STATE_ROOT_DIR = "restore.tier.state.root.dir";
    public static final String RESTORE_LOCAL_TIER_STATE_ROOT_DIR_DOC = "The path to the local root directory containing the tier partition state files to be restored. The files should be organized under the root directory as: /path/to/ftps_root_dir/<TOPIC>-<PARTITION>/<TIER-STATE-FILE>. There should be exactly one <TIER-STATE-FILE> under each <TOPIC-PARTITION> sub directory.";
    public static final String RESTORE_REMOTE_TIER_STATE_URIS_FILE = "restore.remote.tier.state.uris.file";
    public static final String RESTORE_REMOTE_TIER_STATE_URIS_FILE_DOC = "The path to the file containing a map of topic partitions to its respective tier partition state file path in the remote object store";
    public static final int FENCE_EVENT_BATCH_SIZE = 1000;
    public static final long FENCE_EVENT_BATCH_SLEEP_MS = Duration.ofSeconds(1L).toMillis();

    public static int getNumPartitions(Producer<byte[], byte[]> producer, String topicName) {
        List partitions = producer.partitionsFor(topicName);
        Optional<Integer> max = partitions.stream().map(PartitionInfo::partition).max(Integer::compareTo);
        if (!max.isPresent()) {
            throw new IllegalStateException("Partitions not found for tier topic " + topicName);
        }
        if (max.get() + 1 > partitions.size()) {
            throw new IllegalStateException("Partitions missing for tier topic " + topicName);
        }
        return partitions.size();
    }

    public static Producer<byte[], byte[]> createTierTopicProducer(Properties properties, String clientId) {
        String tierTopicClientId = TierTopicClient.clientIdPrefix(clientId);
        Properties producerProperties = new Properties();
        producerProperties.putAll((Map<?, ?>)properties);
        TierTopicProducerSupplier.addBaseProperties(producerProperties, tierTopicClientId, Defaults.TierMetadataRequestTimeoutMs(), Defaults.TierTopicProducerEnableIdempotence());
        KafkaProducer newProducer = new KafkaProducer(producerProperties);
        log.info("Created new TierTopic producer! properties={}, , tierTopicClientId={}, newProducer={}", new Object[]{properties, tierTopicClientId, newProducer});
        return newProducer;
    }

    public static RecordMetadata injectTierTopicEvent(Producer<byte[], byte[]> producer, AbstractTierMetadata event, String tierTopicName, int numTierTopicPartitions) throws InterruptedException, ExecutionException {
        TierTopicPartitioner partitioner = new TierTopicPartitioner(numTierTopicPartitions);
        TopicPartition tierTopicPartition = TierTopic.toTierTopicPartition(event.topicIdPartition(), tierTopicName, partitioner);
        try {
            log.info("Injecting TierTopic event: event={}, tierTopicPartition={}, tierTopicName={}, numTierTopicPartitions={}", new Object[]{event, tierTopicPartition, tierTopicName, numTierTopicPartitions});
            RecordMetadata injected = (RecordMetadata)producer.send(new ProducerRecord(tierTopicPartition.topic(), Integer.valueOf(tierTopicPartition.partition()), (Object)event.serializeKey(), (Object)event.serializeValue())).get();
            log.info("Injected TierTopic event! recordMetadata={}", (Object)injected);
            return injected;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to inject TierTopic event={}, tierTopicPartition={}, tierTopicName={}, numTierTopicPartitions={}", new Object[]{event, tierTopicPartition, tierTopicName, numTierTopicPartitions, e});
            throw e;
        }
    }

    public static void injectTierTopicEventsUntilOffset(Producer<byte[], byte[]> producer, TopicIdPartition partition, String tierTopicName, int numTierTopicPartitions, long offsetToStop, boolean freezeLogStartOffset) throws InterruptedException, ExecutionException {
        long currentOffset;
        long eventCount = 0L;
        do {
            currentOffset = RecoveryUtils.injectTierTopicEvent(producer, new TierPartitionFence(partition, UUID.randomUUID(), freezeLogStartOffset), tierTopicName, numTierTopicPartitions).offset();
            if (++eventCount % 1000L != 0L) continue;
            Thread.sleep(FENCE_EVENT_BATCH_SLEEP_MS);
        } while (currentOffset < offsetToStop);
    }

    public static void injectTierTopicEventsUntilOffsetByUserTopic(Map<TopicIdPartition, Long> partitionToFence, Producer<byte[], byte[]> producer, String tierTopicName, int numTierTopicPartitions) throws ExecutionException, InterruptedException {
        for (Map.Entry<TopicIdPartition, Long> entry : partitionToFence.entrySet()) {
            TopicIdPartition partition = entry.getKey();
            long targetOffset = entry.getValue();
            RecoveryUtils.injectTierTopicEventsUntilOffset(producer, partition, tierTopicName, numTierTopicPartitions, targetOffset + 1L, false);
        }
    }

    private static Boolean parseBoolean(String value) {
        if (value.isEmpty() || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid boolean", value));
        }
        return Boolean.valueOf(value);
    }

    private static String[] splitFencingInput(String partitionFencingInfo) {
        String[] tokens = partitionFencingInfo.split(" ");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(String.format("'%s' does not contain topic information and freeze log start offset flag separated by a space. Required format is: '%s'", partitionFencingInfo, FENCE_TARGET_PARTITIONS_CONFIG_FILE_FORMAT));
        }
        return tokens;
    }

    public static Map<TopicIdPartition, Boolean> parseFencingInformation(List<String> allPartitionsFencingInfo) {
        HashMap<TopicIdPartition, Boolean> partitions = new HashMap<TopicIdPartition, Boolean>();
        for (String partitionFencingInfo : allPartitionsFencingInfo) {
            int partition;
            String partitionStr;
            UUID topicId;
            if ((partitionFencingInfo = partitionFencingInfo.trim()).isEmpty()) continue;
            String[] tokens = RecoveryUtils.splitFencingInput(partitionFencingInfo);
            String topicIdPartitionStr = tokens[0].trim();
            Boolean freezeMergedLogStartOffset = RecoveryUtils.parseBoolean(tokens[1].trim());
            String[] components = topicIdPartitionStr.split(":");
            if (components.length != 2) {
                throw new IllegalArgumentException(String.format("'%s' does not contain one colon (':').", topicIdPartitionStr));
            }
            try {
                topicId = CoreUtils.uuidFromBase64(components[0].trim());
            }
            catch (Exception e) {
                String msg = String.format("Item: '%s' has an invalid UUID provided as topic ID: '%s'", topicIdPartitionStr, components[0]);
                throw new IllegalArgumentException(msg, e);
            }
            String suffixTopicNameAndPartitionName = topicIdPartitionStr.substring(components[0].length() + 1).trim();
            int lastSplitIndex = suffixTopicNameAndPartitionName.lastIndexOf(45);
            if (lastSplitIndex == -1) {
                throw new IllegalArgumentException(String.format("Item: '%s' does not contain at least one hyphen ('-').", topicIdPartitionStr));
            }
            String topicName = suffixTopicNameAndPartitionName.substring(0, lastSplitIndex).trim();
            if (topicName.isEmpty()) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot contain an empty topic name: '%s'", topicIdPartitionStr, topicName));
            }
            try {
                partitionStr = suffixTopicNameAndPartitionName.substring(lastSplitIndex + 1).trim();
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot contain an invalid partition number", topicIdPartitionStr));
            }
            try {
                partition = Integer.parseInt(partitionStr);
            }
            catch (NumberFormatException e) {
                String msg = String.format("Item: '%s' has an illegal partition number: '%s'", topicIdPartitionStr, partitionStr);
                throw new IllegalArgumentException(msg, e);
            }
            if (partition < 0) {
                throw new IllegalArgumentException(String.format("Item: '%s' cannot have a negative partition number: '%d'", topicIdPartitionStr, partition));
            }
            partitions.put(new TopicIdPartition(topicName, topicId, partition), freezeMergedLogStartOffset);
        }
        return partitions;
    }

    public static String makeArgument(String arg) {
        return String.format("--%s", arg);
    }

    public static void validatePartitions(Properties properties, Set<TopicIdPartition> inputPartitions) throws CancellationException, IllegalArgumentException {
        Map results;
        TopicCollection.TopicIdCollection checkTopicIds = TopicCollection.ofTopicIds((Collection)inputPartitions.stream().map(TopicIdPartition::kafkaTopicId).collect(Collectors.toSet()));
        try {
            Admin admin = Admin.create((Properties)properties);
            Object object = null;
            try {
                results = (Map)admin.describeTopics((TopicCollection)checkTopicIds).allTopicIds().get();
                if (results.size() != checkTopicIds.topicIds().size()) {
                    throw new AdminCommandFailedException(String.format("Admin client returned the output for: %d topics, input user topics: %d", results.size(), checkTopicIds.topicIds().size()));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (object != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not validate fencing input user topicIds", e);
        }
        HashMap validMaxPartitions = new HashMap();
        for (Map.Entry entry : results.entrySet()) {
            int maxPartition = ((TopicDescription)entry.getValue()).partitions().stream().mapToInt(TopicPartitionInfo::partition).max().orElse(-1);
            validMaxPartitions.put(entry.getKey(), maxPartition);
        }
        HashSet<TopicIdPartition> invalidPartitions = new HashSet<TopicIdPartition>();
        for (TopicIdPartition inputPartition : inputPartitions) {
            Uuid providedTopicId = inputPartition.kafkaTopicId();
            TopicDescription topicDescription = (TopicDescription)results.get(providedTopicId);
            if (topicDescription != null && topicDescription.name().equals(inputPartition.topic())) {
                int providedPartition = inputPartition.partition();
                int validMaxPartition = (Integer)validMaxPartitions.get(providedTopicId);
                if (providedPartition >= 0 && providedPartition <= validMaxPartition) continue;
            }
            invalidPartitions.add(inputPartition);
        }
        if (!invalidPartitions.isEmpty()) {
            throw new IllegalArgumentException(String.format("Found invalid partitions: %s", invalidPartitions));
        }
    }

    public static String randomString(int length) {
        int leftLimit = 97;
        int rightLimit = 122;
        Random random = new Random();
        return random.ints(leftLimit, rightLimit + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String getTempDirectoryForPartition(TopicPartition topicPartition) {
        return String.format("tmp/%s-%d", topicPartition.topic(), topicPartition.partition());
    }
}

