/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.server.Defaults;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Utils;

public class TierPartitionStateFencingTrigger {
    public static final List<String> REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierMetadataNumPartitionsProp(), "confluent.tier.recovery.working.dir");
    public static final String COMMAND_POSITIONAL = "command";
    public static final String USER_TOPIC_PARTITION_FENCE_COMMAND = "fence-user-topic-partitions";
    public static final String TIER_TOPIC_PARTITION_DUMMY_FENCE_EVENTS_COMMAND = "inject-dummy-tier-topic-fence-events";
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE = "file-fence-target-user-partitions";
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE_DOC = "The path to a file containing non-empty list of target tiered partitions to be fenced by the tool. The format of the file is a newline separated list of information. Each line is a comma-separated value (CSV) containing information about a single tiered TopicIdPartition in the following format: <tiered_partition_topic_ID_base64_encoded>:<tiered_partition_topic_name>-<tiered_partition_number> <freeze_merged_log_start_offset> where `freeze_merged_log_start_offset` is a boolean indicating that log start offset must be frozen as part of fencing the partition.";
    public static final String FENCE_EVENT_COUNT_CONFIG = "fence-event-count";
    public static final String FENCE_EVENT_COUNT_CONFIG_DOC = "The number of fence events to be injected for each input partition.";
    public static final String FENCE_TRIGGER_OUTPUT_FILE = "output.json";
    public static final String FENCE_TRIGGER_OUTPUT_FILE_DOC = "The path where JSON containing the fenced partitions, and fence message offsets/UUIDs will be written to.";
    public static final String TIER_TOPIC_PARTITION_TARGET_INPUT_FILE = "file-fence-target-tier-topic-partitions";
    public static final String TIER_TOPIC_PARTITION_TARGET_INPUT_FILE_DOC = "The path to a file containing non-empty list of target tiered topic partitions to offset mapping to be added";
    public static final UUID USER_TOPIC_PARTITION_DUMMY_EVENT_TOPIC_ID = UUID.randomUUID();
    public static final String USER_TOPIC_PARTITION_DUMMY_TOPIC_NAME_PREFIX = "admin_fencing_topic_";
    private static final String USER_TOPIC_PARTITION_DUMMY_EVENT_TOPIC_NAME = "admin_fencing_topic_" + RecoveryUtils.randomString(5);
    private static final int USER_TOPIC_PARTITION_DUMMY_EVENT_PARTITIONS = 1000;

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierPartitionStateFencingTrigger.class.getName()).defaultHelp(true).description("Provides a command to fence tiered topic partitions using the TierPartitionFence event.");
        Subparsers subparsers = parser.addSubparsers().dest(COMMAND_POSITIONAL).help("sub command help");
        TierPartitionStateFencingTrigger.addUserTopicPartitionFenceSubParser(subparsers);
        TierPartitionStateFencingTrigger.addTierTopicPartitionDummyEventsSubParser(subparsers);
        return parser;
    }

    private static void addUserTopicPartitionFenceSubParser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(USER_TOPIC_PARTITION_FENCE_COMMAND).help("Fence tiered topic partitions using the TierPartitionFence event.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("tier.config")}).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FENCE_TARGET_PARTITIONS_CONFIG_FILE)}).dest(FENCE_TARGET_PARTITIONS_CONFIG_FILE).type(String.class).required(true).help(FENCE_TARGET_PARTITIONS_CONFIG_FILE_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FENCE_TRIGGER_OUTPUT_FILE)}).dest(FENCE_TRIGGER_OUTPUT_FILE).type(String.class).required(true).help(FENCE_TRIGGER_OUTPUT_FILE_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FENCE_EVENT_COUNT_CONFIG)}).dest(FENCE_EVENT_COUNT_CONFIG).type(Integer.class).required(false).setDefault((Object)1).help(FENCE_EVENT_COUNT_CONFIG_DOC);
    }

    private static void addTierTopicPartitionDummyEventsSubParser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(TIER_TOPIC_PARTITION_DUMMY_FENCE_EVENTS_COMMAND).help("Inject dummy events into tiered topic partitions.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("tier.config")}).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(TIER_TOPIC_PARTITION_TARGET_INPUT_FILE)}).dest(TIER_TOPIC_PARTITION_TARGET_INPUT_FILE).type((ArgumentType)Arguments.fileType().verifyCanRead()).required(true).help(TIER_TOPIC_PARTITION_TARGET_INPUT_FILE_DOC);
    }

    private static void cleanDirectory(String dir) throws IOException {
        if (dir.isEmpty()) {
            return;
        }
        File root = new File(dir);
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        System.out.println("Deleting all files under working directory: " + dir);
        ArrayList<File> filesToKeep = new ArrayList<File>();
        filesToKeep.add(root);
        Utils.delete((File)root, filesToKeep, (boolean)false);
    }

    private static void run(ArgumentParser parser, Namespace args) throws ArgumentParserException, InterruptedException, IOException, ExecutionException {
        switch (args.getString(COMMAND_POSITIONAL)) {
            case "fence-user-topic-partitions": {
                TierPartitionStateFencingTrigger.runUserTopicPartitionFence(parser, args);
                break;
            }
            case "inject-dummy-tier-topic-fence-events": {
                TierPartitionStateFencingTrigger.runTierTopicPartitionDummyEventsFence(parser, args);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command: " + args.getString(COMMAND_POSITIONAL));
            }
        }
    }

    private static Properties readAndValidateProperties(ArgumentParser parser, String propertiesConfFile) throws ArgumentParserException {
        Properties props;
        try {
            ArrayList<String> requiredTotal = new ArrayList<String>();
            requiredTotal.addAll(REQUIRED_PROPERTIES);
            requiredTotal.addAll(ProducerConfig.configNames());
            props = Utils.loadProps((String)propertiesConfFile, requiredTotal);
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format("Can not load properties from file: '%s'", propertiesConfFile), (Throwable)e, parser);
        }
        String bootstrapServers = props.getProperty("bootstrap.servers", "").trim();
        if (bootstrapServers.isEmpty()) {
            throw new ArgumentParserException(String.format("The provided properties conf file: '%s' can not contain empty or absent bootstrap servers as value for the property: '%s'", propertiesConfFile, "bootstrap.servers"), parser);
        }
        try {
            int tierMetadataPartitions = Integer.parseInt(props.getProperty(KafkaConfig.TierMetadataNumPartitionsProp(), String.valueOf(Defaults.TierMetadataNumPartitions())));
            if (tierMetadataPartitions < 0) {
                throw new IllegalArgumentException(String.format("Tier metadata partitions: %d must be non-negative", tierMetadataPartitions));
            }
        }
        catch (NumberFormatException e) {
            throw new ArgumentParserException(String.format("Cannot parse tier metadata partitions from input properties file: '%s'", propertiesConfFile), (Throwable)e, parser);
        }
        return props;
    }

    private static void runUserTopicPartitionFence(ArgumentParser parser, Namespace args) throws ArgumentParserException, IOException, ExecutionException, InterruptedException {
        Map<TopicIdPartition, Boolean> tieredTopicIdPartitions;
        List<String> tieredTopicIdPartitionsStr;
        String propertiesConfFile = args.getString("tier.config").trim();
        Properties props = TierPartitionStateFencingTrigger.readAndValidateProperties(parser, propertiesConfFile);
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        String tieredTopicIdPartitionFile = args.getString(FENCE_TARGET_PARTITIONS_CONFIG_FILE).trim();
        int fenceEventCount = args.getInt(FENCE_EVENT_COUNT_CONFIG);
        System.out.println("Fence event count: " + fenceEventCount);
        try {
            Path filePath = Paths.get(tieredTopicIdPartitionFile, new String[0]);
            tieredTopicIdPartitionsStr = Files.readAllLines(filePath);
            tieredTopicIdPartitions = RecoveryUtils.parseFencingInformation(tieredTopicIdPartitionsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArgumentParserException(String.format("Can not parse partitions information from file: '%s'", tieredTopicIdPartitionFile), (Throwable)e, parser);
        }
        if (tieredTopicIdPartitions.isEmpty()) {
            throw new ArgumentParserException(String.format("Found no partitions information in file: '%s'", tieredTopicIdPartitionFile), parser);
        }
        System.out.printf("Read the following tiered TopicIdPartition from %s as candidates for fencing:%n%s%n%n", tieredTopicIdPartitionFile, String.join((CharSequence)"\n", tieredTopicIdPartitionsStr));
        String outputFile = args.getString(FENCE_TRIGGER_OUTPUT_FILE).trim();
        File file = new File(outputFile);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputFile);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputFile);
        }
        String workingDirName = props.getProperty("confluent.tier.recovery.working.dir", "");
        try {
            TierPartitionStateFencingTrigger.cleanDirectory(workingDirName);
        }
        catch (IOException e) {
            System.err.println("Failed to clean the working directory " + e);
            throw new IllegalStateException("Failed to clean the working directory ", e);
        }
        RecoveryUtils.validatePartitions(props, tieredTopicIdPartitions.keySet());
        try (FileOutputStream fos = new FileOutputStream(file);){
            List<FenceEventInfo> events = TierPartitionStateFencingTrigger.injectFencingEvents(props, tierTopicNamespace, tieredTopicIdPartitions, fenceEventCount);
            fos.write(FenceEventInfo.listToJson(events).getBytes());
        }
    }

    private static void runTierTopicPartitionDummyEventsFence(ArgumentParser parser, Namespace args) throws ArgumentParserException, ExecutionException, InterruptedException {
        Map<TopicIdPartition, Long> inputParsedOffsets;
        String propertiesConfFile = args.getString("tier.config").trim();
        Properties props = TierPartitionStateFencingTrigger.readAndValidateProperties(parser, propertiesConfFile);
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        int tierMetadataPartitions = Integer.parseInt(props.getProperty(KafkaConfig.TierMetadataNumPartitionsProp(), String.valueOf(Defaults.TierMetadataNumPartitions())));
        String inputFile = args.getString(TIER_TOPIC_PARTITION_TARGET_INPUT_FILE).trim();
        try {
            Path path = Paths.get(inputFile, new String[0]);
            List<String> inputOffsets = Files.readAllLines(path);
            inputParsedOffsets = TierPartitionStateFencingTrigger.parseTierTopicPartitionTargetOffset(USER_TOPIC_PARTITION_DUMMY_EVENT_TOPIC_ID, USER_TOPIC_PARTITION_DUMMY_EVENT_TOPIC_NAME, 1000, inputOffsets, tierMetadataPartitions);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArgumentParserException(String.format("Can not parse partitions information from file: '%s'", inputFile), (Throwable)e, parser);
        }
        if (inputParsedOffsets.isEmpty()) {
            throw new ArgumentParserException(String.format("Found no partitions information in file: '%s'", inputFile), parser);
        }
        if (inputParsedOffsets.size() > tierMetadataPartitions) {
            throw new ArgumentParserException(String.format("Found '%d' partitions that map to Tier Topic Partition, expected %d in file: '%s'", inputParsedOffsets.size(), tierMetadataPartitions, inputFile), parser);
        }
        System.out.printf("Generated the following dummy tiered topic partitions and target offsets from %s as candidates for injecting dummy fencing events:%n", inputFile);
        for (Map.Entry<TopicIdPartition, Long> entry : inputParsedOffsets.entrySet()) {
            System.out.println("dummyUserTopicPartition=" + entry.getKey() + " targetTierTopicPartition=" + new TierTopicPartitioner(tierMetadataPartitions).partitionId(entry.getKey()) + " targetOffset=" + entry.getValue());
        }
        TierPartitionStateFencingTrigger.injectDummyFencingEvents(props, tierTopicNamespace, inputParsedOffsets);
    }

    public static void injectDummyFencingEvents(Properties properties, String tierTopicNamespace, Map<TopicIdPartition, Long> tierTopicPartitionTargetOffsets) throws ExecutionException, InterruptedException {
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        try (Producer<byte[], byte[]> producer = RecoveryUtils.createTierTopicProducer(properties, TierPartitionStateFencingTrigger.class.getSimpleName());){
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            RecoveryUtils.injectTierTopicEventsUntilOffsetByUserTopic(tierTopicPartitionTargetOffsets, producer, tierTopicName, numTierTopicPartitions);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<FenceEventInfo> injectFencingEvents(Properties properties, String tierTopicNamespace, Map<TopicIdPartition, Boolean> tieredTopicIdPartitions, int eventCount) throws ExecutionException, InterruptedException {
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        ArrayList<FenceEventInfo> events = new ArrayList<FenceEventInfo>();
        try (Producer<byte[], byte[]> producer = RecoveryUtils.createTierTopicProducer(properties, TierPartitionStateFencingTrigger.class.getSimpleName());){
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            for (Map.Entry<TopicIdPartition, Boolean> entry : tieredTopicIdPartitions.entrySet()) {
                TopicIdPartition tieredPartition = entry.getKey();
                Boolean freezeMergedLogStartOffset = entry.getValue();
                for (int i = 0; i < eventCount; ++i) {
                    TierPartitionFence fencingEvent = new TierPartitionFence(tieredPartition, UUID.randomUUID(), freezeMergedLogStartOffset);
                    RecordMetadata metadata = RecoveryUtils.injectTierTopicEvent(producer, fencingEvent, tierTopicName, numTierTopicPartitions);
                    FenceEventInfo event = new FenceEventInfo(tieredPartition.topic(), tieredPartition.topicIdAsBase64(), tieredPartition.partition(), CoreUtils.uuidToBase64(fencingEvent.messageId()), freezeMergedLogStartOffset, metadata.offset(), metadata.partition(), metadata.timestamp());
                    events.add(event);
                    if (i % 1000 != 0) continue;
                    Thread.sleep(RecoveryUtils.FENCE_EVENT_BATCH_SLEEP_MS);
                }
            }
            ArrayList<FenceEventInfo> arrayList = events;
            return arrayList;
        }
        catch (Exception e) {
            System.err.println("Could not inject fencing events.");
            e.printStackTrace();
            throw e;
        }
    }

    private static HashMap<Integer, Integer> createDummyUserTopicPartitionMap(UUID topicId, String topicName, int userTopicPartitions, int tierMetadataPartitions) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        TierTopicPartitioner partitioner = new TierTopicPartitioner(tierMetadataPartitions);
        for (int i = 0; i < userTopicPartitions; ++i) {
            TopicIdPartition tpId = new TopicIdPartition(topicName, topicId, i);
            int partitionId = partitioner.partitionId(tpId);
            map.put(partitionId, i);
        }
        System.out.printf("Injecting dummy fence events into tier topic partitions with topicId: %s topicName: %s%n", CoreUtils.uuidToBase64(topicId), topicName);
        System.out.println("Creating dummy Tier Topic Partition map with number of entries: " + map.size());
        for (Map.Entry entry : map.entrySet()) {
            System.out.println(entry.getKey() + " = " + entry.getValue());
        }
        if (map.size() != tierMetadataPartitions) {
            throw new IllegalStateException(String.format("Could not generate enough %d user topic partitions which map to all %d Tier Topic Partition, please re-run the tool again", userTopicPartitions, tierMetadataPartitions));
        }
        return map;
    }

    public static Map<TopicIdPartition, Long> parseTierTopicPartitionTargetOffset(UUID dummyTopicId, String dummyTopicName, int dummyPartitions, List<String> allPartitionToOffsetInfo, int tierMetadataPartitions) {
        HashMap<Integer, Integer> dummyUserTopicPartitionMap = TierPartitionStateFencingTrigger.createDummyUserTopicPartitionMap(dummyTopicId, dummyTopicName, dummyPartitions, tierMetadataPartitions);
        HashMap<TopicIdPartition, Long> targetOffsets = new HashMap<TopicIdPartition, Long>();
        for (String partitionToOffsetInfo : allPartitionToOffsetInfo) {
            if ((partitionToOffsetInfo = partitionToOffsetInfo.trim()).isEmpty()) continue;
            String[] tokens = partitionToOffsetInfo.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException(String.format("'%s' does not contain partition and offset separated by a space. Required format is: '%s'", partitionToOffsetInfo, "<partition> <offset>"));
            }
            try {
                int partition = Integer.parseInt(tokens[0].trim());
                long offset = Long.parseLong(tokens[1].trim());
                if (partition < 0 || partition >= tierMetadataPartitions) {
                    throw new IllegalArgumentException(String.format("'%d' partition number should be in range [0, %d)", partition, tierMetadataPartitions));
                }
                if (offset < 0L) {
                    throw new IllegalArgumentException(String.format("'%d' offset should be non-negative", offset));
                }
                targetOffsets.put(new TopicIdPartition(dummyTopicName, dummyTopicId, dummyUserTopicPartitionMap.get(partition)), offset);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Item: '%s' has an illegal partition number or offset", partitionToOffsetInfo), e);
            }
        }
        if (targetOffsets.size() != allPartitionToOffsetInfo.size()) {
            throw new IllegalArgumentException(String.format("Input contains '%d' partitions, expected '%d'. This is due to duplicate partitions in input list", allPartitionToOffsetInfo.size(), targetOffsets.size()));
        }
        if (targetOffsets.size() > tierMetadataPartitions) {
            throw new IllegalArgumentException(String.format("Input contains '%d' partitions, expected at most '%d'", targetOffsets.size(), tierMetadataPartitions));
        }
        return targetOffsets;
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateFencingTrigger.createArgParser();
            try {
                TierPartitionStateFencingTrigger.run(parser, parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

