/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.tools.TierPartitionStateUploadResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;

public class TierPartitionStateUploadTask
implements Callable<Map<TopicIdPartition, TierPartitionStateUploadResult>> {
    private static final Logger log = LoggerFactory.getLogger(TierPartitionStateUploadTask.class);
    private volatile boolean isCancelled = false;
    private final Set<TopicIdPartition> topicIdPartitions;
    private final TierObjectStore objectStore;
    private final LogManager logManager;
    private final String identifier;
    private final int broker;
    private final Algorithm checksumAlgorithm;
    private final String baseName = MergedLog.filenamePrefixFromOffset(0L) + MergedLog.TierStateSuffix();

    public TierPartitionStateUploadTask(Set<TopicIdPartition> topicIdPartitions, TierObjectStore objectStore, LogManager logManager, String identifier, KafkaConfig config) {
        this.topicIdPartitions = topicIdPartitions;
        this.objectStore = objectStore;
        this.logManager = logManager;
        this.identifier = identifier;
        this.broker = config.brokerId();
        boolean checksumEnabled = config.confluentConfig().tierChecksumFeatureEnabled();
        this.checksumAlgorithm = checksumEnabled ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    }

    private TierPartitionStateUploadResult uploadTierPartitionState(TopicIdPartition topicIdPartition, Path uploadFilePath) {
        FileTierPartitionStateUploadObject uploadObject = new FileTierPartitionStateUploadObject(this.baseName, this.checksumAlgorithm);
        FileTierPartitionStateRecoveryUploadMetadata metadata = new FileTierPartitionStateRecoveryUploadMetadata(this.identifier, this.broker, topicIdPartition, uploadObject);
        try {
            String keyPath = TierObjectStoreFunctionUtils.putObject(() -> false, this.objectStore, uploadFilePath.toFile(), metadata, ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
            log.info("Upload tier partition state for topic partition: " + topicIdPartition.toString() + " to object store succeeded");
            return TierPartitionStateUploadResult.makeWithResult(keyPath);
        }
        catch (IOException | InterruptedException | TierObjectStoreFatalException e) {
            log.error("Received exception while uploading tier partition state for topic partition: " + topicIdPartition.toString(), (Throwable)e);
            return TierPartitionStateUploadResult.makeWithException(e);
        }
    }

    private Map<TopicIdPartition, TierPartitionState> getTierPartitionStates() {
        return JavaConverters.asJavaCollection(this.logManager.allLogs()).stream().filter(abstractLog -> this.topicIdPartitions.contains(abstractLog.topicIdPartition().get())).collect(Collectors.toMap(log -> (TopicIdPartition)log.topicIdPartition().get(), AbstractLog::tierPartitionState));
    }

    public void cancel() {
        this.isCancelled = true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public Map<TopicIdPartition, TierPartitionStateUploadResult> call() {
        HashMap<TopicIdPartition, TierPartitionStateUploadResult> result = new HashMap<TopicIdPartition, TierPartitionStateUploadResult>();
        Map<TopicIdPartition, TierPartitionState> tierPartitionStates = this.getTierPartitionStates();
        for (TopicIdPartition tp : this.topicIdPartitions) {
            if (this.isCancelled()) {
                log.info("TierPartitionStateUploadTask cancelled. Exiting...");
                break;
            }
            Path copyFile = tierPartitionStates.get(tp).backupStateForRecovery();
            TierPartitionStateUploadResult uploadResult = this.uploadTierPartitionState(tp, copyFile);
            if (uploadResult.hasException()) {
                log.error("Failed to upload tier partition state for topic partition: " + tp);
            } else {
                log.debug("Successfully uploaded tier partition state for topic partition: " + tp);
            }
            result.put(tp, uploadResult);
        }
        return result;
    }
}

