/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.server.KafkaRaftServer$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.FailedRegistrationResult;
import kafka.zk.KRaftRegistrationResult;
import kafka.zk.KafkaZkClient;
import kafka.zk.ProducerIdBlockZNode$;
import kafka.zk.SuccessfulRegistrationResult;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zk.migration.ZkAclMigrationClient;
import kafka.zk.migration.ZkBrokerHealthMigrationClient;
import kafka.zk.migration.ZkClusterLinkMigrationClient;
import kafka.zk.migration.ZkConfigMigrationClient;
import kafka.zk.migration.ZkDelegationTokenMigrationClient;
import kafka.zk.migration.ZkReplicaExclusionMigrationClient;
import kafka.zk.migration.ZkTopicMigrationClient;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerReplicaExclusion;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.BrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.ClusterLinkMetadata;
import org.apache.kafka.metadata.migration.ClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.DelegationTokenMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rx!B\u0016-\u0011\u0003\td!B\u001a-\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004bB\u001f\u0002\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0006\u0001\u000b\u0011B \t\u000b\r\u000bA\u0011\u0001#\t\u000f\tM\u0015\u0001\"\u0001\u0003\u0016\"9!\u0011Z\u0001\u0005\u0002\t-g\u0001B\u001a-\u0001\u0019C\u0001B\u0019\u0005\u0003\u0002\u0003\u0006Ia\u0019\u0005\tM\"\u0011\t\u0011)A\u0005O\"A1\u000f\u0003B\u0001B\u0003%A\u000f\u0003\u0005x\u0011\t\u0005\t\u0015!\u0003y\u0011!Y\bB!A!\u0002\u0013a\b\"C@\t\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\t9\u0001\u0003B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003\u001fA!\u0011!Q\u0001\n\u0005E\u0001BCA\f\u0011\t\u0005\t\u0015!\u0003\u0002\u001a!11\b\u0003C\u0001\u0003?Aq!a\r\t\t\u0003\n)\u0004C\u0004\u0002B!!\t%a\u0011\t\u000f\u0005%\u0003\u0002\"\u0011\u0002L!9\u0011q\n\u0005\u0005B\u0005E\u0003bBA+\u0011\u0011\u0005\u0011q\u000b\u0005\b\u0003\u0003DA\u0011AAb\u0011\u001d\t9\u000f\u0003C\u0001\u0003SDq!a=\t\t\u0003\t)\u0010C\u0004\u0002z\"!\t!a?\t\u000f\u0005}\b\u0002\"\u0001\u0003\u0002!9!Q\u0001\u0005\u0005\u0002\t\u001d\u0001b\u0002B\r\u0011\u0011\u0005!1\u0004\u0005\b\u0005CAA\u0011\u0001B\u0012\u0011\u001d\u00119\u0003\u0003C!\u0005SAqAa\u000f\t\t\u0003\u0012i\u0004C\u0004\u0003F!!\tEa\u0012\t\u000f\tU\u0003\u0002\"\u0011\u0003X!11\u000f\u0003C!\u0005KBaa\u001e\u0005\u0005B\t\u001d\u0004BB>\t\t\u0003\u0012I\u0007\u0003\u0004\u0000\u0011\u0011\u0005#1\u000e\u0005\b\u0003\u000fAA\u0011\tB7\u0011\u001d\ty\u0001\u0003C!\u0005_Bq!a\u0006\t\t\u0003\u0012\t(A\t[W6KwM]1uS>t7\t\\5f]RT!!\f\u0018\u0002\u0005i\\'\"A\u0018\u0002\u000b-\fgm[1\u0004\u0001A\u0011!'A\u0007\u0002Y\t\t\"l['jOJ\fG/[8o\u00072LWM\u001c;\u0014\u0005\u0005)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002c\u0005aQ*\u0019=CCR\u001c\u0007nU5{KV\tq\b\u0005\u00027\u0001&\u0011\u0011i\u000e\u0002\u0004\u0013:$\u0018!D'bq\n\u000bGo\u00195TSj,\u0007%A\u0003baBd\u0017\u0010F\u0005F\u0005g\u0012)Ha \u0003\u0002B\u0011!\u0007C\n\u0005\u0011\u001d{E\f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\r=\u0013'.Z2u!\t\u0001&,D\u0001R\u0015\t\u00116+A\u0005nS\u001e\u0014\u0018\r^5p]*\u0011A+V\u0001\t[\u0016$\u0018\rZ1uC*\u0011qF\u0016\u0006\u0003/b\u000ba!\u00199bG\",'\"A-\u0002\u0007=\u0014x-\u0003\u0002\\#\nyQ*[4sCRLwN\\\"mS\u0016tG\u000f\u0005\u0002^A6\taL\u0003\u0002`]\u0005)Q\u000f^5mg&\u0011\u0011M\u0018\u0002\b\u0019><w-\u001b8h\u0003!Q8n\u00117jK:$\bC\u0001\u001ae\u0013\t)GFA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001(GV\u0014(/\u001a8u\u001b\u0016$\u0018\rZ1uC\u0016s7M]=qi>\u0014h)Y2u_JL8+\u001e9qY&,'\u000fE\u0002i[>l\u0011!\u001b\u0006\u0003U.\f\u0001BZ;oGRLwN\u001c\u0006\u0003Y.\u000bA!\u001e;jY&\u0011a.\u001b\u0002\t'V\u0004\b\u000f\\5feB\u0011\u0001/]\u0007\u0002'&\u0011!o\u0015\u0002\u0019\u001b\u0016$\u0018\rZ1uC\u0016s7M]=qi>\u0014h)Y2u_JL\u0018a\u0003;pa&\u001c7\t\\5f]R\u0004\"\u0001U;\n\u0005Y\f&\u0001\u0006+pa&\u001cW*[4sCRLwN\\\"mS\u0016tG/\u0001\u0007d_:4\u0017nZ\"mS\u0016tG\u000f\u0005\u0002Qs&\u0011!0\u0015\u0002\u0016\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0003%\t7\r\\\"mS\u0016tG\u000f\u0005\u0002Q{&\u0011a0\u0015\u0002\u0013\u0003\u000edW*[4sCRLwN\\\"mS\u0016tG/A\u000beK2,w-\u0019;j_:$vn[3o\u00072LWM\u001c;\u0011\u0007A\u000b\u0019!C\u0002\u0002\u0006E\u0013a\u0004R3mK\u001e\fG/[8o)>\\WM\\'jOJ\fG/[8o\u00072LWM\u001c;\u0002#\rdWo\u001d;fe2Kgn[\"mS\u0016tG\u000fE\u0002Q\u0003\u0017I1!!\u0004R\u0005i\u0019E.^:uKJd\u0015N\\6NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0003I\u0011'o\\6fe\"+\u0017\r\u001c;i\u00072LWM\u001c;\u0011\u0007A\u000b\u0019\"C\u0002\u0002\u0016E\u00131D\u0011:pW\u0016\u0014\b*Z1mi\"l\u0015n\u001a:bi&|gn\u00117jK:$\u0018A\u0006:fa2L7-Y#yG2,8/[8o\u00072LWM\u001c;\u0011\u0007A\u000bY\"C\u0002\u0002\u001eE\u0013qDU3qY&\u001c\u0017-\u0012=dYV\u001c\u0018n\u001c8NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u)M)\u0015\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0011\u0015\u0011'\u00031\u0001d\u0011\u00151'\u00031\u0001h\u0011\u0015\u0019(\u00031\u0001u\u0011\u00159(\u00031\u0001y\u0011\u0015Y(\u00031\u0001}\u0011\u0019y(\u00031\u0001\u0002\u0002!9\u0011q\u0001\nA\u0002\u0005%\u0001bBA\b%\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003/\u0011\u0002\u0019AA\r\u0003\u0005:W\r^(s\u0007J,\u0017\r^3NS\u001e\u0014\u0018\r^5p]J+7m\u001c<fef\u001cF/\u0019;f)\u0011\t9$!\u0010\u0011\u0007A\u000bI$C\u0002\u0002<E\u0013!DW6NS\u001e\u0014\u0018\r^5p]2+\u0017\rZ3sg\"L\u0007o\u0015;bi\u0016Dq!a\u0010\u0014\u0001\u0004\t9$\u0001\u0007j]&$\u0018.\u00197Ti\u0006$X-A\rtKRl\u0015n\u001a:bi&|gNU3d_Z,'/_*uCR,G\u0003BA\u001c\u0003\u000bBq!a\u0012\u0015\u0001\u0004\t9$A\u0003ti\u0006$X-A\rdY\u0006LWnQ8oiJ|G\u000e\\3s\u0019\u0016\fG-\u001a:tQ&\u0004H\u0003BA\u001c\u0003\u001bBq!a\u0012\u0016\u0001\u0004\t9$A\u000esK2,\u0017m]3D_:$(o\u001c7mKJdU-\u00193feND\u0017\u000e\u001d\u000b\u0005\u0003o\t\u0019\u0006C\u0004\u0002HY\u0001\r!a\u000e\u00027\rdW-\u00198B]\u0012l\u0015n\u001a:bi\u0016\u001cE.^:uKJd\u0015N\\6t)!\tI&!!\u0002\"\u0006]\u0006\u0003CA.\u0003S\ny'a\u001f\u000f\t\u0005u\u0013Q\r\t\u0004\u0003?:TBAA1\u0015\r\t\u0019\u0007M\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001dt'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\niGA\u0002NCBT1!a\u001a8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;+\u000611m\\7n_:LA!!\u001f\u0002t\t!Q+^5e!\r\u0001\u0016QP\u0005\u0004\u0003\u007f\n&aE\"mkN$XM\u001d'j].lU\r^1eCR\f\u0007bBAB/\u0001\u0007\u0011QQ\u0001\u000fe\u0016\u001cwN\u001d3D_:\u001cX/\\3s!\u0015A\u0017qQAF\u0013\r\tI)\u001b\u0002\t\u0007>t7/^7feB1\u0011QRAH\u0003'k\u0011a[\u0005\u0004\u0003#['\u0001\u0002'jgR\u0004B!!&\u0002\u001e6\u0011\u0011q\u0013\u0006\u0005\u0003k\nIJC\u0002\u0002\u001cV\u000baa]3sm\u0016\u0014\u0018\u0002BAP\u0003/\u0013A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0007bBAR/\u0001\u0007\u0011QU\u0001\u0012_B,'/\u0019;j_:\u001cuN\\:v[\u0016\u0014\bc\u00025\u0002(\u0006-\u0016\u0011W\u0005\u0004\u0003SK'A\u0003\"j\u0007>t7/^7feB!\u00111LAW\u0013\u0011\ty+!\u001c\u0003\rM#(/\u001b8h!\r\u0001\u00161W\u0005\u0004\u0003k\u000b&aF&SC\u001a$X*[4sCRLwN\\(qKJ\fG/[8o\u0011\u001d\tIl\u0006a\u0001\u0003w\u000b\u0011#\\3uC\u0012\fG/Y#oGJL\b\u000f^8s!\r\u0001\u0018QX\u0005\u0004\u0003\u007f\u001b&!E'fi\u0006$\u0017\r^1F]\u000e\u0014\u0018\u0010\u001d;pe\u0006iQ.[4sCR,Gk\u001c9jGN$\"\"!2\u0002L\u00065\u0017\u0011\\Ao!\r1\u0014qY\u0005\u0004\u0003\u0013<$\u0001B+oSRDq!a!\u0019\u0001\u0004\t)\tC\u0004\u0002Pb\u0001\r!!5\u0002!\t\u0014xn[3s\u0013\u0012\u001cuN\\:v[\u0016\u0014\b#\u00025\u0002\b\u0006M\u0007c\u0001%\u0002V&\u0019\u0011q[%\u0003\u000f%sG/Z4fe\"9\u00111\u001c\rA\u0002\u0005e\u0013\u0001F2mkN$XM\u001d'j].\u001cX*\u001a;bI\u0006$\u0018\rC\u0004\u0002`b\u0001\r!!9\u0002\u001f5,G/\u00193bi\u00064VM]:j_:\u0004B!!&\u0002d&!\u0011Q]AL\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017\u0001F7jOJ\fG/\u001a\"s_.,'oQ8oM&<7\u000f\u0006\u0005\u0002F\u0006-\u0018Q^Ax\u0011\u001d\t\u0019)\u0007a\u0001\u0003\u000bCq!a4\u001a\u0001\u0004\t\t\u000eC\u0004\u0002rf\u0001\r!a/\u0002--\u0014\u0018M\u001a;NKR\fG-\u0019;b\u000b:\u001c'/\u001f9u_J\f1#\\5he\u0006$Xm\u00117jK:$\u0018+^8uCN$B!!2\u0002x\"9\u00111\u0011\u000eA\u0002\u0005\u0015\u0015!E7jOJ\fG/\u001a)s_\u0012,8-\u001a:JIR!\u0011QYA\u007f\u0011\u001d\t\u0019i\u0007a\u0001\u0003\u000b\u000b1\"\\5he\u0006$X-Q2mgR!\u0011Q\u0019B\u0002\u0011\u001d\t\u0019\t\ba\u0001\u0003\u000b\u000b1#\\5he\u0006$XM\u0011:pW\u0016\u0014\b*Z1mi\"$b!!2\u0003\n\t-\u0001bBAB;\u0001\u0007\u0011Q\u0011\u0005\b\u0005\u001bi\u0002\u0019\u0001B\b\u0003M\u0011'o\\6feJ+w-[:ue\u0006$\u0018n\u001c8t!!\tiI!\u0005\u0002T\nM\u0011bAA6WB\u0019\u0001O!\u0006\n\u0007\t]1K\u0001\nCe>\\WM\u001d*fO&\u001cHO]1uS>t\u0017\u0001G7jOJ\fG/\u001a*fa2L7-Y#yG2,8/[8ogR1\u0011Q\u0019B\u000f\u0005?Aq!a!\u001f\u0001\u0004\t)\tC\u0004\u0003\u000ey\u0001\rAa\u0004\u0002/5LwM]1uK\u0012+G.Z4bi&|g\u000eV8lK:\u001cH\u0003BAc\u0005KAq!a! \u0001\u0004\t))\u0001\u000edY\u0016\fg.\u00118e\u001b&<'/\u0019;f\u00032dW*\u001a;bI\u0006$\u0018\r\u0006\b\u0002F\n-\"q\u0006B\u0019\u0005g\u0011)D!\u000f\t\u000f\t5\u0002\u00051\u0001\u0002\u0006\u0006i!-\u0019;dQ\u000e{gn];nKJDq!a4!\u0001\u0004\t\t\u000eC\u0004\u0002$\u0002\u0002\r!!*\t\u000f\t5\u0001\u00051\u0001\u0003\u0010!9!q\u0007\u0011A\u0002\u0005=\u0014aC3oGJL\b\u000f^8s\u0013\u0012Dq!a8!\u0001\u0004\t\t/A\u0007sK\u0006$'I]8lKJLEm\u001d\u000b\u0003\u0005\u007f\u0001b!!$\u0003B\u0005M\u0017b\u0001B\"W\n\u00191+\u001a;\u0002\u001dI,\u0017\r\u001a)s_\u0012,8-\u001a:JIR\u0011!\u0011\n\t\u0007\u0003\u001b\u0013YEa\u0014\n\u0007\t53N\u0001\u0005PaRLwN\\1m!\u0011\t)J!\u0015\n\t\tM\u0013q\u0013\u0002\u0011!J|G-^2fe&#7O\u00117pG.\fqb\u001e:ji\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0007\u0003o\u0011IFa\u0019\t\u000f\tm3\u00051\u0001\u0003^\u0005qa.\u001a=u!J|G-^2fe&#\u0007c\u0001\u001c\u0003`%\u0019!\u0011M\u001c\u0003\t1{gn\u001a\u0005\b\u0003\u000f\u001a\u0003\u0019AA\u001c)\u0005!H#\u0001=\u0015\u0003q$\"!!\u0001\u0015\u0005\u0005%ACAA\t)\t\tI\u0002C\u0003c\u000b\u0001\u00071\rC\u0004\u0003x\u0015\u0001\rA!\u001f\u0002\u001fi\\7i\u001c8gS\u001e,enY8eKJ\u00042!\u0018B>\u0013\r\u0011iH\u0018\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\")a-\u0002a\u0001O\"9!1Q\u0003A\u0002\t\u0015\u0015a\u0005>l\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014\b\u0003\u0002BD\u0005\u001fk!A!#\u000b\t\t-%QR\u0001\u0005Y&t7NC\u0002\u0002\u001c:JAA!%\u0003\n\nA2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4F]\u000e|G-\u001a:\u0002\u001f]\u0014\u0018\r\u001d.l\u000bb\u001cW\r\u001d;j_:,BAa&\u0003\u001eR!!\u0011\u0014BX!\u0011\u0011YJ!(\r\u0001\u00119!q\u0014\u0004C\u0002\t\u0005&!\u0001+\u0012\t\t\r&\u0011\u0016\t\u0004m\t\u0015\u0016b\u0001BTo\t9aj\u001c;iS:<\u0007c\u0001\u001c\u0003,&\u0019!QV\u001c\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u00032\u001a!\t\u0019\u0001BZ\u0003\t1g\u000eE\u00037\u0005k\u0013I*C\u0002\u00038^\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0015\u0006\r\tm&q\u0019\t\u0006m\tu&\u0011Y\u0005\u0004\u0005\u007f;$A\u0002;ie><8\u000fE\u0002Q\u0005\u0007L1A!2R\u0005ai\u0015n\u001a:bi&|gn\u00117jK:$X\t_2faRLwN\\\u0012\u0003\u0005\u0003\fQ\u0002\\8h\u0003:$'+\u001a;ie><X\u0003\u0002Bg\u0005'$bAa4\u0003Z\nuG\u0003\u0002Bi\u0005+\u0004BAa'\u0003T\u00129!qT\u0004C\u0002\t\u0005\u0006\u0002\u0003BY\u000f\u0011\u0005\rAa6\u0011\u000bY\u0012)L!5\t\r\tmw\u00011\u0001]\u0003\u0019awnZ4fe\"9!q\\\u0004A\u0002\u0005-\u0016aA7tO\"*qAa/\u0003H\u0002")
public class ZkMigrationClient
implements MigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier;
    private final TopicMigrationClient topicClient;
    public final ConfigMigrationClient kafka$zk$ZkMigrationClient$$configClient;
    private final AclMigrationClient aclClient;
    private final DelegationTokenMigrationClient delegationTokenClient;
    private final ClusterLinkMigrationClient clusterLinkClient;
    private final BrokerHealthMigrationClient brokerHealthClient;
    private final ReplicaExclusionMigrationClient replicaExclusionClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> T logAndRethrow(Logging logger, String msg, Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable logAndRethrow_e) {
            logger.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static <T> T wrapZkException(Function0<T> fn) throws MigrationClientException {
        try {
            return (T)fn.apply();
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public static ZkMigrationClient apply(KafkaZkClient zkClient, PasswordEncoder zkConfigEncoder, Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier, ClusterLinkConfigEncoder zkLinkConfigEncoder) {
        ZkTopicMigrationClient apply_topicClient = new ZkTopicMigrationClient(zkClient);
        ZkConfigMigrationClient apply_configClient = new ZkConfigMigrationClient(zkClient, zkConfigEncoder, zkLinkConfigEncoder);
        ZkAclMigrationClient apply_aclClient = new ZkAclMigrationClient(zkClient);
        ZkClusterLinkMigrationClient apply_clusterLinkClient = new ZkClusterLinkMigrationClient(zkClient, zkLinkConfigEncoder);
        ZkBrokerHealthMigrationClient apply_brokerHealthClient = new ZkBrokerHealthMigrationClient(zkClient);
        ZkReplicaExclusionMigrationClient apply_replicaExclusionClient = new ZkReplicaExclusionMigrationClient(zkClient);
        ZkDelegationTokenMigrationClient apply_delegationTokenClient = new ZkDelegationTokenMigrationClient(zkClient);
        return new ZkMigrationClient(zkClient, currentMetadataEncryptorFactorySupplier, apply_topicClient, apply_configClient, apply_aclClient, apply_delegationTokenClient, apply_clusterLinkClient, apply_brokerHealthClient, apply_replicaExclusionClient);
    }

    public static int MaxBatchSize() {
        return ZkMigrationClient$.MODULE$.MaxBatchSize();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        try {
            return ZkMigrationClient.$anonfun$getOrCreateMigrationRecoveryState$1(this, initialState);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        try {
            return this.zkClient.updateMigrationState(state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$claimControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$releaseControllerLeadership$1(this, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public scala.collection.immutable.Map<Uuid, ClusterLinkMetadata> cleanAndMigrateClusterLinks(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, BiConsumer<String, KRaftMigrationOperation> operationConsumer, MetadataEncryptor metadataEncryptor) {
        scala.collection.mutable.Map clusterLinksMetadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set deletedLinks = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.clusterLinkClient.iterateClusterLinks(new ClusterLinkMigrationClient.ClusterLinkVisitor(this, clusterLinksMetadata, deletedLinks, metadataEncryptor, recordConsumer){
            private final /* synthetic */ ZkMigrationClient $outer;
            private final scala.collection.mutable.Map clusterLinksMetadata$1;
            private final scala.collection.mutable.Set deletedLinks$1;
            private final MetadataEncryptor metadataEncryptor$1;
            private final Consumer recordConsumer$1;

            public void visitClusterLink(ClusterLinkMetadata clusterLinkMetadata, boolean isDeleted) {
                ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
                this.clusterLinksMetadata$1.put((Object)clusterLinkMetadata.linkId(), (Object)clusterLinkMetadata);
                if (isDeleted) {
                    this.deletedLinks$1.add((Object)clusterLinkMetadata.linkId());
                    return;
                }
                ClusterLinkConfig.LinkMode linkMode = ClusterLinkConfig.LinkMode.fromString((String)clusterLinkMetadata.linkProperties().getProperty("link.mode", ClusterLinkConfig.LinkMode.DESTINATION.name()));
                batch.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkId(clusterLinkMetadata.linkId()).setClusterLinkName(clusterLinkMetadata.linkName()).setTenantPrefix((String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata.tenantPrefix())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setRemoteClusterId((String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLinkMetadata.clusterId())).getOrElse((Function0 & Serializable)() -> "")).setLinkMode(linkMode.toString()), (short)1));
                this.$outer.kafka$zk$ZkMigrationClient$$configClient.readClusterLinkConfig(clusterLinkMetadata.linkId(), linkConfigs -> linkConfigs.forEach((key, value) -> {
                    ApiMessageAndVersion message = new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.CLUSTER_LINK.id()).setResourceName(clusterLinkMetadata.linkId().toString()).setName(key.toString()).setValue(value.toString()), (short)0);
                    if (ClusterLinkConfig$.MODULE$.configType(key.toString()).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$visitClusterLink$4(x$1)))) {
                        batch.add($this.metadataEncryptor$1.encrypt(message));
                        return;
                    }
                    batch.add(message);
                }));
                this.recordConsumer$1.accept(batch);
            }

            public static final /* synthetic */ boolean $anonfun$visitClusterLink$4(ConfigDef.Type x$1) {
                return x$1.isSensitive();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clusterLinksMetadata$1 = clusterLinksMetadata$1;
                this.deletedLinks$1 = deletedLinks$1;
                this.metadataEncryptor$1 = metadataEncryptor$1;
                this.recordConsumer$1 = recordConsumer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitClusterLink$1(), $anonfun$visitClusterLink$4$adapted(org.apache.kafka.common.config.ConfigDef$Type )}, serializedLambda);
            }
        });
        if (deletedLinks.isEmpty()) {
            return clusterLinksMetadata.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        scala.collection.mutable.Map mirrorTopicsOfDeletedLinks = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        HashMap<String, HashMap> mirrorPartitionsOfDeletedLinks = new HashMap<String, HashMap>();
        this.topicClient.iterateTopics(EnumSet.of(TopicMigrationClient.TopicVisitorInterest.TOPICS, TopicMigrationClient.TopicVisitorInterest.MIRROR_STATE, TopicMigrationClient.TopicVisitorInterest.PARTITIONS), new TopicMigrationClient.TopicVisitor(null, deletedLinks, mirrorTopicsOfDeletedLinks, mirrorPartitionsOfDeletedLinks, clusterLinksMetadata){
            private final scala.collection.mutable.Set deletedLinks$1;
            private final scala.collection.mutable.Map mirrorTopicsOfDeletedLinks$1;
            private final HashMap mirrorPartitionsOfDeletedLinks$1;
            private final scala.collection.mutable.Map clusterLinksMetadata$1;

            public void visitTopic(String topicName, Uuid topicId, Map<Integer, java.util.List<Integer>> assignments, Optional<MirrorTopic> mirrorTopic) {
                mirrorTopic.ifPresent(state -> {
                    if ($this.deletedLinks$1.contains((Object)state.linkId())) {
                        $this.mirrorTopicsOfDeletedLinks$1.put((Object)topicName, (Object)topicId);
                        return;
                    }
                });
            }

            public void visitPartition(TopicIdPartition topicIdPartition, PartitionRegistration partitionRegistration) {
                String name = topicIdPartition.topic();
                if (!this.mirrorTopicsOfDeletedLinks$1.contains((Object)name)) {
                    return;
                }
                this.mirrorPartitionsOfDeletedLinks$1.computeIfAbsent(name, x$2 -> new HashMap<K, V>()).put(Predef$.MODULE$.int2Integer(topicIdPartition.partition()), partitionRegistration.withoutLink());
            }

            public ClusterLinkMetadata resolveClusterLink(Uuid linkId) {
                return (ClusterLinkMetadata)this.clusterLinksMetadata$1.getOrElse((Object)linkId, (Function0 & Serializable)() -> null);
            }
            {
                this.deletedLinks$1 = deletedLinks$1;
                this.mirrorTopicsOfDeletedLinks$1 = mirrorTopicsOfDeletedLinks$1;
                this.mirrorPartitionsOfDeletedLinks$1 = mirrorPartitionsOfDeletedLinks$1;
                this.clusterLinksMetadata$1 = clusterLinksMetadata$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$resolveClusterLink$1()}, serializedLambda);
            }
        });
        mirrorTopicsOfDeletedLinks.foreach((Function1 & Serializable)x0$1 -> {
            ZkMigrationClient.$anonfun$cleanAndMigrateClusterLinks$1(this, mirrorPartitionsOfDeletedLinks, operationConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
        mirrorPartitionsOfDeletedLinks.forEach((x0$2, x1$1) -> operationConsumer.accept(new StringBuilder(32).append("Removing mirror state for topic ").append((String)x0$2).toString(), migrationState -> $this.topicClient.updateTopicPartitions(Collections.singletonMap(x0$2, x1$1), migrationState)));
        this.aclClient.iterateAcls((resourcePattern, aclEntries) -> {
            BooleanRef changed = BooleanRef.create((boolean)false);
            scala.collection.mutable.Set newAclEntries = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(aclEntries).asScala().map((Function1 & Serializable)acl -> {
                scala.collection.immutable.Set oldLinkIds = CollectionConverters$.MODULE$.CollectionHasAsScala(acl.clusterLinkIds()).asScala().toSet();
                scala.collection.immutable.Set newLinkIds = (scala.collection.immutable.Set)oldLinkIds.diff((Set)deletedLinks);
                if (!newLinkIds.equals((Object)oldLinkIds)) {
                    changed$1.elem = true;
                    newLinkIds = newLinkIds.size() == 1 && ((Uuid)newLinkIds.head()).equals((Object)Uuid.ZERO_UUID) ? Predef$.MODULE$.Set().empty() : newLinkIds;
                }
                return SecurityUtils.aceWithClusterLinkIds((AccessControlEntry)acl, (Collection)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)newLinkIds).asJavaCollection());
            });
            if (changed.elem) {
                operationConsumer.accept(new StringBuilder(46).append("Removing deleted links for ACLs with resource ").append(resourcePattern).toString(), migrationState -> $this.aclClient.writeResourceAcls(resourcePattern, (Collection)CollectionConverters$.MODULE$.MutableSetHasAsJava(newAclEntries).asJava(), migrationState));
                return;
            }
        });
        deletedLinks.foreach((Function1 & Serializable)linkId -> {
            ZkMigrationClient.$anonfun$cleanAndMigrateClusterLinks$8(this, operationConsumer, linkId);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)clusterLinksMetadata.filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$cleanAndMigrateClusterLinks$11(deletedLinks, x0$3)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void migrateTopics(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer, scala.collection.immutable.Map<Uuid, ClusterLinkMetadata> clusterLinksMetadata, MetadataVersion metadataVersion) {
        try {
            ObjectRef $anonfun$migrateTopics$1_topicBatch = ObjectRef.create(new ArrayList());
            ImageWriterOptions $anonfun$migrateTopics$1_imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion).setConfigSchema(KafkaRaftServer$.MODULE$.configSchema()).build();
            this.topicClient.iterateTopics(EnumSet.allOf(TopicMigrationClient.TopicVisitorInterest.class), new TopicMigrationClient.TopicVisitor(this, $anonfun$migrateTopics$1_topicBatch, recordConsumer, metadataVersion, $anonfun$migrateTopics$1_imageWriterOptions, brokerIdConsumer, clusterLinksMetadata){
                private final /* synthetic */ ZkMigrationClient $outer;
                private final ObjectRef topicBatch$1;
                private final Consumer recordConsumer$2;
                private final MetadataVersion metadataVersion$1;
                private final ImageWriterOptions imageWriterOptions$1;
                private final Consumer brokerIdConsumer$1;
                private final scala.collection.immutable.Map clusterLinksMetadata$2;

                public void visitTopic(String topicName, Uuid topicId, Map<Integer, java.util.List<Integer>> assignments, Optional<MirrorTopic> mirrorTopic) {
                    if (!((ArrayList)this.topicBatch$1.elem).isEmpty()) {
                        this.recordConsumer$2.accept((ArrayList)this.topicBatch$1.elem);
                        this.topicBatch$1.elem = new ArrayList<E>();
                    }
                    ((ArrayList)this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName(topicName).setTopicId(topicId), (short)0));
                    mirrorTopic.ifPresent(state -> {
                        if ($this.metadataVersion$1.isClusterLinkingFailbackSupported()) {
                            ((ArrayList)$this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toSnapshotRecord((MirrorTopic)state, (String)topicName), (short)1));
                            return;
                        }
                        ((ArrayList)$this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)MirrorTopic.toSnapshotRecord((MirrorTopic)state, (String)topicName), (short)0));
                    });
                    this.$outer.kafka$zk$ZkMigrationClient$$configClient.readTopicConfigs(topicName, topicConfigs -> topicConfigs.forEach((key, value) -> ((ArrayList)$this.topicBatch$1.elem).add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName(topicName).setName(key.toString()).setValue(value.toString()), (short)0))));
                }

                public void visitPartition(TopicIdPartition topicIdPartition, PartitionRegistration partitionRegistration) {
                    ApiMessageAndVersion record = partitionRegistration.toRecord(topicIdPartition.topicId(), topicIdPartition.partition(), this.imageWriterOptions$1);
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$3)));
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partitionRegistration.addingReplicas), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> $this.brokerIdConsumer$1.accept(Predef$.MODULE$.int2Integer(x$4)));
                    ((ArrayList)this.topicBatch$1.elem).add(record);
                }

                public ClusterLinkMetadata resolveClusterLink(Uuid linkId) {
                    return (ClusterLinkMetadata)this.clusterLinksMetadata$2.getOrElse((Object)linkId, (Function0 & Serializable)() -> null);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicBatch$1 = topicBatch$1;
                    this.recordConsumer$2 = recordConsumer$2;
                    this.metadataVersion$1 = metadataVersion$1;
                    this.imageWriterOptions$1 = imageWriterOptions$1;
                    this.brokerIdConsumer$1 = brokerIdConsumer$1;
                    this.clusterLinksMetadata$2 = clusterLinksMetadata$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$resolveClusterLink$2(), $anonfun$visitPartition$2(kafka.zk.ZkMigrationClient$$anon$3 int ), $anonfun$visitPartition$3(kafka.zk.ZkMigrationClient$$anon$3 int )}, serializedLambda);
                }
            });
            if (!((ArrayList)$anonfun$migrateTopics$1_topicBatch.elem).isEmpty()) {
                recordConsumer.accept((ArrayList)$anonfun$migrateTopics$1_topicBatch.elem);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateBrokerConfigs(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Consumer<Integer> brokerIdConsumer, MetadataEncryptor kraftMetadataEncryptor) {
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateBrokerConfigs((broker, plainProps, encryptedProps) -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(broker))) {
                    brokerIdConsumer$2.accept(Integer.valueOf(broker));
                }
                ArrayList batch = new ArrayList();
                plainProps.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0)));
                encryptedProps.forEach((key, value) -> batch.add(kraftMetadataEncryptor$1.encrypt(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0))));
                if (!batch.isEmpty()) {
                    recordConsumer$3.accept(batch);
                    return;
                }
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateClientQuotas(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            this.kafka$zk$ZkMigrationClient$$configClient.iterateClientQuotas(new ConfigMigrationClient.ClientQuotaVisitor(null, recordConsumer){
                private final Consumer recordConsumer$4;

                public void visitClientQuota(java.util.List<ClientQuotaRecord.EntityData> entityDataList, Map<String, Double> quotas) {
                    ArrayList<E> batch = new ArrayList<E>();
                    quotas.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ClientQuotaRecord().setEntity(entityDataList).setKey(key).setValue(Predef$.MODULE$.Double2double(value)), (short)0)));
                    this.recordConsumer$4.accept(batch);
                }

                public void visitScramCredential(String userName, ScramMechanism scramMechanism, ScramCredential scramCredential) {
                    ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
                    batch.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName(userName).setMechanism(scramMechanism.type()).setSalt(scramCredential.salt()).setStoredKey(scramCredential.storedKey()).setServerKey(scramCredential.serverKey()).setIterations(scramCredential.iterations()), (short)0));
                    this.recordConsumer$4.accept(batch);
                }
                {
                    this.recordConsumer$4 = recordConsumer$4;
                }
            });
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void migrateProducerId(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            void var5_3;
            Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion("/latest_producer_id_block");
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option $anonfun$migrateProducerId$1_dataOpt = (Option)tuple2._1();
            if (var5_3 instanceof Some) {
                byte[] $anonfun$migrateProducerId$1_data = (byte[])((Some)var5_3).value();
                ProducerIdsBlock $anonfun$migrateProducerId$1_producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData($anonfun$migrateProducerId$1_data);
                recordConsumer.accept(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId($anonfun$migrateProducerId$1_producerIdBlock.assignedBrokerId()).setNextProducerId($anonfun$migrateProducerId$1_producerIdBlock.nextBlockFirstId()), (short)0), (List)Nil$.MODULE$)).asJava());
            } else if (!None$.MODULE$.equals(var5_3)) {
                throw new MatchError((Object)var5_3);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateAcls(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        this.aclClient.iterateAcls((BiConsumer)new BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>>(null, recordConsumer){
            private final Consumer recordConsumer$6;

            public BiConsumer<ResourcePattern, java.util.Set<AccessControlEntry>> andThen(BiConsumer<? super ResourcePattern, ? super java.util.Set<AccessControlEntry>> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            public void accept(ResourcePattern resourcePattern, java.util.Set<AccessControlEntry> aces) {
                ArrayList<E> batch = new ArrayList<E>();
                CollectionConverters$.MODULE$.SetHasAsScala(aces).asScala().foreach((Function1 & Serializable)entry -> {
                    $anon$5.$anonfun$accept$1(this, resourcePattern, batch, entry);
                    return BoxedUnit.UNIT;
                });
                if (!batch.isEmpty()) {
                    this.recordConsumer$6.accept(batch);
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$accept$2($anon$5 $this, ResourcePattern resourcePattern$2, AccessControlEntry entry$1, ArrayList batch$4, Uuid linkId) {
                AccessControlEntryRecord aceRecord = new AccessControlEntryRecord().setId(Uuid.randomUuid()).setResourceType(resourcePattern$2.resourceType().code()).setResourceName(resourcePattern$2.name()).setPatternType(resourcePattern$2.patternType().code()).setPrincipal(entry$1.principal()).setHost(entry$1.host()).setOperation(entry$1.operation().code()).setPermissionType(entry$1.permissionType().code());
                if (!linkId.equals((Object)Uuid.ZERO_UUID)) {
                    aceRecord.setClusterLinkId(linkId);
                }
                batch$4.add(new ApiMessageAndVersion((ApiMessage)aceRecord, 0));
                if (batch$4.size() == ZkMigrationClient$.MODULE$.MaxBatchSize()) {
                    $this.recordConsumer$6.accept(batch$4);
                    batch$4.clear();
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$accept$1($anon$5 $this, ResourcePattern resourcePattern$2, ArrayList batch$4, AccessControlEntry entry) {
                (entry.clusterLinkIds().isEmpty() ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{Uuid.ZERO_UUID})) : CollectionConverters$.MODULE$.CollectionHasAsScala(entry.clusterLinkIds()).asScala().toSet()).foreach((Function1 & Serializable)linkId -> {
                    $anon$5.$anonfun$accept$2($this, resourcePattern$2, entry, batch$4, linkId);
                    return BoxedUnit.UNIT;
                });
            }
            {
                this.recordConsumer$6 = recordConsumer$6;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(kafka.zk.ZkMigrationClient$$anon$5 org.apache.kafka.common.resource.ResourcePattern java.util.ArrayList org.apache.kafka.common.acl.AccessControlEntry ), $anonfun$accept$2$adapted(kafka.zk.ZkMigrationClient$$anon$5 org.apache.kafka.common.resource.ResourcePattern org.apache.kafka.common.acl.AccessControlEntry java.util.ArrayList org.apache.kafka.common.Uuid )}, serializedLambda);
            }
        });
    }

    public void migrateBrokerHealth(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Map<Integer, BrokerRegistration> brokerRegistrations) {
        try {
            ObjectRef $anonfun$migrateBrokerHealth$1_registrationChanges = ObjectRef.create(new ArrayList());
            scala.collection.mutable.Map $anonfun$migrateBrokerHealth$1_brokerHealthState = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.brokerHealthClient().readBrokerHealthState(brokerRegistrations.keySet())).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    Integer brokerId = (Integer)x0$1._1();
                    java.util.Set degradedBrokerComponents = (java.util.Set)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId))), (Object)CollectionConverters$.MODULE$.SetHasAsScala(degradedBrokerComponents).asScala());
                }
                throw new MatchError(null);
            });
            if (!((ArrayList)$anonfun$migrateBrokerHealth$1_registrationChanges.elem).isEmpty()) {
                recordConsumer.accept((ArrayList)$anonfun$migrateBrokerHealth$1_registrationChanges.elem);
                $anonfun$migrateBrokerHealth$1_registrationChanges.elem = new ArrayList();
            }
            $anonfun$migrateBrokerHealth$1_brokerHealthState.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateBrokerHealth$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateBrokerHealth$4(brokerRegistrations$1, registrationChanges, x$5)));
            if (!((ArrayList)$anonfun$migrateBrokerHealth$1_registrationChanges.elem).isEmpty()) {
                recordConsumer.accept((ArrayList)$anonfun$migrateBrokerHealth$1_registrationChanges.elem);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateReplicaExclusions(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer, Map<Integer, BrokerRegistration> brokerRegistrations) {
        try {
            Optional $anonfun$migrateReplicaExclusions$1_replicaExclusions = this.replicaExclusionClient().readReplicaExclusions(brokerRegistrations.keySet());
            if ($anonfun$migrateReplicaExclusions$1_replicaExclusions.isPresent() && !((java.util.Set)$anonfun$migrateReplicaExclusions$1_replicaExclusions.get()).isEmpty()) {
                java.util.List $anonfun$migrateReplicaExclusions$1_replicaExclusionChanges = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)BrokerReplicaExclusion.toBrokerReplicaExclusionRecord((java.util.Set)((java.util.Set)$anonfun$migrateReplicaExclusions$1_replicaExclusions.get())), (short)0), (List)Nil$.MODULE$)).asJava();
                recordConsumer.accept($anonfun$migrateReplicaExclusions$1_replicaExclusionChanges);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void migrateDelegationTokens(Consumer<java.util.List<ApiMessageAndVersion>> recordConsumer) {
        try {
            ArrayList $anonfun$migrateDelegationTokens$1_batch = new ArrayList();
            this.zkClient.getChildren(DelegationTokensZNode$.MODULE$.path()).foreach((Function1 & Serializable)tokenId -> {
                Option<TokenInformation> option = $this.zkClient.getDelegationTokenInfo((String)tokenId);
                if (option instanceof Some) {
                    TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
                    DelegationTokenData newDelegationTokenData = new DelegationTokenData(tokenInformation);
                    return BoxesRunTime.boxToBoolean((boolean)batch.add(new ApiMessageAndVersion((ApiMessage)newDelegationTokenData.toRecord(), (short)0)));
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(option);
            });
            if (!$anonfun$migrateDelegationTokens$1_batch.isEmpty()) {
                recordConsumer.accept($anonfun$migrateDelegationTokens$1_batch);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void cleanAndMigrateAllMetadata(Consumer<java.util.List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer, BiConsumer<String, KRaftMigrationOperation> operationConsumer, Map<Integer, BrokerRegistration> brokerRegistrations, Uuid encryptorId, MetadataVersion metadataVersion) {
        MetadataEncryptor kraftMetadataEncryptor = this.currentMetadataEncryptorFactorySupplier.get().createFromConfig(encryptorId);
        scala.collection.immutable.Map<Uuid, ClusterLinkMetadata> clusterLinksMetadata = this.cleanAndMigrateClusterLinks(batchConsumer, operationConsumer, kraftMetadataEncryptor);
        this.migrateTopics(batchConsumer, brokerIdConsumer, clusterLinksMetadata, metadataVersion);
        this.migrateBrokerConfigs(batchConsumer, brokerIdConsumer, kraftMetadataEncryptor);
        this.migrateClientQuotas(batchConsumer);
        this.migrateProducerId(batchConsumer);
        this.migrateAcls(batchConsumer);
        this.migrateDelegationTokens(batchConsumer);
        this.migrateBrokerHealth(batchConsumer, brokerRegistrations);
        this.migrateReplicaExclusions(batchConsumer, brokerRegistrations);
    }

    public java.util.Set<Integer> readBrokerIds() {
        try {
            return ZkMigrationClient.$anonfun$readBrokerIds$1(this);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<ProducerIdsBlock> readProducerId() {
        void var2_2;
        Tuple2<Option<byte[]>, Object> tuple2 = this.zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(var2_2.map((Function1 & Serializable)jsonData -> ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData((byte[])jsonData))));
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        try {
            return ZkMigrationClient.$anonfun$writeProducerId$1(this, nextProducerId, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public TopicMigrationClient topicClient() {
        return this.topicClient;
    }

    public ConfigMigrationClient configClient() {
        return this.kafka$zk$ZkMigrationClient$$configClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclClient;
    }

    public DelegationTokenMigrationClient delegationTokenClient() {
        return this.delegationTokenClient;
    }

    public ClusterLinkMigrationClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    public BrokerHealthMigrationClient brokerHealthClient() {
        return this.brokerHealthClient;
    }

    public ReplicaExclusionMigrationClient replicaExclusionClient() {
        return this.replicaExclusionClient;
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$getOrCreateMigrationRecoveryState$1(ZkMigrationClient $this, ZkMigrationLeadershipState initialState$1) {
        $this.zkClient.createTopLevelPaths();
        return $this.zkClient.getOrCreateMigrationState(initialState$1);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$claimControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$2) {
        KRaftRegistrationResult kRaftRegistrationResult = $this.zkClient.tryRegisterKRaftControllerAsActiveController(state$2.kraftControllerId(), state$2.kraftControllerEpoch());
        if (kRaftRegistrationResult instanceof SuccessfulRegistrationResult) {
            SuccessfulRegistrationResult successfulRegistrationResult = (SuccessfulRegistrationResult)kRaftRegistrationResult;
            int controllerEpoch = successfulRegistrationResult.zkControllerEpoch();
            int controllerEpochZkVersion = successfulRegistrationResult.controllerEpochZkVersion();
            return state$2.withZkController(controllerEpoch, controllerEpochZkVersion);
        }
        if (kRaftRegistrationResult instanceof FailedRegistrationResult) {
            return state$2.withUnknownZkController();
        }
        throw new MatchError((Object)kRaftRegistrationResult);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$releaseControllerLeadership$1(ZkMigrationClient $this, ZkMigrationLeadershipState state$3) {
        try {
            $this.zkClient.deleteController(state$3.zkControllerEpochZkVersion());
            return state$3.withUnknownZkController();
        }
        catch (ControllerMovedException controllerMovedException) {
            return state$3.withUnknownZkController();
        }
        catch (Throwable t) {
            throw new MigrationClientException("Could not release controller leadership due to underlying error", t);
        }
    }

    public static final /* synthetic */ void $anonfun$cleanAndMigrateClusterLinks$1(ZkMigrationClient $this, HashMap mirrorPartitionsOfDeletedLinks$1, BiConsumer operationConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topicName = (String)x0$1._1();
            Uuid topicId = (Uuid)x0$1._2();
            HashMap partitions = mirrorPartitionsOfDeletedLinks$1.getOrDefault(topicName, new HashMap());
            operationConsumer$1.accept(new StringBuilder(36).append("Removing the mirror state for topic ").append(topicName).toString(), migrationState -> $this.topicClient.updateTopic(topicName, topicId, (Map)partitions, Optional.empty(), migrationState));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$cleanAndMigrateClusterLinks$8(ZkMigrationClient $this, BiConsumer operationConsumer$1, Uuid linkId) {
        operationConsumer$1.accept(new StringBuilder(36).append("Deleting the link metadata for link ").append(linkId).toString(), migrationState -> $this.clusterLinkClient.deleteClusterLink(linkId, migrationState));
        operationConsumer$1.accept(new StringBuilder(35).append("Deleting the link configs for link ").append(linkId).toString(), migrationState -> $this.kafka$zk$ZkMigrationClient$$configClient.deleteConfigs(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()), migrationState));
    }

    public static final /* synthetic */ boolean $anonfun$cleanAndMigrateClusterLinks$11(scala.collection.mutable.Set deletedLinks$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            Uuid linkId = (Uuid)x0$3._1();
            return !deletedLinks$1.contains((Object)linkId);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$migrateTopics$1(ZkMigrationClient $this, MetadataVersion metadataVersion$1, Consumer recordConsumer$2, Consumer brokerIdConsumer$1, scala.collection.immutable.Map clusterLinksMetadata$2) {
        ObjectRef topicBatch = ObjectRef.create(new ArrayList());
        ImageWriterOptions imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion$1).setConfigSchema(KafkaRaftServer$.MODULE$.configSchema()).build();
        $this.topicClient.iterateTopics(EnumSet.allOf(TopicMigrationClient.TopicVisitorInterest.class), new /* invalid duplicate definition of identical inner class */);
        if (!((ArrayList)topicBatch.elem).isEmpty()) {
            recordConsumer$2.accept((ArrayList)topicBatch.elem);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$migrateBrokerConfigs$1(ZkMigrationClient $this, Consumer brokerIdConsumer$2, MetadataEncryptor kraftMetadataEncryptor$1, Consumer recordConsumer$3) {
        $this.kafka$zk$ZkMigrationClient$$configClient.iterateBrokerConfigs((broker, plainProps, encryptedProps) -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(broker))) {
                brokerIdConsumer$2.accept(Integer.valueOf(broker));
            }
            ArrayList batch = new ArrayList();
            plainProps.forEach((key, value) -> batch.add(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0)));
            encryptedProps.forEach((key, value) -> batch.add(kraftMetadataEncryptor$1.encrypt(new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName(broker).setName(key).setValue(value), (short)0))));
            if (!batch.isEmpty()) {
                recordConsumer$3.accept(batch);
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$migrateClientQuotas$1(ZkMigrationClient $this, Consumer recordConsumer$4) {
        $this.kafka$zk$ZkMigrationClient$$configClient.iterateClientQuotas(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$migrateProducerId$1(ZkMigrationClient $this, Consumer recordConsumer$5) {
        void var3_3;
        Tuple2<Option<byte[]>, Object> tuple2 = $this.zkClient.getDataAndVersion("/latest_producer_id_block");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dataOpt = (Option)tuple2._1();
        if (var3_3 instanceof Some) {
            byte[] data = (byte[])((Some)var3_3).value();
            ProducerIdsBlock producerIdBlock = ProducerIdBlockZNode$.MODULE$.parseProducerIdBlockData(data);
            recordConsumer$5.accept(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new ProducerIdsRecord().setBrokerEpoch(-1L).setBrokerId(producerIdBlock.assignedBrokerId()).setNextProducerId(producerIdBlock.nextBlockFirstId()), (short)0), (List)Nil$.MODULE$)).asJava());
            return;
        }
        if (None$.MODULE$.equals(var3_3)) {
            return;
        }
        throw new MatchError((Object)var3_3);
    }

    public static final /* synthetic */ boolean $anonfun$migrateBrokerHealth$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$migrateBrokerHealth$4(Map brokerRegistrations$1, ObjectRef registrationChanges$1, Tuple2 x$5) {
        if (x$5 != null) {
            int broker = x$5._1$mcI$sp();
            scala.collection.mutable.Set degradedBrokerComponents = (scala.collection.mutable.Set)x$5._2();
            if (!brokerRegistrations$1.containsKey(BoxesRunTime.boxToInteger((int)broker))) {
                throw new IllegalArgumentException(new StringBuilder(97).append("Encountered broker id in ZK that is not registered ").append("in KRaft while migrating broker health state: ").append(broker).toString());
            }
            return ((ArrayList)registrationChanges$1.elem).add(new ApiMessageAndVersion((ApiMessage)new BrokerRegistrationChangeRecord().setBrokerId(broker).setBrokerEpoch(((BrokerRegistration)brokerRegistrations$1.get(BoxesRunTime.boxToInteger((int)broker))).epoch()).setDegradedComponents(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)degradedBrokerComponents.map((Function1 & Serializable)degradedBrokerComponent -> new BrokerRegistrationChangeRecord.DegradedComponent().setReason(degradedBrokerComponent.reason()).setComponentCode(degradedBrokerComponent.brokerComponent().id()))).toList()).asJava()), (short)1));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$migrateBrokerHealth$1(ZkMigrationClient $this, Map brokerRegistrations$1, Consumer recordConsumer$7) {
        ObjectRef registrationChanges = ObjectRef.create(new ArrayList());
        scala.collection.mutable.Map brokerHealthState = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala($this.brokerHealthClient().readBrokerHealthState(brokerRegistrations$1.keySet())).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer brokerId = (Integer)x0$1._1();
                java.util.Set degradedBrokerComponents = (java.util.Set)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId))), (Object)CollectionConverters$.MODULE$.SetHasAsScala(degradedBrokerComponents).asScala());
            }
            throw new MatchError(null);
        });
        if (!((ArrayList)registrationChanges.elem).isEmpty()) {
            recordConsumer$7.accept((ArrayList)registrationChanges.elem);
            registrationChanges.elem = new ArrayList();
        }
        brokerHealthState.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateBrokerHealth$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ZkMigrationClient.$anonfun$migrateBrokerHealth$4(brokerRegistrations$1, registrationChanges, x$5)));
        if (!((ArrayList)registrationChanges.elem).isEmpty()) {
            recordConsumer$7.accept((ArrayList)registrationChanges.elem);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$migrateReplicaExclusions$1(ZkMigrationClient $this, Map brokerRegistrations$2, Consumer recordConsumer$8) {
        Optional replicaExclusions = $this.replicaExclusionClient().readReplicaExclusions(brokerRegistrations$2.keySet());
        if (replicaExclusions.isPresent() && !((java.util.Set)replicaExclusions.get()).isEmpty()) {
            java.util.List replicaExclusionChanges = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)BrokerReplicaExclusion.toBrokerReplicaExclusionRecord((java.util.Set)((java.util.Set)replicaExclusions.get())), (short)0), (List)Nil$.MODULE$)).asJava();
            recordConsumer$8.accept(replicaExclusionChanges);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$migrateDelegationTokens$1(ZkMigrationClient $this, Consumer recordConsumer$9) {
        ArrayList batch = new ArrayList();
        $this.zkClient.getChildren(DelegationTokensZNode$.MODULE$.path()).foreach((Function1 & Serializable)tokenId -> {
            Option<TokenInformation> option = $this.zkClient.getDelegationTokenInfo((String)tokenId);
            if (option instanceof Some) {
                TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
                DelegationTokenData newDelegationTokenData = new DelegationTokenData(tokenInformation);
                return BoxesRunTime.boxToBoolean((boolean)batch.add(new ApiMessageAndVersion((ApiMessage)newDelegationTokenData.toRecord(), (short)0)));
            }
            if (None$.MODULE$.equals(option)) {
                return BoxedUnit.UNIT;
            }
            throw new MatchError(option);
        });
        if (!batch.isEmpty()) {
            recordConsumer$9.accept(batch);
            return;
        }
    }

    public static final /* synthetic */ HashSet $anonfun$readBrokerIds$1(ZkMigrationClient $this) {
        return new HashSet(CollectionConverters$.MODULE$.SetHasAsJava((Set)((IterableOnceOps)$this.zkClient.getSortedBrokerList().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).toSet()).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeProducerId$1(ZkMigrationClient $this, long nextProducerId$1, ZkMigrationLeadershipState state$4) {
        void var7_6;
        byte[] newProducerIdBlockData = ProducerIdBlockZNode$.MODULE$.generateProducerIdBlockJson(new ProducerIdsBlock(-1, nextProducerId$1, 1000));
        SetDataRequest request = new SetDataRequest("/latest_producer_id_block", newProducerIdBlockData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        return state$4.withMigrationZkVersion((int)var7_6);
    }

    public ZkMigrationClient(KafkaZkClient zkClient, Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier, TopicMigrationClient topicClient, ConfigMigrationClient configClient, AclMigrationClient aclClient, DelegationTokenMigrationClient delegationTokenClient, ClusterLinkMigrationClient clusterLinkClient, BrokerHealthMigrationClient brokerHealthClient, ReplicaExclusionMigrationClient replicaExclusionClient) {
        this.zkClient = zkClient;
        this.currentMetadataEncryptorFactorySupplier = currentMetadataEncryptorFactorySupplier;
        this.topicClient = topicClient;
        this.kafka$zk$ZkMigrationClient$$configClient = configClient;
        this.aclClient = aclClient;
        this.delegationTokenClient = delegationTokenClient;
        this.clusterLinkClient = clusterLinkClient;
        this.brokerHealthClient = brokerHealthClient;
        this.replicaExclusionClient = replicaExclusionClient;
    }
}

