/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kafka.server.ConfigEntityName$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$Tenant$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.ConfigEntityTypeZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zk.migration.ZkConfigMigrationClient$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\f\u0019\u0001}A\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"A1\t\u0001B\u0001B\u0003%A\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015!\b\u0001\"\u0003v\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!a:\u0001\t\u0003\nIoB\u0004\u0002zbA\t!a?\u0007\r]A\u0002\u0012AA\u007f\u0011\u0019aE\u0003\"\u0001\u0003\u0006!9!q\u0001\u000b\u0005\u0002\t%!a\u0006.l\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0015\tI\"$A\u0005nS\u001e\u0014\u0018\r^5p]*\u00111\u0004H\u0001\u0003u.T\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0005\u000b\u001b\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!\u000b\u001a\u000e\u0003)R!!G\u0016\u000b\u00051j\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005uq#BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003+\r{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007H\u0001\u0006kRLGn]\u0005\u0003sY\u0012q\u0001T8hO&tw-\u0001\u0005{W\u000ec\u0017.\u001a8u!\taT(D\u0001\u001b\u0013\tq$DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0010a\u0006\u001c8o^8sI\u0016s7m\u001c3feB\u0011Q'Q\u0005\u0003\u0005Z\u0012q\u0002U1tg^|'\u000fZ#oG>$WM]\u0001\u001bu.\u001cE.^:uKJd\u0015N\\6D_:4\u0017nZ#oG>$WM\u001d\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\\5oW*\u0011\u0011\nH\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005-3%\u0001G\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0016s7m\u001c3fe\u00061A(\u001b8jiz\"BA\u0014)R%B\u0011q\nA\u0007\u00021!)!\b\u0002a\u0001w!)q\b\u0002a\u0001\u0001\")1\t\u0002a\u0001\t\u0006i\u0011\rZ7j]j[7\t\\5f]R,\u0012!\u0016\t\u0003yYK!a\u0016\u000e\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u00039\tG-\\5o5.\u001cE.[3oi\u0002\naC\u001a:p[j[7i\u001c8gS\u001e,e\u000e^5us:\u000bW.\u001a\u000b\u00047\"T\u0007C\u0001/f\u001d\ti6\r\u0005\u0002_C6\tqL\u0003\u0002a=\u00051AH]8pizR\u0011AY\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0006\fa\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A-\u0019\u0005\u0006S\u001e\u0001\raW\u0001\u000bK:$\u0018\u000e^=OC6,\u0007\"B6\b\u0001\u0004a\u0017AG2p]\u001aLw\rV=qK&\u001b8\t\\;ti\u0016\u0014H*\u001b8lS:<\u0007CA7o\u001b\u0005\t\u0017BA8b\u0005\u001d\u0011un\u001c7fC:\fA\u0003^8[W\u000e{gNZ5h\u000b:$\u0018\u000e^=OC6,GcA.sg\")\u0011\u000e\u0003a\u00017\")1\u000e\u0003a\u0001Y\u0006Q\"-^5mI\u000ec\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010R1uCR)a/!\u0006\u0002\u001aA\u0019q/a\u0004\u000f\u0007a\fIAD\u0002z\u0003\u000bq1A_A\u0001\u001d\tYxP\u0004\u0002}}:\u0011a,`\u0005\u0002c%\u0011q\u0006M\u0005\u0003;9J1!a\u0001.\u0003\u0019\u0019w.\\7p]&\u0019A&a\u0002\u000b\u0007\u0005\rQ&\u0003\u0003\u0002\f\u00055\u0011!E\"mS\u0016tG/U;pi\u0006\u0014VmY8sI*\u0019A&a\u0002\n\t\u0005E\u00111\u0003\u0002\u000b\u000b:$\u0018\u000e^=ECR\f'\u0002BA\u0006\u0003\u001bAa!a\u0006\n\u0001\u0004Y\u0016AC3oi&$\u0018\u0010V=qK\"1\u00111D\u0005A\u0002m\u000b\u0011B\u001f8pI\u0016t\u0015-\\3\u0002'%$XM]1uK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\u0005\u0005\u0012q\u0005\t\u0004[\u0006\r\u0012bAA\u0013C\n!QK\\5u\u0011\u001d\tIC\u0003a\u0001\u0003W\tqA^5tSR|'\u000f\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003oqA!!\r\u000269\u0019!0a\r\n\u00051j\u0013BA\r,\u0013\r\tIDK\u0001\u0016\u0007>tg-[4NS\u001e\u0014\u0018\r^5p]\u000ec\u0017.\u001a8u\u0013\u0011\ti$a\u0010\u0003%\rc\u0017.\u001a8u#V|G/\u0019,jg&$xN\u001d\u0006\u0004\u0003sQ\u0013\u0001F5uKJ\fG/\u001a\"s_.,'oQ8oM&<7\u000f\u0006\u0003\u0002\"\u0005\u0015\u0003bBA$\u0017\u0001\u0007\u0011\u0011J\u0001\u000fG>tg-[4D_:\u001cX/\\3s!\u0011\ti#a\u0013\n\t\u00055\u0013q\b\u0002\u0014\u0005J|7.\u001a:D_:4\u0017n\u001a,jg&$xN]\u0001\u0014SR,'/\u0019;f)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0005\u0003C\t\u0019\u0006C\u0004\u0002H1\u0001\r!!\u0016\u0011\u000f\u0005]\u0013\u0011M.\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0005gk:\u001cG/[8o\u0015\r\ty\u0006J\u0001\u0005kRLG.\u0003\u0003\u0002d\u0005e#A\u0003\"j\u0007>t7/^7feB1\u0011qMA57nk!!!\u0018\n\t\u0005-\u0014Q\f\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u0005:fC\u0012$v\u000e]5d\u0007>tg-[4t)\u0019\t\t#!\u001d\u0002v!1\u00111O\u0007A\u0002m\u000b\u0011\u0002^8qS\u000et\u0015-\\3\t\u000f\u0005\u001dS\u00021\u0001\u0002xA1\u0011qKA=\u0003KJA!a\u001f\u0002Z\tA1i\u001c8tk6,'/\u0001\u0007xe&$XmQ8oM&<7\u000f\u0006\u0006\u0002\u0002\u0006\u001d\u0015qSAN\u0003?\u00032!KAB\u0013\r\t)I\u000b\u0002\u001b5.l\u0015n\u001a:bi&|g\u000eT3bI\u0016\u00148\u000f[5q'R\fG/\u001a\u0005\b\u0003\u0013s\u0001\u0019AAF\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b9!\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003+\u000byI\u0001\bD_:4\u0017n\u001a*fg>,(oY3\t\u000f\u0005ee\u00021\u0001\u0002f\u0005I1m\u001c8gS\u001el\u0015\r\u001d\u0005\b\u0003;s\u0001\u0019AAA\u0003\u0015\u0019H/\u0019;f\u0011\u0019\t\tK\u0004a\u0001Y\u0006A2M]3bi\u0016\u001c\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8\u0002\u001b\u0011,G.\u001a;f\u0007>tg-[4t)\u0019\t\t)a*\u0002*\"9\u0011\u0011R\bA\u0002\u0005-\u0005bBAO\u001f\u0001\u0007\u0011\u0011Q\u0001\u0012oJLG/Z\"mS\u0016tG/U;pi\u0006\u001cHCCAA\u0003_\u000b\u0019,a0\u0002D\"9\u0011\u0011\u0017\tA\u0002\u0005\u0015\u0014AB3oi&$\u0018\u0010C\u0004\u00026B\u0001\r!a.\u0002\rE,x\u000e^1t!\u001d\t9'!\u001b\\\u0003s\u00032!IA^\u0013\r\tiL\t\u0002\u0007\t>,(\r\\3\t\u000f\u0005\u0005\u0007\u00031\u0001\u0002f\u0005)1o\u0019:b[\"9\u0011Q\u0014\tA\u0002\u0005\u0005\u0015\u0001\u0006;ss^\u0013\u0018\u000e^3F]RLG/_\"p]\u001aLw\r\u0006\b\u0002J\u0006=\u0017\u0011[Ak\u0003?\f\u0019/!:\u0011\u000b5\fY-!!\n\u0007\u00055\u0017M\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003/\t\u0002\u0019A.\t\r\u0005M\u0017\u00031\u0001\\\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005]\u0017\u00031\u0001\u0002Z\u0006)\u0001O]8qgB!\u0011qMAn\u0013\u0011\ti.!\u0018\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004\u0002bF\u0001\r\u0001\\\u0001\u0007GJ,\u0017\r^3\t\u000f\u0005u\u0015\u00031\u0001\u0002\u0002\"1\u0011\u0011U\tA\u00021\fQC]3bI\u000ecWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0006\u0004\u0002\"\u0005-\u0018q\u001f\u0005\b\u0003[\u0014\u0002\u0019AAx\u0003\u0019a\u0017N\\6JIB!\u0011\u0011_Az\u001b\t\t9!\u0003\u0003\u0002v\u0006\u001d!\u0001B+vS\u0012Dq!a\u0012\u0013\u0001\u0004\t9(A\f[W\u000e{gNZ5h\u001b&<'/\u0019;j_:\u001cE.[3oiB\u0011q\nF\n\u0004)\u0005}\bcA7\u0003\u0002%\u0019!1A1\u0003\r\u0005s\u0017PU3g)\t\tY0\u0001\u0011hKR\u001c\u0016M\\5uSj,Gm\u00117jK:$\u0018+^8uCjsu\u000eZ3OC6,GC\u0002B\u0006\u0005\u001b\u0011y\u0001\u0005\u0003n\u0003\u0017\\\u0006bBAY-\u0001\u0007\u0011Q\r\u0005\u0007\u0005#1\u0002\u0019A.\u0002\u0013\r|W\u000e]8oK:$\b")
public class ZkConfigMigrationClient
implements ConfigMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private final PasswordEncoder passwordEncoder;
    private final ClusterLinkConfigEncoder zkClusterLinkConfigEncoder;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> getSanitizedClientQuotaZNodeName(java.util.Map<String, String> entity, String component) {
        return ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity, component);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String fromZkConfigEntityName(String entityName, boolean configTypeIsClusterLinking) {
        if (entityName.equals(ConfigEntityName$.MODULE$.Default())) {
            return "";
        }
        if (configTypeIsClusterLinking) {
            return CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString(entityName).toString();
        }
        return entityName;
    }

    private String toZkConfigEntityName(String entityName, boolean configTypeIsClusterLinking) {
        if (entityName.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        if (configTypeIsClusterLinking) {
            return CoreUtils$.MODULE$.toJavaUUIDStringFromKafkaUuidString(entityName);
        }
        return entityName;
    }

    private ClientQuotaRecord.EntityData buildClientQuotaEntityData(String entityType, String znodeName) {
        ClientQuotaRecord.EntityData result = new ClientQuotaRecord.EntityData().setEntityType(entityType);
        if (znodeName.equals(ConfigEntityName$.MODULE$.Default())) {
            result.setEntityName(null);
        } else {
            result.setEntityName(Sanitizer.desanitize((String)znodeName));
        }
        return result;
    }

    public void iterateClientQuotas(ConfigMigrationClient.ClientQuotaVisitor visitor) {
        this.migrateEntityType$1("users", "user", visitor);
        this.migrateEntityType$1("clients", "client-id", visitor);
        this.adminZkClient().fetchAllChildEntityConfigs("users", "clients").foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$7(this, visitor, x0$1);
            return BoxedUnit.UNIT;
        });
        this.migrateEntityType$1("ips", "ip", visitor);
        this.migrateEntityType$1("confluent-tenants", "confluent-tenant", visitor);
    }

    public void iterateBrokerConfigs(ConfigMigrationClient.BrokerConfigVisitor configConsumer) {
        Seq<String> brokerEntities = this.zkClient.getAllEntitiesWithConfig("brokers");
        this.zkClient.getEntitiesConfigs("brokers", (Set<String>)brokerEntities.toSet()).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateBrokerConfigs$1(this, configConsumer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void iterateTopicConfigs(BiConsumer<String, java.util.Map<String, String>> configConsumer) {
        this.zkClient.getAllEntitiesWithConfig("topics").foreach((Function1 & Serializable)topic -> {
            this.readTopicConfigs(topic, props -> configConsumer.accept(topic, props));
            return BoxedUnit.UNIT;
        });
    }

    public void readTopicConfigs(String topicName, Consumer<java.util.Map<String, String>> configConsumer) {
        String topicResource = this.fromZkConfigEntityName(topicName, false);
        Properties props = this.zkClient.getEntityConfigs("topics", topicResource);
        java.util.Map decodedProps = CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String key = (String)x0$1._1();
                String value = (String)x0$1._2();
                if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)$this.passwordEncoder.decode(value).value());
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        String logAndRethrow_msg = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(topicResource).append(".").toString();
        try {
            configConsumer.accept(decodedProps);
        }
        catch (Throwable logAndRethrow_e) {
            this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public ZkMigrationLeadershipState writeConfigs(ConfigResource configResource, java.util.Map<String, String> configMap, ZkMigrationLeadershipState state, boolean createChangeNotification) {
        try {
            return ZkConfigMigrationClient.$anonfun$writeConfigs$1(this, configResource, configMap, state, createChangeNotification);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteConfigs(ConfigResource configResource, ZkMigrationLeadershipState state) {
        try {
            return ZkConfigMigrationClient.$anonfun$deleteConfigs$1(this, configResource, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState writeClientQuotas(java.util.Map<String, String> entity, java.util.Map<String, Double> quotas, java.util.Map<String, String> scram, ZkMigrationLeadershipState state) {
        Object object = new Object();
        try {
            ZkMigrationLeadershipState zkMigrationLeadershipState;
            try {
                zkMigrationLeadershipState = ZkConfigMigrationClient.$anonfun$writeClientQuotas$1(this, entity, object, state, quotas, scram);
            }
            catch (Throwable throwable) {
                if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                    throw throwable;
                }
                if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                    throw new MigrationClientAuthException(throwable);
                }
                if (throwable instanceof KeeperException) {
                    KeeperException keeperException = (KeeperException)throwable;
                    throw new MigrationClientException((Throwable)keeperException);
                }
                throw throwable;
            }
            return zkMigrationLeadershipState;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (ZkMigrationLeadershipState)ex.value();
            }
            throw ex;
        }
    }

    private Option<ZkMigrationLeadershipState> tryWriteEntityConfig(String entityType, String path, Properties props, boolean create, ZkMigrationLeadershipState state, boolean createChangeNotification) {
        try {
            return ZkConfigMigrationClient.$anonfun$tryWriteEntityConfig$1(this, props, create, entityType, path, state, createChangeNotification);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public void readClusterLinkConfig(Uuid linkId, Consumer<java.util.Map<String, String>> configConsumer) {
        String linkResource = this.toZkConfigEntityName(linkId.toString(), true);
        Properties props = this.zkClient.getEntityConfigs("cluster-links", linkResource);
        HashMap decodedPropsMap = new HashMap();
        this.zkClusterLinkConfigEncoder.decode(props).entrySet().forEach(entry -> decodedPropsMap.put(entry.getKey().toString(), entry.getValue().toString()));
        String logAndRethrow_msg = new StringBuilder(43).append("Error in topic config consumer. Topic was ").append(linkResource).append(".").toString();
        try {
            configConsumer.accept(decodedPropsMap);
        }
        catch (Throwable logAndRethrow_e) {
            this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
            throw logAndRethrow_e;
        }
    }

    public static final /* synthetic */ boolean $anonfun$iterateClientQuotas$2(ScramMechanism x$1) {
        ScramMechanism scramMechanism = x$1;
        ScramMechanism scramMechanism2 = ScramMechanism.UNKNOWN;
        return scramMechanism == null ? scramMechanism2 != null : !scramMechanism.equals(scramMechanism2);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$6(ConfigMigrationClient.ClientQuotaVisitor visitor$1, java.util.List entity$1, java.util.Map quotaMap$1) {
        visitor$1.visitClientQuota(entity$1, quotaMap$1);
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$1(ZkConfigMigrationClient $this, String entityType$1, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String znodeName = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            java.util.List entity = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.buildClientQuotaEntityData(entityType$1, znodeName), (List)Nil$.MODULE$)).asJava();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkConfigMigrationClient.$anonfun$iterateClientQuotas$2(x$1)))), (Function1 & Serializable)mechanism -> {
                String propertyValue = props.getProperty(mechanism.mechanismName());
                if (propertyValue != null) {
                    ScramCredential scramCredentials = ScramCredentialUtils.credentialFromString((String)propertyValue);
                    String logAndRethrow_msg = new StringBuilder(62).append("Error in client quota visitor for SCRAM credential. User was ").append(entity).append(".").toString();
                    try {
                        visitor$1.visitScramCredential(Sanitizer.desanitize((String)znodeName), mechanism, scramCredentials);
                    }
                    catch (Throwable logAndRethrow_e) {
                        $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                        throw logAndRethrow_e;
                    }
                    Object var8_8 = null;
                    return props.remove(mechanism.mechanismName());
                }
                return BoxedUnit.UNIT;
            });
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MapHasAsJava((Map)ZkAdminManager$.MODULE$.clientQuotaPropsToDoubleMap((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala()).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String key = (String)x0$2._1();
                    double value = x0$2._2$mcD$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            if (!quotaMap.isEmpty()) {
                String logAndRethrow_msg = new StringBuilder(43).append("Error in client quota visitor. Entity was ").append(entity).append(".").toString();
                try {
                    visitor$1.visitClientQuota(entity, quotaMap);
                }
                catch (Throwable logAndRethrow_e) {
                    $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                    throw logAndRethrow_e;
                }
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void migrateEntityType$1(String zkEntityType, String entityType, ConfigMigrationClient.ClientQuotaVisitor visitor$1) {
        this.adminZkClient().fetchAllEntityConfigs(zkEntityType).foreach((Function1 & Serializable)x0$1 -> {
            ZkConfigMigrationClient.$anonfun$iterateClientQuotas$1(this, entityType, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$iterateClientQuotas$7(ZkConfigMigrationClient $this, ConfigMigrationClient.ClientQuotaVisitor visitor$1, Tuple2 x0$1) {
        block4: {
            Object[] components;
            Properties props;
            block6: {
                String znodePath;
                block5: {
                    if (x0$1 == null) break block4;
                    znodePath = (String)x0$1._1();
                    props = (Properties)x0$1._2();
                    components = znodePath.split("/");
                    if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(components)) != 3) break block5;
                    Object object = components[1];
                    String string = "clients";
                    if (object != null && object.equals(string)) break block6;
                }
                throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected config path: ").append(znodePath).toString());
            }
            .colon.colon entity = new .colon.colon((Object)$this.buildClientQuotaEntityData("user", (String)components[0]), (List)new .colon.colon((Object)$this.buildClientQuotaEntityData("client-id", (String)components[2]), (List)Nil$.MODULE$));
            java.util.Map quotaMap = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Double d;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    try {
                        d = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalStateException(new StringBuilder(49).append("Unexpected client quota configuration value: ").append(key).append(" -> ").append(value).toString());
                    }
                    Double doubleValue = d;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)doubleValue);
                }
                throw new MatchError(null);
            })).asJava();
            String logAndRethrow_msg = new StringBuilder(50).append("Error in client quota entity visitor. Entity was ").append(entity).append(".").toString();
            try {
                visitor$1.visitClientQuota(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)entity)).asJava(), quotaMap);
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$3(ConfigMigrationClient.BrokerConfigVisitor configConsumer$1, String brokerResource$1, HashMap plainProps$1, HashMap encryptedProps$1) {
        configConsumer$1.visitBrokerConfig(brokerResource$1, (java.util.Map)plainProps$1, (java.util.Map)encryptedProps$1);
    }

    public static final /* synthetic */ void $anonfun$iterateBrokerConfigs$1(ZkConfigMigrationClient $this, ConfigMigrationClient.BrokerConfigVisitor configConsumer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String broker = (String)x0$1._1();
            Properties props = (Properties)x0$1._2();
            String brokerResource = $this.fromZkConfigEntityName(broker, false);
            HashMap plainProps = new HashMap();
            HashMap encryptedProps = new HashMap();
            CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    void var6_7;
                    boolean bl;
                    String string;
                    String key = (String)x0$2._1();
                    String value = (String)x0$2._2();
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(key)) {
                        string = $this.passwordEncoder.decode(value).value();
                        bl = true;
                    } else {
                        string = value;
                        bl = false;
                    }
                    boolean bl2 = bl;
                    String newValue = string;
                    if (bl2) {
                        return (String)encryptedProps.put(key, var6_7);
                    }
                    return (String)plainProps.put(key, var6_7);
                }
                throw new MatchError(null);
            });
            String logAndRethrow_msg = new StringBuilder(45).append("Error in broker config consumer. Broker was ").append(brokerResource).append(".").toString();
            try {
                configConsumer$1.visitBrokerConfig(brokerResource, plainProps, encryptedProps);
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$readTopicConfigs$2(Consumer configConsumer$3, java.util.Map decodedProps$1) {
        configConsumer$3.accept(decodedProps$1);
    }

    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$1, java.util.Map configMap$1, ZkMigrationLeadershipState state$1, boolean createChangeNotification$1) {
        ConfigResource.Type type = configResource$1.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)"cluster-links") : None$.MODULE$));
        String configName = $this.toZkConfigEntityName(configResource$1.name(), configType.contains((Object)"cluster-links"));
        if (configType.isDefined()) {
            Properties properties;
            if (configType.contains((Object)"cluster-links")) {
                Properties newProps = new Properties();
                configMap$1.forEach((x0$1, x1$1) -> newProps.put(x0$1, x1$1));
                properties = $this.zkClusterLinkConfigEncoder.encode(newProps);
            } else {
                Properties newProps = new Properties();
                configMap$1.forEach((x0$2, x1$2) -> {
                    if (DynamicBrokerConfig$.MODULE$.isPasswordConfig((String)x0$2)) {
                        newProps.put(x0$2, $this.passwordEncoder.encode(new Password(x1$2)));
                        return;
                    }
                    newProps.put(x0$2, x1$2);
                });
                properties = newProps;
            }
            Properties props = properties;
            Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)configType.get(), configName, props, false, state$1, createChangeNotification$1);
            if (option instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option).value();
            }
            if (None$.MODULE$.equals(option)) {
                String createPath = ConfigEntityTypeZNode$.MODULE$.path((String)configType.get());
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(configResource$1).append(" configs a second time.").toString());
                byte[] x$3 = $this.zkClient.createRecursive$default$2();
                $this.zkClient.createRecursive(createPath, x$3, false);
                Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)configType.get(), configName, props, true, state$1, createChangeNotification$1);
                if (option2 instanceof Some) {
                    return (ZkMigrationLeadershipState)((Some)option2).value();
                }
                if (None$.MODULE$.equals(option2)) {
                    throw new MigrationClientException(new StringBuilder(80).append("Could not write ").append(configType.get()).append(" configs on second attempt when using Create instead of SetData.").toString());
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$1).append(" since it is not a Broker or Topic entity.").toString());
        return state$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteConfigs$1(ZkConfigMigrationClient $this, ConfigResource configResource$2, ZkMigrationLeadershipState state$2) {
        ConfigResource.Type type = configResource$2.type();
        Some configType = ConfigResource.Type.BROKER.equals(type) ? new Some((Object)"brokers") : (ConfigResource.Type.TOPIC.equals(type) ? new Some((Object)"topics") : (ConfigResource.Type.CLUSTER_LINK.equals(type) ? new Some((Object)"cluster-links") : None$.MODULE$));
        String configName = $this.toZkConfigEntityName(configResource$2.name(), configType.contains((Object)"cluster-links"));
        if (configType.isDefined()) {
            void var10_10;
            String path = ConfigEntityZNode$.MODULE$.path((String)configType.get(), configName);
            .colon.colon requests = new .colon.colon((Object)new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
            Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$2);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            int migrationZkVersion = tuple2._1$mcI$sp();
            Seq responses = (Seq)tuple2._2();
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Did not delete ").append(configResource$2).append(" since the node did not exist.").toString());
                return state$2;
            }
            if (((DeleteResponse)var10_10.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
                void var9_9;
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(configType.get()).append("/").append(configName).toString());
                return state$2.withMigrationZkVersion((int)var9_9);
            }
            throw KeeperException.create((KeeperException.Code)((DeleteResponse)var10_10.head()).resultCode(), (String)path);
        }
        $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Not updating ZK for ").append(configResource$2).append(" since it is not a Broker or Topic entity.").toString());
        return state$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$writeClientQuotas$1(ZkConfigMigrationClient $this, java.util.Map entity$3, Object nonLocalReturnKey1$1, ZkMigrationLeadershipState state$3, java.util.Map quotas$1, java.util.Map scram$1) {
        void var11_13;
        void var12_14;
        java.util.Map<String, ConfigDef.ConfigKey> map;
        Some some;
        Some some2;
        Some user = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "user");
        Option<String> client = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "client-id");
        Some ip = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "ip");
        Some tenant = ZkConfigMigrationClient$.MODULE$.getSanitizedClientQuotaZNodeName(entity$3, "confluent-tenant");
        Properties props = new Properties();
        if (user.isDefined() && client.isEmpty()) {
            some2 = new Some((Object)"users");
            some = user;
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (user.isDefined() && client.isDefined()) {
            some2 = new Some((Object)"users");
            some = new Some((Object)new StringBuilder(9).append(user.get()).append("/clients/").append(client.get()).toString());
            map = DynamicConfig$User$.MODULE$.configKeys();
        } else if (client.isDefined()) {
            some2 = new Some((Object)"clients");
            some = client;
            map = DynamicConfig$Client$.MODULE$.configKeys();
        } else if (ip.isDefined()) {
            some2 = new Some((Object)"ips");
            some = ip;
            map = DynamicConfig$Ip$.MODULE$.configKeys();
        } else if (tenant.isDefined()) {
            some2 = new Some((Object)"confluent-tenants");
            some = tenant;
            map = DynamicConfig$Tenant$.MODULE$.configKeys();
        } else {
            some2 = None$.MODULE$;
            some = None$.MODULE$;
            map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava();
        }
        java.util.Map<String, ConfigDef.ConfigKey> map2 = map;
        Some some3 = some;
        Option configType = (Option)some2;
        Option path = (Option)some3;
        if (var12_14.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Skipping unknown client quota entity ").append(entity$3).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)state$3);
        }
        quotas$1.forEach((x0$1, x1$1) -> {
            ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)map2.get(x0$1);
            if (configKey == null) {
                throw new MigrationClientException(new StringBuilder(26).append("Invalid configuration key ").append((String)x0$1).toString());
            }
            ConfigDef.Type type = configKey.type;
            if (ConfigDef.Type.DOUBLE.equals(type)) {
                props.setProperty((String)x0$1, x1$1.toString());
                return;
            }
            if (ConfigDef.Type.LONG.equals(type) ? true : ConfigDef.Type.INT.equals(type)) {
                long intValue;
                double epsilon = 1.0E-6;
                ConfigDef.Type type2 = configKey.type;
                ConfigDef.Type type3 = ConfigDef.Type.LONG;
                long l = !(type2 != null ? !type2.equals(type3) : type3 != null) ? (long)(Predef$.MODULE$.Double2double(x1$1) + epsilon) : (intValue = (long)((int)(Predef$.MODULE$.Double2double(x1$1) + epsilon)));
                if (RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((double)intValue - Predef$.MODULE$.Double2double(x1$1))) > epsilon) {
                    throw new InvalidRequestException(new StringBuilder(31).append("Configuration ").append((String)x0$1).append(" must be a ").append(configKey.type).append(" value").toString());
                }
                props.setProperty((String)x0$1, Long.toString(intValue));
                return;
            }
            throw new MigrationClientException(new StringBuilder(23).append("Unexpected config type ").append(configKey.type).toString());
        });
        scram$1.forEach((x0$2, x1$2) -> props.put(x0$2, x1$2));
        Option<ZkMigrationLeadershipState> option = $this.tryWriteEntityConfig((String)var11_13.get(), (String)var12_14.get(), props, false, state$3, true);
        if (option instanceof Some) {
            return (ZkMigrationLeadershipState)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            String createPath = user.isDefined() && client.isDefined() ? new StringBuilder(9).append(ConfigEntityTypeZNode$.MODULE$.path((String)var11_13.get())).append("/").append(user.get()).append("/clients").toString() : ConfigEntityTypeZNode$.MODULE$.path((String)var11_13.get());
            byte[] x$3 = $this.zkClient.createRecursive$default$2();
            $this.zkClient.createRecursive(createPath, x$3, false);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Recursively creating ZNode ").append(createPath).append(" and attempting to write ").append(entity$3).append(" quotas a second time.").toString());
            Option<ZkMigrationLeadershipState> option2 = $this.tryWriteEntityConfig((String)var11_13.get(), (String)var12_14.get(), props, true, state$3, true);
            if (option2 instanceof Some) {
                return (ZkMigrationLeadershipState)((Some)option2).value();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new MigrationClientException(new StringBuilder(89).append("Could not write client quotas for ").append(entity$3).append(" on second attempt when using Create instead of SetData").toString());
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$tryWriteEntityConfig$1(ZkConfigMigrationClient $this, Properties props$3, boolean create$1, String entityType$2, String path$1, ZkMigrationLeadershipState state$4, boolean createChangeNotification$2) {
        void var11_11;
        byte[] configData = ConfigEntityZNode$.MODULE$.encode(props$3);
        .colon.colon requests = create$1 ? new .colon.colon((Object)new CreateRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, $this.zkClient.defaultAcls(path$1), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$) : new .colon.colon((Object)new SetDataRequest(ConfigEntityZNode$.MODULE$.path(entityType$2, path$1), configData, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        if (!create$1 && ((AsyncResponse)var11_11.head()).resultCode().equals((Object)KeeperException.Code.NONODE)) {
            return None$.MODULE$;
        }
        if (((AsyncResponse)var11_11.head()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var10_10;
            if (createChangeNotification$2) {
                $this.zkClient.createConfigChangeNotification(new StringBuilder(1).append(entityType$2).append("/").append(path$1).toString());
            }
            return new Some((Object)state$4.withMigrationZkVersion((int)var10_10));
        }
        throw KeeperException.create((KeeperException.Code)((AsyncResponse)var11_11.head()).resultCode(), (String)path$1);
    }

    public static final /* synthetic */ void $anonfun$readClusterLinkConfig$2(Consumer configConsumer$4, HashMap decodedPropsMap$1) {
        configConsumer$4.accept(decodedPropsMap$1);
    }

    public ZkConfigMigrationClient(KafkaZkClient zkClient, PasswordEncoder passwordEncoder, ClusterLinkConfigEncoder zkClusterLinkConfigEncoder) {
        this.zkClient = zkClient;
        this.passwordEncoder = passwordEncoder;
        this.zkClusterLinkConfigEncoder = zkClusterLinkConfigEncoder;
        this.adminZkClient = new AdminZkClient(zkClient, (Option<KafkaConfig>)None$.MODULE$);
    }
}

