/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyVerificationKeyResolver;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger log = LoggerFactory.getLogger(JwtLoginService.class);
    private static final String rolesClaimDefault = "clusters";
    private final String realmName;
    private final String rolesClaim;
    private final String subClaimName;
    private final String groupsClaimName;
    private JwtAuthenticator authenticator;
    private IdentityService identityService;
    private MetricsContainer metricsContainer;
    public static final String ORG_RESOURCE_ID_KEY = "orgResourceId";
    private String confluentTokenIssuer = null;

    public JwtLoginService(String realmName, String jwtIssuer, String publicKeyPath, String rolesClaim) {
        Objects.requireNonNull(publicKeyPath, "public key path must not be null");
        this.realmName = realmName;
        this.rolesClaim = rolesClaim;
        this.subClaimName = null;
        this.groupsClaimName = null;
        Collection publicKeys = null;
        try {
            publicKeys = PublicKeyJwks.loadPublicKey((String)publicKeyPath);
        }
        catch (IOException e) {
            throw new ConfigException("Failed to load public keys at " + publicKeyPath);
        }
        this.authenticator = new JwtAuthenticator(jwtIssuer, (CloseableVerificationKeyResolver)new PublicKeyVerificationKeyResolver(new PublicKeyJwks(publicKeys)));
    }

    public JwtLoginService(String realmName, String jwtIssuer, List<PublicKey> publicKeys, String rolesClaim) {
        this(realmName, rolesClaim, new JwtAuthenticator(jwtIssuer, (CloseableVerificationKeyResolver)new PublicKeyVerificationKeyResolver(new PublicKeyJwks(publicKeys))));
    }

    public JwtLoginService(String realmName, String rolesClaim, JwtAuthenticator authenticator) {
        this(realmName, rolesClaim, authenticator, null, null);
    }

    public JwtLoginService(String realmName, JwtAuthenticator authenticator) {
        this(realmName, rolesClaimDefault, authenticator, null, null);
    }

    public JwtLoginService(String realmName, JwtAuthenticator authenticator, String subClaimName, String groupsClaimName) {
        this(realmName, rolesClaimDefault, authenticator, subClaimName, groupsClaimName);
    }

    public JwtLoginService(String realmName, String rolesClaim, JwtAuthenticator authenticator, String subClaimName, String groupsClaimName) {
        Objects.requireNonNull(authenticator, "authenticator must not be null");
        this.realmName = realmName;
        this.rolesClaim = rolesClaim == null ? rolesClaimDefault : rolesClaim;
        this.authenticator = authenticator;
        this.subClaimName = subClaimName;
        this.groupsClaimName = groupsClaimName;
    }

    static boolean isJwtUser(UserIdentity user) {
        return !user.getSubject().getPrincipals(JwtPrincipal.class).isEmpty();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
    }

    public String getName() {
        return this.realmName;
    }

    public String getIssuer() {
        return this.authenticator.issuer();
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        long loginStartTime = System.nanoTime();
        try {
            log.debug("Processing new Jwt login request.");
            OAuthBearerJwsToken idToken = (OAuthBearerJwsToken)this.authenticator.login((String)credentials, this.rolesClaim);
            Subject subject = new Subject();
            JwtPrincipal principal = new JwtPrincipal((OAuthBearerToken)idToken, this.subClaimName, this.groupsClaimName);
            subject.getPrincipals().add(principal);
            String orgResourceId = idToken.jwtClaims().getOrDefault(ORG_RESOURCE_ID_KEY, "");
            log.debug("Organization resource id in jwt : {}", (Object)orgResourceId);
            if (request != null) {
                request.setAttribute(ORG_RESOURCE_ID_KEY, (Object)orgResourceId);
            }
            this.updateSuccessMetrics(loginStartTime);
            String[] roles = idToken.scope().toArray(new String[0]);
            return this.identityService.newUserIdentity(subject, (Principal)principal, roles);
        }
        catch (Exception e) {
            log.debug("Exception", (Throwable)e);
            this.updateFailureMetrics(loginStartTime);
            return null;
        }
    }

    private void updateSuccessMetrics(long loginStartTime) {
        if (Objects.nonNull(this.metricsContainer)) {
            if (Objects.equals(this.authenticator.issuer(), this.confluentTokenIssuer)) {
                this.metricsContainer.getMdsOauthSuccessLoginCount().record();
                this.metricsContainer.getMdsOauthSuccessLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
            } else {
                this.metricsContainer.getOauthSuccessLoginCount().record();
                this.metricsContainer.getOauthSuccessLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
            }
        }
    }

    private void updateFailureMetrics(long loginStartTime) {
        if (Objects.nonNull(this.metricsContainer)) {
            if (Objects.equals(this.authenticator.issuer(), this.confluentTokenIssuer)) {
                this.metricsContainer.getMdsOauthFailedLoginCount().record();
                this.metricsContainer.getMdsOauthFailedLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
            } else {
                this.metricsContainer.getOauthFailedLoginCount().record();
                this.metricsContainer.getOauthFailedLoginLatency().record((double)(System.nanoTime() - loginStartTime) / 1000.0);
            }
        }
    }

    public JwtLoginService withMetricsContainer(MetricsContainer metricsContainer) {
        return this.withMetricsContainer(metricsContainer, "");
    }

    public JwtLoginService withMetricsContainer(MetricsContainer metricsContainer, String confluentTokenIssuer) {
        this.metricsContainer = metricsContainer;
        this.confluentTokenIssuer = confluentTokenIssuer;
        return this;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService service) {
        this.identityService = service;
    }

    public void logout(UserIdentity user) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JwtLoginService that = (JwtLoginService)((Object)o);
        return Objects.equals(this.realmName, that.realmName) && Objects.equals(this.authenticator.issuer(), that.authenticator.issuer()) && Objects.equals(this.rolesClaim, that.rolesClaim) && Objects.equals(this.subClaimName, that.subClaimName) && Objects.equals(this.groupsClaimName, that.groupsClaimName);
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.authenticator.issuer(), this.rolesClaim, this.subClaimName, this.groupsClaimName);
    }
}

