/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.jetty.CompositeLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MultiJwtLoginService;
import io.confluent.common.security.jetty.MultiJwtWithFallbackLoginService;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.common.security.util.AuthUtils;
import io.confluent.common.security.util.Utils;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHandler
implements Consumer<ServletContextHandler>,
Configurable {
    private SecurityHandlerConfig config;
    private MetricsContainer metricsContainer;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);

    public void configure(Map<String, ?> originals) {
        this.config = new SecurityHandlerConfig(originals);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createSecurityHandler());
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        if (this.config.getBoolean("rest.auth.jmx.enabled").booleanValue()) {
            this.metricsContainer = new MetricsContainer(this.config);
        }
        ConstraintSecurityHandler securityHandler = AuthUtils.getOAuthSecurityHandler(this.config);
        securityHandler.setAuthenticator((Authenticator)AuthUtils.createCompositeAuthenticator(this.config));
        securityHandler.setLoginService(this.getCompositeLoginService());
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected LoginService getCompositeLoginService() {
        return new CompositeLoginService(this.createHttpLoginService(), AuthUtils.createX509LoginService(this.config, this.metricsContainer));
    }

    protected LoginService createHttpLoginService() {
        String realm = this.config.getString("authentication.realm");
        String publicKeyPath = this.config.getString("public.key.path");
        String issuer = this.config.getString("token.issuer");
        String idpIssuer = Utils.getBaseString("oauthbearer.expected.issuer", this.config);
        String subClaimName = Utils.getBaseString("oauthbearer.sub.claim.name", this.config);
        String groupsClaimName = Utils.getBaseString("oauthbearer.groups.claim.name", this.config);
        List<String> audience = Utils.getBaseList("oauthbearer.expected.audience", this.config);
        boolean isConfluentOAuthEnabled = this.isConfluentOAuthEnabled();
        boolean isIdpOAuthEnabled = this.isIdpOAuthEnabled();
        log.debug("Confluent OAuth enabled: {}, IDP Oauth is enabled: {}", (Object)isConfluentOAuthEnabled, (Object)isIdpOAuthEnabled);
        if (!isConfluentOAuthEnabled && !isIdpOAuthEnabled) {
            log.error("Neither Confluent OAuth nor IDP OAuth is enabled. Please check your configuration.");
            return null;
        }
        if (isConfluentOAuthEnabled && !isIdpOAuthEnabled) {
            return new JwtWithFallbackLoginService(AuthUtils.getConfluentJwtLoginService(realm, issuer, publicKeyPath, this.metricsContainer), (LoginService)AuthUtils.getMdsBasicLoginService(this.config, this.metricsContainer));
        }
        if (!isConfluentOAuthEnabled) {
            return AuthUtils.getIdpJwtLoginService(realm, idpIssuer, audience, subClaimName, groupsClaimName, this.config, this.metricsContainer);
        }
        return new MultiJwtWithFallbackLoginService(new MultiJwtLoginService(AuthUtils.getConfluentJwtLoginService(realm, issuer, publicKeyPath, this.metricsContainer), AuthUtils.getIdpJwtLoginService(realm, idpIssuer, audience, subClaimName, groupsClaimName, this.config, this.metricsContainer)), (LoginService)AuthUtils.getMdsBasicLoginService(this.config, this.metricsContainer));
    }

    private boolean isConfluentOAuthEnabled() {
        String publicKeyPath = this.config.getString("public.key.path");
        log.debug("Configured public key path for token validation: {}", (Object)publicKeyPath);
        return StringUtils.isNotEmpty((CharSequence)publicKeyPath);
    }

    private boolean isIdpOAuthEnabled() {
        String idpIssuer = Utils.getBaseString("oauthbearer.expected.issuer", this.config);
        String idpKeyUrl = Utils.getBaseString("oauthbearer.jwks.endpoint.url", this.config);
        log.debug("Configured IDP issuer: {}, IDP key url: {}", (Object)idpIssuer, (Object)idpKeyUrl);
        return StringUtils.isNotEmpty((CharSequence)idpIssuer) && StringUtils.isNotEmpty((CharSequence)idpKeyUrl);
    }

    private String getBaseString(String key) {
        String res = (String)this.config.originals().get(key);
        return res == null ? res : res.trim();
    }

    private List<String> getBaseList(String key) {
        Object res = this.config.originals().get(key);
        return res instanceof List ? (List)res : null;
    }

    public static class SecurityHandlerConfig
    extends RestConfig {
        public static final String TOKEN_ISSUER_PROP = "token.issuer";
        public static final String TOKEN_ISSUER_DEFAULT = "Confluent";
        public static final String TOKEN_ISSUER_DOC = "An identifier for the token issuer.";
        public static final String TOKEN_PUBLIC_KEY_PATH_PROP = "public.key.path";
        public static final String TOKEN_PUBLIC_KEY_PATH_DOC = "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_PROP = "auth.ssl.principal.mapping.rules";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DEFAULT = "DEFAULT";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DOC = "Rules to execute the conversion from the certificate SN into principal name";
        public static final String ALLOW_ANONYMOUS_USER_PROP = "auth.allow.anonymous.user";
        public static final boolean ALLOW_ANONYMOUS_USER_DEFAULT = false;
        public static final String ALLOW_ANONYMOUS_USER_DOC = "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.";
        private static final String EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG = "expose.internal.connect.endpoints";
        private static final boolean EXPOSE_INTERNAL_CONNECT_ENDPOINTS_DEFAULT = false;
        private static final String OAUTHBEARER_CONFIG_PREFIX = "oauthbearer";
        public static final String OAUTHBEARER_JWKS_ENDPOINT_URL = "oauthbearer.jwks.endpoint.url";
        public static final String OAUTHBEARER_JWKS_ENDPOINT_URL_DOC = "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based. The fetched keys, will be cached on for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.";
        public static final String OAUTHBEARER_EXPECTED_ISSUER = "oauthbearer.expected.issuer";
        public static final String OAUTHBEARER_EXPECTED_ISSUER_DOC = "This is required to assure that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, Server will match it exactly against what is in the JWT's \"iss\" claim. If there's no match, the broker will reject the JWT and authentication will fail.";
        public static final String OAUTHBEARER_EXPECTED_AUDIENCE = "oauthbearer.expected.audience";
        public static final String OAUTHBEARER_EXPECTED_AUDIENCE_DOC = "The (optional) comma-delimited setting for to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.";
        public static final String OAUTHBEARER_SUB_CLAIM_NAME = "oauthbearer.sub.claim.name";
        public static final String OAUTHBEARER_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named `sub` but this is optional. This optional setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for sub claim.";
        public static final String OAUTHBEARER_GROUPS_CLAIM_NAME = "oauthbearer.groups.claim.name";
        public static final String OAUTHBEARER_GROUPS_CLAIM_NAME_DOC = "This optional setting provides the name of claim to use for the groups in the JWT payload. If setting is not provided, groups of principal will be empty.";
        public static final String OAUTHBEARER_JTI_VALIDATION_ENABLED = "oauthbearer.jti.validation.enabled";
        public static final String OAUTHBEARER_JTI_VALIDATION_ENABLED_DOC = "This flag mandates the presence of field JTI (unique id in token) in the token. Setting this flag true, doesn't add any validation against the IDP server.";
        public static final String AUTH_JMX_ENABLED = "rest.auth.jmx.enabled";
        public static final String AUTH_JMX_ENABLED_DOC = "This property enables authentication metricsfor configured authentication mechanism in AuthenticationHandler class. This includesBasic, Oauth, mTLS and Kerberos";
        public static final boolean AUTH_JMX_ENABLED_DEFAULT = false;
        private static final ConfigDef CONFIG = SecurityHandlerConfig.baseConfigDef().define("public.key.path", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.").define("token.issuer", ConfigDef.Type.STRING, (Object)"Confluent", ConfigDef.Importance.HIGH, "An identifier for the token issuer.").define("auth.ssl.principal.mapping.rules", ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "Rules to execute the conversion from the certificate SN into principal name").define("auth.allow.anonymous.user", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.").defineInternal("expose.internal.connect.endpoints", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW).define("oauthbearer.jwks.endpoint.url", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based. The fetched keys, will be cached on for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.").define("oauthbearer.expected.issuer", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "This is required to assure that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, Server will match it exactly against what is in the JWT's \"iss\" claim. If there's no match, the broker will reject the JWT and authentication will fail.").define("oauthbearer.expected.audience", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "The (optional) comma-delimited setting for to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.").define("oauthbearer.sub.claim.name", ConfigDef.Type.STRING, (Object)"sub", ConfigDef.Importance.LOW, "The OAuth claim for the subject is often named `sub` but this is optional. This optional setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for sub claim.").define("oauthbearer.groups.claim.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "This optional setting provides the name of claim to use for the groups in the JWT payload. If setting is not provided, groups of principal will be empty.").define("oauthbearer.jti.validation.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "This flag mandates the presence of field JTI (unique id in token) in the token. Setting this flag true, doesn't add any validation against the IDP server.").define("rest.auth.jmx.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "This property enables authentication metricsfor configured authentication mechanism in AuthenticationHandler class. This includesBasic, Oauth, mTLS and Kerberos");

        public boolean allowAnonymousUser() {
            return this.getBoolean(ALLOW_ANONYMOUS_USER_PROP);
        }

        public SecurityHandlerConfig(Map<String, ?> originals) {
            super(CONFIG, originals);
        }
    }
}

