/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.jetty.CertificateAuthenticator;
import io.confluent.common.security.jetty.CertificateLoginService;
import io.confluent.common.security.jetty.CompositeAuthenticator;
import io.confluent.common.security.jetty.CompositeLoginService;
import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.ConnectConstraintSecurityHandler;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class InstallCompositeSecurityHandler
implements Consumer<ServletContextHandler>,
Configurable {
    private SecurityHandlerConfig config;

    public void configure(Map<String, ?> originals) {
        this.config = new SecurityHandlerConfig(originals);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createSecurityHandler());
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = this.newConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createGlobalAuthConstraint());
        securityHandler.setAuthenticator((Authenticator)this.createAuthenticator());
        securityHandler.setLoginService(this.createLoginService());
        securityHandler.setIdentityService(this.createIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    private ConstraintSecurityHandler newConstraintSecurityHandler() {
        return this.config.exposeInternalConnectEndpoints() ? new ConnectConstraintSecurityHandler() : new ConstraintSecurityHandler();
    }

    protected ConstraintMapping createGlobalAuthConstraint() {
        return AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
    }

    protected LoginAuthenticator createAuthenticator() {
        return new CompositeAuthenticator((Authenticator)new OAuthOrBasicAuthenticator(), (Authenticator)new CertificateAuthenticator(), this.config.allowAnonymousUser());
    }

    protected LoginService createLoginService() {
        return new CompositeLoginService(this.createHttpLoginService(), this.createX509LoginService());
    }

    protected LoginService createHttpLoginService() {
        String realm = this.config.getString("authentication.realm");
        String publicKeyPath = this.config.getString("public.key.path");
        String issuer = this.config.getString("token.issuer");
        JwtLoginService jwtLoginService = new JwtLoginService(realm, issuer, publicKeyPath, "");
        MdsBasicLoginService mdsBasicLoginService = new MdsBasicLoginService(this.config.originals(), realm);
        return new JwtWithFallbackLoginService(jwtLoginService, (LoginService)mdsBasicLoginService);
    }

    protected LoginService createX509LoginService() {
        String rules = this.config.getString("auth.ssl.principal.mapping.rules");
        SslPrincipalMapper principalMapper = SslPrincipalMapper.fromRules((String)rules);
        CertificateLoginService loginService = new CertificateLoginService();
        loginService.setSslPrincipalMapper(principalMapper);
        return loginService;
    }

    protected IdentityService createIdentityService() {
        return new DefaultIdentityService();
    }

    public static class SecurityHandlerConfig
    extends RestConfig {
        public static final String TOKEN_ISSUER_PROP = "token.issuer";
        public static final String TOKEN_ISSUER_DEFAULT = "Confluent";
        public static final String TOKEN_ISSUER_DOC = "An identifier for the token issuer.";
        public static final String TOKEN_PUBLIC_KEY_PATH_PROP = "public.key.path";
        public static final String TOKEN_PUBLIC_KEY_PATH_DOC = "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_PROP = "auth.ssl.principal.mapping.rules";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DEFAULT = "DEFAULT";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DOC = "Rules to execute the conversion from the certificate SN into principal name";
        public static final String ALLOW_ANONYMOUS_USER_PROP = "auth.allow.anonymous.user";
        public static final boolean ALLOW_ANONYMOUS_USER_DEFAULT = false;
        public static final String ALLOW_ANONYMOUS_USER_DOC = "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.";
        private static final String EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG = "expose.internal.connect.endpoints";
        private static final boolean EXPOSE_INTERNAL_CONNECT_ENDPOINTS_DEFAULT = false;
        private static final ConfigDef CONFIG = SecurityHandlerConfig.baseConfigDef().define("public.key.path", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Location of the PEM encoded public key to be used  by a loginService to verify Authentication Tokens. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.").define("token.issuer", ConfigDef.Type.STRING, (Object)"Confluent", ConfigDef.Importance.HIGH, "An identifier for the token issuer.").define("auth.ssl.principal.mapping.rules", ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "Rules to execute the conversion from the certificate SN into principal name").define("auth.allow.anonymous.user", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Decide what to do when no credentials are provided. The default behaviour (false) is to request BASIC authorization.").defineInternal("expose.internal.connect.endpoints", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW);

        boolean allowAnonymousUser() {
            return this.getBoolean(ALLOW_ANONYMOUS_USER_PROP);
        }

        boolean exposeInternalConnectEndpoints() {
            return this.getBoolean(EXPOSE_INTERNAL_CONNECT_ENDPOINTS_CONFIG);
        }

        public SecurityHandlerConfig(Map<String, ?> originals) {
            super(CONFIG, originals);
        }
    }
}

