/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.metrics;

import io.confluent.common.security.metrics.AbstractAuthSensor;
import io.confluent.common.security.metrics.AuthenticationType;
import java.util.Map;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.Value;

public class MtlsAuthSensor
extends AbstractAuthSensor {
    private final Sensor mtlsSuccessCountSensor;
    private final Sensor mtlsFailedCountSensor;
    private final Sensor mtlsSuccessLatencySensor;
    private final Sensor mtlsFailedLatencySensor;

    public MtlsAuthSensor(Metrics metrics, Map<String, String> configuredTags) {
        this.mtlsSuccessCountSensor = metrics.sensor("mtlsSuccessCountSensor");
        this.mtlsFailedCountSensor = metrics.sensor("mtlsFailedCountSensor");
        this.mtlsSuccessLatencySensor = metrics.sensor("mtlsSuccessLatencySensor");
        this.mtlsFailedLatencySensor = metrics.sensor("mtlsFailedLatencySensor");
        this.mtlsSuccessCountSensor.add(this.getMetricName("successful-auth-count", "auth-" + AuthenticationType.MTLS.getValue(), "Total number of successful Authentications", configuredTags), (MeasurableStat)new CumulativeCount());
        this.mtlsFailedCountSensor.add(this.getMetricName("unsuccessful-auth-count", "auth-" + AuthenticationType.MTLS.getValue(), "Total number of unsuccessful Authentications", configuredTags), (MeasurableStat)new CumulativeCount());
        this.mtlsSuccessLatencySensor.add(this.getMetricName("successful-auth-latency", "auth-" + AuthenticationType.MTLS.getValue(), "Time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Value());
        this.mtlsFailedLatencySensor.add(this.getMetricName("unsuccessful-auth-latency", "auth-" + AuthenticationType.MTLS.getValue(), "Time taken for an unsuccessful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Value());
        this.mtlsSuccessLatencySensor.add(this.getMetricName("successful-auth-latency-max", "auth-" + AuthenticationType.MTLS.getValue(), "Maximum time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Max());
        this.mtlsSuccessLatencySensor.add(this.getMetricName("successful-auth-latency-avg", "auth-" + AuthenticationType.MTLS.getValue(), "Average time taken for a successful Authentication(milliseconds)", configuredTags), (MeasurableStat)new Avg());
        this.mtlsSuccessLatencySensor.add((CompoundStat)new Percentiles(800, 0.0, PERCENTILE_MAX_LATENCY_IN_MS, Percentiles.BucketSizing.LINEAR, new Percentile[]{new Percentile(this.getMetricName("successful-auth-latency-95", "auth-" + AuthenticationType.MTLS.getValue(), "The 95th percentile request latency in ms", configuredTags), 95.0), new Percentile(this.getMetricName("successful-auth-latency-99", "auth-" + AuthenticationType.MTLS.getValue(), "The 99th percentile request latency in ms", configuredTags), 99.0)}));
    }

    public Sensor getMtlsSuccessCountSensor() {
        return this.mtlsSuccessCountSensor;
    }

    public Sensor getMtlsFailedCountSensor() {
        return this.mtlsFailedCountSensor;
    }

    public Sensor getMtlsSuccessLatencySensor() {
        return this.mtlsSuccessLatencySensor;
    }

    public Sensor getMtlsFailedLatencySensor() {
        return this.mtlsFailedLatencySensor;
    }
}

