/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import io.confluent.common.security.jetty.CertificateAuthenticator;
import io.confluent.common.security.jetty.CertificateLoginService;
import io.confluent.common.security.jetty.CompositeAuthenticator;
import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.AuthenticationHandler;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.common.security.util.Utils;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactory;
import io.confluent.rest.auth.AuthUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);

    public static LoginAuthenticator createCompositeAuthenticator(AuthenticationHandler.SecurityHandlerConfig config) {
        return new CompositeAuthenticator((Authenticator)new OAuthOrBasicAuthenticator(), (Authenticator)new CertificateAuthenticator(), config.allowAnonymousUser());
    }

    public static ConstraintSecurityHandler getOAuthSecurityHandler(RestConfig config) {
        String realm = config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setRealmName(realm);
        ConstraintMapping globalConstraint = AuthUtil.createGlobalAuthConstraint((RestConfig)config);
        globalConstraint.getConstraint().setRoles(new String[]{"**"});
        log.debug("Configured Jetty authentication roles: {}", (Object)String.join((CharSequence)",", globalConstraint.getConstraint().getRoles()));
        securityHandler.addConstraintMapping(globalConstraint);
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        return securityHandler;
    }

    public static LoginService createX509LoginService(AuthenticationHandler.SecurityHandlerConfig config) {
        return AuthUtils.createX509LoginService(config, null);
    }

    public static LoginService createX509LoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        String rules = config.getString("auth.ssl.principal.mapping.rules");
        SslPrincipalMapper principalMapper = SslPrincipalMapper.fromRules((String)rules);
        CertificateLoginService loginService = new CertificateLoginService();
        loginService.setSslPrincipalMapper(principalMapper);
        if (Objects.nonNull(metricsContainer)) {
            loginService.withMetricsContainer(metricsContainer);
        }
        return loginService;
    }

    public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config) {
        return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config);
    }

    public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config, metricsContainer);
    }

    public static JwtLoginService getConfluentJwtLoginService(String realm, String issuer, String publicKeyPath, MetricsContainer metricsContainer) {
        return new JwtLoginService(realm, issuer, publicKeyPath, "").withMetricsContainer(metricsContainer, issuer);
    }

    public static JwtLoginService getIdpJwtLoginService(String realm, String issuer, List<String> audience, String subClaimName, String groupsClaimName, AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        String idpJwksEndpoint = Utils.getBaseString("oauthbearer.jwks.endpoint.url", config);
        String sslEndpointIdentificationAlgorithm = Utils.getBaseString("ssl.endpoint.identification.algorithm", config);
        SslContextFactory sslContextFactory = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{config.getBaseSslConfig().getTrustStorePath()}) ? null : SslFactory.createSslContextFactory((SslConfig)config.getBaseSslConfig());
        CloseableVerificationKeyResolver jwksKeyResolver = JwtUtils.getJwtKeyResolver(idpJwksEndpoint, sslEndpointIdentificationAlgorithm, sslContextFactory);
        JwtAuthenticator authenticator = new JwtAuthenticator(issuer, jwksKeyResolver, audience, false);
        return new JwtLoginService(realm, authenticator, subClaimName, groupsClaimName).withMetricsContainer(metricsContainer);
    }

    static class MdsBasicLoginServiceProxy {
        MdsBasicLoginServiceProxy() {
        }

        public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config) {
            return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config, null);
        }

        public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
            String realm = config.getString("authentication.realm");
            return new MdsBasicLoginService(config.originals(), realm).withMetricsContainer(metricsContainer);
        }
    }
}

