/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.DefaultHostResolver;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.telemetry.internals.ClientTelemetrySender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    private ClientUtils() {
    }

    public static String utcDateFor(long timeMs) {
        Date date = new Date(timeMs);
        SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd_HH:mm:ss z");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(date);
    }

    public static List<InetSocketAddress> parseAndValidateAddresses(AbstractConfig config) {
        List<String> urls = config.getList("bootstrap.servers");
        String clientDnsLookupConfig = config.getString("client.dns.lookup");
        return ClientUtils.parseAndValidateAddresses(urls, clientDnsLookupConfig);
    }

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls, String clientDnsLookupConfig) {
        return ClientUtils.parseAndValidateAddresses(urls, ClientDnsLookup.forConfig(clientDnsLookupConfig));
    }

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls, ClientDnsLookup clientDnsLookup) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String url : urls) {
            if (url == null || url.isEmpty()) continue;
            try {
                String host = Utils.getHost(url);
                Integer port = Utils.getPort(url);
                if (host == null || port == null) {
                    throw new ConfigException("Invalid url in bootstrap.servers: " + url);
                }
                if (clientDnsLookup == ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY) {
                    InetAddress[] inetAddresses;
                    for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                        String resolvedCanonicalName = inetAddress.getCanonicalHostName();
                        InetSocketAddress address = new InetSocketAddress(resolvedCanonicalName, (int)port);
                        if (address.isUnresolved()) {
                            log.warn("Couldn't resolve server {} from {} as DNS resolution of the canonical hostname {} failed for {}", new Object[]{url, "bootstrap.servers", resolvedCanonicalName, host});
                            continue;
                        }
                        addresses.add(address);
                    }
                    continue;
                }
                InetSocketAddress address = new InetSocketAddress(host, (int)port);
                if (address.isUnresolved()) {
                    log.warn("Couldn't resolve server {} from {} as DNS resolution failed for {}", new Object[]{url, "bootstrap.servers", host});
                    continue;
                }
                addresses.add(address);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Invalid port in bootstrap.servers: " + url);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Unknown host in bootstrap.servers: " + url);
            }
        }
        if (addresses.isEmpty()) {
            throw new ConfigException("No resolvable bootstrap urls given in bootstrap.servers");
        }
        return addresses;
    }

    public static ChannelBuilder createChannelBuilder(AbstractConfig config, Time time, LogContext logContext) {
        return ClientUtils.createChannelBuilder(config, time, logContext, null, null);
    }

    public static ChannelBuilder createChannelBuilder(AbstractConfig config, Time time, LogContext logContext, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        SecurityProtocol securityProtocol = SecurityProtocol.forName(config.getString("security.protocol"));
        String clientSaslMechanism = config.getString("sasl.mechanism");
        return ChannelBuilders.clientChannelBuilder(securityProtocol, JaasContext.Type.CLIENT, config, null, clientSaslMechanism, time, true, logContext, requestCallback, proxyProtocolEngineFactory);
    }

    static List<InetAddress> resolve(String host, HostResolver hostResolver) throws UnknownHostException {
        InetAddress[] addresses = hostResolver.resolve(host);
        List<InetAddress> result = ClientUtils.filterPreferredAddresses(addresses);
        if (log.isDebugEnabled()) {
            log.debug("Resolved host {} as {}", (Object)host, (Object)result.stream().map(i -> i.getHostAddress()).collect(Collectors.joining(",")));
        }
        return result;
    }

    static List<InetAddress> filterPreferredAddresses(InetAddress[] allAddresses) {
        ArrayList<InetAddress> preferredAddresses = new ArrayList<InetAddress>();
        Class<?> clazz = null;
        for (InetAddress address : allAddresses) {
            if (clazz == null) {
                clazz = address.getClass();
            }
            if (!clazz.isInstance(address)) continue;
            preferredAddresses.add(address);
        }
        return preferredAddresses;
    }

    public static NetworkClient createNetworkClient(AbstractConfig config, Metrics metrics, String metricsGroupPrefix, LogContext logContext, ApiVersions apiVersions, Time time, int maxInFlightRequestsPerConnection, Metadata metadata, Sensor throttleTimeSensor, ClientTelemetrySender clientTelemetrySender) {
        return ClientUtils.createNetworkClient(config, config.getString("client.id"), metrics, metricsGroupPrefix, logContext, apiVersions, time, maxInFlightRequestsPerConnection, config.getInt("request.timeout.ms"), metadata, null, new DefaultHostResolver(), throttleTimeSensor, clientTelemetrySender);
    }

    public static NetworkClient createNetworkClient(AbstractConfig config, String clientId, Metrics metrics, String metricsGroupPrefix, LogContext logContext, ApiVersions apiVersions, Time time, int maxInFlightRequestsPerConnection, int requestTimeoutMs, MetadataUpdater metadataUpdater, HostResolver hostResolver) {
        return ClientUtils.createNetworkClient(config, clientId, metrics, metricsGroupPrefix, logContext, apiVersions, time, maxInFlightRequestsPerConnection, requestTimeoutMs, null, metadataUpdater, hostResolver, null, null);
    }

    public static NetworkClient createNetworkClient(AbstractConfig config, String clientId, Metrics metrics, String metricsGroupPrefix, LogContext logContext, ApiVersions apiVersions, Time time, int maxInFlightRequestsPerConnection, int requestTimeoutMs, Metadata metadata, MetadataUpdater metadataUpdater, HostResolver hostResolver, Sensor throttleTimeSensor, ClientTelemetrySender clientTelemetrySender) {
        ChannelBuilder channelBuilder = null;
        Selector selector = null;
        try {
            channelBuilder = ClientUtils.createChannelBuilder(config, time, logContext);
            selector = new Selector(config.getLong("connections.max.idle.ms"), metrics, time, metricsGroupPrefix, channelBuilder, logContext);
            return new NetworkClient(metadataUpdater, metadata, selector, clientId, maxInFlightRequestsPerConnection, config.getLong("reconnect.backoff.ms"), config.getLong("reconnect.backoff.max.ms"), config.getInt("send.buffer.bytes"), config.getInt("receive.buffer.bytes"), requestTimeoutMs, config.getLong("socket.connection.setup.timeout.ms"), config.getLong("socket.connection.setup.timeout.max.ms"), time, true, apiVersions, throttleTimeSensor, logContext, hostResolver, clientTelemetrySender);
        }
        catch (Throwable t) {
            Utils.closeQuietly(selector, "Selector");
            Utils.closeQuietly(channelBuilder, "ChannelBuilder");
            throw new KafkaException("Failed to create new NetworkClient", t);
        }
    }

    public static <T> List configuredInterceptors(AbstractConfig config, String interceptorClassesConfigName, Class<T> clazz) {
        String clientId = config.getString("client.id");
        return config.getConfiguredInstances(interceptorClassesConfigName, clazz, Collections.singletonMap("client.id", clientId));
    }

    public static ClusterResourceListeners configureClusterResourceListeners(List<?> ... candidateLists) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        for (List<?> candidateList : candidateLists) {
            clusterResourceListeners.maybeAddAll(candidateList);
        }
        return clusterResourceListeners;
    }
}

