/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorTopicsRequestData
implements ApiMessage {
    List<AlterMirrorTopic> alterMirrorTopics;
    boolean validateOnly;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("alter_mirror_topics", new CompactArrayOf(AlterMirrorTopic.SCHEMA_0), "The mirror topics to modify."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the mirror topic can be updated with this request data."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterMirrorTopicsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorTopicsRequestData() {
        this.alterMirrorTopics = new ArrayList<AlterMirrorTopic>(0);
        this.validateOnly = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10023;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field alterMirrorTopics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<AlterMirrorTopic> newCollection = new ArrayList<AlterMirrorTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterMirrorTopic(_readable, _version, _context));
        }
        this.alterMirrorTopics = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.alterMirrorTopics.size() + 1);
        for (AlterMirrorTopic alterMirrorTopicsElement : this.alterMirrorTopics) {
            alterMirrorTopicsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.alterMirrorTopics.size() + 1));
        for (AlterMirrorTopic alterMirrorTopicsElement : this.alterMirrorTopics) {
            alterMirrorTopicsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorTopicsRequestData)) {
            return false;
        }
        AlterMirrorTopicsRequestData other = (AlterMirrorTopicsRequestData)obj;
        if (this.alterMirrorTopics == null ? other.alterMirrorTopics != null : !this.alterMirrorTopics.equals(other.alterMirrorTopics)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.alterMirrorTopics == null ? 0 : this.alterMirrorTopics.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterMirrorTopicsRequestData duplicate() {
        AlterMirrorTopicsRequestData _duplicate = new AlterMirrorTopicsRequestData();
        ArrayList<AlterMirrorTopic> newAlterMirrorTopics = new ArrayList<AlterMirrorTopic>(this.alterMirrorTopics.size());
        for (AlterMirrorTopic _element : this.alterMirrorTopics) {
            newAlterMirrorTopics.add(_element.duplicate());
        }
        _duplicate.alterMirrorTopics = newAlterMirrorTopics;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorTopicsRequestData(alterMirrorTopics=" + MessageUtil.deepToString(this.alterMirrorTopics.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<AlterMirrorTopic> alterMirrorTopics() {
        return this.alterMirrorTopics;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorTopicsRequestData setAlterMirrorTopics(List<AlterMirrorTopic> v) {
        this.alterMirrorTopics = v;
        return this;
    }

    public AlterMirrorTopicsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public AlterMirrorTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class AlterMirrorTopic
    implements Message {
        String topic;
        String mirrorTopicState;
        List<Long> stoppedLogEndOffsets;
        boolean promoted;
        boolean linkLevelPause;
        boolean topicLevelPause;
        List<Long> mirrorStartOffsets;
        short mirrorTopicError;
        Uuid linkId;
        Uuid sourceTopicId;
        String sourceTopicName;
        Uuid expectedLocalTopicId;
        String nextState;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The name of the mirror topic."), new Field("mirror_topic_state", Type.COMPACT_STRING, "The new state of the mirror topic. Valid States: Mirror, FailedMirror, PendingStoppedMirror, PausedMirror, StoppedMirror, PendingMirror and PendingSynchronizeMirror"), Field.TaggedFieldsSection.of(0, new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was at stopped state. Null if mirror topic is not stopped."), 1, new Field("promoted", Type.BOOLEAN, "Should the mirror synchronize with the source before stopping"), 2, new Field("link_level_pause", Type.BOOLEAN, "True if this pause transition was at the link level."), 3, new Field("topic_level_pause", Type.BOOLEAN, "True if the mirror topic was paused."), 4, new Field("mirror_start_offsets", CompactArrayOf.nullable(Type.INT64), "List of earliest offsets to start mirroring from, ordered by partition. By default, mirroring starts from the first available offset."), 5, new Field("mirror_topic_error", Type.INT16, "Mirror failure reason if the mirror is in failed state."), 6, new Field("link_id", Type.UUID, "The link id of the mirror topic. Used only when converting a writable topic into a mirror topic."), 7, new Field("source_topic_id", Type.UUID, "The source topic id of the mirror topic. Used only when converting a writable topic into a mirror topic."), 8, new Field("source_topic_name", Type.COMPACT_STRING, "The name of the source topic for the mirror topic. Used only when converting a writable topic into a mirror topic."), 9, new Field("expected_local_topic_id", Type.UUID, "The expected local topic id of the topic being converted to a mirror topic. Used only when converting a writable topic into a mirror topic."), 10, new Field("next_state", Type.COMPACT_NULLABLE_STRING, "The state the remote mirror topic will go into after synchronization, or the next state the local pending mirror topic will go into after synchronization. Non-null in PendingSynchronize and PendingMirror states")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterMirrorTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterMirrorTopic() {
            this.topic = "";
            this.mirrorTopicState = "";
            this.stoppedLogEndOffsets = null;
            this.promoted = false;
            this.linkLevelPause = false;
            this.topicLevelPause = false;
            this.mirrorStartOffsets = null;
            this.mirrorTopicError = (short)-1;
            this.linkId = Uuid.ZERO_UUID;
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.sourceTopicName = "";
            this.expectedLocalTopicId = Uuid.ZERO_UUID;
            this.nextState = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterMirrorTopic");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
            }
            this.mirrorTopicState = _readable.readString(length);
            this.stoppedLogEndOffsets = null;
            this.promoted = false;
            this.linkLevelPause = false;
            this.topicLevelPause = false;
            this.mirrorStartOffsets = null;
            this.mirrorTopicError = (short)-1;
            this.linkId = Uuid.ZERO_UUID;
            this.sourceTopicId = Uuid.ZERO_UUID;
            this.sourceTopicName = "";
            this.expectedLocalTopicId = Uuid.ZERO_UUID;
            this.nextState = null;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block13: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int i;
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.stoppedLogEndOffsets = null;
                            continue block13;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readLong());
                        }
                        this.stoppedLogEndOffsets = newCollection;
                        continue block13;
                    }
                    case 1: {
                        this.promoted = _readable.readByte() != 0;
                        continue block13;
                    }
                    case 2: {
                        this.linkLevelPause = _readable.readByte() != 0;
                        continue block13;
                    }
                    case 3: {
                        this.topicLevelPause = _readable.readByte() != 0;
                        continue block13;
                    }
                    case 4: {
                        int i;
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.mirrorStartOffsets = null;
                            continue block13;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Long> newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readLong());
                        }
                        this.mirrorStartOffsets = newCollection;
                        continue block13;
                    }
                    case 5: {
                        this.mirrorTopicError = _readable.readShort();
                        continue block13;
                    }
                    case 6: {
                        this.linkId = _readable.readUuid();
                        continue block13;
                    }
                    case 7: {
                        this.sourceTopicId = _readable.readUuid();
                        continue block13;
                    }
                    case 8: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            throw new RuntimeException("non-nullable field sourceTopicName was serialized as null");
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field sourceTopicName had invalid length " + length2);
                        }
                        this.sourceTopicName = _context.read(EntityType.TOPIC_NAME, _readable.readString(length2));
                        continue block13;
                    }
                    case 9: {
                        this.expectedLocalTopicId = _readable.readUuid();
                        continue block13;
                    }
                    case 10: {
                        int length2 = _readable.readUnsignedVarint() - 1;
                        if (length2 < 0) {
                            this.nextState = null;
                            continue block13;
                        }
                        if (length2 > Short.MAX_VALUE) {
                            throw new RuntimeException("string field nextState had invalid length " + length2);
                        }
                        this.nextState = _readable.readString(length2);
                        continue block13;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            byte[] _stringBytes2 = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
            _stringBytes2 = _cache.getSerializedValue(this.mirrorTopicState);
            _writable.writeUnsignedVarint(_stringBytes2.length + 1);
            _writable.writeByteArray(_stringBytes2);
            if (this.stoppedLogEndOffsets != null) {
                ++_numTaggedFields;
            }
            if (this.promoted) {
                ++_numTaggedFields;
            }
            if (this.linkLevelPause) {
                ++_numTaggedFields;
            }
            if (this.topicLevelPause) {
                ++_numTaggedFields;
            }
            if (this.mirrorStartOffsets != null) {
                ++_numTaggedFields;
            }
            if (this.mirrorTopicError != -1) {
                ++_numTaggedFields;
            }
            if (!this.linkId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
            }
            if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
            }
            if (!this.sourceTopicName.equals("")) {
                ++_numTaggedFields;
            }
            if (!this.expectedLocalTopicId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
            }
            if (this.nextState != null) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.stoppedLogEndOffsets != null) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets));
                _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
                for (Long stoppedLogEndOffsetsElement : this.stoppedLogEndOffsets) {
                    _writable.writeLong(stoppedLogEndOffsetsElement);
                }
            }
            if (this.promoted) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.promoted ? (byte)1 : 0);
            }
            if (this.linkLevelPause) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.linkLevelPause ? (byte)1 : 0);
            }
            if (this.topicLevelPause) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.topicLevelPause ? (byte)1 : 0);
            }
            if (this.mirrorStartOffsets != null) {
                _writable.writeUnsignedVarint(4);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.mirrorStartOffsets));
                _writable.writeUnsignedVarint(this.mirrorStartOffsets.size() + 1);
                for (Long mirrorStartOffsetsElement : this.mirrorStartOffsets) {
                    _writable.writeLong(mirrorStartOffsetsElement);
                }
            }
            if (this.mirrorTopicError != -1) {
                _writable.writeUnsignedVarint(5);
                _writable.writeUnsignedVarint(2);
                _writable.writeShort(this.mirrorTopicError);
            }
            if (!this.linkId.equals(Uuid.ZERO_UUID)) {
                _writable.writeUnsignedVarint(6);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.linkId);
            }
            if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                _writable.writeUnsignedVarint(7);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.sourceTopicId);
            }
            if (!this.sourceTopicName.equals("")) {
                _writable.writeUnsignedVarint(8);
                _stringBytes = _cache.getSerializedValue(this.sourceTopicName);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            if (!this.expectedLocalTopicId.equals(Uuid.ZERO_UUID)) {
                _writable.writeUnsignedVarint(9);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.expectedLocalTopicId);
            }
            if (this.nextState != null) {
                _writable.writeUnsignedVarint(10);
                _stringBytes = _cache.getSerializedValue(this.nextState);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _stringPrefixSize;
            int _arraySize;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterMirrorTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.mirrorTopicState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.stoppedLogEndOffsets != null) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stoppedLogEndOffsets.size() + 1));
                _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
                _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this.promoted) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.linkLevelPause) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.topicLevelPause) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.mirrorStartOffsets != null) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.mirrorStartOffsets.size() + 1));
                _size.addBytes(this.mirrorStartOffsets.size() * 8);
                _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.mirrorStartOffsets, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this.mirrorTopicError != -1) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(2);
            }
            if (!this.linkId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (!this.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (!this.sourceTopicName.equals("")) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _stringBytes = _context.write(EntityType.TOPIC_NAME, this.sourceTopicName).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.sourceTopicName, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
            }
            if (!this.expectedLocalTopicId.equals(Uuid.ZERO_UUID)) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(16);
            }
            if (this.nextState != null) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _stringBytes = this.nextState.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'nextState' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.nextState, _stringBytes);
                _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                _size.addBytes(_stringBytes.length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + _stringBytes.length));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterMirrorTopic)) {
                return false;
            }
            AlterMirrorTopic other = (AlterMirrorTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
                return false;
            }
            if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
                return false;
            }
            if (this.promoted != other.promoted) {
                return false;
            }
            if (this.linkLevelPause != other.linkLevelPause) {
                return false;
            }
            if (this.topicLevelPause != other.topicLevelPause) {
                return false;
            }
            if (this.mirrorStartOffsets == null ? other.mirrorStartOffsets != null : !this.mirrorStartOffsets.equals(other.mirrorStartOffsets)) {
                return false;
            }
            if (this.mirrorTopicError != other.mirrorTopicError) {
                return false;
            }
            if (!this.linkId.equals(other.linkId)) {
                return false;
            }
            if (!this.sourceTopicId.equals(other.sourceTopicId)) {
                return false;
            }
            if (this.sourceTopicName == null ? other.sourceTopicName != null : !this.sourceTopicName.equals(other.sourceTopicName)) {
                return false;
            }
            if (!this.expectedLocalTopicId.equals(other.expectedLocalTopicId)) {
                return false;
            }
            if (this.nextState == null ? other.nextState != null : !this.nextState.equals(other.nextState)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
            hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
            hashCode = 31 * hashCode + (this.promoted ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.linkLevelPause ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.topicLevelPause ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.mirrorStartOffsets == null ? 0 : this.mirrorStartOffsets.hashCode());
            hashCode = 31 * hashCode + this.mirrorTopicError;
            hashCode = 31 * hashCode + this.linkId.hashCode();
            hashCode = 31 * hashCode + this.sourceTopicId.hashCode();
            hashCode = 31 * hashCode + (this.sourceTopicName == null ? 0 : this.sourceTopicName.hashCode());
            hashCode = 31 * hashCode + this.expectedLocalTopicId.hashCode();
            hashCode = 31 * hashCode + (this.nextState == null ? 0 : this.nextState.hashCode());
            return hashCode;
        }

        @Override
        public AlterMirrorTopic duplicate() {
            AlterMirrorTopic _duplicate = new AlterMirrorTopic();
            _duplicate.topic = this.topic;
            _duplicate.mirrorTopicState = this.mirrorTopicState;
            if (this.stoppedLogEndOffsets == null) {
                _duplicate.stoppedLogEndOffsets = null;
            } else {
                ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
                for (Long _element : this.stoppedLogEndOffsets) {
                    newStoppedLogEndOffsets.add(_element);
                }
                _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
            }
            _duplicate.promoted = this.promoted;
            _duplicate.linkLevelPause = this.linkLevelPause;
            _duplicate.topicLevelPause = this.topicLevelPause;
            if (this.mirrorStartOffsets == null) {
                _duplicate.mirrorStartOffsets = null;
            } else {
                ArrayList<Long> newMirrorStartOffsets = new ArrayList<Long>(this.mirrorStartOffsets.size());
                for (Long _element : this.mirrorStartOffsets) {
                    newMirrorStartOffsets.add(_element);
                }
                _duplicate.mirrorStartOffsets = newMirrorStartOffsets;
            }
            _duplicate.mirrorTopicError = this.mirrorTopicError;
            _duplicate.linkId = this.linkId;
            _duplicate.sourceTopicId = this.sourceTopicId;
            _duplicate.sourceTopicName = this.sourceTopicName;
            _duplicate.expectedLocalTopicId = this.expectedLocalTopicId;
            _duplicate.nextState = this.nextState == null ? null : this.nextState;
            return _duplicate;
        }

        public String toString() {
            return "AlterMirrorTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", mirrorTopicState=" + (this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", promoted=" + (this.promoted ? "true" : "false") + ", linkLevelPause=" + (this.linkLevelPause ? "true" : "false") + ", topicLevelPause=" + (this.topicLevelPause ? "true" : "false") + ", mirrorStartOffsets=" + (this.mirrorStartOffsets == null ? "null" : MessageUtil.deepToString(this.mirrorStartOffsets.iterator())) + ", mirrorTopicError=" + this.mirrorTopicError + ", linkId=" + this.linkId.toString() + ", sourceTopicId=" + this.sourceTopicId.toString() + ", sourceTopicName=" + (this.sourceTopicName == null ? "null" : "'" + this.sourceTopicName.toString() + "'") + ", expectedLocalTopicId=" + this.expectedLocalTopicId.toString() + ", nextState=" + (this.nextState == null ? "null" : "'" + this.nextState.toString() + "'") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public String mirrorTopicState() {
            return this.mirrorTopicState;
        }

        public List<Long> stoppedLogEndOffsets() {
            return this.stoppedLogEndOffsets;
        }

        public boolean promoted() {
            return this.promoted;
        }

        public boolean linkLevelPause() {
            return this.linkLevelPause;
        }

        public boolean topicLevelPause() {
            return this.topicLevelPause;
        }

        public List<Long> mirrorStartOffsets() {
            return this.mirrorStartOffsets;
        }

        public short mirrorTopicError() {
            return this.mirrorTopicError;
        }

        public Uuid linkId() {
            return this.linkId;
        }

        public Uuid sourceTopicId() {
            return this.sourceTopicId;
        }

        public String sourceTopicName() {
            return this.sourceTopicName;
        }

        public Uuid expectedLocalTopicId() {
            return this.expectedLocalTopicId;
        }

        public String nextState() {
            return this.nextState;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterMirrorTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public AlterMirrorTopic setMirrorTopicState(String v) {
            this.mirrorTopicState = v;
            return this;
        }

        public AlterMirrorTopic setStoppedLogEndOffsets(List<Long> v) {
            this.stoppedLogEndOffsets = v;
            return this;
        }

        public AlterMirrorTopic setPromoted(boolean v) {
            this.promoted = v;
            return this;
        }

        public AlterMirrorTopic setLinkLevelPause(boolean v) {
            this.linkLevelPause = v;
            return this;
        }

        public AlterMirrorTopic setTopicLevelPause(boolean v) {
            this.topicLevelPause = v;
            return this;
        }

        public AlterMirrorTopic setMirrorStartOffsets(List<Long> v) {
            this.mirrorStartOffsets = v;
            return this;
        }

        public AlterMirrorTopic setMirrorTopicError(short v) {
            this.mirrorTopicError = v;
            return this;
        }

        public AlterMirrorTopic setLinkId(Uuid v) {
            this.linkId = v;
            return this;
        }

        public AlterMirrorTopic setSourceTopicId(Uuid v) {
            this.sourceTopicId = v;
            return this;
        }

        public AlterMirrorTopic setSourceTopicName(String v) {
            this.sourceTopicName = v;
            return this;
        }

        public AlterMirrorTopic setExpectedLocalTopicId(Uuid v) {
            this.expectedLocalTopicId = v;
            return this;
        }

        public AlterMirrorTopic setNextState(String v) {
            this.nextState = v;
            return this;
        }
    }
}

