/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ApiVersionsResponseData
implements ApiMessage {
    short errorCode;
    ApiVersionCollection apiKeys;
    int throttleTimeMs;
    SupportedFeatureKeyCollection supportedFeatures;
    long finalizedFeaturesEpoch;
    FinalizedFeatureKeyCollection finalizedFeatures;
    boolean zkMigrationReady;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("api_keys", new ArrayOf(ApiVersion.SCHEMA_0), "The APIs supported by the broker."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public ApiVersionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ApiVersionsResponseData() {
        this.errorCode = 0;
        this.apiKeys = new ApiVersionCollection(0);
        this.throttleTimeMs = 0;
        this.supportedFeatures = new SupportedFeatureKeyCollection(0);
        this.finalizedFeaturesEpoch = -1L;
        this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
        this.zkMigrationReady = false;
    }

    @Override
    public short apiKey() {
        return 18;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ApiVersionCollection newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ApiVersionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersion(_readable, _version, _context));
            }
            this.apiKeys = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ApiVersionCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersion(_readable, _version, _context));
            }
            this.apiKeys = newCollection;
        }
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.supportedFeatures = new SupportedFeatureKeyCollection(0);
        this.finalizedFeaturesEpoch = -1L;
        this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
        this.zkMigrationReady = false;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block8: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int i2;
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field supportedFeatures was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ImplicitLinkedHashMultiCollection newCollection2 = new SupportedFeatureKeyCollection(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(new SupportedFeatureKey(_readable, _version, _context));
                        }
                        this.supportedFeatures = newCollection2;
                        continue block8;
                    }
                    case 1: {
                        this.finalizedFeaturesEpoch = _readable.readLong();
                        continue block8;
                    }
                    case 2: {
                        int i2;
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field finalizedFeatures was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ImplicitLinkedHashMultiCollection newCollection2 = new FinalizedFeatureKeyCollection(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(new FinalizedFeatureKey(_readable, _version, _context));
                        }
                        this.finalizedFeatures = newCollection2;
                        continue block8;
                    }
                    case 3: {
                        this.zkMigrationReady = _readable.readByte() != 0;
                        continue block8;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.apiKeys.size() + 1);
            for (ApiVersion apiKeysElement : this.apiKeys) {
                apiKeysElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.apiKeys.size());
            for (ApiVersion apiKeysElement : this.apiKeys) {
                apiKeysElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 3 && !this.supportedFeatures.isEmpty()) {
            ++_numTaggedFields;
        }
        if (_version >= 3 && this.finalizedFeaturesEpoch != -1L) {
            ++_numTaggedFields;
        }
        if (_version >= 3 && !this.finalizedFeatures.isEmpty()) {
            ++_numTaggedFields;
        }
        if (_version >= 3 && this.zkMigrationReady) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.supportedFeatures.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.supportedFeatures));
                _writable.writeUnsignedVarint(this.supportedFeatures.size() + 1);
                for (SupportedFeatureKey supportedFeaturesElement : this.supportedFeatures) {
                    supportedFeaturesElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.finalizedFeaturesEpoch != -1L) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.finalizedFeaturesEpoch);
            }
            if (!this.finalizedFeatures.isEmpty()) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.finalizedFeatures));
                _writable.writeUnsignedVarint(this.finalizedFeatures.size() + 1);
                for (FinalizedFeatureKey finalizedFeaturesElement : this.finalizedFeatures) {
                    finalizedFeaturesElement.write(_writable, _cache, _version, _context);
                }
            }
            if (this.zkMigrationReady) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.zkMigrationReady ? (byte)1 : 0);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.apiKeys.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (Object apiKeysElement : this.apiKeys) {
            ((ApiVersion)apiKeysElement).addSize(_size, _cache, _version, _context);
        }
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 3 && !this.supportedFeatures.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.supportedFeatures.size() + 1));
            for (SupportedFeatureKey supportedFeaturesElement : this.supportedFeatures) {
                supportedFeaturesElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.supportedFeatures, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (_version >= 3 && this.finalizedFeaturesEpoch != -1L) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(8);
        }
        if (_version >= 3 && !this.finalizedFeatures.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.finalizedFeatures.size() + 1));
            for (FinalizedFeatureKey finalizedFeaturesElement : this.finalizedFeatures) {
                finalizedFeaturesElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.finalizedFeatures, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (_version >= 3 && this.zkMigrationReady) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 3) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiVersionsResponseData)) {
            return false;
        }
        ApiVersionsResponseData other = (ApiVersionsResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.apiKeys == null ? other.apiKeys != null : !this.apiKeys.equals(other.apiKeys)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.supportedFeatures == null ? other.supportedFeatures != null : !this.supportedFeatures.equals(other.supportedFeatures)) {
            return false;
        }
        if (this.finalizedFeaturesEpoch != other.finalizedFeaturesEpoch) {
            return false;
        }
        if (this.finalizedFeatures == null ? other.finalizedFeatures != null : !this.finalizedFeatures.equals(other.finalizedFeatures)) {
            return false;
        }
        if (this.zkMigrationReady != other.zkMigrationReady) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.apiKeys == null ? 0 : this.apiKeys.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.supportedFeatures == null ? 0 : this.supportedFeatures.hashCode());
        hashCode = 31 * hashCode + ((int)(this.finalizedFeaturesEpoch >> 32) ^ (int)this.finalizedFeaturesEpoch);
        hashCode = 31 * hashCode + (this.finalizedFeatures == null ? 0 : this.finalizedFeatures.hashCode());
        hashCode = 31 * hashCode + (this.zkMigrationReady ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public ApiVersionsResponseData duplicate() {
        ApiVersionsResponseData _duplicate = new ApiVersionsResponseData();
        _duplicate.errorCode = this.errorCode;
        ApiVersionCollection newApiKeys = new ApiVersionCollection(this.apiKeys.size());
        for (Object _element : this.apiKeys) {
            newApiKeys.add(((ApiVersion)_element).duplicate());
        }
        _duplicate.apiKeys = newApiKeys;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        SupportedFeatureKeyCollection newSupportedFeatures = new SupportedFeatureKeyCollection(this.supportedFeatures.size());
        for (SupportedFeatureKey _element : this.supportedFeatures) {
            newSupportedFeatures.add(_element.duplicate());
        }
        _duplicate.supportedFeatures = newSupportedFeatures;
        _duplicate.finalizedFeaturesEpoch = this.finalizedFeaturesEpoch;
        FinalizedFeatureKeyCollection newFinalizedFeatures = new FinalizedFeatureKeyCollection(this.finalizedFeatures.size());
        for (FinalizedFeatureKey _element : this.finalizedFeatures) {
            newFinalizedFeatures.add(_element.duplicate());
        }
        _duplicate.finalizedFeatures = newFinalizedFeatures;
        _duplicate.zkMigrationReady = this.zkMigrationReady;
        return _duplicate;
    }

    public String toString() {
        return "ApiVersionsResponseData(errorCode=" + this.errorCode + ", apiKeys=" + MessageUtil.deepToString(this.apiKeys.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ", supportedFeatures=" + MessageUtil.deepToString(this.supportedFeatures.iterator()) + ", finalizedFeaturesEpoch=" + this.finalizedFeaturesEpoch + ", finalizedFeatures=" + MessageUtil.deepToString(this.finalizedFeatures.iterator()) + ", zkMigrationReady=" + (this.zkMigrationReady ? "true" : "false") + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public ApiVersionCollection apiKeys() {
        return this.apiKeys;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public SupportedFeatureKeyCollection supportedFeatures() {
        return this.supportedFeatures;
    }

    public long finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }

    public FinalizedFeatureKeyCollection finalizedFeatures() {
        return this.finalizedFeatures;
    }

    public boolean zkMigrationReady() {
        return this.zkMigrationReady;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ApiVersionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ApiVersionsResponseData setApiKeys(ApiVersionCollection v) {
        this.apiKeys = v;
        return this;
    }

    public ApiVersionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ApiVersionsResponseData setSupportedFeatures(SupportedFeatureKeyCollection v) {
        this.supportedFeatures = v;
        return this;
    }

    public ApiVersionsResponseData setFinalizedFeaturesEpoch(long v) {
        this.finalizedFeaturesEpoch = v;
        return this;
    }

    public ApiVersionsResponseData setFinalizedFeatures(FinalizedFeatureKeyCollection v) {
        this.finalizedFeatures = v;
        return this;
    }

    public ApiVersionsResponseData setZkMigrationReady(boolean v) {
        this.zkMigrationReady = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("api_keys", new ArrayOf(ApiVersion.SCHEMA_0), "The APIs supported by the broker."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_3 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("api_keys", new CompactArrayOf(ApiVersion.SCHEMA_3), "The APIs supported by the broker."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(0, new Field("supported_features", new CompactArrayOf(SupportedFeatureKey.SCHEMA_3), "Features supported by the broker."), 1, new Field("finalized_features_epoch", Type.INT64, "The monotonically increasing epoch for the finalized features information. Valid values are >= 0. A value of -1 is special and represents unknown epoch."), 2, new Field("finalized_features", new CompactArrayOf(FinalizedFeatureKey.SCHEMA_3), "List of cluster-wide finalized features. The information is valid only if FinalizedFeaturesEpoch >= 0."), 3, new Field("zk_migration_ready", Type.BOOLEAN, "Set by a KRaft controller if the required configurations for ZK migration are present")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class FinalizedFeatureKeyCollection
    extends ImplicitLinkedHashMultiCollection<FinalizedFeatureKey> {
        public FinalizedFeatureKeyCollection() {
        }

        public FinalizedFeatureKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FinalizedFeatureKeyCollection(Iterator<FinalizedFeatureKey> iterator) {
            super(iterator);
        }

        @Override
        public FinalizedFeatureKey find(String name) {
            FinalizedFeatureKey _key = new FinalizedFeatureKey();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<FinalizedFeatureKey> findAll(String name) {
            FinalizedFeatureKey _key = new FinalizedFeatureKey();
            _key.setName(name);
            return this.findAll(_key);
        }

        public FinalizedFeatureKeyCollection duplicate() {
            FinalizedFeatureKeyCollection _duplicate = new FinalizedFeatureKeyCollection(this.size());
            for (FinalizedFeatureKey _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class FinalizedFeatureKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short maxVersionLevel;
        short minVersionLevel;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_3 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the feature."), new Field("max_version_level", Type.INT16, "The cluster-wide finalized max version level for the feature."), new Field("min_version_level", Type.INT16, "The cluster-wide finalized min version level for the feature."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public FinalizedFeatureKey(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public FinalizedFeatureKey() {
            this.name = "";
            this.maxVersionLevel = 0;
            this.minVersionLevel = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FinalizedFeatureKey");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.maxVersionLevel = _readable.readShort();
            this.minVersionLevel = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FinalizedFeatureKey");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.maxVersionLevel);
            _writable.writeShort(this.minVersionLevel);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FinalizedFeatureKey");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof FinalizedFeatureKey)) {
                return false;
            }
            FinalizedFeatureKey other = (FinalizedFeatureKey)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FinalizedFeatureKey)) {
                return false;
            }
            FinalizedFeatureKey other = (FinalizedFeatureKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.maxVersionLevel != other.maxVersionLevel) {
                return false;
            }
            if (this.minVersionLevel != other.minVersionLevel) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public FinalizedFeatureKey duplicate() {
            FinalizedFeatureKey _duplicate = new FinalizedFeatureKey();
            _duplicate.name = this.name;
            _duplicate.maxVersionLevel = this.maxVersionLevel;
            _duplicate.minVersionLevel = this.minVersionLevel;
            return _duplicate;
        }

        public String toString() {
            return "FinalizedFeatureKey(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", maxVersionLevel=" + this.maxVersionLevel + ", minVersionLevel=" + this.minVersionLevel + ")";
        }

        public String name() {
            return this.name;
        }

        public short maxVersionLevel() {
            return this.maxVersionLevel;
        }

        public short minVersionLevel() {
            return this.minVersionLevel;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FinalizedFeatureKey setName(String v) {
            this.name = v;
            return this;
        }

        public FinalizedFeatureKey setMaxVersionLevel(short v) {
            this.maxVersionLevel = v;
            return this;
        }

        public FinalizedFeatureKey setMinVersionLevel(short v) {
            this.minVersionLevel = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class SupportedFeatureKeyCollection
    extends ImplicitLinkedHashMultiCollection<SupportedFeatureKey> {
        public SupportedFeatureKeyCollection() {
        }

        public SupportedFeatureKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public SupportedFeatureKeyCollection(Iterator<SupportedFeatureKey> iterator) {
            super(iterator);
        }

        @Override
        public SupportedFeatureKey find(String name) {
            SupportedFeatureKey _key = new SupportedFeatureKey();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<SupportedFeatureKey> findAll(String name) {
            SupportedFeatureKey _key = new SupportedFeatureKey();
            _key.setName(name);
            return this.findAll(_key);
        }

        public SupportedFeatureKeyCollection duplicate() {
            SupportedFeatureKeyCollection _duplicate = new SupportedFeatureKeyCollection(this.size());
            for (SupportedFeatureKey _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class SupportedFeatureKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minVersion;
        short maxVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_3 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the feature."), new Field("min_version", Type.INT16, "The minimum supported version for the feature."), new Field("max_version", Type.INT16, "The maximum supported version for the feature."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public SupportedFeatureKey(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public SupportedFeatureKey() {
            this.name = "";
            this.minVersion = 0;
            this.maxVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SupportedFeatureKey");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minVersion = _readable.readShort();
            this.maxVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of SupportedFeatureKey");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minVersion);
            _writable.writeShort(this.maxVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SupportedFeatureKey");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof SupportedFeatureKey)) {
                return false;
            }
            SupportedFeatureKey other = (SupportedFeatureKey)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SupportedFeatureKey)) {
                return false;
            }
            SupportedFeatureKey other = (SupportedFeatureKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minVersion != other.minVersion) {
                return false;
            }
            if (this.maxVersion != other.maxVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public SupportedFeatureKey duplicate() {
            SupportedFeatureKey _duplicate = new SupportedFeatureKey();
            _duplicate.name = this.name;
            _duplicate.minVersion = this.minVersion;
            _duplicate.maxVersion = this.maxVersion;
            return _duplicate;
        }

        public String toString() {
            return "SupportedFeatureKey(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SupportedFeatureKey setName(String v) {
            this.name = v;
            return this;
        }

        public SupportedFeatureKey setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public SupportedFeatureKey setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class ApiVersionCollection
    extends ImplicitLinkedHashMultiCollection<ApiVersion> {
        public ApiVersionCollection() {
        }

        public ApiVersionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ApiVersionCollection(Iterator<ApiVersion> iterator) {
            super(iterator);
        }

        @Override
        public ApiVersion find(short apiKey) {
            ApiVersion _key = new ApiVersion();
            _key.setApiKey(apiKey);
            return this.find(_key);
        }

        @Override
        public List<ApiVersion> findAll(short apiKey) {
            ApiVersion _key = new ApiVersion();
            _key.setApiKey(apiKey);
            return this.findAll(_key);
        }

        public ApiVersionCollection duplicate() {
            ApiVersionCollection _duplicate = new ApiVersionCollection(this.size());
            for (ApiVersion _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class ApiVersion
    implements Message,
    ImplicitLinkedHashCollection.Element {
        short apiKey;
        short minVersion;
        short maxVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public ApiVersion(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public ApiVersion() {
            this.apiKey = 0;
            this.minVersion = 0;
            this.maxVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ApiVersion");
            }
            this.apiKey = _readable.readShort();
            this.minVersion = _readable.readShort();
            this.maxVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.apiKey);
            _writable.writeShort(this.minVersion);
            _writable.writeShort(this.maxVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ApiVersion");
            }
            _size.addBytes(2);
            _size.addBytes(2);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 3) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof ApiVersion)) {
                return false;
            }
            ApiVersion other = (ApiVersion)obj;
            return this.apiKey == other.apiKey;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApiVersion)) {
                return false;
            }
            ApiVersion other = (ApiVersion)obj;
            if (this.apiKey != other.apiKey) {
                return false;
            }
            if (this.minVersion != other.minVersion) {
                return false;
            }
            if (this.maxVersion != other.maxVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.apiKey;
            return hashCode;
        }

        @Override
        public ApiVersion duplicate() {
            ApiVersion _duplicate = new ApiVersion();
            _duplicate.apiKey = this.apiKey;
            _duplicate.minVersion = this.minVersion;
            _duplicate.maxVersion = this.maxVersion;
            return _duplicate;
        }

        public String toString() {
            return "ApiVersion(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public short apiKey() {
            return this.apiKey;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ApiVersion setApiKey(short v) {
            this.apiKey = v;
            return this;
        }

        public ApiVersion setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public ApiVersion setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("api_key", Type.INT16, "The API index."), new Field("min_version", Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", Type.INT16, "The maximum supported version, inclusive.")));
            SCHEMA_3 = new Schema(new Field("api_key", Type.INT16, "The API index."), new Field("min_version", Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", Type.INT16, "The maximum supported version, inclusive."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

