/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;

public class AlterMirrorTopicsRequest
extends AbstractRequest {
    private final AlterMirrorTopicsRequestData data;

    public AlterMirrorTopicsRequest(AlterMirrorTopicsRequestData data, short version) {
        super(ApiKeys.ALTER_MIRROR_TOPICS, version);
        this.data = data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short errorCode = Errors.forException(e).code();
        String errorMessage = e.getMessage();
        AlterMirrorTopicsResponseData responseData = new AlterMirrorTopicsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(errorCode).setErrorMessage(errorMessage);
        return new AlterMirrorTopicsResponse(responseData);
    }

    @Override
    public AlterMirrorTopicsRequestData data() {
        return this.data;
    }

    public static AlterMirrorTopicsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterMirrorTopicsRequest(new AlterMirrorTopicsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterMirrorTopicsRequest> {
        private final AlterMirrorTopicsRequestData data;

        public Builder(AlterMirrorTopicsRequestData data) {
            super(ApiKeys.ALTER_MIRROR_TOPICS);
            this.data = data;
        }

        public Builder(List<AlterMirrorTopicsRequestData.AlterMirrorTopic> alterTopics, boolean validateOnly, int timeoutMs) {
            super(ApiKeys.ALTER_MIRROR_TOPICS);
            this.data = new AlterMirrorTopicsRequestData().setAlterMirrorTopics(alterTopics).setValidateOnly(validateOnly).setTimeoutMs(timeoutMs);
        }

        public Builder(AlterMirrorTopicsRequestData.AlterMirrorTopic alterTopic, boolean validateOnly, int timeoutMs) {
            this(Collections.singletonList(alterTopic), validateOnly, timeoutMs);
        }

        @Override
        public AlterMirrorTopicsRequest build(short version) {
            return new AlterMirrorTopicsRequest(this.data, version);
        }
    }
}

