/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.CatCommandHandler;
import org.apache.kafka.shell.command.CdCommandHandler;
import org.apache.kafka.shell.command.ErroneousCommandHandler;
import org.apache.kafka.shell.command.ExitCommandHandler;
import org.apache.kafka.shell.command.FindCommandHandler;
import org.apache.kafka.shell.command.HelpCommandHandler;
import org.apache.kafka.shell.command.HistoryCommandHandler;
import org.apache.kafka.shell.command.LsCommandHandler;
import org.apache.kafka.shell.command.ManCommandHandler;
import org.apache.kafka.shell.command.NoOpCommandHandler;
import org.apache.kafka.shell.command.PwdCommandHandler;
import org.apache.kafka.shell.command.SnapshotCommandHandler;
import org.apache.kafka.shell.command.TreeCommandHandler;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;

public final class Commands {
    public static final NavigableMap<String, Type> TYPES;
    private final ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"", (boolean)false);

    public Commands(boolean addShellCommands) {
        Subparsers subparsers = this.parser.addSubparsers().dest("command");
        for (Type type : TYPES.values()) {
            if (!addShellCommands && type.shellOnly()) continue;
            Subparser subParser = subparsers.addParser(type.name());
            subParser.help(type.description());
            type.addArguments((ArgumentParser)subParser);
        }
    }

    ArgumentParser parser() {
        return this.parser;
    }

    public Handler parseCommand(List<String> arguments) {
        Namespace namespace;
        ArrayList<String> trimmedArguments = new ArrayList<String>(arguments);
        while (true) {
            if (trimmedArguments.isEmpty()) {
                return new NoOpCommandHandler();
            }
            String last = (String)trimmedArguments.get(trimmedArguments.size() - 1);
            if (!last.isEmpty()) break;
            trimmedArguments.remove(trimmedArguments.size() - 1);
        }
        try {
            namespace = this.parser.parseArgs(trimmedArguments.toArray(new String[0]));
        }
        catch (HelpScreenException e) {
            return new NoOpCommandHandler();
        }
        catch (ArgumentParserException e) {
            return new ErroneousCommandHandler(e.getMessage());
        }
        String command = (String)namespace.get("command");
        if (!command.equals(trimmedArguments.get(0))) {
            return new ErroneousCommandHandler("invalid choice: '" + (String)trimmedArguments.get(0) + "': did you mean '" + command + "'?");
        }
        Type type = (Type)TYPES.get(command);
        if (type == null) {
            return new ErroneousCommandHandler("Unknown command specified: " + command);
        }
        return type.createHandler(namespace);
    }

    static {
        TreeMap<String, Type> typesMap = new TreeMap<String, Type>();
        for (Type type : Arrays.asList(CatCommandHandler.TYPE, CdCommandHandler.TYPE, ExitCommandHandler.TYPE, FindCommandHandler.TYPE, HelpCommandHandler.TYPE, HistoryCommandHandler.TYPE, LsCommandHandler.TYPE, ManCommandHandler.TYPE, PwdCommandHandler.TYPE, SnapshotCommandHandler.TYPE, TreeCommandHandler.TYPE)) {
            typesMap.put(type.name(), type);
        }
        TYPES = Collections.unmodifiableNavigableMap(typesMap);
    }

    public static interface Type {
        public String name();

        public String description();

        public boolean shellOnly();

        public void addArguments(ArgumentParser var1);

        public Handler createHandler(Namespace var1);

        public void completeNext(MetadataShellState var1, List<String> var2, List<Candidate> var3) throws Exception;
    }

    public static interface Handler {
        public void run(Optional<InteractiveShell> var1, PrintWriter var2, MetadataShellState var3) throws Exception;
    }
}

