/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.confluent;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.compat.java8.OptionConverters;

public class MetadataShellObserver
implements ClusterMetadataSource {
    private static final Logger log = LoggerFactory.getLogger(MetadataShellObserver.class);
    private final String quorumVoters;
    private final String clusterId;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Path tempDir;

    static MetadataShellObserver create(String quorumVoters, String clusterId, Properties configProps) throws Exception {
        Path tempDir = Files.createTempDirectory("MetadataShell", new FileAttribute[0]);
        Exit.addShutdownHook((String)"delete-metadata-shell-temp-dir", () -> MetadataShellObserver.cleanup(null, tempDir));
        KafkaRaftManager raftManager = null;
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> configMap.put(key.toString(), (String)value)));
            configMap.put("controller.quorum.voters", quorumVoters);
            configMap.put(KafkaConfig.ProcessRolesProp(), "broker");
            configMap.put(KafkaConfig.NodeIdProp(), String.valueOf(Integer.MAX_VALUE));
            configMap.put(KafkaConfig.MetadataLogDirProp(), tempDir.toAbsolutePath().toString());
            configMap.remove(KafkaConfig.LogDirProp());
            configMap.remove(KafkaConfig.LogDirsProp());
            configMap.putIfAbsent(KafkaConfig.ControllerListenerNamesProp(), "CONTROLLER");
            KafkaConfig config = new KafkaConfig(configMap);
            CompletableFuture<Map> votersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections((List)config.quorumVoters()));
            raftManager = new KafkaRaftManager(clusterId, config, (RecordSerde)MetadataRecordSerde.INSTANCE, KafkaRaftServer.MetadataPartition(), KafkaRaftServer.MetadataTopicId(), Time.SYSTEM, new Metrics(), OptionConverters.toScala(Optional.of("MetadataShellObserver")), votersFuture, (FaultHandler)new LoggingFaultHandler("MetadataShellObserver", () -> {}), Optional.empty());
            return new MetadataShellObserver(quorumVoters, clusterId, (KafkaRaftManager<ApiMessageAndVersion>)raftManager, tempDir);
        }
        catch (Throwable e) {
            MetadataShellObserver.cleanup(raftManager, tempDir);
            throw e;
        }
    }

    static void cleanup(KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir) {
        if (raftManager != null) {
            try {
                raftManager.shutdown();
            }
            catch (Exception e) {
                log.error("Got exception while shutting down raftManager", (Throwable)e);
            }
        }
        if (tempDir != null) {
            try {
                Utils.delete((File)tempDir.toFile());
            }
            catch (Exception e) {
                log.error("Got exception while removing temporary directory {}", (Throwable)e);
            }
        }
    }

    public MetadataShellObserver(String quorumVoters, String clusterId, KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir) {
        this.quorumVoters = quorumVoters;
        this.clusterId = clusterId;
        this.raftManager = raftManager;
        this.tempDir = tempDir;
    }

    public void start(RaftClient.Listener<ApiMessageAndVersion> listener) throws Exception {
        this.raftManager.register(listener);
        this.raftManager.startup();
    }

    public OptionalLong highWaterMark() {
        OptionalLong result = this.raftManager.client().highWatermark();
        return result;
    }

    public void close() throws Exception {
        MetadataShellObserver.cleanup(this.raftManager, this.tempDir);
    }

    public String toString() {
        return "MetadataShellObserver(quorumVoters=" + this.quorumVoters + ", clusterId=" + this.clusterId + ")";
    }
}

