/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.util.Map;
import java.util.TreeMap;

public enum SerializerEncoding {
    JSON,
    XML,
    TEXT;

    private static final ClientLogger LOGGER;
    private static final Map<String, SerializerEncoding> SUPPORTED_MIME_TYPES;

    public static SerializerEncoding fromHeaders(HttpHeaders headers) {
        String mimeContentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        if (CoreUtils.isNullOrEmpty(mimeContentType)) {
            LOGGER.verbose("'Content-Type' not found. Returning default encoding: JSON");
            return JSON;
        }
        int contentTypeEnd = mimeContentType.indexOf(59);
        String contentType = contentTypeEnd == -1 ? mimeContentType : mimeContentType.substring(0, contentTypeEnd);
        SerializerEncoding encoding = SUPPORTED_MIME_TYPES.get(contentType);
        if (encoding != null) {
            return encoding;
        }
        int contentTypeTypeSplit = contentType.indexOf(47);
        if (contentTypeTypeSplit == -1) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + contentType + "' does not match mime-type formatting 'type'/'subtype'. Returning default: JSON");
            return JSON;
        }
        String subtype = contentType.substring(contentTypeTypeSplit + 1);
        int lastIndex = subtype.lastIndexOf(43);
        if (lastIndex == -1) {
            return JSON;
        }
        String mimeTypeSuffix = subtype.substring(lastIndex + 1);
        if ("xml".equalsIgnoreCase(mimeTypeSuffix)) {
            return XML;
        }
        if ("json".equalsIgnoreCase(mimeTypeSuffix)) {
            return JSON;
        }
        LOGGER.log(LogLevel.VERBOSE, () -> "Content-Type '" + mimeTypeSuffix + "' does not match any supported one. Returning default: JSON");
        return JSON;
    }

    static {
        LOGGER = new ClientLogger(SerializerEncoding.class);
        SUPPORTED_MIME_TYPES = new TreeMap<String, SerializerEncoding>(String.CASE_INSENSITIVE_ORDER);
        SUPPORTED_MIME_TYPES.put("text/xml", XML);
        SUPPORTED_MIME_TYPES.put("application/xml", XML);
        SUPPORTED_MIME_TYPES.put("application/json", JSON);
        SUPPORTED_MIME_TYPES.put("text/css", TEXT);
        SUPPORTED_MIME_TYPES.put("text/csv", TEXT);
        SUPPORTED_MIME_TYPES.put("text/html", TEXT);
        SUPPORTED_MIME_TYPES.put("text/javascript", TEXT);
        SUPPORTED_MIME_TYPES.put("text/plain", TEXT);
    }
}

