/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.audit.telemetry.exporter.NonBlockingKafkaExporter;
import io.confluent.security.audit.telemetry.exporter.TopicSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogConfig
extends AbstractConfig {
    protected static final Logger log = LoggerFactory.getLogger(AuditLogConfig.class);
    public static final String AUDIT_CLOUD_EVENT_ENCODING_CONFIG = "confluent.security.event.logger.cloudevent.codec";
    public static final String DEFAULT_AUDIT_CLOUD_EVENT_ENCODING_CONFIG = "structured";
    public static final String AUDIT_CLOUD_EVENT_ENCODING_DOC = "Which cloudevent encoding to use. Use structured encoding by default";
    public static final String EVENT_EXPORTER_CLASS_CONFIG = "confluent.security.event.logger.exporter.class";
    public static final String DEFAULT_EVENT_EXPORTER_CLASS_CONFIG = NonBlockingKafkaExporter.class.getCanonicalName();
    public static final String BOOTSTRAP_SERVERS_CONFIG = "confluent.security.event.logger.exporter.kafka.bootstrap.servers";
    public static final String TOPIC_CREATE_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.create";
    public static final boolean DEFAULT_TOPIC_CREATE_CONFIG = true;
    public static final String TOPIC_PARTITIONS_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.partitions";
    public static final int DEFAULT_TOPIC_PARTITIONS_CONFIG = 12;
    public static final String TOPIC_RETENTION_MS_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.retention.ms";
    public static final long DEFAULT_TOPIC_RETENTION_MS_CONFIG = TimeUnit.DAYS.toMillis(30L);
    public static final String TOPIC_RETENTION_BYTES_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.retention.bytes";
    public static final long DEFAULT_TOPIC_RETENTION_BYTES_CONFIG = -1L;
    public static final String TOPIC_ROLL_MS_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.roll.ms";
    public static final long DEFAULT_TOPIC_ROLL_MS_CONFIG = TimeUnit.HOURS.toMillis(4L);
    private static final String DEFAULT_PRODUCER_ACKS_CONFIG = "all";
    private static final String DEFAULT_PRODUCER_COMPRESSION_TYPE_CONFIG = "lz4";
    private static final String DEFAULT_PRODUCER_INTERCEPTOR_CLASSES_CONFIG = "";
    private static final String DEFAULT_PRODUCER_KEY_SERIALIZER_CLASS_CONFIG = ByteArraySerializer.class.getName();
    private static final String DEFAULT_PRODUCER_LINGER_MS_CONFIG = "500";
    private static final int DEFAULT_PRODUCER_RETRIES_CONFIG = 10;
    private static final long DEFAULT_PRODUCER_RETRY_BACKOFF_MS_CONFIG = 500L;
    private static final String DEFAULT_PRODUCER_VALUE_SERIALIZER_CLASS_CONFIG = ByteArraySerializer.class.getName();
    private static final int DEFAULT_PRODUCER_MAX_BLOCK_MS_CONFIG = 0;
    public static final String ROUTER_CACHE_ENTRIES_CONFIG = "confluent.security.event.router.cache.entries";
    public static final int DEFAULT_ROUTER_CACHE_ENTRIES = 10000;
    public static final String ROUTER_CACHE_ENTRIES_DOC = "Number of Resource entries that the router cache should support";
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.security.event.logger.enable", ConfigDef.Type.BOOLEAN, (Object)"true", ConfigDef.Importance.HIGH, "Whether the event logger is enabled").define("confluent.security.event.logger.exporter.class", ConfigDef.Type.CLASS, (Object)DEFAULT_EVENT_EXPORTER_CLASS_CONFIG, ConfigDef.Importance.HIGH, "Class to use for delivering event logs.").define("confluent.security.event.logger.exporter.kafka.topic.create", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Create the event log topic if it does not exist.").define("confluent.security.event.logger.exporter.kafka.topic.partitions", ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, "Number of partitions in the event log topic.").define("confluent.security.event.logger.exporter.kafka.topic.replicas", ConfigDef.Type.INT, (Object)"3", ConfigDef.Importance.LOW, "Replication factor for audit log topics").define("confluent.security.event.logger.exporter.kafka.topic.retention.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Importance.LOW, "Retention time for the event log topic.").define("confluent.security.event.logger.exporter.kafka.topic.retention.bytes", ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, "Retention bytes for the event log topic.").define("confluent.security.event.logger.exporter.kafka.topic.roll.ms", ConfigDef.Type.LONG, (Object)DEFAULT_TOPIC_ROLL_MS_CONFIG, ConfigDef.Importance.LOW, "Log rolling time for the event log topic.").define("confluent.security.event.router.config", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "JSON configuration for routing events to topics").define("confluent.security.event.router.cache.entries", ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.LOW, "Number of Resource entries that the router cache should support").define("confluent.security.event.logger.cloudevent.codec", ConfigDef.Type.STRING, (Object)"structured", ConfigDef.Importance.LOW, "Which cloudevent encoding to use. Use structured encoding by default").define("confluent.security.event.logger.authentication.enable", ConfigDef.Type.BOOLEAN, (Object)"false", ConfigDef.Importance.HIGH, "Enable authentication audit logs").define("confluent.security.event.logger.authentication.event.rate.limit", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.HIGH, "Configuration to control and limit the rate at which authentication audit events are sent to the clearing house per second").define("confluent.security.event.logger.authorization.event.rate.limit", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.HIGH, "Configuration to control and limit the rate at which authorization audit events are sent to the clearing house per second").define("confluent.security.event.logger.kafka.request.rate.limit", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.HIGH, "Configuration to control and limit the rate at which kafka requests (kafka management, produce or consume) are processed to extract and send audit events to the clearing house per second.").define("confluent.security.event.logger.physical.cluster.id", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "Physical cluster id of the source cluster");

    public AuditLogConfig(Map<String, ?> configs) {
        super(CONFIG, configs);
    }

    public static Properties kafkaProducerOverrides() {
        Properties props = new Properties();
        props.put("acks", DEFAULT_PRODUCER_ACKS_CONFIG);
        props.put("compression.type", DEFAULT_PRODUCER_COMPRESSION_TYPE_CONFIG);
        props.put("key.serializer", DEFAULT_PRODUCER_KEY_SERIALIZER_CLASS_CONFIG);
        props.put("value.serializer", DEFAULT_PRODUCER_VALUE_SERIALIZER_CLASS_CONFIG);
        props.put("linger.ms", DEFAULT_PRODUCER_LINGER_MS_CONFIG);
        props.put("retries", (Object)10);
        props.put("interceptor.classes", DEFAULT_PRODUCER_INTERCEPTOR_CLASSES_CONFIG);
        props.put("retry.backoff.ms", (Object)500L);
        props.put("max.block.ms", (Object)0);
        return props;
    }

    public static Map<String, ?> kafkaInterBrokerClientConfig(Map<String, ?> originals) {
        HashMap props = new HashMap();
        if (originals.get("bootstrap.servers") != null) {
            props.put("bootstrap.servers", originals.get("bootstrap.servers"));
        }
        ConfigDef cfg = new ConfigDef();
        SaslConfigs.addClientSaslSupport((ConfigDef)cfg);
        SslConfigs.addClientSslSupport((ConfigDef)cfg);
        originals.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("confluent.security.")).filter(e -> cfg.names().contains(e.getKey()) || AdminClientConfig.configNames().contains(e.getKey())).filter(e -> e.getValue() != null).forEach(e -> props.put((String)e.getKey(), e.getValue()));
        props.remove("metric.reporters");
        ConfluentConfigs.enableSslDynamicStoreUpdate(originals, props);
        return props;
    }

    public AuditLogRouterJsonConfig routerJsonConfig() throws ConfigException {
        try {
            String routerConfig = this.getString("confluent.security.event.router.config");
            if (routerConfig == null || routerConfig.isEmpty()) {
                return AuditLogRouterJsonConfig.defaultConfig();
            }
            return AuditLogRouterJsonConfig.load(this.getString("confluent.security.event.router.config"));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConfigException("Invalid router config", (Object)e);
        }
    }

    public static Map<String, Object> toEventLoggerConfig(Map<String, ?> originals) throws ConfigException {
        AuditLogConfig alc = new AuditLogConfig(originals);
        AuditLogRouterJsonConfig aljc = alc.routerJsonConfig();
        HashMap<String, Object> eventLoggerConfig = new HashMap<String, Object>();
        if (!originals.containsKey("confluent.metadata.server.api.flavor") || originals.get("confluent.metadata.server.api.flavor").toString().equals("CP")) {
            AuditLogConfig.kafkaInterBrokerClientConfig(originals).forEach((k, v) -> eventLoggerConfig.put("event.logger.exporter.kafka." + k, v));
        }
        AuditLogConfig.kafkaProducerOverrides().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> eventLoggerConfig.put("event.logger.exporter.kafka." + k, v)));
        alc.values().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("confluent.security.event.logger.")).forEach(entry -> eventLoggerConfig.put(((String)entry.getKey()).substring("confluent.security.".length()), entry.getValue()));
        originals.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("confluent.security.event.logger.")).forEach(entry -> eventLoggerConfig.put(((String)entry.getKey()).substring("confluent.security.".length()), entry.getValue()));
        if (aljc.bootstrapServers() != null && !aljc.bootstrapServers().isEmpty()) {
            eventLoggerConfig.put("event.logger.exporter.kafka.bootstrap.servers", aljc.bootstrapServers());
        }
        if (!eventLoggerConfig.containsKey("event.logger.exporter.kafka.bootstrap.servers")) {
            throw new ConfigException("Missing required property confluent.security.event.logger.exporter.kafka.bootstrap.servers. Either specify bootstrap brokers in either 'confluent.security.event.router.config' or 'confluent.security.event.logger.exporter.kafka.bootstrap.servers' or 'bootstrap.servers'");
        }
        HashMap allTopics = new HashMap();
        try {
            ObjectMapper mapper = new ObjectMapper();
            TopicSpec.Topics topics = new TopicSpec.Topics();
            String topicConfig = (String)originals.get("confluent.security.event.logger.exporter.kafka.topic.config");
            if (topicConfig != null) {
                topics = (TopicSpec.Topics)mapper.readValue(topicConfig, TopicSpec.Topics.class);
                topics.topics.forEach(e -> allTopics.put(e.name(), e));
            }
            aljc.destinations.topics.entrySet().stream().forEach(e -> {
                TopicSpec spec = TopicSpec.builder().setName((String)e.getKey()).setTopicConfig("retention.ms", DEFAULT_PRODUCER_INTERCEPTOR_CLASSES_CONFIG + ((AuditLogRouterJsonConfig.DestinationTopic)e.getValue()).retentionMs).build();
                if (allTopics.containsKey(spec.name())) {
                    log.warn("Overriding spec {} from {} with {} from {}", new Object[]{allTopics.get(spec.name()), "confluent.security.event.logger.exporter.kafka.topic.config", spec, "confluent.security.event.router.config"});
                }
                allTopics.put(spec.name(), spec);
            });
            topics.setTopics(new ArrayList<TopicSpec>(allTopics.values()));
            eventLoggerConfig.put("event.logger.exporter.kafka.topic.config", mapper.writeValueAsString((Object)topics));
            eventLoggerConfig.put("event.logger.exporter.kafka.blocking", false);
        }
        catch (IOException | IllegalArgumentException e2) {
            throw new ConfigException("Invalid router config", (Object)e2);
        }
        return eventLoggerConfig;
    }
}

