/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.security.audit.kafka.AlterConfigsRequestAuditExtractor;
import io.confluent.security.audit.kafka.AlterMirrorsRequestAuditExtractor;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.audit.kafka.CreateAclsRequestAuditExtractor;
import io.confluent.security.audit.kafka.CreateClusterLinksAuditExtractor;
import io.confluent.security.audit.kafka.CreatePartitionsRequestAuditExtractor;
import io.confluent.security.audit.kafka.CreateTopicsRequestAuditExtractor;
import io.confluent.security.audit.kafka.DeleteAclsRequestAuditExtractor;
import io.confluent.security.audit.kafka.DeleteClusterLinksRequestAuditExtractor;
import io.confluent.security.audit.kafka.DeleteGroupsRequestAuditExtractor;
import io.confluent.security.audit.kafka.DeleteTopicsRequestAuditExtractor;
import io.confluent.security.audit.kafka.FetchRequestAuditExtractor;
import io.confluent.security.audit.kafka.IncrementalAlterRequestAuditExtractor;
import io.confluent.security.audit.kafka.ProduceRequestAuditExtractor;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.server.audit.KafkaRequestEvent;

public final class KafkaRequestToAuditEntry {
    public static List<AuditLog> extractAuditLog(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ApiKeys apiKey = ApiKeys.forId((int)requestEvent.requestContext().requestType());
        switch (apiKey) {
            case CREATE_TOPICS: {
                return CreateTopicsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case CREATE_PARTITIONS: {
                return CreatePartitionsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case CREATE_ACLS: {
                return CreateAclsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case DELETE_ACLS: {
                return DeleteAclsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case CREATE_CLUSTER_LINKS: {
                return CreateClusterLinksAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case DELETE_CLUSTER_LINKS: {
                return DeleteClusterLinksRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case DELETE_GROUPS: {
                return DeleteGroupsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case ALTER_CONFIGS: {
                return AlterConfigsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                return IncrementalAlterRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case ALTER_MIRRORS: {
                return AlterMirrorsRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case PRODUCE: {
                return ProduceRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
            case FETCH: {
                return FetchRequestAuditExtractor.extract(requestEvent, extractorOptions);
            }
        }
        return Collections.emptyList();
    }
}

