/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.confluent.crn.ConfluentCloudCrnAuthority;
import io.confluent.crn.ConfluentServerCrnAuthority;
import io.confluent.crn.CrnAuthorityConfig;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuditLogConfig;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.security.audit.AuditLogConfig;
import io.confluent.security.audit.AuditLogEntry;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.audit.kafka.KafkaRequestToAuditEntry;
import io.confluent.security.audit.provider.AuditLogRateLimiter;
import io.confluent.security.audit.router.AuditLogRouter;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventLogger;
import io.confluent.telemetry.events.EventUtils;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentAuditLogProvider
implements AuditLogProvider,
ClusterResourceListener {
    public static final String AUTHORIZATION_MESSAGE_TYPE = "io.confluent.kafka.server/authorization";
    public static final String AUTHENTICATION_MESSAGE_TYPE = "io.confluent.kafka.server/authentication";
    public static final String KAFKA_REQUEST_MESSAGE_TYPE = "io.confluent.kafka.server/request";
    protected static final Logger log = LoggerFactory.getLogger(ConfluentAuditLogProvider.class);
    private static final String FALLBACK_LOGGER = "io.confluent.security.audit.log.fallback";
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    protected final Logger fallbackLog = LoggerFactory.getLogger((String)"io.confluent.security.audit.log.fallback");
    private UnaryOperator<AuditEvent> sanitizer;
    private volatile Map<String, Object> originalInterBrokerListenerConfigs = new HashMap<String, Object>();
    private ConfiguredState configuredState;
    private ExecutorService initExecutor;
    private ExecutorService fallbackExecutor;
    private ConfluentServerCrnAuthority crnAuthority;
    private volatile boolean eventLoggerReady;
    private Scope scope;
    private Scope auditLogScope;
    private boolean omitClientAddressConfig;
    protected AuditLogRateLimiter auditLogRateLimiter;
    private Boolean isCloud;
    private String physicalClusterId;
    private AuditLogMetrics auditLogMetrics;

    public void onUpdate(ClusterResource clusterResource) {
        this.scope = Scope.kafkaClusterScope((String)clusterResource.clusterId());
        this.auditLogScope = this.physicalClusterId == null || this.physicalClusterId.isEmpty() ? this.scope : Scope.kafkaClusterScope((String)this.physicalClusterId);
    }

    public void configure(Map<String, ?> configs) {
        AuditLogConfig auditLogConfig = new AuditLogConfig(configs);
        if (!auditLogConfig.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            return;
        }
        this.configuredState = new ConfiguredState(new EventLogger(), new AuditLogRouter(auditLogConfig.routerJsonConfig(), auditLogConfig.getInt("confluent.security.event.router.cache.entries")), auditLogConfig);
        CrnAuthorityConfig crnAuthorityConfig = new CrnAuthorityConfig(configs);
        String apiFlavor = crnAuthorityConfig.getString("confluent.metadata.server.api.flavor");
        if (apiFlavor.equals("CP")) {
            this.crnAuthority = new ConfluentServerCrnAuthority();
            this.isCloud = false;
        } else {
            this.crnAuthority = new ConfluentCloudCrnAuthority();
            this.isCloud = true;
        }
        this.crnAuthority.configure(crnAuthorityConfig.values());
        MultiTenantAuditLogConfig multiTenantAuditLogConfig = new MultiTenantAuditLogConfig(configs);
        this.omitClientAddressConfig = false;
        if (multiTenantAuditLogConfig.getBoolean("confluent.security.event.logger.multitenant.enable").booleanValue()) {
            this.omitClientAddressConfig = multiTenantAuditLogConfig.getBoolean("confluent.security.event.logger.client.ip.enable") == false;
        }
        this.eventLoggerReady = false;
        this.auditLogRateLimiter = new AuditLogRateLimiter();
        this.auditLogRateLimiter.configure(configs);
        this.physicalClusterId = auditLogConfig.getString("confluent.security.event.logger.physical.cluster.id");
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add("confluent.security.event.router.config");
        configs.add("confluent.security.event.logger.enable");
        configs.addAll(this.auditLogRateLimiter.reconfigurableConfigs());
        return configs;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        AuditLogConfig config = new AuditLogConfig(configs);
        AuditLogRouterJsonConfig routerJsonConfig = config.routerJsonConfig();
        HashMap newConfigs = new HashMap(configs);
        if (routerJsonConfig.bootstrapServers() == null || routerJsonConfig.bootstrapServers().isEmpty()) {
            newConfigs.putAll(this.originalInterBrokerListenerConfigs);
        }
        AuditLogConfig.toEventLoggerConfig(newConfigs);
    }

    private void updateConfiguredState(Map<String, Object> loggerConfig, AuditLogRouter router, AuditLogConfig config) {
        EventLogger oldLogger = this.configuredState != null ? this.configuredState.logger : null;
        EventLogger newLogger = new EventLogger();
        newLogger.configure(loggerConfig);
        this.configuredState = new ConfiguredState(newLogger, router, config);
        if (oldLogger != null) {
            Utils.closeQuietly((AutoCloseable)oldLogger, (String)"eventLogger");
        }
    }

    public void reconfigure(Map<String, ?> configs) {
        AuditLogConfig alc = new AuditLogConfig(configs);
        AuditLogRouterJsonConfig routerJsonConfig = alc.routerJsonConfig();
        HashMap newConfigs = new HashMap(configs);
        if (alc.routerJsonConfig().bootstrapServers() == null || alc.routerJsonConfig().bootstrapServers().isEmpty()) {
            newConfigs.putAll(this.originalInterBrokerListenerConfigs);
        }
        AuditLogRouter router = new AuditLogRouter(routerJsonConfig, alc.getInt("confluent.security.event.router.cache.entries"));
        Map<String, Object> elc = AuditLogConfig.toEventLoggerConfig(newConfigs);
        this.updateConfiguredState(elc, router, alc);
        this.auditLogRateLimiter.reconfigure(configs);
    }

    public CompletionStage<Void> start(Map<String, ?> interBrokerListenerConfigs) {
        this.initExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"audit-init-%d", (boolean)true));
        this.fallbackExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"audit-fallback-init-%d", (boolean)true));
        this.originalInterBrokerListenerConfigs = new HashMap(interBrokerListenerConfigs);
        CompletableFuture future = new CompletableFuture();
        this.initExecutor.submit(() -> {
            try {
                HashMap config = new HashMap(interBrokerListenerConfigs);
                config.putAll(this.configuredState.config.values());
                this.updateConfiguredState(AuditLogConfig.toEventLoggerConfig(config), this.configuredState.router, this.configuredState.config);
                this.eventLoggerReady = true;
                future.complete(null);
                log.info("ConfluentAuditLogProvider startup is completed");
            }
            catch (Throwable e) {
                log.error("Audit log provider could not be started", e);
                future.completeExceptionally(e);
            }
        });
        return future.whenComplete((unused, e) -> this.initExecutor.shutdownNow());
    }

    public void logEvent(AuditEvent auditEvent) {
        this.logEvent(auditEvent, false);
    }

    public void logEvent(AuditEvent auditEvent, boolean isProxyModeLocal) {
        boolean shouldOmitIpFromLogs = this.shouldOmitIpFromLogs(isProxyModeLocal);
        if (auditEvent.type() == AuditEventType.AUTHORIZATION && this.configuredState.config.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            this.logAuthorization((ConfluentAuthorizationEvent)auditEvent, shouldOmitIpFromLogs);
        } else if (auditEvent.type() == AuditEventType.AUTHENTICATION && this.configuredState.config.getBoolean("confluent.security.event.logger.enable").booleanValue()) {
            this.logAuthentication((AuthenticationEvent)auditEvent, shouldOmitIpFromLogs);
        } else if (auditEvent.type() == AuditEventType.KAFKA_REQUEST) {
            this.logKafkaRequestEvent((KafkaRequestEvent)auditEvent, shouldOmitIpFromLogs);
        } else {
            log.error("Unknown event received {}", (Object)auditEvent);
        }
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return true;
    }

    public boolean providerConfigured(Map<String, ?> configs) {
        AuditLogConfig cfg = new AuditLogConfig(configs);
        return cfg.getBoolean("confluent.security.event.logger.enable");
    }

    public void setSanitizer(UnaryOperator<AuditEvent> sanitizer) {
        this.sanitizer = sanitizer;
    }

    public void setMetrics(Metrics metrics) {
        this.auditLogMetrics = new AuditLogMetrics(metrics);
    }

    private boolean shouldThrottleAuditEvent(AuditEvent auditEvent) {
        return this.isCloud != false && this.auditLogRateLimiter.rateLimitReached(auditEvent) != false;
    }

    private void logAuthorization(ConfluentAuthorizationEvent authorizationEvent, boolean shouldOmitIpFromLogs) {
        ConfiguredState state = this.configuredState;
        if (!this.shouldLog(authorizationEvent, state) || this.shouldThrottleAuditEvent((AuditEvent)authorizationEvent)) {
            return;
        }
        try {
            KafkaPrincipal origPrincipal = authorizationEvent.requestContext().principal();
            AuditLogEntry auditLogEntry = AuditLogUtils.authorizationEvent(authorizationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            Optional<String> route = state.router.topic(auditLogEntry);
            if (this.isSuppressed(route)) {
                return;
            }
            if (this.sanitizer != null) {
                if ((authorizationEvent = (ConfluentAuthorizationEvent)this.sanitizer.apply((AuditEvent)authorizationEvent)) == null) {
                    return;
                }
                auditLogEntry = AuditLogUtils.authorizationEvent(authorizationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            }
            Event event = this.event(auditLogEntry.getServiceName(), auditLogEntry.getResourceName(), (Message)auditLogEntry, state, (AuditEvent)authorizationEvent, AUTHORIZATION_MESSAGE_TYPE);
            this.logEventToRoute(state, route, event, !this.eventLoggerReady);
            this.auditLogMetrics.recordAuthorizationAuditLogMetrics();
        }
        catch (CrnSyntaxException e) {
            log.error("Couldn't create cloud event due to internally generated CRN syntax problem", (Throwable)e);
            this.auditLogMetrics.recordAuthorizationAuditLogFailureMetrics();
        }
        catch (Exception e) {
            log.error("Error occurred while handling authorization event", (Throwable)e);
            this.auditLogMetrics.recordAuthorizationAuditLogFailureMetrics();
        }
    }

    private boolean isSuppressed(Optional<String> route) {
        return route.isPresent() && route.get().equalsIgnoreCase("");
    }

    private void logEventToRoute(ConfiguredState state, Optional<String> route, Event event, boolean fallback) {
        if (fallback) {
            this.fallbackLog.info(EventUtils.toJson((Event)event));
            this.auditLogMetrics.recordFallbackAuditLogMetrics();
            return;
        }
        if (!route.isPresent()) {
            this.fallbackLog.error(EventUtils.toJson((Event)event));
            return;
        }
        event.setExtension("route", route.get());
        boolean routeReady = state.logger.ready(event);
        if (routeReady) {
            this.emitEvent(event, state.logger).whenCompleteAsync((response, throwable) -> {
                if (throwable != null && throwable instanceof KafkaException) {
                    this.fallbackLog.info(EventUtils.toJson((Event)event));
                    this.auditLogMetrics.recordFallbackAuditLogMetrics();
                }
                if (response != null) {
                    if (!response.booleanValue()) {
                        this.fallbackLog.info(EventUtils.toJson((Event)event));
                        this.auditLogMetrics.recordFallbackAuditLogMetrics();
                    } else {
                        this.auditLogMetrics.recordNormalAuditLogMetrics();
                    }
                }
            }, (Executor)this.fallbackExecutor);
        } else {
            this.fallbackLog.info(EventUtils.toJson((Event)event));
            this.auditLogMetrics.recordFallbackAuditLogMetrics();
        }
    }

    @VisibleForTesting
    CompletableFuture<Boolean> emitEvent(Event event, EventLogger logger) {
        return logger.logAndGetFuture(event);
    }

    private Event event(String serviceName, String subject, Message message, ConfiguredState state, AuditEvent auditEvent, String messageType) {
        String dataContentType = this.dataContentType(state);
        return new Event().setId(auditEvent.uuid().toString()).setTime(auditEvent.timestamp().atOffset(ZoneOffset.UTC)).setSource(serviceName).setSubject(subject).setType(messageType).setData(dataContentType, EventUtils.protoToBytes((Message)message, (String)dataContentType));
    }

    private String dataContentType(ConfiguredState state) {
        String dataContentType;
        String encodingConfig;
        switch (encodingConfig = state.config.getString("confluent.security.event.logger.cloudevent.codec")) {
            case "structured": {
                dataContentType = "application/json";
                break;
            }
            case "binary": {
                dataContentType = "application/protobuf";
                break;
            }
            default: {
                throw new RuntimeException("unknown encoding " + encodingConfig);
            }
        }
        return dataContentType;
    }

    private boolean shouldLog(ConfluentAuthorizationEvent authorizationEvent, ConfiguredState state) {
        if (!state.router.isEventRoutable(authorizationEvent)) {
            return false;
        }
        switch (authorizationEvent.authorizeResult()) {
            case ALLOWED: {
                return authorizationEvent.action().logIfAllowed();
            }
            case DENIED: {
                return authorizationEvent.action().logIfDenied();
            }
        }
        return true;
    }

    private void logAuthentication(AuthenticationEvent auditEvent, boolean shouldOmitIpFromLogs) {
        try {
            if (this.shouldThrottleAuditEvent((AuditEvent)auditEvent)) {
                return;
            }
            ConfluentAuthenticationEvent authenticationEvent = new ConfluentAuthenticationEvent(auditEvent, this.auditLogScope);
            KafkaPrincipal origPrincipal = authenticationEvent.principal().isPresent() ? (KafkaPrincipal)authenticationEvent.principal().get() : null;
            AuditLogEntry entry = AuditLogUtils.authenticationEvent(authenticationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            ConfiguredState state = this.configuredState;
            Optional<String> route = state.router.topic(entry);
            if (this.isSuppressed(route)) {
                return;
            }
            if (this.sanitizer != null) {
                if ((authenticationEvent = (ConfluentAuthenticationEvent)this.sanitizer.apply((AuditEvent)authenticationEvent)) == null) {
                    return;
                }
                entry = AuditLogUtils.authenticationEvent(authenticationEvent, origPrincipal, this.crnAuthority, shouldOmitIpFromLogs);
            }
            Event event = this.event(entry.getServiceName(), entry.getResourceName(), (Message)entry, state, (AuditEvent)auditEvent, AUTHENTICATION_MESSAGE_TYPE);
            this.logEventToRoute(state, route, event, !this.eventLoggerReady);
            this.auditLogMetrics.recordAuthenticationAuditLogMetrics();
        }
        catch (Exception e) {
            this.auditLogMetrics.recordAuthenticationAuditLogFailureMetrics();
            log.error("Error occurred while handling authentication event : {}", (Object)auditEvent, (Object)e);
        }
    }

    private void logKafkaRequestEvent(KafkaRequestEvent auditEvent, boolean shouldOmitIpFromLogs) {
        try {
            if (this.shouldThrottleAuditEvent((AuditEvent)auditEvent)) {
                return;
            }
            if (this.sanitizer != null) {
                AuditExtractorOptions auditExtractorOptions = new AuditExtractorOptions(this.crnAuthority, shouldOmitIpFromLogs);
                List<AuditLog> auditLogList = KafkaRequestToAuditEntry.extractAuditLog(auditEvent, auditExtractorOptions);
                ConfiguredState state = this.configuredState;
                int successEvents = 0;
                int failureEvents = 0;
                for (AuditLog auditLog : auditLogList) {
                    try {
                        Event event = this.event(auditLog.getServiceName(), auditLog.getResourceName(), (Message)auditLog, state, (AuditEvent)auditEvent, KAFKA_REQUEST_MESSAGE_TYPE);
                        this.logEventToRoute(state, AuditLogRouterJsonConfig.DEFAULT_V2_TOPIC_ROUTE, event, !this.eventLoggerReady);
                        ++successEvents;
                    }
                    catch (Exception e) {
                        ++failureEvents;
                        log.error("Error occurred while handling Kafka management event : {}", (Object)auditLog, (Object)e);
                    }
                }
                if (successEvents != 0) {
                    this.auditLogMetrics.recordKafkaRequestEventAuditLogMetrics(ApiKeys.forId((int)auditEvent.requestContext().requestType()), successEvents);
                }
                if (failureEvents != 0) {
                    this.auditLogMetrics.recordKafkaRequestAuditLogFailureMetrics(failureEvents);
                }
            }
        }
        catch (Exception e) {
            this.auditLogMetrics.recordKafkaRequestAuditLogFailureMetrics(1.0);
            log.error("Error occurred while handling Kafka management events : {}", (Object)auditEvent, (Object)e);
        }
    }

    private boolean shouldOmitIpFromLogs(boolean isLocalProxyMode) {
        return this.omitClientAddressConfig || isLocalProxyMode;
    }

    public void close(String brokerSessionUuid) throws Exception {
        this.close();
    }

    public void close() {
        if (this.initExecutor != null) {
            this.initExecutor.shutdownNow();
            try {
                this.initExecutor.awaitTermination(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.debug("ConfluentAuditLogProvider was interrupted while waiting to close initExecutor");
                throw new InterruptException(e);
            }
        }
        if (this.fallbackExecutor != null) {
            this.fallbackExecutor.shutdownNow();
            try {
                this.fallbackExecutor.awaitTermination(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.debug("ConfluentAuditLogProvider was interrupted while waiting to close fallbackExecutor");
                throw new InterruptException(e);
            }
        }
        Utils.closeQuietly((AutoCloseable)this.configuredState.logger, (String)"eventLogger");
    }

    public ExecutorService initExecutor() {
        return this.initExecutor;
    }

    public EventLogger getEventLogger() {
        return this.configuredState.logger;
    }

    public boolean isEventLoggerReady() {
        return this.eventLoggerReady;
    }

    public Metrics metrics() {
        return this.auditLogMetrics.metrics();
    }

    protected void setupMetrics(Time time) {
        this.auditLogMetrics = new AuditLogMetrics(time);
    }

    protected Time metricsTime() {
        return this.auditLogMetrics.metricsTime();
    }

    public class AuditLogMetrics {
        public static final String GROUP_NAME = "confluent-audit-metrics";
        public static final String AUDIT_LOG_RATE_MINUTE = "audit-log-rate-per-minute";
        public static final String AUDIT_LOG_FALLBACK_RATE_MINUTE = "audit-log-fallback-rate-per-minute";
        public static final String AUTHENTICATION_AUDIT_LOG_RATE = "authentication-audit-log-rate";
        public static final String AUTHENTICATION_AUDIT_LOG_FAILURE_RATE = "authentication-audit-log-failure-rate";
        public static final String AUTHORIZATION_AUDIT_LOG_RATE = "authorization-audit-log-rate";
        public static final String AUTHORIZATION_AUDIT_LOG_FAILURE_RATE = "authorization-audit-log-failure-rate";
        public static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_RATE = "kafka-request-event-audit-log-rate";
        public static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_RATE = "kafka-request-event-audit-log-failure-rate";
        private static final String AUDIT_LOG_NORMAL_SENSOR = "audit-log-normal";
        private static final String AUDIT_LOG_FALLBACK_SENSOR = "audit-log-fallback";
        private static final String AUTHENTICATION_AUDIT_LOG_SENSOR = "authentication-audit-log";
        private static final String AUTHENTICATION_AUDIT_LOG_FAILURE_SENSOR = "authentication-audit-log-failure";
        private static final String AUTHORIZATION_AUDIT_LOG_SENSOR = "authorization-audit-log";
        private static final String AUTHORIZATION_AUDIT_LOG_FAILURE_SENSOR = "authorization-audit-log-failure";
        private static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_SENSOR = "kafka-request-event-audit-log";
        private static final String KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_SENSOR = "kafka-request-event-audit-log-failure";
        private Sensor normalAuditSensor = null;
        private Sensor fallbackAuditSensor = null;
        private Sensor authenticationAuditLogSensor = null;
        private Sensor authenticationAuditLogFailureSensor = null;
        private Sensor authorizationAuditLogSensor = null;
        private Sensor authorizationAuditLogFailureSensor = null;
        private Map<ApiKeys, Sensor> kafkaRequestEventAuditLogSensor = new EnumMap<ApiKeys, Sensor>(ApiKeys.class);
        private Sensor kafkaRequestEventAuditLogFailureSensor = null;
        private Time time;
        private Metrics metrics;

        AuditLogMetrics(Metrics metrics) {
            this.metrics = metrics;
            this.setupMetrics();
        }

        AuditLogMetrics(Time time) {
            this.time = time;
            this.metrics = new Metrics(time);
            this.setupMetrics();
        }

        void recordNormalAuditLogMetrics() {
            this.normalAuditSensor.record();
        }

        void recordFallbackAuditLogMetrics() {
            this.fallbackAuditSensor.record();
        }

        void recordAuthenticationAuditLogMetrics() {
            this.authenticationAuditLogSensor.record();
        }

        void recordAuthenticationAuditLogFailureMetrics() {
            this.authenticationAuditLogFailureSensor.record();
        }

        void recordAuthorizationAuditLogMetrics() {
            this.authorizationAuditLogSensor.record();
        }

        void recordAuthorizationAuditLogFailureMetrics() {
            this.authorizationAuditLogFailureSensor.record();
        }

        void recordKafkaRequestEventAuditLogMetrics(ApiKeys apiKeys, double value) {
            this.kafkaRequestEventAuditLogSensor.get(apiKeys).record(value);
        }

        void recordKafkaRequestAuditLogFailureMetrics(double value) {
            this.kafkaRequestEventAuditLogFailureSensor.record(value);
        }

        Metrics metrics() {
            return this.metrics;
        }

        Time metricsTime() {
            return this.time;
        }

        void setupMetrics() {
            this.normalAuditSensor = this.metrics.sensor(AUDIT_LOG_NORMAL_SENSOR);
            this.normalAuditSensor.add(this.metrics.metricName(AUDIT_LOG_RATE_MINUTE, GROUP_NAME, "The number of audit log per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES, (SampledStat)new WindowedCount()));
            this.fallbackAuditSensor = this.metrics.sensor(AUDIT_LOG_FALLBACK_SENSOR);
            this.fallbackAuditSensor.add(this.metrics.metricName(AUDIT_LOG_FALLBACK_RATE_MINUTE, GROUP_NAME, "The number of audit log fallback per minute"), (MeasurableStat)new Rate(TimeUnit.MINUTES, (SampledStat)new WindowedCount()));
            this.authenticationAuditLogSensor = this.metrics.sensor(AUTHENTICATION_AUDIT_LOG_SENSOR);
            this.authenticationAuditLogSensor.add(this.metrics.metricName(AUTHENTICATION_AUDIT_LOG_RATE, GROUP_NAME, "The number of authentication audit log per second"), (MeasurableStat)new Rate());
            this.authenticationAuditLogFailureSensor = this.metrics.sensor(AUTHENTICATION_AUDIT_LOG_FAILURE_SENSOR);
            this.authenticationAuditLogFailureSensor.add(this.metrics.metricName(AUTHENTICATION_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of authentication audit log failure per second"), (MeasurableStat)new Rate());
            this.authorizationAuditLogSensor = this.metrics.sensor(AUTHORIZATION_AUDIT_LOG_SENSOR);
            this.authorizationAuditLogSensor.add(this.metrics.metricName(AUTHORIZATION_AUDIT_LOG_RATE, GROUP_NAME, "The number of authorization audit log per second"), (MeasurableStat)new Rate());
            this.authorizationAuditLogFailureSensor = this.metrics.sensor(AUTHORIZATION_AUDIT_LOG_FAILURE_SENSOR);
            this.authorizationAuditLogFailureSensor.add(this.metrics.metricName(AUTHORIZATION_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of authorization audit log failure per second"), (MeasurableStat)new Rate());
            this.kafkaRequestEventAuditLogFailureSensor = this.metrics.sensor(KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_SENSOR);
            this.kafkaRequestEventAuditLogFailureSensor.add(this.metrics.metricName(KAFKA_REQUEST_EVENT_AUDIT_LOG_FAILURE_RATE, GROUP_NAME, "The number of kafka request event audit log failure per second"), (MeasurableStat)new Rate());
            this.addKafkaRequestEventMetrics();
        }

        void addKafkaRequestEventMetrics() {
            EnumSet<ApiKeys> supportedApis = EnumSet.copyOf(DetailedRequestAuditLogFilter.SUPPORTED_APIS_MGMT_OPERATIONS);
            supportedApis.addAll(DetailedRequestAuditLogFilter.SUPPORTED_APIS_PRODUCE_CONSUME);
            for (ApiKeys apiKey : supportedApis) {
                this.kafkaRequestEventAuditLogSensor.put(apiKey, this.metrics.sensor("kafka-request-event-audit-log-" + apiKey.name()));
                this.kafkaRequestEventAuditLogSensor.get(apiKey).add(this.metrics.metricName(KAFKA_REQUEST_EVENT_AUDIT_LOG_RATE, GROUP_NAME, "The number of kafka request event audit log per second", new String[]{"api-key", apiKey.name()}), (MeasurableStat)new Rate());
            }
        }
    }

    private class ConfiguredState {
        final EventLogger logger;
        final AuditLogRouter router;
        final AuditLogConfig config;

        private ConfiguredState(EventLogger logger, AuditLogRouter router, AuditLogConfig config) {
            this.logger = logger;
            this.router = router;
            this.config = config;
        }
    }
}

