/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.router;

import io.confluent.crn.CachedCrnStringPatternMatcher;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.security.audit.AuditLogEntry;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.router.AuditLogCategoryResultRouter;
import io.confluent.security.audit.router.AuditLogRouterJsonConfig;
import io.confluent.security.audit.router.AuditLogRouterResult;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import io.confluent.security.audit.router.Router;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogRouter
implements Router {
    private final Logger log = LoggerFactory.getLogger(AuditLogRouter.class);
    public static final String SUPPRESSED = "";
    private AuditLogCategoryResultRouter defaultTopicRouter;
    private final Set<KafkaPrincipal> excludedPrincipals;
    private final CachedCrnStringPatternMatcher<AuditLogCategoryResultRouter> crnRouters;
    private final Set<String> routableMethodCategories;

    private void setDefaultTopicRouter(AuditLogRouterJsonConfig config) {
        this.defaultTopicRouter = new AuditLogCategoryResultRouter();
        for (String category : AuditLogRouterUtils.CATEGORIES) {
            if (AuditLogRouterUtils.DEFAULT_ENABLED_CATEGORIES.contains(category)) {
                this.defaultTopicRouter.setRoute(category, AuditLogRouterResult.ALLOWED, config.defaultTopics.allowed).setRoute(category, AuditLogRouterResult.DENIED, config.defaultTopics.denied);
                this.routableMethodCategories.add(category);
                continue;
            }
            this.defaultTopicRouter.setRoute(category, AuditLogRouterResult.ALLOWED, SUPPRESSED).setRoute(category, AuditLogRouterResult.DENIED, SUPPRESSED);
        }
    }

    public AuditLogRouter(AuditLogRouterJsonConfig config, int cacheEntries) {
        try {
            this.routableMethodCategories = new HashSet<String>();
            this.setDefaultTopicRouter(config);
            this.excludedPrincipals = config.excludedPrincipals.stream().map(SecurityUtils::parseKafkaPrincipal).collect(Collectors.toSet());
            CachedCrnStringPatternMatcher.Builder builder = CachedCrnStringPatternMatcher.builder().capacity(cacheEntries);
            for (String crnString : config.routes.keySet()) {
                AuditLogCategoryResultRouter router = new AuditLogCategoryResultRouter();
                for (Map.Entry<String, Map<String, String>> categoryResultTopic : config.routes.get(crnString).entrySet()) {
                    for (Map.Entry<String, String> resultTopic : categoryResultTopic.getValue().entrySet()) {
                        String category = categoryResultTopic.getKey();
                        AuditLogRouterResult routerResult = AuditLogRouterJsonConfig.result(resultTopic.getKey());
                        String topic = resultTopic.getValue();
                        router.setRoute(category, routerResult, topic);
                        if (topic == null || topic.isEmpty()) continue;
                        this.routableMethodCategories.add(category);
                    }
                }
                builder.setPattern(crnString, (Object)router);
            }
            this.crnRouters = builder.build();
        }
        catch (CrnSyntaxException e) {
            throw new ConfigException("Invalid CRN in config", (Object)e);
        }
    }

    @Override
    public Optional<String> topic(AuditLogEntry auditLogEntry) {
        Optional<String> routedTopic;
        if (auditLogEntry.getAuthenticationInfo().getPrincipal().isEmpty()) {
            this.log.warn("Tried to route invalid event. No principal found. {}", (Object)auditLogEntry);
            return Optional.empty();
        }
        KafkaPrincipal eventPrincipal = SecurityUtils.parseKafkaPrincipal((String)auditLogEntry.getAuthenticationInfo().getPrincipal());
        if (this.excludedPrincipals.contains(eventPrincipal)) {
            return Optional.of(SUPPRESSED);
        }
        if (auditLogEntry.getResourceName().isEmpty()) {
            this.log.warn("Tried to route invalid event. No resource name found. {}", (Object)auditLogEntry);
            return Optional.empty();
        }
        AuditLogCategoryResultRouter router = (AuditLogCategoryResultRouter)this.crnRouters.match(auditLogEntry.getResourceName());
        if (router != null && (routedTopic = router.topic(auditLogEntry)).isPresent()) {
            return routedTopic;
        }
        return this.defaultTopicRouter.topic(auditLogEntry);
    }

    public boolean isEventRoutable(ConfluentAuthorizationEvent authorizationEvent) {
        String methodName = AuditLogUtils.methodName(authorizationEvent);
        String requestCategory = AuditLogRouterUtils.category(methodName);
        return this.routableMethodCategories.contains(requestCategory);
    }

    public Optional<String> defaultRoute(String category, AuditLogRouterResult result) {
        return this.defaultTopicRouter.route(category, result);
    }

    public String toString() {
        return "AuditLogRouter(default=" + this.defaultTopicRouter + ",routes=" + this.crnRouters + ")";
    }
}

