/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.router;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.security.audit.router.AuditLogRouterResult;
import io.confluent.security.audit.router.AuditLogRouterUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Utils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(converter=Canonicalizer.class)
@JsonDeserialize(converter=Canonicalizer.class)
public class AuditLogRouterJsonConfig {
    public static final Map<String, AuditLogRouterResult> ALLOWED_RESULTS = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"allowed", (Object)((Object)AuditLogRouterResult.ALLOWED)), Utils.mkEntry((Object)"denied", (Object)((Object)AuditLogRouterResult.DENIED))});
    public static final String TOPIC_PREFIX = "confluent-audit-log-events";
    public static final String DEFAULT_TOPIC = "confluent-audit-log-events";
    public static final String DEFAULT_V2_TOPIC = "confluent-audit-log-events-v2";
    public static final Optional<String> DEFAULT_V2_TOPIC_ROUTE = Optional.of("confluent-audit-log-events-v2");
    public static final long DEFAULT_RETENTION_MS = 7776000000L;
    @JsonProperty(value="default_topics")
    public DefaultTopics defaultTopics;
    @JsonProperty(value="excluded_principals")
    public List<String> excludedPrincipals = new ArrayList<String>();
    public Map<String, Map<String, Map<String, String>>> routes = new HashMap<String, Map<String, Map<String, String>>>();
    public Metadata metadata;
    public Destinations destinations;

    public static void validateDefaultTopics(AuditLogRouterJsonConfig config, Set<String> allowedTopics) {
        if (config.defaultTopics == null) {
            throw new IllegalArgumentException("Default topics must be provided");
        }
        if (!allowedTopics.contains(config.defaultTopics.allowed) || !allowedTopics.contains(config.defaultTopics.denied)) {
            throw new IllegalArgumentException(String.format("Default topics %s and %s must appear in destinations", config.defaultTopics.allowed, config.defaultTopics.denied));
        }
    }

    public static void validateRoutes(AuditLogRouterJsonConfig config, Set<String> allowedTopics) {
        try {
            for (Map.Entry<String, Map<String, Map<String, String>>> routeEntry : config.routes.entrySet()) {
                ConfluentResourceName.fromString((String)routeEntry.getKey());
                for (Map.Entry<String, Map<String, String>> categoryResultTopic : routeEntry.getValue().entrySet()) {
                    String category = categoryResultTopic.getKey();
                    if (!AuditLogRouterUtils.CATEGORIES.contains(category)) {
                        throw new IllegalArgumentException(String.format("Unknown category: %s", category));
                    }
                    for (Map.Entry<String, String> resultTopic : categoryResultTopic.getValue().entrySet()) {
                        String result = resultTopic.getKey();
                        if (!ALLOWED_RESULTS.containsKey(result)) {
                            throw new IllegalArgumentException(String.format("Result %s not one of the allowed results: %s", result, String.join((CharSequence)",", ALLOWED_RESULTS.keySet())));
                        }
                        String topic = resultTopic.getValue();
                        if (topic == null || topic.isEmpty() || allowedTopics.contains(topic)) continue;
                        throw new IllegalArgumentException(String.format("Topic name \"%s\" must be in destinations.topics", topic));
                    }
                }
            }
        }
        catch (CrnSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void validate(AuditLogRouterJsonConfig config) {
        if (config.destinations == null) {
            throw new IllegalArgumentException("Destinations must be provided");
        }
        Set<String> destinationTopicNames = config.destinations.topics.keySet();
        String misnamedDestinationTopicNames = destinationTopicNames.stream().filter(topicName -> !topicName.startsWith("confluent-audit-log-events")).sorted().collect(Collectors.joining(", "));
        if (!misnamedDestinationTopicNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("Topics must start with %s: %s", "confluent-audit-log-events", misnamedDestinationTopicNames));
        }
        HashSet<String> allowedTopics = new HashSet<String>(destinationTopicNames);
        allowedTopics.add("");
        AuditLogRouterJsonConfig.validateDefaultTopics(config, allowedTopics);
        AuditLogRouterJsonConfig.validateRoutes(config, allowedTopics);
    }

    public static AuditLogRouterResult result(String resultName) {
        return ALLOWED_RESULTS.get(resultName);
    }

    public static AuditLogRouterJsonConfig load(String json) throws IOException {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
        AuditLogRouterJsonConfig config = (AuditLogRouterJsonConfig)mapper.readValue(json, AuditLogRouterJsonConfig.class);
        AuditLogRouterJsonConfig.validate(config);
        return config;
    }

    public String bootstrapServers() {
        if (this.destinations.bootstrapServers == null) {
            return null;
        }
        return String.join((CharSequence)",", this.destinations.bootstrapServers);
    }

    public static AuditLogRouterJsonConfig defaultConfig() {
        AuditLogRouterJsonConfig config = new AuditLogRouterJsonConfig();
        config.destinations = new Destinations(null);
        config.destinations.putTopic("confluent-audit-log-events", new DestinationTopic(7776000000L));
        config.defaultTopics = new DefaultTopics("confluent-audit-log-events", "confluent-audit-log-events");
        return config;
    }

    public String toJsonString() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static class Canonicalizer
    extends StdConverter<AuditLogRouterJsonConfig, AuditLogRouterJsonConfig> {
        public AuditLogRouterJsonConfig convert(AuditLogRouterJsonConfig value) {
            for (Map.Entry<String, Map<String, Map<String, String>>> route : value.routes.entrySet()) {
                Map<String, String> managementCategoryRules;
                Map<String, Map<String, String>> routeRules = route.getValue();
                Map<String, String> otherCategoryRules = routeRules.remove("other");
                if (otherCategoryRules == null || otherCategoryRules.isEmpty() || (managementCategoryRules = routeRules.get("management")) != null && !managementCategoryRules.isEmpty()) continue;
                routeRules.put("management", otherCategoryRules);
            }
            return value;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Metadata {
        @JsonProperty(value="resource_version")
        public String resourceVersion;
        @JsonProperty(value="updated_at")
        public String updatedAt;

        public Metadata(@JsonProperty(value="resource_version") String resourceVersion, @JsonProperty(value="updated_at") String updatedAt) {
            this.resourceVersion = resourceVersion;
            this.updatedAt = updatedAt;
        }
    }

    public static class DefaultTopics {
        public String allowed;
        public String denied;

        public DefaultTopics(@JsonProperty(value="allowed") String allowed, @JsonProperty(value="denied") String denied) {
            this.allowed = allowed;
            this.denied = denied;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Destinations {
        @JsonProperty(value="bootstrap_servers", required=false)
        public List<String> bootstrapServers;
        public Map<String, DestinationTopic> topics = new HashMap<String, DestinationTopic>();

        public Destinations(@JsonProperty(value="bootstrap_servers") List<String> bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public DestinationTopic putTopic(String key, DestinationTopic value) {
            if (key.isEmpty()) {
                return null;
            }
            return this.topics.put(key, value);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DestinationTopic {
        @JsonProperty(value="retention_ms")
        public long retentionMs;

        public DestinationTopic(@JsonProperty(value="retention_ms") long retentionMs) {
            this.retentionMs = retentionMs;
        }
    }
}

