/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logevents.connect;

import com.google.common.base.Throwables;
import java.util.Objects;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventState {
    private static final Logger log = LoggerFactory.getLogger(LogEventState.class);
    private final String id;
    private final long logFailureEventResetTime;
    private final Time time;
    private long lastErrorTimestamp;
    private Throwable lastError;
    private String lastRootCause;

    public LogEventState(String id, long logFailureEventResetTime, Time time) {
        this.id = id;
        this.logFailureEventResetTime = logFailureEventResetTime;
        this.time = time;
        this.lastErrorTimestamp = -1L;
        this.lastError = null;
        this.lastRootCause = null;
    }

    public synchronized boolean logFailureEvent(Throwable error) {
        if (this.shouldReset() || !this.isSameError(error)) {
            this.lastError = error;
            this.lastRootCause = Throwables.getRootCause((Throwable)error).getMessage();
            this.lastErrorTimestamp = this.time.milliseconds();
            log.debug("Capturing failure log event {} for id: {}, logEventState: {}", new Object[]{error, this.id, this});
            return true;
        }
        log.debug("Skipping failure log event {} for id: {}, with lastErrorTimestamp: {}", new Object[]{error, this.id, this.lastErrorTimestamp});
        return false;
    }

    public synchronized boolean shouldReset() {
        return this.time.milliseconds() > this.lastErrorTimestamp + this.logFailureEventResetTime;
    }

    private boolean isSameError(Throwable currentError) {
        if (this.lastError == null) {
            return false;
        }
        if (!this.lastError.getClass().equals(currentError.getClass())) {
            return false;
        }
        if (!Objects.equals(this.lastError.getMessage(), currentError.getMessage())) {
            return false;
        }
        String currentRootCause = Throwables.getRootCause((Throwable)currentError).getMessage();
        return Objects.equals(this.lastRootCause, currentRootCause);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogEventState)) {
            return false;
        }
        LogEventState that = (LogEventState)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.logFailureEventResetTime, that.logFailureEventResetTime) && Objects.equals(this.lastErrorTimestamp, that.lastErrorTimestamp) && Objects.equals(this.lastError, that.lastError) && Objects.equals(this.lastRootCause, that.lastRootCause);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.logFailureEventResetTime, this.lastErrorTimestamp, this.lastError, this.lastRootCause);
    }

    public String toString() {
        return "LogEventState{id=" + this.id + ", logFailureEventResetTime=" + this.logFailureEventResetTime + ", lastErrorTimestamp=" + this.lastErrorTimestamp + ", lastError=" + this.lastError + ", lastRootCause=" + this.lastRootCause + '}';
    }
}

