/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import java.util.Objects;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeDescription;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.FieldTester;
import org.projectnessie.cel.common.types.traits.Indexer;

public abstract class ObjectT
extends BaseVal
implements FieldTester,
Indexer,
TypeAdapter {
    protected final TypeAdapter adapter;
    protected final Object value;
    protected final TypeDescription typeDesc;
    protected final Type typeValue;

    protected ObjectT(TypeAdapter adapter, Object value, TypeDescription typeDesc, Type typeValue) {
        this.adapter = adapter;
        this.value = value;
        this.typeDesc = typeDesc;
        this.typeValue = typeValue;
    }

    @Override
    public Val convertToType(Type typeVal) {
        switch (typeVal.typeEnum()) {
            case Type: {
                return this.typeValue;
            }
            case Object: {
                if (!this.type().typeName().equals(typeVal.typeName())) break;
                return this;
            }
        }
        return Err.newTypeConversionError(this.typeDesc.name(), typeVal);
    }

    @Override
    public Val equal(Val other) {
        if (!this.typeDesc.name().equals(other.type().typeName())) {
            return Err.noSuchOverload(this, "equal", other);
        }
        return Types.boolOf(this.value.equals(other.value()));
    }

    @Override
    public Type type() {
        return this.typeValue;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public Val nativeToValue(Object value) {
        return this.adapter.nativeToValue(value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectT objectT = (ObjectT)o;
        return Objects.equals(this.value, objectT.value) && Objects.equals(this.typeDesc, objectT.typeDesc) && Objects.equals(this.typeValue, objectT.typeValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.typeDesc, this.typeValue);
    }
}

