/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.mac;

import com.google.crypto.tink.Mac;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.mac.MacKey;
import com.google.crypto.tink.mac.internal.LegacyFullMac;
import com.google.crypto.tink.monitoring.MonitoringClient;
import com.google.crypto.tink.monitoring.MonitoringKeysetInfo;
import com.google.crypto.tink.util.Bytes;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;

class MacWrapper
implements PrimitiveWrapper<Mac, Mac> {
    private static final MacWrapper WRAPPER = new MacWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, Mac> LEGACY_FULL_MAC_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullMac::create, LegacyProtoKey.class, Mac.class);

    private void validateMacKeyPrefixes(PrimitiveSet<Mac> primitives) throws GeneralSecurityException {
        for (List<PrimitiveSet.Entry<Mac>> entryList : primitives.getAll()) {
            for (PrimitiveSet.Entry<Mac> entry : entryList) {
                if (!(entry.getKey() instanceof MacKey)) continue;
                MacKey macKey = (MacKey)entry.getKey();
                Bytes expectedOutputPrefix = Bytes.copyFrom(entry.getIdentifier());
                if (expectedOutputPrefix.equals(macKey.getOutputPrefix())) continue;
                throw new GeneralSecurityException("Mac Key with parameters " + macKey.getParameters() + " has wrong output prefix (" + macKey.getOutputPrefix() + ") instead of (" + expectedOutputPrefix + ")");
            }
        }
    }

    MacWrapper() {
    }

    @Override
    public Mac wrap(PrimitiveSet<Mac> primitives) throws GeneralSecurityException {
        this.validateMacKeyPrefixes(primitives);
        return new WrappedMac(primitives);
    }

    @Override
    public Class<Mac> getPrimitiveClass() {
        return Mac.class;
    }

    @Override
    public Class<Mac> getInputPrimitiveClass() {
        return Mac.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_FULL_MAC_PRIMITIVE_CONSTRUCTOR);
    }

    private static class WrappedMac
    implements Mac {
        private final PrimitiveSet<Mac> primitives;
        private final MonitoringClient.Logger computeLogger;
        private final MonitoringClient.Logger verifyLogger;

        private WrappedMac(PrimitiveSet<Mac> primitives) {
            this.primitives = primitives;
            if (primitives.hasAnnotations()) {
                MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
                MonitoringKeysetInfo keysetInfo = MonitoringUtil.getMonitoringKeysetInfo(primitives);
                this.computeLogger = client.createLogger(keysetInfo, "mac", "compute");
                this.verifyLogger = client.createLogger(keysetInfo, "mac", "verify");
            } else {
                this.computeLogger = MonitoringUtil.DO_NOTHING_LOGGER;
                this.verifyLogger = MonitoringUtil.DO_NOTHING_LOGGER;
            }
        }

        @Override
        public byte[] computeMac(byte[] data) throws GeneralSecurityException {
            try {
                byte[] output = this.primitives.getPrimary().getFullPrimitive().computeMac(data);
                this.computeLogger.log(this.primitives.getPrimary().getKeyId(), data.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.computeLogger.logFailure();
                throw e;
            }
        }

        @Override
        public void verifyMac(byte[] mac, byte[] data) throws GeneralSecurityException {
            if (mac.length <= 5) {
                this.verifyLogger.logFailure();
                throw new GeneralSecurityException("tag too short");
            }
            byte[] prefix = Arrays.copyOf(mac, 5);
            List<PrimitiveSet.Entry<Mac>> entries = this.primitives.getPrimitive(prefix);
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    entry.getFullPrimitive().verifyMac(mac, data);
                    this.verifyLogger.log(entry.getKeyId(), data.length);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            entries = this.primitives.getRawPrimitives();
            for (PrimitiveSet.Entry<Mac> entry : entries) {
                try {
                    entry.getFullPrimitive().verifyMac(mac, data);
                    this.verifyLogger.log(entry.getKeyId(), data.length);
                    return;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            this.verifyLogger.logFailure();
            throw new GeneralSecurityException("invalid MAC");
        }
    }
}

