/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.SecretKeyAccess;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutableKeyDerivationRegistry;
import com.google.crypto.tink.internal.MutableParametersRegistry;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.PrivateKeyTypeManager;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.proto.Ed25519KeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.signature.Ed25519Parameters;
import com.google.crypto.tink.signature.Ed25519PrivateKey;
import com.google.crypto.tink.signature.Ed25519ProtoSerialization;
import com.google.crypto.tink.signature.Ed25519PublicKey;
import com.google.crypto.tink.signature.Ed25519PublicKeyManager;
import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.Validators;
import com.google.crypto.tink.util.Bytes;
import com.google.crypto.tink.util.SecretBytes;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class Ed25519PrivateKeyManager
extends PrivateKeyTypeManager<com.google.crypto.tink.proto.Ed25519PrivateKey, com.google.crypto.tink.proto.Ed25519PublicKey> {
    private static final MutableKeyDerivationRegistry.InsecureKeyCreator<Ed25519Parameters> KEY_DERIVER = Ed25519PrivateKeyManager::createEd25519KeyFromRandomness;

    Ed25519PrivateKeyManager() {
        super(com.google.crypto.tink.proto.Ed25519PrivateKey.class, com.google.crypto.tink.proto.Ed25519PublicKey.class, new PrimitiveFactory<PublicKeySign, com.google.crypto.tink.proto.Ed25519PrivateKey>(PublicKeySign.class){

            @Override
            public PublicKeySign getPrimitive(com.google.crypto.tink.proto.Ed25519PrivateKey keyProto) throws GeneralSecurityException {
                return new Ed25519Sign(keyProto.getKeyValue().toByteArray());
            }
        });
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.Ed25519PrivateKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public com.google.crypto.tink.proto.Ed25519PublicKey getPublicKey(com.google.crypto.tink.proto.Ed25519PrivateKey key) throws GeneralSecurityException {
        return key.getPublicKey();
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PRIVATE;
    }

    @Override
    public com.google.crypto.tink.proto.Ed25519PrivateKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return com.google.crypto.tink.proto.Ed25519PrivateKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(com.google.crypto.tink.proto.Ed25519PrivateKey keyProto) throws GeneralSecurityException {
        Validators.validateVersion(keyProto.getVersion(), this.getVersion());
        new Ed25519PublicKeyManager().validateKey(keyProto.getPublicKey());
        if (keyProto.getKeyValue().size() != 32) {
            throw new GeneralSecurityException("invalid Ed25519 private key: incorrect key length");
        }
    }

    @Override
    public KeyTypeManager.KeyFactory<Ed25519KeyFormat, com.google.crypto.tink.proto.Ed25519PrivateKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<Ed25519KeyFormat, com.google.crypto.tink.proto.Ed25519PrivateKey>(Ed25519KeyFormat.class){

            @Override
            public void validateKeyFormat(Ed25519KeyFormat format) throws GeneralSecurityException {
            }

            @Override
            public Ed25519KeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return Ed25519KeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public com.google.crypto.tink.proto.Ed25519PrivateKey createKey(Ed25519KeyFormat format) throws GeneralSecurityException {
                Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPair();
                com.google.crypto.tink.proto.Ed25519PublicKey publicKey = com.google.crypto.tink.proto.Ed25519PublicKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPublicKey())).build();
                return com.google.crypto.tink.proto.Ed25519PrivateKey.newBuilder().setVersion(Ed25519PrivateKeyManager.this.getVersion()).setKeyValue(ByteString.copyFrom((byte[])keyPair.getPrivateKey())).setPublicKey(publicKey).build();
            }
        };
    }

    @AccessesPartialKey
    static Ed25519PrivateKey createEd25519KeyFromRandomness(Ed25519Parameters parameters, InputStream stream, @Nullable Integer idRequirement, SecretKeyAccess access) throws GeneralSecurityException {
        SecretBytes pseudorandomness = Util.readIntoSecretBytes(stream, 32, access);
        Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPairFromSeed(pseudorandomness.toByteArray(access));
        Ed25519PublicKey publicKey = Ed25519PublicKey.create(parameters.getVariant(), Bytes.copyFrom(keyPair.getPublicKey()), idRequirement);
        return Ed25519PrivateKey.create(publicKey, SecretBytes.copyFrom(keyPair.getPrivateKey(), access));
    }

    private static Map<String, Parameters> namedParameters() throws GeneralSecurityException {
        HashMap<String, Ed25519Parameters> result = new HashMap<String, Ed25519Parameters>();
        result.put("ED25519", Ed25519Parameters.create(Ed25519Parameters.Variant.TINK));
        result.put("ED25519_RAW", Ed25519Parameters.create(Ed25519Parameters.Variant.NO_PREFIX));
        result.put("ED25519WithRawOutput", Ed25519Parameters.create(Ed25519Parameters.Variant.NO_PREFIX));
        return Collections.unmodifiableMap(result);
    }

    public static void registerPair(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerAsymmetricKeyManagers(new Ed25519PrivateKeyManager(), new Ed25519PublicKeyManager(), newKeyAllowed);
        Ed25519ProtoSerialization.register();
        MutableParametersRegistry.globalInstance().putAll(Ed25519PrivateKeyManager.namedParameters());
        MutableKeyDerivationRegistry.globalInstance().add(KEY_DERIVER, Ed25519Parameters.class);
    }

    public static final KeyTemplate ed25519Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(Ed25519Parameters.create(Ed25519Parameters.Variant.TINK)));
    }

    public static final KeyTemplate rawEd25519Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(Ed25519Parameters.create(Ed25519Parameters.Variant.NO_PREFIX)));
    }
}

