/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;

public final class MetadataRecoveryState {
    private final MetadataRecoveryPartition recoveryPartition;
    private final MetadataEncryptorFactory metadataEncryptorFactory;
    private MetadataImage currentImage;

    public MetadataRecoveryState(MetadataRecoveryPartition metadataRecoveryPartition, MetadataEncryptorFactory metadataEncryptorFactory) {
        this.recoveryPartition = metadataRecoveryPartition;
        this.metadataEncryptorFactory = metadataEncryptorFactory;
        this.currentImage = MetadataImage.EMPTY;
    }

    public void load() {
        long lastCommittedOffset = -1L;
        int lastCommittedEpoch = 0;
        long lastCommittedTimestamp = -1L;
        MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
        for (Batch recordBatch : this.recoveryPartition) {
            for (ApiMessageAndVersion record : recordBatch) {
                metadataDelta.replay(record.message(), record.version());
            }
            lastCommittedOffset = recordBatch.lastOffset();
            lastCommittedEpoch = recordBatch.epoch();
            lastCommittedTimestamp = recordBatch.appendTimestamp();
        }
        this.currentImage = metadataDelta.apply(new MetadataProvenance(lastCommittedOffset, lastCommittedEpoch, lastCommittedTimestamp));
    }

    public MetadataImage getImage() {
        return this.currentImage;
    }

    public void importCheckpoint(RecordsSnapshotReader<ApiMessageAndVersion> snapshotReplay, RecordsSnapshotReader<ApiMessageAndVersion> snapshotAppend) {
        Batch batch;
        if (this.recoveryPartition.iterator().hasNext()) {
            throw new IllegalStateException("Recovery partition should be empty");
        }
        ApiMessageAndVersion currRecord = null;
        MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
        try {
            while (snapshotReplay.hasNext()) {
                batch = snapshotReplay.next();
                Iterator iterator = batch.records().iterator();
                while (iterator.hasNext()) {
                    ApiMessageAndVersion record;
                    currRecord = record = (ApiMessageAndVersion)iterator.next();
                    metadataDelta.replay(record.message(), record.version());
                }
            }
        }
        catch (RuntimeException e) {
            if (currRecord != null) {
                System.err.printf("Failed to replay all records from provided checkpoint. Failed at record (json format):%n", new Object[0]);
                MetadataRecoveryUtils.writeSingleRecordAsJson(currRecord, System.err);
            }
            throw e;
        }
        this.currentImage = metadataDelta.apply(new MetadataProvenance(snapshotReplay.lastContainedLogOffset(), snapshotReplay.lastContainedLogEpoch(), snapshotReplay.lastContainedLogTimestamp()));
        while (snapshotAppend.hasNext()) {
            batch = snapshotAppend.next();
            for (ApiMessageAndVersion record : batch.records()) {
                if (record.message() instanceof NoOpRecord) continue;
                this.recoveryPartition.appendRecord(record);
            }
            for (ControlRecord controlRecord : batch.controlRecords()) {
                this.recoveryPartition.maybeAppendControlRecord(controlRecord);
            }
        }
    }

    public void applyLogs(AutoCloseableIterator<Batch<ApiMessageAndVersion>> iterator, long startOffset, long endingOffset) {
        long lastContainedLogTimestamp = 0L;
        block2: while (iterator.hasNext()) {
            Batch batch = (Batch)iterator.next();
            lastContainedLogTimestamp = Math.max(batch.appendTimestamp(), lastContainedLogTimestamp);
            int epoch = batch.epoch();
            ApiMessageAndVersion currRecord = null;
            long currOffset = batch.baseOffset() - 1L;
            try {
                MetadataDelta metadataDelta = new MetadataDelta.Builder().setImage(this.currentImage).setMetadataEncryptorFactory(this.metadataEncryptorFactory).build();
                for (ApiMessageAndVersion record : batch.records()) {
                    if (++currOffset < startOffset) continue;
                    if (currOffset >= endingOffset) break;
                    currRecord = record;
                    metadataDelta.replay(record.message(), record.version());
                    if (record.message() instanceof NoOpRecord) continue;
                    this.recoveryPartition.appendRecord(record);
                }
                this.currentImage = metadataDelta.apply(new MetadataProvenance(currOffset, epoch, lastContainedLogTimestamp));
                for (ControlRecord controlRecord : batch.controlRecords()) {
                    if (++currOffset < startOffset) continue;
                    if (currOffset >= endingOffset) continue block2;
                    this.recoveryPartition.maybeAppendControlRecord(controlRecord);
                }
            }
            catch (RuntimeException e) {
                if (currRecord != null) {
                    System.err.printf("Failed to apply record at offset %s. Please use %s(.sh/.bat) %s to view the current state of the recovery partition%nFailed to replay/apply the following record (json format): %n", currOffset, "kafka-metadata-recovery", "display");
                    MetadataRecoveryUtils.writeSingleRecordAsJson(currRecord, System.out);
                }
                throw e;
            }
        }
    }

    public void exportCheckpoint(long offset, int epoch, long lastContainedLogTimestamp, Path outDirectory) {
        try (RaftSnapshotWriter raftSnapshotWriter = new RaftSnapshotWriter((SnapshotWriter)RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)outDirectory, (OffsetAndEpoch)new OffsetAndEpoch(offset, epoch), Optional.empty()), (int)0x800000, (MemoryPool)new BatchMemoryPool(5, 0x800000), (Time)Time.SYSTEM, (long)lastContainedLogTimestamp, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE), 0x800000);){
            this.currentImage.write((ImageWriter)raftSnapshotWriter, new ImageWriterOptions.Builder(this.currentImage).build());
        }
    }
}

