/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class AssignBrokersCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "assign-brokers";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Assigns brokers to a cell");
        parser.addArgument(new String[]{"--broker-ids"}).help("list of brokers to assign separated by commas. Brokers in this list must be originating from one source cell and all brokers should be included.").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
        parser.addArgument(new String[]{"--cell-id"}).help("target cell id").action((ArgumentAction)Arguments.store()).type(Integer.class).required(true);
        parser.addArgument(new String[]{"--force"}).help("allows for brokers to be from multiple cells, or only contain some brokers in source cell").action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        int cellId = ns.getInt("cell_id");
        String brokerIds = ns.getString("broker_ids");
        List assignments = Arrays.stream(brokerIds.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        boolean force = Optional.ofNullable(ns.getString("force")).map(Boolean::parseBoolean).orElse(false);
        try {
            admin.assignBrokersToCell(assignments, cellId, force).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to assign brokers to cell", e.getCause());
            return;
        }
        CellsAdminCommand.printMessageAndExit(out, "Successfully set brokers " + brokerIds + " to cell " + cellId);
    }
}

