/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class DescribeCellMigrationCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "describe-migration";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Describes cell migration state");
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        String cellsMigrationState;
        try {
            cellsMigrationState = ((DescribeCellMigrationResponseData)admin.describeCellMigration().value().get()).cellMigrationState();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to fetch cell migration details", e.getCause());
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("Cells Migration state: %s\n", cellsMigrationState));
        CellsAdminCommand.printMessageAndExit(out, message.toString());
    }
}

