/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.reassign;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Assignment {
    private final List<Integer> replicas;
    private final List<Integer> observers;

    public Assignment(List<Integer> replicas, List<Integer> observers) {
        this.replicas = replicas;
        this.observers = observers;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> observers() {
        return this.observers;
    }

    public String replicasString() {
        return this.replicas.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public String observersString() {
        return this.observers.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment other = (Assignment)o;
        return this.replicas.equals(other.replicas) && this.observers.equals(other.observers);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.observers);
    }

    public String toString() {
        return "Assignment(replicas=[" + this.replicasString() + "], observers=[" + this.observersString() + "])";
    }
}

