/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.protobuf.events.auditlog.v2;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import io.confluent.protobuf.events.auditlog.v2.AuditLogOuterClass;
import io.confluent.protobuf.events.auditlog.v2.RequestMetadataOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class RequestMetadata
extends GeneratedMessageV3
implements RequestMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CONNECTION_ID_FIELD_NUMBER = 1;
    private volatile Object connectionId_;
    public static final int REQUEST_ID_FIELD_NUMBER = 2;
    private LazyStringList requestId_;
    public static final int CLIENT_ADDRESS_FIELD_NUMBER = 3;
    private List<Address> clientAddress_;
    public static final int CLIENT_ID_FIELD_NUMBER = 4;
    private volatile Object clientId_;
    public static final int CLIENT_TRACE_ID_FIELD_NUMBER = 5;
    private ByteString clientTraceId_;
    public static final int LOCAL_ADDRESS_FIELD_NUMBER = 6;
    private Address localAddress_;
    public static final int SERVICE_TRACE_ID_FIELD_NUMBER = 7;
    private ByteString serviceTraceId_;
    public static final int SERVICE_SPAN_ID_FIELD_NUMBER = 8;
    private ByteString serviceSpanId_;
    public static final int REQUEST_TYPE_FIELD_NUMBER = 9;
    private int requestType_;
    public static final int REQUEST_PATH_FIELD_NUMBER = 10;
    private volatile Object requestPath_;
    public static final int CORRELATION_ID_FIELD_NUMBER = 11;
    private volatile Object correlationId_;
    public static final int NETWORK_ID_FIELD_NUMBER = 12;
    private volatile Object networkId_;
    public static final int REQUEST_LISTENER_NAME_FIELD_NUMBER = 13;
    private volatile Object requestListenerName_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final RequestMetadata DEFAULT_INSTANCE = new RequestMetadata();
    private static final Parser<RequestMetadata> PARSER = new AbstractParser<RequestMetadata>(){

        public RequestMetadata parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new RequestMetadata(input, extensionRegistry);
        }
    };

    private RequestMetadata(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private RequestMetadata() {
        this.connectionId_ = "";
        this.requestId_ = LazyStringArrayList.EMPTY;
        this.clientAddress_ = Collections.emptyList();
        this.clientId_ = "";
        this.clientTraceId_ = ByteString.EMPTY;
        this.serviceTraceId_ = ByteString.EMPTY;
        this.serviceSpanId_ = ByteString.EMPTY;
        this.requestType_ = 0;
        this.requestPath_ = "";
        this.correlationId_ = "";
        this.networkId_ = "";
        this.requestListenerName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new RequestMetadata();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private RequestMetadata(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block22: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block22;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.connectionId_ = s;
                        continue block22;
                    }
                    case 18: {
                        String s = input.readStringRequireUtf8();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.requestId_ = new LazyStringArrayList();
                            mutable_bitField0_ |= 1;
                        }
                        this.requestId_.add((Object)s);
                        continue block22;
                    }
                    case 26: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.clientAddress_ = new ArrayList<Address>();
                            mutable_bitField0_ |= 2;
                        }
                        this.clientAddress_.add((Address)input.readMessage(Address.parser(), extensionRegistry));
                        continue block22;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        this.clientId_ = s;
                        continue block22;
                    }
                    case 42: {
                        this.clientTraceId_ = input.readBytes();
                        continue block22;
                    }
                    case 50: {
                        Address.Builder subBuilder = null;
                        if (this.localAddress_ != null) {
                            subBuilder = this.localAddress_.toBuilder();
                        }
                        this.localAddress_ = (Address)input.readMessage(Address.parser(), extensionRegistry);
                        if (subBuilder == null) continue block22;
                        subBuilder.mergeFrom(this.localAddress_);
                        this.localAddress_ = subBuilder.buildPartial();
                        continue block22;
                    }
                    case 58: {
                        this.serviceTraceId_ = input.readBytes();
                        continue block22;
                    }
                    case 66: {
                        this.serviceSpanId_ = input.readBytes();
                        continue block22;
                    }
                    case 72: {
                        int rawValue;
                        this.requestType_ = rawValue = input.readEnum();
                        continue block22;
                    }
                    case 82: {
                        String s = input.readStringRequireUtf8();
                        this.requestPath_ = s;
                        continue block22;
                    }
                    case 90: {
                        String s = input.readStringRequireUtf8();
                        this.correlationId_ = s;
                        continue block22;
                    }
                    case 98: {
                        String s = input.readStringRequireUtf8();
                        this.networkId_ = s;
                        continue block22;
                    }
                    case 106: {
                        String s = input.readStringRequireUtf8();
                        this.requestListenerName_ = s;
                        continue block22;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.requestId_ = this.requestId_.getUnmodifiableView();
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.clientAddress_ = Collections.unmodifiableList(this.clientAddress_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(RequestMetadata.class, Builder.class);
    }

    @Override
    public String getConnectionId() {
        Object ref = this.connectionId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.connectionId_ = s;
        return s;
    }

    @Override
    public ByteString getConnectionIdBytes() {
        Object ref = this.connectionId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.connectionId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getRequestIdList() {
        return this.requestId_;
    }

    @Override
    public int getRequestIdCount() {
        return this.requestId_.size();
    }

    @Override
    public String getRequestId(int index) {
        return (String)this.requestId_.get(index);
    }

    @Override
    public ByteString getRequestIdBytes(int index) {
        return this.requestId_.getByteString(index);
    }

    @Override
    public List<Address> getClientAddressList() {
        return this.clientAddress_;
    }

    @Override
    public List<? extends AddressOrBuilder> getClientAddressOrBuilderList() {
        return this.clientAddress_;
    }

    @Override
    public int getClientAddressCount() {
        return this.clientAddress_.size();
    }

    @Override
    public Address getClientAddress(int index) {
        return this.clientAddress_.get(index);
    }

    @Override
    public AddressOrBuilder getClientAddressOrBuilder(int index) {
        return this.clientAddress_.get(index);
    }

    @Override
    public String getClientId() {
        Object ref = this.clientId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clientId_ = s;
        return s;
    }

    @Override
    public ByteString getClientIdBytes() {
        Object ref = this.clientId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clientId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public ByteString getClientTraceId() {
        return this.clientTraceId_;
    }

    @Override
    public boolean hasLocalAddress() {
        return this.localAddress_ != null;
    }

    @Override
    public Address getLocalAddress() {
        return this.localAddress_ == null ? Address.getDefaultInstance() : this.localAddress_;
    }

    @Override
    public AddressOrBuilder getLocalAddressOrBuilder() {
        return this.getLocalAddress();
    }

    @Override
    public ByteString getServiceTraceId() {
        return this.serviceTraceId_;
    }

    @Override
    public ByteString getServiceSpanId() {
        return this.serviceSpanId_;
    }

    @Override
    public int getRequestTypeValue() {
        return this.requestType_;
    }

    @Override
    public RequestType getRequestType() {
        RequestType result = RequestType.valueOf(this.requestType_);
        return result == null ? RequestType.UNRECOGNIZED : result;
    }

    @Override
    public String getRequestPath() {
        Object ref = this.requestPath_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.requestPath_ = s;
        return s;
    }

    @Override
    public ByteString getRequestPathBytes() {
        Object ref = this.requestPath_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.requestPath_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getCorrelationId() {
        Object ref = this.correlationId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.correlationId_ = s;
        return s;
    }

    @Override
    public ByteString getCorrelationIdBytes() {
        Object ref = this.correlationId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.correlationId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getNetworkId() {
        Object ref = this.networkId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.networkId_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkIdBytes() {
        Object ref = this.networkId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.networkId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getRequestListenerName() {
        Object ref = this.requestListenerName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.requestListenerName_ = s;
        return s;
    }

    @Override
    public ByteString getRequestListenerNameBytes() {
        Object ref = this.requestListenerName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.requestListenerName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.connectionId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.connectionId_);
        }
        for (i = 0; i < this.requestId_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.requestId_.getRaw(i));
        }
        for (i = 0; i < this.clientAddress_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.clientAddress_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clientId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.clientId_);
        }
        if (!this.clientTraceId_.isEmpty()) {
            output.writeBytes(5, this.clientTraceId_);
        }
        if (this.localAddress_ != null) {
            output.writeMessage(6, (MessageLite)this.getLocalAddress());
        }
        if (!this.serviceTraceId_.isEmpty()) {
            output.writeBytes(7, this.serviceTraceId_);
        }
        if (!this.serviceSpanId_.isEmpty()) {
            output.writeBytes(8, this.serviceSpanId_);
        }
        if (this.requestType_ != RequestType.HTTP.getNumber()) {
            output.writeEnum(9, this.requestType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestPath_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.requestPath_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.correlationId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.correlationId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.networkId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestListenerName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.requestListenerName_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.connectionId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.connectionId_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.requestId_.size(); ++i) {
            dataSize += RequestMetadata.computeStringSizeNoTag((Object)this.requestId_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRequestIdList().size();
        for (int i = 0; i < this.clientAddress_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.clientAddress_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clientId_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.clientId_);
        }
        if (!this.clientTraceId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)5, (ByteString)this.clientTraceId_);
        }
        if (this.localAddress_ != null) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getLocalAddress());
        }
        if (!this.serviceTraceId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)7, (ByteString)this.serviceTraceId_);
        }
        if (!this.serviceSpanId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)8, (ByteString)this.serviceSpanId_);
        }
        if (this.requestType_ != RequestType.HTTP.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.requestType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestPath_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.requestPath_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.correlationId_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.correlationId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.networkId_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.networkId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.requestListenerName_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.requestListenerName_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RequestMetadata)) {
            return super.equals(obj);
        }
        RequestMetadata other = (RequestMetadata)obj;
        if (!this.getConnectionId().equals(other.getConnectionId())) {
            return false;
        }
        if (!this.getRequestIdList().equals(other.getRequestIdList())) {
            return false;
        }
        if (!this.getClientAddressList().equals(other.getClientAddressList())) {
            return false;
        }
        if (!this.getClientId().equals(other.getClientId())) {
            return false;
        }
        if (!this.getClientTraceId().equals((Object)other.getClientTraceId())) {
            return false;
        }
        if (this.hasLocalAddress() != other.hasLocalAddress()) {
            return false;
        }
        if (this.hasLocalAddress() && !this.getLocalAddress().equals(other.getLocalAddress())) {
            return false;
        }
        if (!this.getServiceTraceId().equals((Object)other.getServiceTraceId())) {
            return false;
        }
        if (!this.getServiceSpanId().equals((Object)other.getServiceSpanId())) {
            return false;
        }
        if (this.requestType_ != other.requestType_) {
            return false;
        }
        if (!this.getRequestPath().equals(other.getRequestPath())) {
            return false;
        }
        if (!this.getCorrelationId().equals(other.getCorrelationId())) {
            return false;
        }
        if (!this.getNetworkId().equals(other.getNetworkId())) {
            return false;
        }
        if (!this.getRequestListenerName().equals(other.getRequestListenerName())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + RequestMetadata.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getConnectionId().hashCode();
        if (this.getRequestIdCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getRequestIdList().hashCode();
        }
        if (this.getClientAddressCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getClientAddressList().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getClientId().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getClientTraceId().hashCode();
        if (this.hasLocalAddress()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getLocalAddress().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getServiceTraceId().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getServiceSpanId().hashCode();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.requestType_;
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getRequestPath().hashCode();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getCorrelationId().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getNetworkId().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getRequestListenerName().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static RequestMetadata parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data);
    }

    public static RequestMetadata parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RequestMetadata parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data);
    }

    public static RequestMetadata parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RequestMetadata parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data);
    }

    public static RequestMetadata parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RequestMetadata)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RequestMetadata parseFrom(InputStream input) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static RequestMetadata parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static RequestMetadata parseDelimitedFrom(InputStream input) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static RequestMetadata parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static RequestMetadata parseFrom(CodedInputStream input) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static RequestMetadata parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RequestMetadata)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return RequestMetadata.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RequestMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static RequestMetadata getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<RequestMetadata> parser() {
        return PARSER;
    }

    public Parser<RequestMetadata> getParserForType() {
        return PARSER;
    }

    public RequestMetadata getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements RequestMetadataOrBuilder {
        private int bitField0_;
        private Object connectionId_ = "";
        private LazyStringList requestId_ = LazyStringArrayList.EMPTY;
        private List<Address> clientAddress_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> clientAddressBuilder_;
        private Object clientId_ = "";
        private ByteString clientTraceId_ = ByteString.EMPTY;
        private Address localAddress_;
        private SingleFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> localAddressBuilder_;
        private ByteString serviceTraceId_ = ByteString.EMPTY;
        private ByteString serviceSpanId_ = ByteString.EMPTY;
        private int requestType_ = 0;
        private Object requestPath_ = "";
        private Object correlationId_ = "";
        private Object networkId_ = "";
        private Object requestListenerName_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_fieldAccessorTable.ensureFieldAccessorsInitialized(RequestMetadata.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getClientAddressFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.connectionId_ = "";
            this.requestId_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.clientAddressBuilder_ == null) {
                this.clientAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.clientAddressBuilder_.clear();
            }
            this.clientId_ = "";
            this.clientTraceId_ = ByteString.EMPTY;
            if (this.localAddressBuilder_ == null) {
                this.localAddress_ = null;
            } else {
                this.localAddress_ = null;
                this.localAddressBuilder_ = null;
            }
            this.serviceTraceId_ = ByteString.EMPTY;
            this.serviceSpanId_ = ByteString.EMPTY;
            this.requestType_ = 0;
            this.requestPath_ = "";
            this.correlationId_ = "";
            this.networkId_ = "";
            this.requestListenerName_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_descriptor;
        }

        public RequestMetadata getDefaultInstanceForType() {
            return RequestMetadata.getDefaultInstance();
        }

        public RequestMetadata build() {
            RequestMetadata result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public RequestMetadata buildPartial() {
            RequestMetadata result = new RequestMetadata(this);
            int from_bitField0_ = this.bitField0_;
            result.connectionId_ = this.connectionId_;
            if ((this.bitField0_ & 1) != 0) {
                this.requestId_ = this.requestId_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.requestId_ = this.requestId_;
            if (this.clientAddressBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.clientAddress_ = Collections.unmodifiableList(this.clientAddress_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.clientAddress_ = this.clientAddress_;
            } else {
                result.clientAddress_ = this.clientAddressBuilder_.build();
            }
            result.clientId_ = this.clientId_;
            result.clientTraceId_ = this.clientTraceId_;
            if (this.localAddressBuilder_ == null) {
                result.localAddress_ = this.localAddress_;
            } else {
                result.localAddress_ = (Address)this.localAddressBuilder_.build();
            }
            result.serviceTraceId_ = this.serviceTraceId_;
            result.serviceSpanId_ = this.serviceSpanId_;
            result.requestType_ = this.requestType_;
            result.requestPath_ = this.requestPath_;
            result.correlationId_ = this.correlationId_;
            result.networkId_ = this.networkId_;
            result.requestListenerName_ = this.requestListenerName_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof RequestMetadata) {
                return this.mergeFrom((RequestMetadata)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(RequestMetadata other) {
            if (other == RequestMetadata.getDefaultInstance()) {
                return this;
            }
            if (!other.getConnectionId().isEmpty()) {
                this.connectionId_ = other.connectionId_;
                this.onChanged();
            }
            if (!other.requestId_.isEmpty()) {
                if (this.requestId_.isEmpty()) {
                    this.requestId_ = other.requestId_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureRequestIdIsMutable();
                    this.requestId_.addAll((Collection)other.requestId_);
                }
                this.onChanged();
            }
            if (this.clientAddressBuilder_ == null) {
                if (!other.clientAddress_.isEmpty()) {
                    if (this.clientAddress_.isEmpty()) {
                        this.clientAddress_ = other.clientAddress_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureClientAddressIsMutable();
                        this.clientAddress_.addAll(other.clientAddress_);
                    }
                    this.onChanged();
                }
            } else if (!other.clientAddress_.isEmpty()) {
                if (this.clientAddressBuilder_.isEmpty()) {
                    this.clientAddressBuilder_.dispose();
                    this.clientAddressBuilder_ = null;
                    this.clientAddress_ = other.clientAddress_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.clientAddressBuilder_ = alwaysUseFieldBuilders ? this.getClientAddressFieldBuilder() : null;
                } else {
                    this.clientAddressBuilder_.addAllMessages((Iterable)other.clientAddress_);
                }
            }
            if (!other.getClientId().isEmpty()) {
                this.clientId_ = other.clientId_;
                this.onChanged();
            }
            if (other.getClientTraceId() != ByteString.EMPTY) {
                this.setClientTraceId(other.getClientTraceId());
            }
            if (other.hasLocalAddress()) {
                this.mergeLocalAddress(other.getLocalAddress());
            }
            if (other.getServiceTraceId() != ByteString.EMPTY) {
                this.setServiceTraceId(other.getServiceTraceId());
            }
            if (other.getServiceSpanId() != ByteString.EMPTY) {
                this.setServiceSpanId(other.getServiceSpanId());
            }
            if (other.requestType_ != 0) {
                this.setRequestTypeValue(other.getRequestTypeValue());
            }
            if (!other.getRequestPath().isEmpty()) {
                this.requestPath_ = other.requestPath_;
                this.onChanged();
            }
            if (!other.getCorrelationId().isEmpty()) {
                this.correlationId_ = other.correlationId_;
                this.onChanged();
            }
            if (!other.getNetworkId().isEmpty()) {
                this.networkId_ = other.networkId_;
                this.onChanged();
            }
            if (!other.getRequestListenerName().isEmpty()) {
                this.requestListenerName_ = other.requestListenerName_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            RequestMetadata parsedMessage = null;
            try {
                parsedMessage = (RequestMetadata)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (RequestMetadata)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getConnectionId() {
            Object ref = this.connectionId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.connectionId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getConnectionIdBytes() {
            Object ref = this.connectionId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.connectionId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setConnectionId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.connectionId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearConnectionId() {
            this.connectionId_ = RequestMetadata.getDefaultInstance().getConnectionId();
            this.onChanged();
            return this;
        }

        public Builder setConnectionIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.connectionId_ = value;
            this.onChanged();
            return this;
        }

        private void ensureRequestIdIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.requestId_ = new LazyStringArrayList(this.requestId_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getRequestIdList() {
            return this.requestId_.getUnmodifiableView();
        }

        @Override
        public int getRequestIdCount() {
            return this.requestId_.size();
        }

        @Override
        public String getRequestId(int index) {
            return (String)this.requestId_.get(index);
        }

        @Override
        public ByteString getRequestIdBytes(int index) {
            return this.requestId_.getByteString(index);
        }

        public Builder setRequestId(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestIdIsMutable();
            this.requestId_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addRequestId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRequestIdIsMutable();
            this.requestId_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllRequestId(Iterable<String> values) {
            this.ensureRequestIdIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.requestId_);
            this.onChanged();
            return this;
        }

        public Builder clearRequestId() {
            this.requestId_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addRequestIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.ensureRequestIdIsMutable();
            this.requestId_.add(value);
            this.onChanged();
            return this;
        }

        private void ensureClientAddressIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.clientAddress_ = new ArrayList<Address>(this.clientAddress_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Address> getClientAddressList() {
            if (this.clientAddressBuilder_ == null) {
                return Collections.unmodifiableList(this.clientAddress_);
            }
            return this.clientAddressBuilder_.getMessageList();
        }

        @Override
        public int getClientAddressCount() {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.size();
            }
            return this.clientAddressBuilder_.getCount();
        }

        @Override
        public Address getClientAddress(int index) {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.get(index);
            }
            return (Address)this.clientAddressBuilder_.getMessage(index);
        }

        public Builder setClientAddress(int index, Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.set(index, value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setClientAddress(int index, Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addClientAddress(Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addClientAddress(int index, Address value) {
            if (this.clientAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(index, value);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addClientAddress(Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addClientAddress(int index, Address.Builder builderForValue) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllClientAddress(Iterable<? extends Address> values) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.clientAddress_);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearClientAddress() {
            if (this.clientAddressBuilder_ == null) {
                this.clientAddress_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.clientAddressBuilder_.clear();
            }
            return this;
        }

        public Builder removeClientAddress(int index) {
            if (this.clientAddressBuilder_ == null) {
                this.ensureClientAddressIsMutable();
                this.clientAddress_.remove(index);
                this.onChanged();
            } else {
                this.clientAddressBuilder_.remove(index);
            }
            return this;
        }

        public Address.Builder getClientAddressBuilder(int index) {
            return (Address.Builder)this.getClientAddressFieldBuilder().getBuilder(index);
        }

        @Override
        public AddressOrBuilder getClientAddressOrBuilder(int index) {
            if (this.clientAddressBuilder_ == null) {
                return this.clientAddress_.get(index);
            }
            return (AddressOrBuilder)this.clientAddressBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AddressOrBuilder> getClientAddressOrBuilderList() {
            if (this.clientAddressBuilder_ != null) {
                return this.clientAddressBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.clientAddress_);
        }

        public Address.Builder addClientAddressBuilder() {
            return (Address.Builder)this.getClientAddressFieldBuilder().addBuilder((AbstractMessage)Address.getDefaultInstance());
        }

        public Address.Builder addClientAddressBuilder(int index) {
            return (Address.Builder)this.getClientAddressFieldBuilder().addBuilder(index, (AbstractMessage)Address.getDefaultInstance());
        }

        public List<Address.Builder> getClientAddressBuilderList() {
            return this.getClientAddressFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> getClientAddressFieldBuilder() {
            if (this.clientAddressBuilder_ == null) {
                this.clientAddressBuilder_ = new RepeatedFieldBuilderV3(this.clientAddress_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.clientAddress_ = null;
            }
            return this.clientAddressBuilder_;
        }

        @Override
        public String getClientId() {
            Object ref = this.clientId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clientId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClientIdBytes() {
            Object ref = this.clientId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clientId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClientId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clientId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearClientId() {
            this.clientId_ = RequestMetadata.getDefaultInstance().getClientId();
            this.onChanged();
            return this;
        }

        public Builder setClientIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.clientId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getClientTraceId() {
            return this.clientTraceId_;
        }

        public Builder setClientTraceId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clientTraceId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearClientTraceId() {
            this.clientTraceId_ = RequestMetadata.getDefaultInstance().getClientTraceId();
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLocalAddress() {
            return this.localAddressBuilder_ != null || this.localAddress_ != null;
        }

        @Override
        public Address getLocalAddress() {
            if (this.localAddressBuilder_ == null) {
                return this.localAddress_ == null ? Address.getDefaultInstance() : this.localAddress_;
            }
            return (Address)this.localAddressBuilder_.getMessage();
        }

        public Builder setLocalAddress(Address value) {
            if (this.localAddressBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.localAddress_ = value;
                this.onChanged();
            } else {
                this.localAddressBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setLocalAddress(Address.Builder builderForValue) {
            if (this.localAddressBuilder_ == null) {
                this.localAddress_ = builderForValue.build();
                this.onChanged();
            } else {
                this.localAddressBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeLocalAddress(Address value) {
            if (this.localAddressBuilder_ == null) {
                this.localAddress_ = this.localAddress_ != null ? Address.newBuilder(this.localAddress_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.localAddressBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearLocalAddress() {
            if (this.localAddressBuilder_ == null) {
                this.localAddress_ = null;
                this.onChanged();
            } else {
                this.localAddress_ = null;
                this.localAddressBuilder_ = null;
            }
            return this;
        }

        public Address.Builder getLocalAddressBuilder() {
            this.onChanged();
            return (Address.Builder)this.getLocalAddressFieldBuilder().getBuilder();
        }

        @Override
        public AddressOrBuilder getLocalAddressOrBuilder() {
            if (this.localAddressBuilder_ != null) {
                return (AddressOrBuilder)this.localAddressBuilder_.getMessageOrBuilder();
            }
            return this.localAddress_ == null ? Address.getDefaultInstance() : this.localAddress_;
        }

        private SingleFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> getLocalAddressFieldBuilder() {
            if (this.localAddressBuilder_ == null) {
                this.localAddressBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLocalAddress(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.localAddress_ = null;
            }
            return this.localAddressBuilder_;
        }

        @Override
        public ByteString getServiceTraceId() {
            return this.serviceTraceId_;
        }

        public Builder setServiceTraceId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceTraceId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearServiceTraceId() {
            this.serviceTraceId_ = RequestMetadata.getDefaultInstance().getServiceTraceId();
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getServiceSpanId() {
            return this.serviceSpanId_;
        }

        public Builder setServiceSpanId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceSpanId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearServiceSpanId() {
            this.serviceSpanId_ = RequestMetadata.getDefaultInstance().getServiceSpanId();
            this.onChanged();
            return this;
        }

        @Override
        public int getRequestTypeValue() {
            return this.requestType_;
        }

        public Builder setRequestTypeValue(int value) {
            this.requestType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public RequestType getRequestType() {
            RequestType result = RequestType.valueOf(this.requestType_);
            return result == null ? RequestType.UNRECOGNIZED : result;
        }

        public Builder setRequestType(RequestType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearRequestType() {
            this.requestType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getRequestPath() {
            Object ref = this.requestPath_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.requestPath_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRequestPathBytes() {
            Object ref = this.requestPath_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.requestPath_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRequestPath(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestPath_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRequestPath() {
            this.requestPath_ = RequestMetadata.getDefaultInstance().getRequestPath();
            this.onChanged();
            return this;
        }

        public Builder setRequestPathBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.requestPath_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getCorrelationId() {
            Object ref = this.correlationId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.correlationId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCorrelationIdBytes() {
            Object ref = this.correlationId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.correlationId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCorrelationId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.correlationId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearCorrelationId() {
            this.correlationId_ = RequestMetadata.getDefaultInstance().getCorrelationId();
            this.onChanged();
            return this;
        }

        public Builder setCorrelationIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.correlationId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getNetworkId() {
            Object ref = this.networkId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.networkId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkIdBytes() {
            Object ref = this.networkId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.networkId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetworkId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.networkId_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearNetworkId() {
            this.networkId_ = RequestMetadata.getDefaultInstance().getNetworkId();
            this.onChanged();
            return this;
        }

        public Builder setNetworkIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.networkId_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getRequestListenerName() {
            Object ref = this.requestListenerName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.requestListenerName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getRequestListenerNameBytes() {
            Object ref = this.requestListenerName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.requestListenerName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setRequestListenerName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.requestListenerName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearRequestListenerName() {
            this.requestListenerName_ = RequestMetadata.getDefaultInstance().getRequestListenerName();
            this.onChanged();
            return this;
        }

        public Builder setRequestListenerNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RequestMetadata.checkByteStringIsUtf8((ByteString)value);
            this.requestListenerName_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class Address
    extends GeneratedMessageV3
    implements AddressOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int IP_FIELD_NUMBER = 1;
        private volatile Object ip_;
        public static final int PORT_FIELD_NUMBER = 2;
        private int port_;
        public static final int INTERNAL_FIELD_NUMBER = 4;
        private boolean internal_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Address DEFAULT_INSTANCE = new Address();
        private static final Parser<Address> PARSER = new AbstractParser<Address>(){

            public Address parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return new Address(input, extensionRegistry);
            }
        };

        private Address(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Address() {
            this.ip_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Address();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        private Address(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            String s = input.readStringRequireUtf8();
                            this.ip_ = s;
                            continue block12;
                        }
                        case 16: {
                            this.port_ = input.readInt32();
                            continue block12;
                        }
                        case 32: {
                            this.internal_ = input.readBool();
                            continue block12;
                        }
                    }
                    if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)this);
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
            }
            finally {
                this.unknownFields = unknownFields.build();
                this.makeExtensionsImmutable();
            }
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_Address_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_Address_fieldAccessorTable.ensureFieldAccessorsInitialized(Address.class, Builder.class);
        }

        @Override
        public String getIp() {
            Object ref = this.ip_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.ip_ = s;
            return s;
        }

        @Override
        public ByteString getIpBytes() {
            Object ref = this.ip_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ip_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getPort() {
            return this.port_;
        }

        @Override
        public boolean getInternal() {
            return this.internal_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.ip_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.ip_);
            }
            if (this.port_ != 0) {
                output.writeInt32(2, this.port_);
            }
            if (this.internal_) {
                output.writeBool(4, this.internal_);
            }
            this.unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.ip_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.ip_);
            }
            if (this.port_ != 0) {
                size += CodedOutputStream.computeInt32Size((int)2, (int)this.port_);
            }
            if (this.internal_) {
                size += CodedOutputStream.computeBoolSize((int)4, (boolean)this.internal_);
            }
            this.memoizedSize = size += this.unknownFields.getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Address)) {
                return super.equals(obj);
            }
            Address other = (Address)obj;
            if (!this.getIp().equals(other.getIp())) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            if (this.getInternal() != other.getInternal()) {
                return false;
            }
            return this.unknownFields.equals((Object)other.unknownFields);
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Address.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getIp().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getPort();
            hash = 37 * hash + 4;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getInternal());
            this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
            return hash;
        }

        public static Address parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data);
        }

        public static Address parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Address parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data);
        }

        public static Address parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Address parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data);
        }

        public static Address parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Address)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Address parseFrom(InputStream input) throws IOException {
            return (Address)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Address parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Address)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Address parseDelimitedFrom(InputStream input) throws IOException {
            return (Address)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Address parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Address)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Address parseFrom(CodedInputStream input) throws IOException {
            return (Address)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Address parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Address)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Address.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Address prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Address getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Address> parser() {
            return PARSER;
        }

        public Parser<Address> getParserForType() {
            return PARSER;
        }

        public Address getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AddressOrBuilder {
            private Object ip_ = "";
            private int port_;
            private boolean internal_;

            public static final Descriptors.Descriptor getDescriptor() {
                return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_Address_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_Address_fieldAccessorTable.ensureFieldAccessorsInitialized(Address.class, Builder.class);
            }

            private Builder() {
                this.maybeForceBuilderInitialization();
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                this.maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (alwaysUseFieldBuilders) {
                    // empty if block
                }
            }

            public Builder clear() {
                super.clear();
                this.ip_ = "";
                this.port_ = 0;
                this.internal_ = false;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AuditLogOuterClass.internal_static_auditlog_v2_RequestMetadata_Address_descriptor;
            }

            public Address getDefaultInstanceForType() {
                return Address.getDefaultInstance();
            }

            public Address build() {
                Address result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Address buildPartial() {
                Address result = new Address(this);
                result.ip_ = this.ip_;
                result.port_ = this.port_;
                result.internal_ = this.internal_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Address) {
                    return this.mergeFrom((Address)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Address other) {
                if (other == Address.getDefaultInstance()) {
                    return this;
                }
                if (!other.getIp().isEmpty()) {
                    this.ip_ = other.ip_;
                    this.onChanged();
                }
                if (other.getPort() != 0) {
                    this.setPort(other.getPort());
                }
                if (other.getInternal()) {
                    this.setInternal(other.getInternal());
                }
                this.mergeUnknownFields(other.unknownFields);
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                Address parsedMessage = null;
                try {
                    parsedMessage = (Address)PARSER.parsePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    parsedMessage = (Address)e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                }
                finally {
                    if (parsedMessage != null) {
                        this.mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            @Override
            public String getIp() {
                Object ref = this.ip_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.ip_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getIpBytes() {
                Object ref = this.ip_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.ip_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setIp(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ip_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearIp() {
                this.ip_ = Address.getDefaultInstance().getIp();
                this.onChanged();
                return this;
            }

            public Builder setIpBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Address.checkByteStringIsUtf8((ByteString)value);
                this.ip_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public int getPort() {
                return this.port_;
            }

            public Builder setPort(int value) {
                this.port_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearPort() {
                this.port_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean getInternal() {
                return this.internal_;
            }

            public Builder setInternal(boolean value) {
                this.internal_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearInternal() {
                this.internal_ = false;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AddressOrBuilder
    extends MessageOrBuilder {
        public String getIp();

        public ByteString getIpBytes();

        public int getPort();

        public boolean getInternal();
    }

    public static enum RequestType implements ProtocolMessageEnum
    {
        HTTP(0),
        GRPC(1),
        UNRECOGNIZED(-1);

        public static final int HTTP_VALUE = 0;
        public static final int GRPC_VALUE = 1;
        private static final Internal.EnumLiteMap<RequestType> internalValueMap;
        private static final RequestType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static RequestType valueOf(int value) {
            return RequestType.forNumber(value);
        }

        public static RequestType forNumber(int value) {
            switch (value) {
                case 0: {
                    return HTTP;
                }
                case 1: {
                    return GRPC;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<RequestType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)RequestType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return RequestType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)RequestMetadata.getDescriptor().getEnumTypes().get(0);
        }

        public static RequestType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != RequestType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private RequestType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<RequestType>(){

                public RequestType findValueByNumber(int number) {
                    return RequestType.forNumber(number);
                }
            };
            VALUES = RequestType.values();
        }
    }
}

