/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logevents.connect;

import com.google.common.base.Throwables;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.logevents.connect.ConnectLogEntry;
import io.confluent.logevents.connect.Context;
import io.confluent.logevents.connect.LogEventState;
import io.confluent.logevents.connect.LogEventsEmitter;
import io.confluent.logevents.connect.Summary;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEvents {
    private static final String CONNECTOR_SOURCE_NAME = "connector";
    private static final String KAFKA_SOURCE_NAME = "kafka";
    private static final String ENVIRONMENT_SOURCE_NAME = "environment";
    private static final Logger log = LoggerFactory.getLogger(LogEvents.class);
    private static final String CCLOUD_METADATA_KAFKA_CLUSTER_ID = "ccloud.metadata.kafka.cluster.id";
    private static final String CCLOUD_METADATA_ENVIRONMENT_ID = "ccloud.metadata.environment.id";
    private static final int LOG_EVENT_MESSAGE_LENGTH_LIMIT = 102400;

    public static void connectorFailedEvent(Supplier<LogEventsEmitter> logEventsEmitterSupplier, Map<String, String> connectorConfig, String connectorId, Throwable cause, Optional<LogEventState> logEventStateOptional) {
        LogEvents.validateArguments(logEventsEmitterSupplier, connectorId, cause, connectorConfig);
        if (!logEventStateOptional.isPresent() || logEventStateOptional.get().logFailureEvent(cause)) {
            LogEvents.emitLogEntry(logEventsEmitterSupplier, connectorId, connectorConfig, cause, EventType.CONNECTOR_FAILED, connectorId);
        } else {
            log.trace("Skipping emission of duplicate Connector failure log event for connector: {}", (Object)connectorId);
        }
    }

    public static void connectorTaskFailedEvent(Supplier<LogEventsEmitter> logEventsEmitterSupplier, Map<String, String> connectorConfig, String connectorId, String taskId, Throwable cause, Optional<LogEventState> logEventStateOptional) {
        LogEvents.validateArguments(logEventsEmitterSupplier, connectorId, cause, connectorConfig);
        Objects.requireNonNull(taskId, "taskId");
        if (!logEventStateOptional.isPresent() || logEventStateOptional.get().logFailureEvent(cause)) {
            LogEvents.emitLogEntry(logEventsEmitterSupplier, connectorId, connectorConfig, cause, EventType.TASK_FAILED, connectorId + "-" + taskId);
        } else {
            log.trace("Skipping emission of Connector Task failure log event for task: {}", (Object)(connectorId + "-" + taskId));
        }
    }

    public static LogEventState createLogEventState(Function<Map.Entry<String, LogEventState>, LogEventState> createLogEventStateIfAbsent, String id, long logFailureEventResetTime) {
        Map.Entry logEventStateEntry = Utils.mkEntry((Object)id, (Object)new LogEventState(id, logFailureEventResetTime, Time.SYSTEM));
        return createLogEventStateIfAbsent.apply(logEventStateEntry);
    }

    private static void validateArguments(Supplier<LogEventsEmitter> logEventsEmitterSupplier, String connectorId, Throwable cause, Map<String, String> connectorConfig) {
        Objects.requireNonNull(logEventsEmitterSupplier, "logEventsEmitterSupplier");
        Objects.requireNonNull(cause, "cause");
        Objects.requireNonNull(connectorId, "connectorId should not be null or empty");
        Objects.requireNonNull(connectorConfig, "connectorConfig should not be null");
    }

    private static void emitLogEntry(Supplier<LogEventsEmitter> connectLogEventsProviderSupplier, String connectorId, Map<String, String> connectorConfig, Throwable cause, EventType eventType, String subject) {
        ConnectLogEntry connectLogEntry = LogEvents.constructLogEntry(connectorId, eventType, cause);
        try {
            connectLogEventsProviderSupplier.get().emit(connectLogEntry, subject, LogEvents.sourceCRN(connectorId, connectorConfig), eventType.toString());
        }
        catch (CrnSyntaxException e) {
            log.error("Unable to create CRN for source: {}. Skipping Connect Log Event {}", (Object)connectorId, (Object)connectLogEntry);
        }
    }

    private static ConnectLogEntry constructLogEntry(String connectorId, EventType eventType, Throwable cause) {
        ConnectLogEntry.Builder logEntryBuilder = ConnectLogEntry.newBuilder();
        Summary.Builder summaryBuilder = Summary.newBuilder();
        switch (eventType) {
            case CONNECTOR_FAILED: 
            case TASK_FAILED: {
                Summary.ConnectorErrorSummary.Builder connectorErrorSummaryBuilder = Summary.ConnectorErrorSummary.newBuilder();
                if (cause.getMessage() != null) {
                    String message = cause.getMessage();
                    connectorErrorSummaryBuilder.setMessage(LogEvents.truncateMessageToLimit(message));
                }
                try {
                    Throwable rootCause = Throwables.getRootCause((Throwable)cause);
                    if (rootCause.getMessage() != null) {
                        String rootCauseMessage = rootCause.getMessage();
                        connectorErrorSummaryBuilder.setRootCause(LogEvents.truncateMessageToLimit(rootCauseMessage));
                    }
                }
                catch (IllegalArgumentException e) {
                    log.warn("Exception loop found, not setting root cause in connect log entry.", (Throwable)e);
                }
                summaryBuilder.setConnectorErrorSummary(connectorErrorSummaryBuilder);
                break;
            }
        }
        logEntryBuilder.setLevel(eventType.level().toString()).setSummary(summaryBuilder).setContext(Context.newBuilder().setConnectorId(connectorId));
        return logEntryBuilder.build();
    }

    private static String truncateMessageToLimit(String message) {
        if (message.length() > 102400) {
            return message.substring(0, 102400);
        }
        return message;
    }

    private static String sourceCRN(String connectorId, Map<String, String> connectorConfig) throws CrnSyntaxException {
        ConfluentResourceName.Builder crnBuilder = ConfluentResourceName.newBuilder().setAuthority("confluent.cloud");
        if (connectorConfig != null && connectorConfig.containsKey(CCLOUD_METADATA_ENVIRONMENT_ID)) {
            crnBuilder.addElement(ENVIRONMENT_SOURCE_NAME, connectorConfig.get(CCLOUD_METADATA_ENVIRONMENT_ID));
        }
        if (connectorConfig != null && connectorConfig.containsKey(CCLOUD_METADATA_KAFKA_CLUSTER_ID)) {
            crnBuilder.addElement(KAFKA_SOURCE_NAME, connectorConfig.get(CCLOUD_METADATA_KAFKA_CLUSTER_ID));
        }
        return crnBuilder.addElement(CONNECTOR_SOURCE_NAME, connectorId).build().toString();
    }

    static enum EventType {
        CONNECTOR_STARTED("ConnectorStarted", Level.INFO),
        CONNECTOR_PAUSED("ConnectorPaused", Level.INFO),
        CONNECTOR_RESUMED("ConnectorResumed", Level.INFO),
        CONNECTOR_FAILED("ConnectorFailed", Level.ERROR),
        CONNECTOR_SHUTDOWN("ConnectorShutdown", Level.INFO),
        CONNECTOR_DELETED("ConnectorDeleted", Level.INFO),
        TASK_FAILED("TaskFailed", Level.ERROR);

        private static final String NAMESPACE_PREFIX = "io.confluent.logevents.connect.";
        private final String canonicalType;
        private final Level level;

        private EventType(String canonicalType, Level level) {
            this.canonicalType = NAMESPACE_PREFIX + canonicalType;
            this.level = level;
        }

        public String toString() {
            return this.canonicalType;
        }

        public Level level() {
            return this.level;
        }

        static enum Level {
            ERROR,
            INFO;

        }
    }
}

