/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import kafka.catalog.LocalStore;
import kafka.catalog.MetadataEventProvider;

public class ZkMetadataEventProvider
implements MetadataEventProvider<String> {
    private final LocalStore localStore;
    private final String logicalCluster;

    public ZkMetadataEventProvider(LocalStore localStore, String logicalCluster) {
        this.localStore = localStore;
        this.logicalCluster = logicalCluster;
    }

    @Override
    public Iterable<String> topicIterable() {
        return this.localStore.topics(this.logicalCluster);
    }

    @Override
    public Iterable<String> clusterLinkIterable() {
        return this.localStore.clusterLinks(this.logicalCluster);
    }

    @Override
    public MetadataEvent getTopicMetadata(String topic) {
        return this.localStore.topicMetadataEvent(topic);
    }

    @Override
    public MetadataEvent getClusterLinkMetadata(String clusterLink) {
        return this.localStore.clusterLinkMetadataEvent(clusterLink);
    }
}

