/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015x!B\u00181\u0011\u00039d!B\u001d1\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%\t\u0001\u0012\u0005\u0007-\u0006\u0001\u000b\u0011B#\t\u000b]\u000bA\u0011\u0001-\t\u000f\t}\u0017\u0001\"\u0003\u0003b\u001a!\u0011\b\r\u0001[\u0011!9wA!b\u0001\n\u0003A\u0007\u0002\u00037\b\u0005\u0003\u0005\u000b\u0011B5\t\u00115<!Q1A\u0005\u00029D\u0001B]\u0004\u0003\u0002\u0003\u0006Ia\u001c\u0005\tg\u001e\u0011)\u0019!C\u0001i\"A\u0001p\u0002B\u0001B\u0003%Q\u000f\u0003\u0005z\u000f\t\u0015\r\u0011\"\u0001{\u0011%\tya\u0002B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u0012\u001d\u0011)\u0019!C\u0001\u0003'A!\"!\f\b\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011)\tyc\u0002BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003{9!\u0011!Q\u0001\n\u0005M\u0002BCA \u000f\t\u0015\r\u0011\"\u0001\u0002B!Q\u0011\u0011K\u0004\u0003\u0002\u0003\u0006I!a\u0011\t\r\u0005;A\u0011AA*\u0011%\t\u0019g\u0002b\u0001\n\u0003\t)\u0007\u0003\u0005\u0002x\u001d\u0001\u000b\u0011BA4\u0011%\tIh\u0002a\u0001\n\u0003\tY\bC\u0005\u0002\u0004\u001e\u0001\r\u0011\"\u0001\u0002\u0006\"A\u0011\u0011S\u0004!B\u0013\ti\bC\u0005\u0002\u001c\u001e\u0001\r\u0011\"\u0001\u0002|!I\u0011QT\u0004A\u0002\u0013\u0005\u0011q\u0014\u0005\t\u0003G;\u0001\u0015)\u0003\u0002~!9\u0011qU\u0004\u0005\u0002\u0005%\u0006bBA[\u000f\u0011\u0005\u0011q\u0017\u0005\b\u0003\u0013<A\u0011AAf\u0011\u001d\t)n\u0002C\u0001\u0003/DqAa\u0002\b\t\u0003\u0011I\u0001C\u0004\u0003.\u001d!\tAa\f\t\u000f\ter\u0001\"\u0001\u0003<!9!qH\u0004\u0005\u0002\t\u0005\u0003b\u0002B&\u000f\u0011\u0005!Q\n\u0005\b\u0005/:A\u0011\u0001B-\u0011\u001d\u0011\tg\u0002C\u0001\u0005GBqAa\u001c\b\t\u0003\u0011\t\b\u0003\u0004\u0003t\u001d!\t\u0005\u0012\u0005\b\u0005k:A\u0011\tB<\u0011\u001d\u0011\u0019i\u0002C\u0001\u0005\u000bCqA!$\b\t\u0013\u0011y)\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;pe*\u0011\u0011GM\u0001\u0006cV|G/\u0019\u0006\u0003gQ\n1bY8pe\u0012Lg.\u0019;pe*\tQ'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0019\u0003!E+x\u000e^1D_>\u0014H-\u001b8bi>\u00148CA\u0001<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aN\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005)\u0005c\u0001$J\u00176\tqI\u0003\u0002I{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005);%aA*fiB\u0011Aj\u0015\b\u0003\u001bF\u0003\"AT\u001f\u000e\u0003=S!\u0001\u0015\u001c\u0002\rq\u0012xn\u001c;?\u0013\t\u0011V(\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*>\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!B1qa2LHcE-\u0003\u0016\ne%1\u0014BY\u0005\u0007\u0014iMa4\u0003R\nu\u0007C\u0001\u001d\b'\u001191hW1\u0011\u0005q{V\"A/\u000b\u0005y#\u0014!B;uS2\u001c\u0018B\u00011^\u0005\u001daunZ4j]\u001e\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u001b\u0002\rM,'O^3s\u0013\t17M\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\tEJ|7.\u001a:JIV\t\u0011\u000e\u0005\u0002=U&\u00111.\u0010\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003-\tXo\u001c;b\u0007>tg-[4\u0016\u0003=\u0004\"\u0001\u000f9\n\u0005E\u0004$AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0002\u0019E,x\u000e^1D_:4\u0017n\u001a\u0011\u0002#E,x\u000e^1Ti\u0006$X-T1oC\u001e,'/F\u0001v!\tAd/\u0003\u0002xa\t\t\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:\u0002%E,x\u000e^1Ti\u0006$X-T1oC\u001e,'\u000fI\u0001\ng\u000eDW\rZ;mKJ,\u0012a\u001f\t\u0004y\u0006-Q\"A?\u000b\u0005y|\u0018\u0001B;uS2T1\u0001ZA\u0001\u0015\r)\u00141\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0013\t1a\u001c:h\u0013\r\ti! \u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003UIg\u000e^3s]\u0006d\u0017\tZ7j]N+\b\u000f\u001d7jKJ,\"!!\u0006\u0011\r\u0005]\u00111EA\u0014\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007y\fyB\u0003\u0002\u0002\"\u0005!!.\u0019<b\u0013\u0011\t)#!\u0007\u0003\u0011M+\b\u000f\u001d7jKJ\u00042AYA\u0015\u0013\r\tYc\u0019\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002-%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5fe\u0002\n\u0011d\u00197vgR,'\u000fT3wK2\fVo\u001c;b\u0007\u0006dGNY1dWV\u0011\u00111\u0007\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0011\u0011g`\u0005\u0005\u0003w\t9DA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AG2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0011\u0011\t\u0005\u0015\u0013QJ\u0007\u0003\u0003\u000fR1AXA%\u0015\u0011\tY%!\u0001\u0002\r\r|W.\\8o\u0013\u0011\ty%a\u0012\u0003\tQKW.Z\u0001\u0006i&lW\r\t\u000b\u00103\u0006U\u0013qKA-\u00037\ni&a\u0018\u0002b!)qM\u0006a\u0001S\")QN\u0006a\u0001_\")1O\u0006a\u0001k\")\u0011P\u0006a\u0001w\"9\u0011\u0011\u0003\fA\u0002\u0005U\u0001bBA\u0018-\u0001\u0007\u00111\u0007\u0005\b\u0003\u007f1\u0002\u0019AA\"\u0003!I7/Q2uSZ,WCAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\na!\u0019;p[&\u001c'\u0002BA9\u0003;\t!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)(a\u001b\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%\u0001\u0010ce>\\WM\u001d+f]\u0006tG\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uCV\u0011\u0011Q\u0010\t\u0004y\u0005}\u0014bAAA{\t!Aj\u001c8h\u0003\t\u0012'o\\6feR+g.\u00198u\u0019&l\u0017\u000e\u001e)s_\u0012,8-\u001a:Rk>$\u0018m\u0018\u0013fcR!\u0011qQAG!\ra\u0014\u0011R\u0005\u0004\u0003\u0017k$\u0001B+oSRD\u0011\"a$\u001b\u0003\u0003\u0005\r!! \u0002\u0007a$\u0013'A\u0010ce>\\WM\u001d+f]\u0006tG\u000fT5nSR\u0004&o\u001c3vG\u0016\u0014\u0018+^8uC\u0002B3aGAK!\ra\u0014qS\u0005\u0004\u00033k$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002=\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LGoQ8ogVlWM])v_R\f\u0017A\t2s_.,'\u000fV3oC:$H*[7ji\u000e{gn];nKJ\fVo\u001c;b?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006\u0005\u0006\"CAH;\u0005\u0005\t\u0019AA?\u0003}\u0011'o\\6feR+g.\u00198u\u0019&l\u0017\u000e^\"p]N,X.\u001a:Rk>$\u0018\r\t\u0015\u0004=\u0005U\u0015!C:fi\u0006\u001bG/\u001b<f)\u0011\t9)a+\t\u000f\u00055v\u00041\u0001\u00020\u00061\u0011m\u0019;jm\u0016\u00042\u0001PAY\u0013\r\t\u0019,\u0010\u0002\b\u0005>|G.Z1o\u0003M9W\r\u001e\"s_.,'/U;pi\u0006d\u0015.\\5u)\u0011\tI,a0\u0011\u0007q\nY,C\u0002\u0002>v\u0012a\u0001R8vE2,\u0007bBAaA\u0001\u0007\u00111Y\u0001\ncV|G/\u0019+za\u0016\u0004B!!\u000e\u0002F&!\u0011qYA\u001c\u0005=\u0019E.[3oiF+x\u000e^1UsB,\u0017\u0001H;qI\u0006$XM\u0011:pW\u0016\u0014H+\u001a8b]R\fVo\u001c;b\u0019&l\u0017\u000e\u001e\u000b\u0007\u0003\u000f\u000bi-!5\t\u000f\u0005=\u0017\u00051\u0001\u0002~\u0005i\u0001O]8ek\u000e,'/U;pi\u0006Dq!a5\"\u0001\u0004\ti(A\u0007d_:\u001cX/\\3s#V|G/Y\u0001\u000eG>l\u0007/\u001e;f#V|G/Y:\u0015\u0011\u0005\u001d\u0015\u0011\\An\u0003oDQa\u001a\u0012A\u0002%Dq!!8#\u0001\u0004\ty.\u0001\u0007rk>$\u0018-\u00128ue&,7\u000f\u0005\u0004\u0002b\u0006-\u0018\u0011\u001f\b\u0005\u0003G\f9OD\u0002O\u0003KL\u0011AP\u0005\u0004\u0003Sl\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003[\fyO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tI/\u0010\t\u0004q\u0005M\u0018bAA{a\tQ\u0012+^8uC\u0016sG/\u001b;z\u0003:$7i\u001c8tk6\u0004H/[8og\"9\u0011\u0011 \u0012A\u0002\u0005m\u0018\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u001da\u0014Q B\u0001\u0003\u000fK1!a@>\u0005%1UO\\2uS>t\u0017\u0007E\u00029\u0005\u0007I1A!\u00021\u0005E\u0011V\r]8siF+x\u000e^1SKN,H\u000e^\u0001\u000eI\u0016\u001c8M]5cKF+x\u000e^1\u0015\t\t-!1\u0005\t\by\t5!\u0011\u0003B\u000f\u0013\r\u0011y!\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\tM!\u0011D\u0007\u0003\u0005+QAAa\u0006\u0002J\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003\u001c\tU!AB#se>\u00148\u000fE\u00029\u0005?I1A!\t1\u0005A\tVo\u001c;b\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003&\r\u0002\rAa\n\u0002\u0017E,x\u000e^1F]RLG/\u001f\t\u0004q\t%\u0012b\u0001B\u0016a\tY\u0011+^8uC\u0016sG/\u001b;z\u0003I\tXo\u001c;bgR{\u0007/[2D_:4\u0017nZ:\u0016\u0005\tE\u0002\u0003\u0002B\u001a\u0005ki!!!\b\n\t\t]\u0012Q\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00049beRLG/[8o\r>\u0014HcA5\u0003>!9!QE\u0013A\u0002\t\u001d\u0012a\u0005<bY&$\u0017\r^3Rk>$\u0018-\u00128uSRLH\u0003\u0002B\"\u0005\u0013\u0002R\u0001\u0010B#\u0005#I1Aa\u0012>\u0005\u0019y\u0005\u000f^5p]\"9!Q\u0005\u0014A\u0002\t\u001d\u0012AC8o\u000b2,7\r^5p]R1\u0011q\u0011B(\u0005'BaA!\u0015(\u0001\u0004I\u0017!F9v_R\fGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0005+:\u0003\u0019A5\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0017!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0004\u0002\b\nm#Q\f\u0005\u0007\u0005#B\u0003\u0019A5\t\u000f\tU\u0003\u00061\u0001\u0003`A!AH!\u0012j\u0003\u001d\u0019H/\u0019:ukB$B!a\"\u0003f!9!qM\u0015A\u0002\t%\u0014\u0001\t:fiJLWM^3Rk>$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R\u0004B\u0001\u0010B6S&\u0019!QN\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014\u0001C:ikR$wn\u001e8\u0015\u0005\u0005\u001d\u0015!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$B!a\"\u0003z!9!1\u0010\u0017A\u0002\tu\u0014!\u00038fo\u000e{gNZ5h!\r\u0011'qP\u0005\u0004\u0005\u0003\u001b'aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u0011q\u0011BD\u0005\u0017CqA!#.\u0001\u0004\u0011i(A\u0005pY\u0012\u001cuN\u001c4jO\"9!1P\u0017A\u0002\tu\u0014AF5t\u00072LWM\u001c;Rk>$\u0018\rV=qKZ\u000bG.\u001b3\u0015\t\u0005=&\u0011\u0013\u0005\u0007\u0005's\u0003\u0019A&\u0002\u0003MDqAa&\u0006\u0001\u0004\u0011i(\u0001\u0004d_:4\u0017n\u001a\u0005\u0006s\u0016\u0001\ra\u001f\u0005\b\u0005;+\u0001\u0019\u0001BP\u0003Y!XM\\1oi6+GO]5dgB+(\r\\5tQ\u0016\u0014\b#\u0002\u001f\u0003F\t\u0005\u0006\u0003\u0002BR\u0005[k!A!*\u000b\t\t\u001d&\u0011V\u0001\b[\u0016$(/[2t\u0015\u0011\u0011Y+!\u0001\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u00030\n\u0015&A\u0006+f]\u0006tG/T3ue&\u001c7\u000fU;cY&\u001c\b.\u001a:\t\u000f\tMV\u00011\u0001\u00036\u0006\u0019R.\u001e7uSR+g.\u00198u\u001b\u0016$\u0018\rZ1uCB)AH!\u0012\u00038B!!\u0011\u0018B`\u001b\t\u0011YLC\u0002\u0003>~\f1\"\\;mi&$XM\\1oi&!!\u0011\u0019B^\u0005MiU\u000f\u001c;j)\u0016t\u0017M\u001c;NKR\fG-\u0019;b\u0011\u001d\u0011)-\u0002a\u0001\u0005\u000f\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002c\u0005\u0013L1Aa3d\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!!\u0005\u0006\u0001\u0004\t)\u0002C\u0004\u00020\u0015\u0001\r!a\r\t\u000f\t\u001dV\u00011\u0001\u0003TB!!Q\u001bBm\u001b\t\u00119N\u0003\u0003\u0003(\u0006%\u0013\u0002\u0002Bn\u0005/\u0014q!T3ue&\u001c7\u000fC\u0004\u0002@\u0015\u0001\r!a\u0011\u0002-E,x\u000e^1D_>\u0014H-\u001b8bi>\u00148i\u001c8gS\u001e$2a\u001cBr\u0011\u001d\u00119J\u0002a\u0001\u0005{\u0002")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile long brokerTenantLimitProducerQuota;
    private volatile long brokerTenantLimitConsumerQuota;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig config, Scheduler scheduler, Option<TenantMetricsPublisher> tenantMetricsPublisher, Option<MultiTenantMetadata> multiTenantMetadata, ReplicaManager replicaManager, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinatorConfig apply_quotaConfig = QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(config);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, tenantMetricsPublisher, multiTenantMetadata, replicaManager, clusterLevelQuotaCallback, metrics, time);
        return new QuotaCoordinator(config.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, internalAdminSupplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public long brokerTenantLimitProducerQuota() {
        return this.brokerTenantLimitProducerQuota;
    }

    public void brokerTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerTenantLimitProducerQuota = x$1;
    }

    public long brokerTenantLimitConsumerQuota() {
        return this.brokerTenantLimitConsumerQuota;
    }

    public void brokerTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerTenantLimitConsumerQuota = x$1;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public double getBrokerQuotaLimit(ClientQuotaType quotaType) {
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            return this.brokerTenantLimitConsumerQuota();
        }
        if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            return this.brokerTenantLimitProducerQuota();
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
    }

    public void updateBrokerTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((IterableOnceOps)quotaEntries.map((Function1 & Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
            this.storeQuotaCallback$1(responseStatus, quotaEntries, responseCallback, invalidQuotaEntries);
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            return new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                scala.collection.immutable.Map brokerQuotaEntries = (scala.collection.immutable.Map)((IterableOnceOps)((IterableOps)((QuotaEntry)((Some)option2).value()).computedQuotas().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        int brokerId = x0$1._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)((MapOps)perBrokerQuotas.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$3(this, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                            if (x0$3 != null) {
                                String quotaType = (String)x0$3._1();
                                QuotaValue quotaValue = (QuotaValue)x0$3._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                            }
                            throw new MatchError(null);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$5(x$2)));
                if (!brokerQuotaEntries.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$6(x$3)))) {
                    return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
                }
                return new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)brokerQuotaEntries));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.consumer.rate'  to be positive");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block5: {
            block4: {
                Integer n = newConfig.confluentConfig().quotasExpirationTimeMs();
                Integer n2 = oldConfig.confluentConfig().quotasExpirationTimeMs();
                if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                    this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
                }
                Long l = newConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                Long l2 = oldConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                if (l != null ? !((Object)l).equals(l2) : l2 != null) break block4;
                Long l3 = newConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                Long l4 = oldConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                if (!(l3 == null ? l4 != null : !((Object)l3).equals(l4))) break block5;
            }
            this.updateBrokerTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()));
            return;
        }
    }

    private boolean isClientQuotaTypeValid(String s) {
        block3: {
            block2: {
                String string = s;
                String string2 = ClientQuotaType.PRODUCE.toString();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = s;
                String string4 = ClientQuotaType.FETCH.toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        if ($this.isClientQuotaTypeValid(quotaConsumption.quotaType())) {
            String valueOf_name = quotaConsumption.quotaType();
            Object var6_4 = null;
            ClientQuotaType clientQuotaType = Enum.valueOf(ClientQuotaType.class, valueOf_name);
            Double clusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(clientQuotaType, CollectionConverters$.MODULE$.MapHasAsJava(quotaEntry$1.quotaEntity().entityTypes()).asJava());
            quotaEntry$1.updateConsumptionAndRecomputeQuotas(brokerId$1, quotaConsumption, Predef$.MODULE$.Double2double(clusterQuotaLimit), $this.getBrokerQuotaLimit(clientQuotaType), $this.time().milliseconds(), $this.quotaConfig().quotasConsumptionExpirationTimeMs(), $this.quotaConfig().quotasRecomputeIntervalMs(), $this.quotaConfig().quotasLazyEvaluationThreshold(), $this.quotaConfig().quotaComputingUsageAdjustment());
            return;
        }
        quotaEntry$1.updateConsumption(brokerId$1, quotaConsumption, $this.time().milliseconds());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((IterableOnceOps)quotaEntries$1.map((Function1 & Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((Map)entityResults.$plus$plus((IterableOnce)invalidQuotaEntries$1))));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$3(QuotaCoordinator $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            String quotaType = (String)x0$2._1();
            return $this.isClientQuotaTypeValid(quotaType);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$5(Tuple2 x$2) {
        return ((IterableOnceOps)x$2._2()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$6(Tuple2 x$3) {
        return ((IterableOnceOps)x$3._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
        this.brokerTenantLimitProducerQuota = quotaConfig.quotasBrokerLimitProducer();
        this.brokerTenantLimitConsumerQuota = quotaConfig.quotasBrokerLimitConsumer();
    }
}

