/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.PartitionLoadScheduler;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$;
import kafka.coordinator.transaction.TransactionLoggingVerbosity$Off$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00115q!B\u001c9\u0011\u0003yd!B!9\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Q\u0005\"B&\u0002\t\u0003a\u0005b\u0002C\u0001\u0003\u0011%A1\u0001\u0005\b\t\u000f\tA\u0011\u0002C\u0005\r\u0011\t\u0005\b\u0001(\t\u0011U3!\u0011!Q\u0001\nYC\u0001\"\u0017\u0004\u0003\u0002\u0003\u0006IA\u0017\u0005\tO\u001a\u0011\t\u0011)A\u0005Q\"AaN\u0002B\u0001B\u0003%q\u000e\u0003\u0005s\r\t\u0005\t\u0015!\u0003t\u0011!1hA!A!\u0002\u00139\b\u0002\u0003@\u0007\u0005\u0003\u0005\u000b\u0011B@\t\r%3A\u0011AA\u0003\u000b\u0019\t)B\u0002\u0003\u0002\u0018\u00151\u0011\u0011\u0006\u0004\u0005\u0003W)a!!\u000f\u0007\t\u0005mRABA5\r\u0011\tY#\u0002\u0004\u0002l\u0019!\u0011Q\u000e\u0005\n\u0003/3!\u0019!C\u0005\u00033C\u0001\"!-\u0007A\u0003%\u00111\u0014\u0005\n\u0003g3!\u0019!C\u0001\u0003kCq!a.\u0007A\u0003%1\u000eC\u0005\u0002:\u001a\u0001\r\u0011\"\u0003\u0002<\"I\u00111\u0019\u0004A\u0002\u0013%\u0011Q\u0019\u0005\t\u0003\u00174\u0001\u0015)\u0003\u0002>\"9\u0011Q\u001b\u0004\u0005\u0002\u0005]\u0007bBAr\r\u0011\u0005\u0011Q\u001d\u0005\n\u0005g1\u0011\u0013!C\u0001\u0005kAqAa\u0013\u0007\t\u0013\u0011i\u0005C\u0004\u0003t\u0019!\tA!\u001e\t\u0013\tee!%A\u0005\u0002\tm\u0005b\u0002BP\r\u0011\u0005!\u0011\u0015\u0005\b\u0005g3A\u0011\u0001B[\u0011\u001d\u0011\tO\u0002C\u0001\u0005GD\u0011Ba=\u0007#\u0003%\tA!\u000e\t\u000f\tUh\u0001\"\u0001\u0003x\"9!q \u0004\u0005\u0002\r\u0005\u0001bBB\u0005\r\u0011%11\u0002\u0005\b\u0007\u001f1A\u0011BB\t\u0011\u001d\u00199D\u0002C\u0001\u0007sA\u0011ba\u0013\u0007#\u0003%\tA!\u000e\t\u000f\r5c\u0001\"\u0003\u0004P!91q\u000b\u0004\u0005\n\re\u0003bBB4\r\u0011%1\u0011\u000e\u0005\b\u0007_2A\u0011BB9\u0011\u001d\u0019\tI\u0002C\u0001\u0007\u0007Cqa!$\u0007\t\u0003\u0019y\tC\u0004\u0004\u0012\u001a!\taa%\t\u000f\r]e\u0001\"\u0003\u0004\u001a\"A11\u0016\u0004\u0005\u0002a\u001ai\u000bC\u0004\u00046\u001a!\taa.\t\u0013\r\rg!%A\u0005\u0002\r\u0015\u0007bBBe\r\u0011\u000511Z\u0001\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe*\u0011\u0011HO\u0001\fiJ\fgn]1di&|gN\u0003\u0002<y\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005i\u0014!B6bM.\f7\u0001\u0001\t\u0003\u0001\u0006i\u0011\u0001\u000f\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;peN\u0011\u0011a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0014!B1qa2LHcD'\u0004N\u000e]7\u0011]Br\u0007O\u001c)pa@\u0011\u0005\u000131c\u0001\u0004D\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!\u000bP\u0001\u0006kRLGn]\u0005\u0003)F\u0013q\u0001T8hO&tw-A\u0005uq:\u001cuN\u001c4jOB\u0011\u0001iV\u0005\u00031b\u0012\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002\\K6\tAL\u0003\u0002^=\u0006!Q\u000f^5m\u0015\ty\u0006-\u0001\u0004tKJ4XM\u001d\u0006\u0003{\u0005T!AY2\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0017aA8sO&\u0011a\r\u0018\u0002\n'\u000eDW\rZ;mKJ\fqc\u0019:fCR,\u0007K]8ek\u000e,'/\u00133NC:\fw-\u001a:\u0011\u0007\u0011K7.\u0003\u0002k\u000b\nIa)\u001e8di&|g\u000e\r\t\u0003\u00012L!!\u001c\u001d\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"\u0001\u00119\n\u0005ED$a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002Ai&\u0011Q\u000f\u000f\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"\u0001\u001f?\u000e\u0003eT!A\u0015>\u000b\u0005m\u0004\u0017AB2p[6|g.\u0003\u0002~s\n!A+[7f\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u0004q\u0006\u0005\u0011bAA\u0002s\nQAj\\4D_:$X\r\u001f;\u0015\u001f5\u000b9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'AQ!\u0016\bA\u0002YCQ!\u0017\bA\u0002iCQa\u001a\bA\u0002!DQA\u001c\bA\u0002=DQA\u001d\bA\u0002MDQA\u001e\bA\u0002]DQA \bA\u0002}\u0014a#\u00138jiB\u0013x\u000eZ;dKJLEmQ1mY\n\f7m\u001b\t\b\t\u0006e\u0011QDA\u0012\u0013\r\tY\"\u0012\u0002\n\rVt7\r^5p]F\u00022\u0001QA\u0010\u0013\r\t\t\u0003\u000f\u0002\u0015\u0013:LG\u000f\u0015:pIV\u001cWM]%e%\u0016\u001cX\u000f\u001c;\u0011\u0007\u0011\u000b)#C\u0002\u0002(\u0015\u0013A!\u00168ji\n)\u0012\t\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0002#\u0002\u001a\u00055\u00121\u0005\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007>\u0002\u0011A\u0014x\u000e^8d_2LA!a\u000e\u00022\t1QI\u001d:peN\u0014\u0001DV3sS\u001aL\b+\u0019:uSRLwN\\:DC2d'-Y2l!\u001d!\u0015\u0011DA\u001f\u0003G\u0001B!a\u0010\u0002d9!\u0011\u0011IA/\u001d\u0011\t\u0019%!\u0017\u000f\t\u0005\u0015\u0013q\u000b\b\u0005\u0003\u000f\n)F\u0004\u0003\u0002J\u0005Mc\u0002BA&\u0003#j!!!\u0014\u000b\u0007\u0005=c(\u0001\u0004=e>|GOP\u0005\u0002I&\u0011!mY\u0005\u0003{\u0005L!a\u001f1\n\u0007\u0005m#0A\u0004nKN\u001c\u0018mZ3\n\t\u0005}\u0013\u0011M\u0001\u001f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChNU3ta>t7/\u001a#bi\u0006T1!a\u0017{\u0013\u0011\t)'a\u001a\u00031\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fgVdGO\u0003\u0003\u0002`\u0005\u0005$AD#oIRChnQ1mY\n\f7m\u001b\u0002\n\u0003BL'+Z:vYR,B!a\u001c\u0002\u0006BA\u0011\u0011OA>\u0003[\t\tI\u0004\u0003\u0002t\u0005]d\u0002BA&\u0003kJ\u0011AR\u0005\u0004\u0003s*\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyH\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003s*\u0005\u0003BAB\u0003\u000bc\u0001\u0001B\u0004\u0002\bN\u0011\r!!#\u0003\u0003Q\u000bB!a#\u0002\u0012B\u0019A)!$\n\u0007\u0005=UIA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\u000b\u0019*C\u0002\u0002\u0016\u0016\u00131!\u00118z\u0003!I7/Q2uSZ,WCAAN!\u0011\ti*!,\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000ba!\u0019;p[&\u001c'\u0002BAS\u0003O\u000b!bY8oGV\u0014(/\u001a8u\u0015\ri\u0016\u0011\u0016\u0006\u0003\u0003W\u000bAA[1wC&!\u0011qVAP\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006I\u0011n]!di&4X\rI\u0001\u0012aJ|G-^2fe&#W*\u00198bO\u0016\u0014X#A6\u0002%A\u0014x\u000eZ;dKJLE-T1oC\u001e,'\u000fI\u0001\rY><g+\u001a:c_NLG/_\u000b\u0003\u0003{\u00032\u0001QA`\u0013\r\t\t\r\u000f\u0002\u001c)J\fgn]1di&|g\u000eT8hO&twMV3sE>\u001c\u0018\u000e^=\u0002!1|wMV3sE>\u001c\u0018\u000e^=`I\u0015\fH\u0003BA\u0012\u0003\u000fD\u0011\"!3\u001a\u0003\u0003\u0005\r!!0\u0002\u0007a$\u0013'A\u0007m_\u001e4VM\u001d2pg&$\u0018\u0010\t\u0015\u00045\u0005=\u0007c\u0001#\u0002R&\u0019\u00111[#\u0003\u0011Y|G.\u0019;jY\u0016\f1c]3u\u0019><w-\u001b8h-\u0016\u0014(m\\:jif$B!a\t\u0002Z\"9\u00111\\\u000eA\u0002\u0005u\u0017!\u00027fm\u0016d\u0007c\u0001#\u0002`&\u0019\u0011\u0011]#\u0003\u0007%sG/\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\u0011\u0003G\t9/a?\u0002\u0000\n%!Q\u0002B\u000f\u0005KAq!!;\u001d\u0001\u0004\tY/A\bue\u0006t7/Y2uS>t\u0017\r\\%e!\u0011\ti/!>\u000f\t\u0005=\u0018\u0011\u001f\t\u0004\u0003\u0017*\u0015bAAz\u000b\u00061\u0001K]3eK\u001aLA!a>\u0002z\n11\u000b\u001e:j]\u001eT1!a=F\u0011\u001d\ti\u0010\ba\u0001\u0003;\fA\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi6\u001b\bb\u0002B\u00019\u0001\u0007!1A\u0001\u0010K:\f'\r\\3Uo>\u00046I\u00127bOB\u0019AI!\u0002\n\u0007\t\u001dQIA\u0004C_>dW-\u00198\t\u000f\t-A\u00041\u0001\u0003\u0004\u0005y1.Z3q!J,\u0007/\u0019:fIRCh\u000eC\u0004\u0003\u0010q\u0001\rA!\u0005\u00025\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0011\u000b\u0011\u0013\u0019Ba\u0006\n\u0007\tUQI\u0001\u0004PaRLwN\u001c\t\u0004q\ne\u0011b\u0001B\u000es\n\u0011\u0002K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i\u0011\u001d\u0011y\u0002\ba\u0001\u0005C\t\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\t\rr\"D\u0001\u0007\u0011%\u00119\u0003\bI\u0001\u0002\u0004\u0011I#\u0001\u0007sKF,Xm\u001d;M_\u000e\fG\u000e\u0005\u0003\u0003,\t=RB\u0001B\u0017\u0015\tyF(\u0003\u0003\u00032\t5\"\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017A\b5b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u00119D\u000b\u0003\u0003*\te2F\u0001B\u001e!\u0011\u0011iDa\u0012\u000e\u0005\t}\"\u0002\u0002B!\u0005\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015S)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0013\u0003@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029A\u0014X\r]1sK&s\u0017\u000e\u001e)s_\u0012,8-\u001a:JIR\u0013\u0018M\\:jiRq!q\nB/\u0005?\u0012\tGa\u0019\u0003h\tE\u0004#\u0002B\u0012'\tE\u0003c\u0002#\u0003T\u0005u'qK\u0005\u0004\u0005+*%A\u0002+va2,'\u0007E\u0002A\u00053J1Aa\u00179\u0005I!\u0006P\u001c+sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\t\u000f\u0005%h\u00041\u0001\u0002l\"9\u0011Q \u0010A\u0002\u0005u\u0007b\u0002B\u0006=\u0001\u0007!1\u0001\u0005\b\u0005Kr\u0002\u0019AAo\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0004\u0003jy\u0001\rAa\u001b\u0002\u0017QDh.T3uC\u0012\fG/\u0019\t\u0004\u0001\n5\u0014b\u0001B8q\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"9!q\u0002\u0010A\u0002\tE\u0011A\u00065b]\u0012dW\rT5tiR\u0013\u0018M\\:bGRLwN\\:\u0015\u0011\t]$q\u0010BH\u0005+\u0003BA!\u001f\u0003|5\u0011\u0011\u0011M\u0005\u0005\u0005{\n\tG\u0001\u000fMSN$HK]1og\u0006\u001cG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\t\u0005u\u00041\u0001\u0003\u0004\u0006\u0019b-\u001b7uKJ,G\r\u0015:pIV\u001cWM]%egB1\u0011Q\u001eBC\u0005\u0013KAAa\"\u0002z\n\u00191+\u001a;\u0011\u0007\u0011\u0013Y)C\u0002\u0003\u000e\u0016\u0013A\u0001T8oO\"9!\u0011S\u0010A\u0002\tM\u0015A\u00044jYR,'/\u001a3Ti\u0006$Xm\u001d\t\u0007\u0003[\u0014))a;\t\u0013\t]u\u0004%AA\u0002\t%\u0015\u0001\u00054jYR,'/\u001a3EkJ\fG/[8o\u0003\u0001B\u0017M\u001c3mK2K7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu%\u0006\u0002BE\u0005s\t!\u0004[1oI2,G)Z:de&\u0014W\r\u0016:b]N\f7\r^5p]N$BAa)\u00032B!!Q\u0015BV\u001d\u0011\u0011IHa*\n\t\t%\u0016\u0011M\u0001!\t\u0016\u001c8M]5cKR\u0013\u0018M\\:bGRLwN\\:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0003.\n=&\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0015\u0011\u0011I+!\u0019\t\u000f\u0005%\u0018\u00051\u0001\u0002l\u0006\u0019\u0003.\u00198eY\u00164VM]5gsB\u000b'\u000f^5uS>t7/\u00138Ue\u0006t7/Y2uS>tG\u0003DA\u0012\u0005o\u0013IL!0\u0003H\nu\u0007bBAuE\u0001\u0007\u00111\u001e\u0005\b\u0005w\u0013\u0003\u0019\u0001BE\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\b\u0005\u007f\u0013\u0003\u0019\u0001Ba\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019AIa1\n\u0007\t\u0015WIA\u0003TQ>\u0014H\u000fC\u0004\u0003J\n\u0002\rAa3\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0003N\nM'Q[\u0007\u0003\u0005\u001fT1A!5F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\u0013y\r\u0005\u0003\u0003X\neW\"\u0001>\n\u0007\tm'P\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\t}!\u00051\u0001\u0003`B\u0019!1E\t\u0002A!\fg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_R\u0013\u0018M\\:bGRLwN\u001c\u000b\u000f\u0003G\u0011)Oa:\u0003j\n-(Q\u001eBy\u0011\u001d\tIo\ta\u0001\u0003WDqAa/$\u0001\u0004\u0011I\tC\u0004\u0003@\u000e\u0002\rA!1\t\u000f\t%7\u00051\u0001\u0003L\"9!qD\u0012A\u0002\t=\bc\u0001B\u0012!!I!qE\u0012\u0011\u0002\u0003\u0007!\u0011F\u0001+Q\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)J\fgn]1di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0003)yg.\u00127fGRLwN\u001c\u000b\u0007\u0003G\u0011IP!@\t\u000f\tmX\u00051\u0001\u0002^\u0006\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\"9!QM\u0013A\u0002\u0005u\u0017!D8o%\u0016\u001c\u0018n\u001a8bi&|g\u000e\u0006\u0004\u0002$\r\r1Q\u0001\u0005\b\u0005w4\u0003\u0019AAo\u0011\u001d\u0011)G\na\u0001\u0007\u000f\u0001R\u0001\u0012B\n\u0003;\fq\"[:BI\u0012LgnZ(gMN,Go\u001d\u000b\u0005\u0005\u0007\u0019i\u0001C\u0004\u0003J\u001e\u0002\rAa3\u0002O1|w-\u00138wC2LGm\u0015;bi\u0016$&/\u00198tSRLwN\\!oIJ+G/\u001e:o\u000bJ\u0014xN\u001d\u000b\t\u0007'\u0019iba\b\u0004(AA1QCB\r\u0003[\tY)\u0004\u0002\u0004\u0018)\u0011Q,R\u0005\u0005\u00077\u00199B\u0001\u0003MK\u001a$\bbBAuQ\u0001\u0007\u00111\u001e\u0005\b\u0007CA\u0003\u0019AB\u0012\u0003A!(/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rE\u0002A\u0007KI1A!,9\u0011\u001d\u0019I\u0003\u000ba\u0001\u0007W\t\u0011\u0003\u001e:b]N\f7\r^5p]J+7/\u001e7u!\u0011\u0019ica\r\u000e\u0005\r=\"bAB\u0019u\u0006A!/Z9vKN$8/\u0003\u0003\u00046\r=\"!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006!\u0002.\u00198eY\u0016,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$b\"a\t\u0004<\ru2qHB!\u0007\u000b\u001aI\u0005C\u0004\u0002j&\u0002\r!a;\t\u000f\tm\u0016\u00061\u0001\u0003\n\"9!qX\u0015A\u0002\t\u0005\u0007bBB\"S\u0001\u000711F\u0001\u0010ibtW*\u0019:lKJ\u0014Vm];mi\"9!qD\u0015A\u0002\r\u001d\u0003c\u0001B\u0012%!I!qE\u0015\u0011\u0002\u0003\u0007!\u0011F\u0001\u001fQ\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIY\na#\\1zE\u0016dun\u001a,fe\n|7/Z'fgN\fw-\u001a\u000b\u0005\u0003G\u0019\t\u0006C\u0004\u0004T-\u0002\ra!\u0016\u0002\u0019\t,\u0018\u000e\u001c3NKN\u001c\u0018mZ3\u0011\u000f\u0011\u000bI\"!0\u0002l\u00069Bn\\4Uq:\u0004&/\u001a9be\u0016\u001cu.\u001c9mKRLwN\u001c\u000b\t\u0003G\u0019Yfa\u0018\u0004d!91Q\f\u0017A\u0002\t-\u0014\u0001C7fi\u0006$\u0017\r^1\t\u000f\r\u0005D\u00061\u0001\u0004,\u00051!/Z:vYRDqa!\u001a-\u0001\u0004\u0011\u0019!\u0001\u0007jg\u001a\u0013x.\\\"mS\u0016tG/\u0001\tm_\u001e$\u0006P\\\"p[BdW\r^5p]R1\u00111EB6\u0007[Bqa!\u0018.\u0001\u0004\u0011Y\u0007C\u0004\u0004b5\u0002\raa\u000b\u0002\u001d\u0015tG\r\u0016:b]N\f7\r^5p]R\u0001\u00121EB:\u0007k\u001a9h!\u001f\u0004|\ru4q\u0010\u0005\b\u0003St\u0003\u0019AAv\u0011\u001d\u0011YL\fa\u0001\u0005\u0013CqAa0/\u0001\u0004\u0011\t\rC\u0004\u0004D9\u0002\raa\u000b\t\u000f\r\u0015d\u00061\u0001\u0003\u0004!9!q\u0004\u0018A\u0002\r\u001d\u0003b\u0002B\u0014]\u0001\u0007!\u0011F\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"a!\"\u0011\t\r\u001d5\u0011R\u0007\u0003\u0003OKAaa#\u0002(\nQ\u0001K]8qKJ$\u0018.Z:\u0002)Ad\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;t+\t\tY/\u0001\u0007qCJ$\u0018\u000e^5p]\u001a{'\u000f\u0006\u0003\u0002^\u000eU\u0005bBAuc\u0001\u0007\u00111^\u0001\u0019_:,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\u001cu.\u001c9mKR,G\u0003BBN\u0007C#B!a\t\u0004\u001e\"91q\u0014\u001aA\u0002\u00055\u0012!B3se>\u0014\bbBBRe\u0001\u00071QU\u0001\u0011ibt\u0017\nZ!oIBKG-\u00129pG\"\u00042\u0001QBT\u0013\r\u0019I\u000b\u000f\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001aC\n|'\u000f\u001e+j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u0002$\r=\u0006bBBYg\u0001\u000711W\u0001\u000b_:\u001cu.\u001c9mKR,\u0007c\u0002#\u0002\u001a\r\u00156qI\u0001\bgR\f'\u000f^;q)\u0019\t\u0019c!/\u0004@\"911\u0018\u001bA\u0002\ru\u0016A\n:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiB!A)[Ao\u0011%\u0019\t\r\u000eI\u0001\u0002\u0004\u0011\u0019!A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\f\u0011c\u001d;beR,\b\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199M\u000b\u0003\u0003\u0004\te\u0012\u0001C:ikR$wn\u001e8\u0015\u0005\u0005\r\u0002bBBh\u0007\u0001\u00071\u0011[\u0001\u0007G>tg-[4\u0011\t\t-21[\u0005\u0005\u0007+\u0014iCA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bBBm\u0007\u0001\u000711\\\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\u0011Yc!8\n\t\r}'Q\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015I6\u00011\u0001[\u0011\u0019\u0019)o\u0001a\u0001Q\u0006I2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\nZ$f]\u0016\u0014\u0018\r^8s\u0011\u001d\u0019Io\u0001a\u0001\u0007W\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0004n\u000eEXBABx\u0015\r\u0019IO_\u0005\u0005\u0007g\u001cyOA\u0004NKR\u0014\u0018nY:\t\u000f\r]8\u00011\u0001\u0004z\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BAa\u000b\u0004|&!1Q B\u0017\u00055iU\r^1eCR\f7)Y2iK\")ao\u0001a\u0001o\u0006!\u0012N\\5u)J\fgn]1di&|g.\u0012:s_J$B!!\b\u0005\u0006!91q\u0014\u0003A\u0002\u00055\u0012aF5oSR$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b)\u0011\ti\u0002b\u0003\t\u000f\t%T\u00011\u0001\u0003X\u0001")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private volatile TransactionLoggingVerbosity logVerbosity;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig config, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdGenerator, Metrics metrics, MetadataCache metadataCache, Time time) {
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(config.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(config.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(config.transactionTopicPartitions()), Predef$.MODULE$.Short2short(config.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(config.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(config.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(config.transactionTopicMinISR()), (String)config.transactionTopicPlacementConstraints().map(TransactionCoordinator$::$anonfun$apply$1).getOrElse(TransactionCoordinator$::$anonfun$apply$2), Predef$.MODULE$.Integer2int(config.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), Predef$.MODULE$.Integer2int(config.transactionMetadataLoadThreads()), Predef$.MODULE$.Integer2int(config.transactions2PcTimeoutMs()), TransactionLoggingVerbosity$.MODULE$.fromLevel(config.confluentConfig().transactionLoggingVerbosity()));
        PartitionLoadScheduler apply_loadScheduler = new PartitionLoadScheduler(Predef$.MODULE$.Integer2int(config.transactionMetadataLoadThreads()), "transaction-state-manager-loader");
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(config.brokerId(), scheduler, apply_loadScheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(config.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(apply_txnConfig, scheduler, createProducerIdGenerator, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    private TransactionLoggingVerbosity logVerbosity() {
        return this.logVerbosity;
    }

    private void logVerbosity_$eq(TransactionLoggingVerbosity x$1) {
        this.logVerbosity = x$1;
    }

    public void setLoggingVerbosity(int level) {
        this.logVerbosity_$eq(TransactionLoggingVerbosity$.MODULE$.fromLevel(level));
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, boolean enableTwoPCFlag, boolean keepPreparedTxn, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            Try<Object> try_ = this.producerIdManager().generateProducerId();
            if (try_ instanceof Success) {
                long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.forException((Throwable)exception);
                Object var35_11 = null;
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
                return;
            }
            throw new MatchError(try_);
        }
        if (transactionalId.isEmpty()) {
            Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.INVALID_REQUEST;
            Object var36_12 = null;
            responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(enableTwoPCFlag, transactionTimeoutMs)) {
            Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.INVALID_TRANSACTION_TIMEOUT;
            Object var37_13 = null;
            responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
            return;
        }
        int resolvedTxnTimeoutMs = enableTwoPCFlag ? Integer.MAX_VALUE : transactionTimeoutMs;
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                Try<Object> try_ = this.producerIdManager().generateProducerId();
                if (try_ instanceof Success) {
                    long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                    Empty$ x$7 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$8 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
                    long x$9 = $this.time.milliseconds();
                    long x$10 = -1L;
                    TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, -1L, -1, -1, resolvedTxnTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, x$10, x$9);
                    return $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
                }
                if (try_ instanceof Failure) {
                    Throwable exception = ((Failure)try_).exception();
                    return new Left((Object)Errors.forException((Throwable)exception));
                }
                throw new MatchError(try_);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                return new Right((Object)epochAndTxnMetadata);
            }
            throw new MatchError(x0$1);
        }).flatMap((Function1 & Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, resolvedTxnTimeoutMs, keepPreparedTxn, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_2 = (BoxedUnit)responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (transactionState != null && transactionState.equals(prepareEpochFence$)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable intersect = (Function1 & Serializable)error -> {
                    TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, errors));
                        return;
                    }
                    Errors sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
                    Object var40_30 = null;
                    responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, errors));
                        return;
                    }
                    Errors sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
                    Object var42_34 = null;
                    responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable x$14 = (Function1 & Serializable)error -> {
                this.sendPidResponseCallback$1(error, transactionalId, newMetadata, responseCallback);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleInitProducerId$default$7() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, boolean keepPreparedTxn, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        if (txnMetadata.pendingTransitionInProgress()) {
            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return new Left((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        if (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState)) {
            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState))) {
            Right transitMetadataResult;
            Right right;
            if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$2)))) {
                Try<Object> try_ = this.producerIdManager().generateProducerId();
                if (try_ instanceof Success) {
                    long producerId = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
                    right = new Right((Object)txnMetadata.prepareProducerIdRotation(producerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    if (!(try_ instanceof Failure)) throw new MatchError(try_);
                    Throwable exception = ((Failure)try_).exception();
                    right = new Left((Object)Errors.forException((Throwable)exception));
                }
            } else {
                right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToShort((short)x$3.epoch)), this.time.milliseconds());
            }
            if (transitMetadataResult instanceof Right) {
                TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
            }
            if (!(transitMetadataResult instanceof Left)) throw new MatchError((Object)transitMetadataResult);
            Errors err = (Errors)((Left)transitMetadataResult).value();
            return new Left((Object)err);
        }
        if (Ongoing$.MODULE$.equals(transactionState)) {
            if (!txnMetadata.isDistributedTwoPhaseCommitTxn() || !keepPreparedTxn) return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            TxnTransitMetadata txnTransitMetadata = txnMetadata.prepareTransitionTo(txnMetadata.state(), txnMetadata.producerId(), txnMetadata.producerEpoch(), txnMetadata.lastProducerEpoch(), txnMetadata.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)txnMetadata.topicPartitions().toSet(), txnMetadata.txnStartTimestamp(), txnMetadata.txnLastUpdateTimestamp());
            return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnTransitMetadata));
        }
        if (!(Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState))) throw new MatchError((Object)transactionState);
        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
        this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
        throw new IllegalStateException(errorMsg);
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates, long filteredDuration) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates, filteredDuration);
    }

    public long handleListTransactions$default$3() {
        return -1L;
    }

    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        Option option;
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Errors error = (Errors)((Left)either).value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0 & Serializable)() -> {
                TransactionState transactionState = txnMetadata.state();
                Dead$ dead$ = Dead$.MODULE$;
                if (transactionState != null && transactionState.equals(dead$)) {
                    return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
                }
                txnMetadata.topicPartitions().foreach((Function1 & Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
                return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().name()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
            });
        }
        throw new MatchError(either);
    }

    public void handleVerifyPartitionsInTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<AddPartitionsToTxnResponseData.AddPartitionsToTxnResult, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)partitions.map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Errors.INVALID_REQUEST))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    block6: {
                        block5: {
                            if (txnMetadata.producerId() != producerId) {
                                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return new Left((Object)Errors.PRODUCER_FENCED);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (transactionState != null && transactionState.equals(prepareCommit$)) break block5;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) break block6;
                        }
                        return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    return new Right((Object)((IterableOnceOps)partitions.map((Function1 & Serializable)part -> {
                        if (txnMetadata.topicPartitions().contains(part)) {
                            return new Tuple2(part, (Object)Errors.NONE);
                        }
                        return new Tuple2(part, (Object)Errors.TRANSACTION_ABORTABLE);
                    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                });
            }
            throw new MatchError(x0$1);
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request for verification").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)partitions.map((Function1 & Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)err))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()));
            return;
        }
        if (result instanceof Right) {
            scala.collection.immutable.Map errors = (scala.collection.immutable.Map)((Right)result).value();
            BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback.apply((Object)AddPartitionsToTxnResponse.resultForTransaction((String)transactionalId, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)errors).asJava()));
            return;
        }
        throw new MatchError((Object)result);
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    block9: {
                        block8: {
                            if (txnMetadata.producerId() != producerId) {
                                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return new Left((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (transactionState != null && transactionState.equals(prepareCommit$)) break block8;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) break block9;
                        }
                        return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    if (txnMetadata.isDistributedTwoPhaseCommitTxn() && this.isAddingOffsets(partitions)) {
                        return new Left((Object)Errors.INVALID_REQUEST);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (transactionState != null && transactionState.equals(ongoing$) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return new Left((Object)Errors.NONE);
                    }
                    return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            }
            throw new MatchError(x0$1);
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private boolean isAddingOffsets(Set<TopicPartition> partitions) {
        return partitions.exists((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$isAddingOffsets$1(tp)));
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return new Left((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return new Left((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null || !object.equals(prepareEpochFence$)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : (nextState = PrepareAbort$.MODULE$);
                        if (nextState.equals(PrepareAbort$.MODULE$) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        this.logTxnPrepareCompletion(txnMetadata, txnMarkerResult, endTransaction_isFromClient);
                        return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    }
                    if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            return new Left((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                            return new Left((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Empty$.MODULE$.equals(transactionState)) {
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                });
            }
            throw new MatchError(x0$1);
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable endTransaction_x$4 = (Function1 & Serializable)error -> {
                this.sendTxnMarkersCallback$1(error, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public RequestLocal handleEndTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private void maybeLogVerboseMessage(Function1<TransactionLoggingVerbosity, String> buildMessage) {
        TransactionLoggingVerbosity verbosity;
        TransactionLoggingVerbosity transactionLoggingVerbosity = verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (transactionLoggingVerbosity != null && transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void logTxnPrepareCompletion(TransactionMetadata metadata, TransactionResult result, boolean isFromClient) {
        TransactionLoggingVerbosity maybeLogVerboseMessage_verbosity;
        Function1 & Serializable maybeLogVerboseMessage_buildMessage = (Function1 & Serializable)verbosity -> {
            String reason = isFromClient ? "client EndTxn request" : "transaction timeout";
            return new StringBuilder(33).append("Prepare ").append(result).append(" of transaction due to ").append(reason).append(": ").append(metadata.toString((TransactionLoggingVerbosity)verbosity)).toString();
        };
        TransactionLoggingVerbosity transactionLoggingVerbosity = maybeLogVerboseMessage_verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (transactionLoggingVerbosity != null && transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void logTxnCompletion(TransactionMetadata metadata, TransactionResult result) {
        TransactionLoggingVerbosity maybeLogVerboseMessage_verbosity;
        Function1 & Serializable maybeLogVerboseMessage_buildMessage = (Function1 & Serializable)verbosity -> new StringBuilder(26).append("Complete ").append(result).append(" of transaction: ").append(metadata.toString((TransactionLoggingVerbosity)verbosity)).toString();
        TransactionLoggingVerbosity transactionLoggingVerbosity = maybeLogVerboseMessage_verbosity = this.logVerbosity();
        TransactionLoggingVerbosity$Off$ transactionLoggingVerbosity$Off$ = TransactionLoggingVerbosity$Off$.MODULE$;
        if (transactionLoggingVerbosity != null && transactionLoggingVerbosity.equals(transactionLoggingVerbosity$Off$)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> (String)buildMessage.apply((Object)verbosity));
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            if (None$.MODULE$.equals(x0$1)) {
                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            }
            if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                return (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return new Left((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null || !object.equals(prepareEpochFence$)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : (nextState = PrepareAbort$.MODULE$);
                        if (nextState.equals(PrepareAbort$.MODULE$) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        this.logTxnPrepareCompletion(txnMetadata, txnMarkerResult, endTransaction_isFromClient);
                        return new Right((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    }
                    if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.COMMIT);
                            return new Left((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null)) {
                            this.logTxnCompletion(txnMetadata, TransactionResult.ABORT);
                            return new Left((Object)Errors.NONE);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        if (!(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null)) {
                            return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Empty$.MODULE$.equals(transactionState)) {
                        return this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    }
                    if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                });
            }
            throw new MatchError(x0$1);
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
                this.sendTxnMarkersCallback$1(error, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public String placementConstraints() {
        return this.txnManager.placementConstraints();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.txnManager.transactionTimeoutSensor().record();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Completed rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString());
            return;
        }
        if (Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error))) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("has been cancelled due to error ").append(error).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").append("failed due to error ").append(error).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable)txnIdAndPidEpoch -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$1(this, onComplete, txnIdAndPidEpoch);
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", () -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable)txnIdAndPidEpoch -> (Function1 & Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs(), (long)this.txnConfig.abortTimedOutTransactionsIntervalMs());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, error));
            return;
        }
        Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
        Object var3_3 = null;
        responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId$1).append(" with producerId ").append(newMetadata$1.producerId()).append(" and producer ").append("epoch ").append(newMetadata$1.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId$1)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId$1).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$2) {
        return x$2.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData);
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ boolean $anonfun$isAddingOffsets$1(TopicPartition tp) {
        String string = tp.topic();
        String string2 = "__consumer_offsets";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$5, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$5).append(", but there is ").append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(166).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$5).append(" to the transaction log ").append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$5, int coordinatorEpoch$6, long producerId$3, short producerEpoch$3, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$5).flatMap((Function1 & Serializable)x0$1 -> {
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$5).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        return (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                            if (txnMetadata.producerId() != producerId$3) {
                                return new Left((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch$3) {
                                return new Left((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return new Left((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            if (Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)))) {
                                return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                if (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                                }
                                return new Right((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                if (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) {
                                    return this.logInvalidStateTransitionAndReturnError(transactionalId$5, txnMetadata.state(), txnMarkerResult$1);
                                }
                                return new Right((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState)) {
                                String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$5).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                                this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                                throw new IllegalStateException(errorMsg);
                            }
                            throw new MatchError((Object)transactionState);
                        });
                    }
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").append("successfully appended to the log for ").append(transactionalId$5).append(" with old epoch ").append(coordinatorEpoch$6).toString());
                    return new Left((Object)Errors.NOT_COORDINATOR);
                }
                throw new MatchError(x0$1);
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult$1).append(" to transaction log and returning ").append(err).append(" error to client for ").append(transactionalId$5).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId$5).append("'s EndTransaction request of ").append(txnMarkerResult$1).append(", ").append("since appending ").append(newMetadata$2).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch$6).append(" failed").toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$5).foreach((Function1 & Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId$5, coordinatorEpoch$6, error, newMetadata$2, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").append("pending state transition").toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.isDistributedTwoPhaseCommitTxn()) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Aborting 2PC transaction ").append(txnMetadata.transactionalId()).toString());
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable)txnTransitMetadata -> {
                $this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), RequestLocal$.MODULE$.NoCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable)x0$1 -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$2($this, txnIdAndPidEpoch, onComplete$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = (ProducerIdManager)createProducerIdManager.apply();
        this.logVerbosity = txnConfig.transactionLoggingVerbosity();
    }
}

