/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization.validation;

import java.io.Serializable;
import kafka.durability.DurabilityAuditMirrorState;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.broker.DestLogEpochChangeEvent;
import kafka.durability.events.broker.EpochChangeEvent;
import kafka.durability.events.broker.RetentionType$;
import kafka.durability.events.broker.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.validation.AbstractValidator;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.state.SegmentState;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\t}d\u0001\u0002\u0015*\u0001IB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0013\tC\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0013\"A!\n\u0001B\u0001B\u0003%1\nC\u0003Y\u0001\u0011\u0005\u0011\f\u0003\u0005_\u0001\t\u0007I\u0011A\u0016`\u0011\u00191\u0007\u0001)A\u0005A\"9q\r\u0001b\u0001\n\u0013y\u0006B\u00025\u0001A\u0003%\u0001\rC\u0004j\u0001\t\u0007I\u0011B0\t\r)\u0004\u0001\u0015!\u0003a\u0011\u001dY\u0007A1A\u0005\n}Ca\u0001\u001c\u0001!\u0002\u0013\u0001\u0007\"B7\u0001\t\u0003r\u0007\"\u0002>\u0001\t\u0003Y\b\"CA\u001c\u0001E\u0005I\u0011AA\u001d\u0011%\ty\u0005AI\u0001\n\u0003\t\t\u0006C\u0004\u0002V\u0001!\t!a\u0016\t\u0013\u00055\u0004!%A\u0005\u0002\u0005e\u0002bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003O\u0003A\u0011AAU\u0011%\tY\fAI\u0001\n\u0003\tI\u0004C\u0004\u0002>\u0002!I!a0\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bb\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005KAqAa\r\u0001\t\u0003\u0011)\u0004C\u0004\u0003>\u0001!IAa\u0010\t\u000f\t%\u0003\u0001\"\u0003\u0003L!A!Q\u000b\u0001\u0005\u0002-\u00129\u0006\u0003\u0005\u0003\\\u0001!\ta\u000bB/\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005G:\u0011Ba\u001b*\u0003\u0003E\tA!\u001c\u0007\u0011!J\u0013\u0011!E\u0001\u0005_Ba\u0001W\u0013\u0005\u0002\t]\u0004\"\u0003B=KE\u0005I\u0011\u0001B>\u0005=\u0011%o\\6feZ\u000bG.\u001b3bi>\u0014(B\u0001\u0016,\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003Y5\nq\"\\1uKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003]=\n!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0003\u0001M\u0002\"\u0001N\u001b\u000e\u0003%J!AN\u0015\u0003#\u0005\u00137\u000f\u001e:bGR4\u0016\r\\5eCR|'/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0018\u0002\rM,'O^3s\u0013\tq4H\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n\u0001B]3q_J$XM]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q)L\u0001\u0006CV$\u0017\u000e^\u0005\u0003\u000f\u0012\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018!\u0003:fa>\u0014H/\u001a:!\u0013\t\u0001U'\u0001\u0003uS6,\u0007C\u0001'W\u001b\u0005i%B\u0001(P\u0003\u0015)H/\u001b7t\u0015\t\u0001\u0016+\u0001\u0004d_6lwN\u001c\u0006\u0003aIS!a\u0015+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0016aA8sO&\u0011q+\u0014\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u00055ncV\f\u0005\u00025\u0001!)qG\u0002a\u0001s!)\u0001I\u0002a\u0001\u0005\"9!J\u0002I\u0001\u0002\u0004Y\u0015\u0001\b*fi\u0016tG/[8o)&lW-T1sO&twJZ#se>\u0014Xj]\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n\u0019\u0011J\u001c;\u0002;I+G/\u001a8uS>tG+[7f\u001b\u0006\u0014x-\u001b8PM\u0016\u0013(o\u001c:Ng\u0002\n!DU3uK:$\u0018n\u001c8TSj,W*\u0019:hS:|e-\u0012:s_J\f1DU3uK:$\u0018n\u001c8TSj,W*\u0019:hS:|e-\u0012:s_J\u0004\u0013aG'bq>3gm]3u\u000f\u0006\u0004Hk\u001c7fe\u0006t7-\u001a+j[\u0016l5/\u0001\u000fNCb|eMZ:fi\u001e\u000b\u0007\u000fV8mKJ\fgnY3US6,Wj\u001d\u0011\u0002Y5\u000b\u0007\u0010S5hQ^\u000bG/\u001a:nCJ\\Gk\u001c7fe\u0006t7-\u001a$pe6K'O]8s!\u0006\u0014H/\u001b;j_:\u001c\u0018!L'bq\"Kw\r[,bi\u0016\u0014X.\u0019:l)>dWM]1oG\u00164uN]'jeJ|'\u000fU1si&$\u0018n\u001c8tA\u0005QAn\\4hKJt\u0015-\\3\u0016\u0003=\u0004\"\u0001]<\u000f\u0005E,\bC\u0001:c\u001b\u0005\u0019(B\u0001;2\u0003\u0019a$o\\8u}%\u0011aOY\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002wE\u00069b/\u00197jI\u0006$X\r\u0012\"IS\u001eDw+\u0019;fe6\f'o\u001b\u000b\ry~\fY!a\u0004\u0002\u001a\u0005%\u0012Q\u0006\t\u0003CvL!A 2\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0003\u0001\u0002\u0019AA\u0002\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!\u0002\u0002\b5\tq*C\u0002\u0002\n=\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\u000eA\u0001\r\u0001Y\u0001\u0006KB|7\r\u001b\u0005\b\u0003#\u0001\u0002\u0019AA\n\u0003\rAw/\u001c\t\u0004C\u0006U\u0011bAA\fE\n!Aj\u001c8h\u0011\u001d\tY\u0002\u0005a\u0001\u0003;\tQa\u001d;bi\u0016\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gi\u0013A\u00013c\u0013\u0011\t9#!\t\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\"A\u00111\u0006\t\u0011\u0002\u0003\u0007q.\u0001\u0005nKR\fG-\u0019;b\u0011%\ty\u0003\u0005I\u0001\u0002\u0004\t\t$A\u0007jg\u0016\u0003xn\u00195DQ\u0006tw-\u001a\t\u0004C\u0006M\u0012bAA\u001bE\n9!i\\8mK\u0006t\u0017!\t<bY&$\u0017\r^3E\u0005\"Kw\r[,bi\u0016\u0014X.\u0019:lI\u0011,g-Y;mi\u0012*TCAA\u001eU\ry\u0017QH\u0016\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\n2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tc/\u00197jI\u0006$X\r\u0012\"IS\u001eDw+\u0019;fe6\f'o\u001b\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u000b\u0016\u0005\u0003c\ti$A\rwC2LG-\u0019;f\u0019>\u001c\u0017\r\u001c'pO\u0016sGm\u00144gg\u0016$H#\u0004?\u0002Z\u0005m\u0013QLA0\u0003S\nY\u0007C\u0004\u0002\u0002M\u0001\r!a\u0001\t\r\u000551\u00031\u0001a\u0011\u001d\t\tb\u0005a\u0001\u0003'Aq!!\u0019\u0014\u0001\u0004\t\u0019'A\u0002jgJ\u0004B\u0001]A3A&\u0019\u0011qM=\u0003\u0007M+G\u000fC\u0004\u0002\u001cM\u0001\r!!\b\t\u0011\u0005-2\u0003%AA\u0002=\f1E^1mS\u0012\fG/\u001a'pG\u0006dGj\\4F]\u0012|eMZ:fi\u0012\"WMZ1vYR$c'A\thKR\u0014V\r^3oi&|gNV1mk\u0016$\u0002\"a\u001d\u0002z\u0005m\u0014Q\u0010\t\u0006C\u0006U\u00141C\u0005\u0004\u0003o\u0012'AB(qi&|g\u000eC\u0004\u0002\u0002U\u0001\r!a\u0001\t\u000f\u0005mQ\u00031\u0001\u0002\u001e!9\u0011qP\u000bA\u0002\u0005\u0005\u0015!\u0004:fi\u0016tG/[8o)f\u0004X\r\u0005\u0003\u0002\u0004\u0006\u0005f\u0002BAC\u00037sA!a\"\u0002\u0016:!\u0011\u0011RAI\u001d\u0011\tY)a$\u000f\u0007I\fi)C\u00011\u0013\tqs&C\u0002\u0002\u00146\na!\u001a<f]R\u001c\u0018\u0002BAL\u00033\u000baA\u0019:pW\u0016\u0014(bAAJ[%!\u0011QTAP\u00035\u0011V\r^3oi&|g\u000eV=qK*!\u0011qSAM\u0013\u0011\t\u0019+!*\u0003\u001bI+G/\u001a8uS>tG+\u001f9f\u0015\u0011\ti*a(\u00021Y\fG.\u001b3bi\u0016$%\tT8h'R\f'\u000f^(gMN,G\u000f\u0006\u0005\u00022\u0005-\u0016qWA]\u0011\u001d\tiK\u0006a\u0001\u0003_\u000bQ!\u001a<f]R\u0004B!!-\u000246\u0011\u0011qT\u0005\u0005\u0003k\u000byJ\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u001d\tYB\u0006a\u0001\u0003;A\u0001\"a\u000b\u0017!\u0003\u0005\ra\\\u0001#m\u0006d\u0017\u000eZ1uK\u0012\u0013Ej\\4Ti\u0006\u0014Ho\u00144gg\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u0002)ML'0\u001a'baN,7)\u00197dk2\fG/[8o)1\t\t$!1\u0002D\u0006\u0015\u0017\u0011ZAf\u0011\u001d\ti\u000b\u0007a\u0001\u0003_Cq!a\u0007\u0019\u0001\u0004\ti\u0002C\u0004\u0002Hb\u0001\r!a\u0005\u0002\u001dI,G/\u001a8uS>tg+\u00197vK\"1\u00111\u0006\rA\u0002=Dq!!4\u0019\u0001\u0004\ty-A\u0005mCB\u001cX\rV=qKB!\u0011\u0011[An\u001d\u0011\t\u0019.a6\u000f\t\u0005%\u0015Q[\u0005\u0003Y5J1!!7,\u0003M!UO]1cS2LG/\u001f'baN,G+\u001f9f\u0013\u0011\ti.a8\u0003'\u0011+(/\u00192jY&$\u0018\u0010T1qg\u0016$\u0016\u0010]3\u000b\u0007\u0005e7&\u0001\u000buS6,G*\u00199tK\u000e\u000bGnY;mCRLwN\u001c\u000b\r\u0003c\t)/a:\u0002j\u0006-\u0018Q\u001e\u0005\b\u0003[K\u0002\u0019AAX\u0011\u001d\tY\"\u0007a\u0001\u0003;Aq!a2\u001a\u0001\u0004\t\u0019\u0002\u0003\u0004\u0002,e\u0001\ra\u001c\u0005\b\u0003\u001bL\u0002\u0019AAh\u0003m1\u0018\r\\5eCR,Gj\\2bY2{wm\u0015;beR|eMZ:fiRIA0a=\u0002~\n\r!q\u0001\u0005\b\u0003kT\u0002\u0019AA|\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0006\u0005e\u0018bAA~\u001f\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u007fT\u0002\u0019\u0001B\u0001\u0003-i\u0017N\u001d:peN#\u0018\r^3\u0011\t\u0005\f)h\u001c\u0005\b\u0005\u000bQ\u0002\u0019AA\n\u00031aW-\u00193fe>3gm]3u\u0011\u0019\tYC\u0007a\u0001_\u0006)b/\u00197jI\u0006$X\r\u0012\"Fa>\u001c\u0007n\u00115b]\u001e,Gc\u0002?\u0003\u000e\tU!q\u0003\u0005\b\u0003[[\u0002\u0019\u0001B\b!\u0011\t\tL!\u0005\n\t\tM\u0011q\u0014\u0002\u0011\u000bB|7\r[\"iC:<W-\u0012<f]RDq!a\u0007\u001c\u0001\u0004\ti\u0002\u0003\u0004\u0002,m\u0001\ra\\\u0001\u001dm\u0006d\u0017\u000eZ1uK\u0016\u0003xn\u00195DQ\u0006tw-Z,ji\"dunY1m)\u001da(Q\u0004B\u0010\u0005CAq!!,\u001d\u0001\u0004\u0011y\u0001C\u0004\u0002\u0000r\u0001\rA!\u0001\t\r\u0005-B\u00041\u0001p\u0003\r2\u0018\r\\5eCR,G)Z:u\u0019><W\t]8dQ\u000eC\u0017M\\4f/&$\b\u000eT8dC2$r\u0001 B\u0014\u0005_\u0011\t\u0004C\u0004\u0002.v\u0001\rA!\u000b\u0011\t\u0005E&1F\u0005\u0005\u0005[\tyJA\fEKN$Hj\\4Fa>\u001c\u0007n\u00115b]\u001e,WI^3oi\"9\u00111D\u000fA\u0002\u0005u\u0001BBA\u0016;\u0001\u0007q.A\u000ewC2LG-\u0019;f\u000bB|7\r[\"iC&tw+\u001b;i\u0019>\u001c\u0017\r\u001c\u000b\by\n]\"\u0011\bB\u001e\u0011\u001d\t\tA\ba\u0001\u0003\u0007Aq!a\u0007\u001f\u0001\u0004\ti\u0002\u0003\u0004\u0002,y\u0001\ra\\\u0001&o&$\b.\u001b8NCJ<\u0017N\\(g\u000bJ\u0014xN\u001d$peRKW.Z't%\u0016$XM\u001c;j_:$b!!\r\u0003B\t\u0015\u0003b\u0002B\"?\u0001\u0007\u00111C\u0001\u0007i&lW-T:\t\u000f\t\u001ds\u00041\u0001\u0002\u0014\u0005Y!/\u001a;f]RLwN\\'t\u0003\r:\u0018\u000e\u001e5j]6\u000b'oZ5o\u001f\u001a,%O]8s\r>\u00148+\u001b>f%\u0016$XM\u001c;j_:$b!!\r\u0003N\tE\u0003b\u0002B(A\u0001\u0007\u00111C\u0001\u0005g&TX\rC\u0004\u0003T\u0001\u0002\r!a\u0005\u0002\u001bI,G/\u001a8uS>t7+\u001b>f\u0003!I7/\u00138Ts:\u001cG\u0003BA\u0019\u00053Bq!!\u0019\"\u0001\u0004\t\u0019'A\u0004jg&s\u0017j\u0015*\u0015\t\u0005E\"q\f\u0005\b\u0003\u0003\u0011\u0003\u0019AA\u0002\u000319W\r\u001e'baN,G+\u001f9f)\u0019\tyM!\u001a\u0003h!9\u0011q`\u0012A\u0002\t\u0005\u0001b\u0002B5G\u0001\u0007\u0011qZ\u0001\u0006Y\u0006\u00048/Z\u0001\u0010\u0005J|7.\u001a:WC2LG-\u0019;peB\u0011A'J\n\u0004K\tE\u0004cA1\u0003t%\u0019!Q\u000f2\u0003\r\u0005s\u0017PU3g)\t\u0011i'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005{R3aSA\u001f\u0001")
public class BrokerValidator
extends AbstractValidator {
    private final ReplicaManager replicaManager;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MaxOffsetGapToleranceTimeMs;
    private final int MaxHighWatermarkToleranceForMirrorPartitions;

    public static Time $lessinit$greater$default$3() {
        return Time.SYSTEM;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public AuditReporter reporter() {
        return super.reporter();
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    private int MaxOffsetGapToleranceTimeMs() {
        return this.MaxOffsetGapToleranceTimeMs;
    }

    private int MaxHighWatermarkToleranceForMirrorPartitions() {
        return this.MaxHighWatermarkToleranceForMirrorPartitions;
    }

    @Override
    public String loggerName() {
        return BrokerValidator.class.getName();
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, String metadata, boolean isEpochChange) {
        Enumeration.Value lapseType = this.getLapseType(state.mirrorState(), DurabilityLapseType$.MODULE$.HighWatermark());
        if (isEpochChange) {
            return;
        }
        if (state.highWatermark() != 0L && hwm > state.highWatermark() + (long)this.MaxHighWatermarkToleranceForMirrorPartitions() && state.mirrorState().exists((Function1 & Serializable)mirrorState -> BoxesRunTime.boxToBoolean((boolean)BrokerValidator.$anonfun$validateDBHighWatermark$1(mirrorState)))) {
            String msg = new StringBuilder(252).append("durability lapse on validation with hwm stored in database, should not append records in the mirror states where mirror partitions are not allowed to fetch data from the source topics\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, 1L, lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
        if (hwm < state.highWatermark()) {
            String msg = new StringBuilder(175).append("durability lapse on validation with hwm stored in database, hwm decreased from a previous committed value.\n").append("new hwm: ").append(hwm).append(", db hwm: ").append(state.highWatermark()).append(", event epoch: ").append(epoch).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
    }

    public String validateDBHighWatermark$default$5() {
        return "";
    }

    public boolean validateDBHighWatermark$default$6() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, String metadata) {
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some) {
            long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (localEndOffset < hwm) {
                String msg = new StringBuilder(207).append("durability lapse on validation with local log end offset, log end offset is found to be less than hwm.\n").append("local end offset: ").append(localEndOffset).append(", hwm: ").append(hwm).append(", event epoch: ").append(epoch).append(", local replica epoch: ").append(state.latestLocalEpoch()).append(", isr: ").append(isr).append("\n").append("partition: ").append(topicPartition).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return;
            }
            return;
        }
    }

    public String validateLocalLogEndOffset$default$6() {
        return "";
    }

    private Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            if (state.retentionMs() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs()));
            }
            return Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        }
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value2 != null ? !value2.equals(retentionType) : retentionType != null)) {
            if (state.retentionSz() != -1L) {
                return new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz()));
            }
            return Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition);
        }
        return None$.MODULE$;
    }

    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state, String metadata) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Validating db log startOffset ").append(event).append(" ").append(state).toString());
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.ClusterLinkReplication();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            state.committedStartOffset_$eq(event.logStartOffset());
            state.lapseWatchStartTime_$eq(0L);
            return false;
        }
        Enumeration.Value lapseType = this.getLapseType(state.mirrorState(), DurabilityLapseType$.MODULE$.StartOffset());
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue(), metadata, lapseType);
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            return this.timeLapseCalculation(event, state, event.retentionValue(), metadata, lapseType);
        }
        Enumeration.Value value7 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value8 = RetentionType$.MODULE$.Other();
        if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
            Option<Object> option = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicIdPartition().topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            if (option2 instanceof Some) {
                long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Validating for db log start offset lapse for ").append(event).append(" ").append(state).append(" with retentions (").append(retentionSz).append(", ").append(retentionMs).append(")").toString());
                    Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    Option<SegmentState> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
                    if (estimatedSize instanceof Some) {
                        long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)estimatedSize).value());
                        if (prevSegInfo instanceof Some) {
                            SegmentState prevSegInfo2 = (SegmentState)((Some)prevSegInfo).value();
                            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                                String msg = new StringBuilder(397).append("durability lapse on validation with db log start offset, the start offset is more than expected retention window.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegInfo2.maxTimestamp()).append(", retentionMs: ").append(retentionMs).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize2).append(", retentionSz: ").append(retentionSz).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("Lapse with ").append(estimatedSize2).append(" ").append(prevSegInfo2).append(".size ").append(msg).toString());
                                if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MaxOffsetGapToleranceTimeMs())) {
                                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Postponing start offset lapse with details: ").append(msg).toString());
                                    if (state.lapseWatchStartTime() == 0L) {
                                        state.lapseWatchStartTime_$eq(this.time.milliseconds());
                                    }
                                    return false;
                                }
                                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                                return true;
                            }
                            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Validation against db log start offset went fine  ").append(estimatedSize2).append(", ").append(prevSegInfo2).toString());
                            return true;
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("validateDBLogStartOffset exits as not able to fetch comparing value ").append(event).append(" ").append(state).toString());
        return true;
    }

    public String validateDBLogStartOffset$default$3() {
        return "";
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata, Enumeration.Value lapseType) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("sizeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (option instanceof Some) {
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(289).append("durability lapse on validation with db log start offset based on size, the start offset is more than expected retention window size.\n").append("Size based lapse info - estimatedSize including previous segment: ").append(estimatedSize).append(", retentionValue: ").append(retentionValue).append(", RetentionSizeMarginOfError: ").append(this.RetentionSizeMarginOfError()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return true;
            }
            return true;
        }
        return true;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue, String metadata, Enumeration.Value lapseType) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("timeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<SegmentState> previousTierSegmentInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicIdPartition(), event.logStartOffset());
        if (previousTierSegmentInfo instanceof Some) {
            SegmentState prevSegmentState = (SegmentState)((Some)previousTierSegmentInfo).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevSegmentState.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(405).append("durability lapse on validation with db log start offset based on time, the start offset is more than expected retention window time.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegmentState.maxTimestamp()).append(", retentionValue: ").append(retentionValue).append(", current time: ").append(this.time.milliseconds()).append(", RetentionTimeMarginOfErrorMs: ").append(this.RetentionTimeMarginOfErrorMs()).append("\n").append("Previous deleted tiered segment info - objectId: ").append(prevSegmentState.objectId()).append(", baseOffset: ").append(prevSegmentState.baseOffset()).append(", size: ").append(prevSegmentState.size()).append(", endOffset: ").append(prevSegmentState.endOffset()).append(", tierEpoch: ").append(prevSegmentState.tierEpoch()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return true;
            }
            return true;
        }
        return true;
    }

    public void validateLocalLogStartOffset(TopicIdPartition topicIdPartition, Option<String> mirrorState, long leaderOffset, String metadata) {
        AbstractLog log;
        Option<AbstractLog> option = this.replicaManager().logManager().getLog(topicIdPartition.topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null && log.logStartOffset() > leaderOffset) {
            SegmentState prevSegmentState;
            Option<SegmentState> option2 = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicIdPartition, log.logStartOffset());
            if (option2 instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (SegmentState)((Some)option2).value()).maxTimestamp(), log.config().retentionMs) && !this.withinMarginOfErrorForSizeRetention(log.size() + (long)prevSegmentState.size(), log.config().retentionSize)) {
                String msg = new StringBuilder(241).append("durability lapse on validation with local log start offset.\n").append("Time based lapse info - maxTimestamp in previous deleted segment: ").append(prevSegmentState.maxTimestamp()).append(", retentionMs: ").append(log.config().retentionMs).append("\n").append("Size based lapse info - prevSegmentSize: ").append(prevSegmentState.size()).append(", logSize: ").append(log.size()).append(", retentionSz: ").append(log.config().retentionSize).append("\n").append("broker: ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append("\n").append("partition: ").append(topicIdPartition).append("\n").append("metadata: ").append(metadata).toString();
                this.reporter().reportDurabilityLapse(topicIdPartition.topicPartition(), log.logStartOffset(), Math.max(log.logStartOffset() - leaderOffset, 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                return;
            }
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent event, PartitionState state, String metadata) {
        Enumeration.Value lapseType = this.getLapseType(state.mirrorState(), DurabilityLapseType$.MODULE$.EpochChange());
        if (event.firstOffset() < state.highWatermark() || event.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(209).append("durability lapse on epoch change event with db, first offset for new epoch is less than previous recorded db state hwm\n").append("event first offset: ").append(event.firstOffset()).append(", new epoch: ").append(event.epoch()).append("\n").append("db state hwm: ").append(state.highWatermark()).append("\n").append("partition: ").append(event.topicIdPartition()).append("\n").append("event: ").append(event).append("\n").append("db state: ").append(state).append("\n").append("metadata: ").append(metadata).toString();
            this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), event.firstOffset(), Math.max(state.highWatermark() - event.firstOffset(), 1L), lapseType, msg, true, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
            return;
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent event, Option<String> mirrorState, String metadata) {
        if (mirrorState.isDefined()) {
            return;
        }
        if (!this.isInSync(event.isr())) {
            return;
        }
        if (this.isInISR(event.topicIdPartition().topicPartition())) {
            Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition());
            Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition());
            if (option2 instanceof Some) {
                int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    if (epoch >= event.epoch() && localEndOffset < event.firstOffset()) {
                        String msg = new StringBuilder(217).append("durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\n").append("in-sync partition ").append(event.topicIdPartition()).append("\n").append("local end offset: ").append(localEndOffset).append(", local epoch ").append(epoch).append("\n").append("first offset: ").append(event.firstOffset()).append(" of the new epoch\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                    } else if (localEndOffset < event.highWatermark()) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\n").append("For in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local end offset ").append(localEndOffset).append(",local epoch ").append(epoch).append("\n").append("hwm: ").append(event.highWatermark()).append(", isrSet ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                    }
                }
            }
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Follower is lagging ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append(", processing older event ").append(event.topicIdPartition()).append(" ").toString());
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.epoch());
        Option<AbstractLog> log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (localOffset instanceof Some) {
            long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)localOffset).value());
            if (log instanceof Some) {
                AbstractLog localLog = (AbstractLog)((Some)log).value();
                if (firstOffset != -1L) {
                    if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\n").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local first offset: ").append(localOffset).append("\n").append("first offset: ").append(event.firstOffset()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                        return;
                    }
                    return;
                }
            }
        }
    }

    public void validateDestLogEpochChangeWithLocal(DestLogEpochChangeEvent event, PartitionState state, String metadata) {
        if (!this.isInSync(event.isr())) {
            return;
        }
        if (this.isInISR(event.topicIdPartition().topicPartition())) {
            Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), event.topicIdPartition().topicPartition());
            Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), event.topicIdPartition().topicPartition());
            if (option2 instanceof Some) {
                int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                if (option instanceof Some) {
                    long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    if (epoch >= event.destLogEpoch() && localEndOffset < event.firstOffset()) {
                        String msg = new StringBuilder(217).append("durability lapse on validation of epoch change with local, local end offset is less than first offset of new event\n").append("in-sync partition ").append(event.topicIdPartition()).append("\n").append("local end offset: ").append(localEndOffset).append(", local epoch ").append(epoch).append("\n").append("first offset: ").append(event.firstOffset()).append(" of the new epoch\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                    } else if (localEndOffset < event.highWatermark()) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local end offset is less than hwm of new event\n").append("For in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local end offset ").append(localEndOffset).append(",local epoch ").append(epoch).append("\n").append("hwm: ").append(event.highWatermark()).append(", isrSet ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                    }
                }
            }
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Follower is lagging ").append(Utils$.MODULE$.getIsrPartition(this.replicaManager(), event.topicIdPartition().topicPartition())).append(", processing older event ").append(event.topicIdPartition()).append(" ").toString());
        }
        if (Utils$.MODULE$.isCompacted(this.replicaManager(), event.topicIdPartition().topicPartition())) {
            return;
        }
        Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), event.topicIdPartition().topicPartition(), event.destLogEpoch());
        Option<AbstractLog> log = this.replicaManager().logManager().getLog(event.topicIdPartition().topicPartition(), this.replicaManager().logManager().getLog$default$2());
        if (localOffset instanceof Some) {
            long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)localOffset).value());
            if (log instanceof Some) {
                AbstractLog localLog = (AbstractLog)((Some)log).value();
                if (firstOffset != -1L) {
                    if (firstOffset != event.firstOffset() && (firstOffset < event.firstOffset() || firstOffset > localLog.logStartOffset())) {
                        String msg = new StringBuilder(194).append("durability lapse on validation of epoch change with local, local first offset is not equal to first offset of new event\n").append("in-sync partition: ").append(event.topicIdPartition()).append("\n").append("local first offset: ").append(localOffset).append("\n").append("first offset: ").append(event.firstOffset()).append("\n").append("event: ").append(event).append("\n").append("metadata: ").append(metadata).toString();
                        this.reporter().reportDurabilityLapse(event.topicIdPartition().topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, this.reporter().reportDurabilityLapse$default$7(), this.reporter().reportDurabilityLapse$default$8());
                        return;
                    }
                    return;
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state, String metadata) {
        Object object = new Object();
        try {
            if (Utils$.MODULE$.isCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)(state.mirrorState().isEmpty() ? state.epochChain() : state.mirrorCacheEpochChain()).toList().sortWith((Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)BrokerValidator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable)x0$1 -> {
                BrokerValidator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, prevEpoch, state, metadata, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("validating ").append(timeMs).append(" against ").append(retentionMs).toString());
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Validating ").append(size).append(" against ").append(retentionSize).toString());
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public boolean isInISR(TopicPartition topicPartition) {
        return Utils$.MODULE$.getIsrPartition(this.replicaManager(), topicPartition).contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    private Enumeration.Value getLapseType(Option<String> mirrorState, Enumeration.Value lapse) {
        ObjectRef newLapse = ObjectRef.create((Object)lapse);
        mirrorState.foreach((Function1 & Serializable)mirror -> {
            BrokerValidator.$anonfun$getLapseType$1(lapse, newLapse, mirror);
            return BoxedUnit.UNIT;
        });
        return (Enumeration.Value)newLapse.elem;
    }

    public static final /* synthetic */ boolean $anonfun$validateDBHighWatermark$1(String mirrorState) {
        return !DurabilityAuditMirrorState.fromString(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(Option$.MODULE$.apply((Object)mirrorState)))).get().isAppendRecordsAllowed();
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(BrokerValidator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, IntRef prevEpoch$1, PartitionState state$4, String metadata$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(218).append("durability lapse on epoch chain validation with db, local first offset is greater than or equal to next epoch's first offset\n").append("partition ").append(topicPartition$1).append("\n").append("prevEpoch: ").append(prevEpoch$1.elem).append(", prevLocalFirstOffset: ").append(prevLocalEpochFirstOffset$1.elem).append("\n").append("dbEpoch: ").append(dbEpoch).append(", db first offset ").append(dbEpochFirstOffset).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7(), $this.reporter().reportDurabilityLapse$default$8());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(199).append("durability lapse on epoch chain validation, db first offset is greater than local first offset\n").append("partition: ").append(topicPartition$1).append("\n").append("dbEpoch: ").append(dbEpoch).append(", the local first offset: ").append(localEpochFirstOffset).append("\n").append("db first offset: ").append(dbEpochFirstOffset).append(", log start offset: ").append(log.logStartOffset()).append("\n").append("state: ").append(state$4).append("\n").append("metadata: ").append(metadata$1).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false, $this.reporter().reportDurabilityLapse$default$7(), $this.reporter().reportDurabilityLapse$default$8());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$getLapseType$1(Enumeration.Value lapse$1, ObjectRef newLapse$1, String mirror) {
        block20: {
            block19: {
                Enumeration.Value value;
                block18: {
                    block14: {
                        block17: {
                            block16: {
                                Enumeration.Value value2;
                                block15: {
                                    if (!mirror.equals(DurabilityAuditMirrorState.STOPPED.getName())) break block14;
                                    Enumeration.Value value3 = DurabilityLapseType$.MODULE$.HighWatermark();
                                    if (!(value3 != null ? !value3.equals(lapse$1) : lapse$1 != null)) {
                                        newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionHighWatermark();
                                        return;
                                    }
                                    Enumeration.Value value4 = DurabilityLapseType$.MODULE$.StartOffset();
                                    if (!(value4 != null ? !value4.equals(lapse$1) : lapse$1 != null)) {
                                        newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionStartOffset();
                                        return;
                                    }
                                    value2 = DurabilityLapseType$.MODULE$.EpochChange();
                                    if (value2 != null) break block15;
                                    if (lapse$1 != null) {
                                        return;
                                    }
                                    break block16;
                                }
                                if (!value2.equals(lapse$1)) break block17;
                            }
                            newLapse$1.elem = DurabilityLapseType$.MODULE$.StoppedMirrorPartitionEpochChange();
                            return;
                        }
                        return;
                    }
                    Enumeration.Value value5 = DurabilityLapseType$.MODULE$.HighWatermark();
                    if (!(value5 != null ? !value5.equals(lapse$1) : lapse$1 != null)) {
                        newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionHighWatermark();
                        return;
                    }
                    Enumeration.Value value6 = DurabilityLapseType$.MODULE$.StartOffset();
                    if (!(value6 != null ? !value6.equals(lapse$1) : lapse$1 != null)) {
                        newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionStartOffset();
                        return;
                    }
                    value = DurabilityLapseType$.MODULE$.EpochChange();
                    if (value != null) break block18;
                    if (lapse$1 != null) {
                        return;
                    }
                    break block19;
                }
                if (!value.equals(lapse$1)) break block20;
            }
            newLapse$1.elem = DurabilityLapseType$.MODULE$.MirrorPartitionEpochChange();
            return;
        }
    }

    public BrokerValidator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.time = time;
        super(reporter, time);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MaxOffsetGapToleranceTimeMs = 900000;
        this.MaxHighWatermarkToleranceForMirrorPartitions = 10000;
    }
}

